/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.accounts.A_CmsGroupUsersList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsGroupUsersList
extends A_CmsGroupUsersList {
    public static final String LIST_ACTION_REMOVE = "ar";
    public static final String LIST_DEFACTION_REMOVE = "dr";
    public static final String LIST_DETAIL_ORGUNIT = "dou";
    public static final String LIST_ID = "lgu";
    public static final String LIST_MACTION_REMOVE = "mr";
    protected static Set m_removeActionIds = new HashSet();

    public CmsGroupUsersList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsGroupUsersList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsGroupUsersList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_GROUPUSERS_LIST_NAME_0"), true);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_REMOVE)) {
            Iterator itItems = this.getSelectedItems().iterator();
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                String userName = (String)listItem.get("cl");
                try {
                    this.getCms().removeUserFromGroup(userName, this.getParamGroupname());
                }
                catch (CmsException e) {}
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        if (m_removeActionIds.contains(this.getParamListAction())) {
            CmsListItem listItem = this.getSelectedItem();
            try {
                this.getCms().removeUserFromGroup((String)listItem.get("cl"), this.getParamGroupname());
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_REMOVE_SELECTED_GROUP_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected List getUsers(boolean withOtherOus) throws CmsException {
        return this.getCms().getUsersOfGroup(this.getParamGroupname(), withOtherOus);
    }

    protected void setDefaultAction(CmsListColumnDefinition loginCol) {
        CmsListDefaultAction removeAction = new CmsListDefaultAction(LIST_DEFACTION_REMOVE);
        removeAction.setName(Messages.get().container("GUI_USERS_LIST_DEFACTION_REMOVE_NAME_0"));
        removeAction.setHelpText(Messages.get().container("GUI_USERS_LIST_DEFACTION_REMOVE_HELP_0"));
        loginCol.addDefaultAction(removeAction);
        m_removeActionIds.add(removeAction.getId());
    }

    protected void setIconAction(CmsListColumnDefinition iconCol) {
        CmsListDefaultAction iconAction = new CmsListDefaultAction("ai"){

            public String getIconPath() {
                return ((A_CmsGroupUsersList)this.getWp()).getIconPath(this.getItem());
            }
        };
        iconAction.setName(Messages.get().container("GUI_USERS_LIST_INGROUP_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_USERS_LIST_INGROUP_HELP_0"));
        iconAction.setIconPath("tools/accounts/buttons/user.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)iconAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction removeMultiAction = new CmsListMultiAction(LIST_MACTION_REMOVE);
        removeMultiAction.setName(Messages.get().container("GUI_USERS_LIST_MACTION_REMOVE_NAME_0"));
        removeMultiAction.setHelpText(Messages.get().container("GUI_USERS_LIST_MACTION_REMOVE_HELP_0"));
        removeMultiAction.setConfirmationMessage(Messages.get().container("GUI_USERS_LIST_MACTION_REMOVE_CONF_0"));
        removeMultiAction.setIconPath("list/multi_minus.png");
        metadata.addMultiAction(removeMultiAction);
    }

    protected void setStateActionCol(CmsListMetadata metadata) {
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition("cs");
        stateCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_STATE_0"));
        stateCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_STATE_HELP_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_REMOVE);
        stateAction.setName(Messages.get().container("GUI_USERS_LIST_DEFACTION_REMOVE_NAME_0"));
        stateAction.setHelpText(Messages.get().container("GUI_USERS_LIST_DEFACTION_REMOVE_HELP_0"));
        stateAction.setIconPath("list/minus.png");
        stateCol.addDirectAction((I_CmsListDirectAction)stateAction);
        metadata.addColumn(stateCol);
        m_removeActionIds.add(stateAction.getId());
    }

    protected void validateParamaters() throws Exception {
        super.validateParamaters();
        if (this.getCms().readGroup(new CmsUUID(this.getParamGroupid())).isVirtual()) {
            throw new Exception();
        }
    }
}

