/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.A_CmsGroupsList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsGroupsAllOrgUnitsList
extends A_CmsGroupsList {
    public static final String LIST_ACTION_OVERVIEW = "ao";
    public static final String LIST_COLUMN_ORGUNIT = "co";
    public static final String LIST_DETAIL_ORGUNIT_DESC = "dd";
    public static final String LIST_ID = "lgaou";

    public CmsGroupsAllOrgUnitsList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_GROUPS_LIST_NAME_0"));
    }

    public CmsGroupsAllOrgUnitsList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListSingleActions() throws IOException, ServletException, CmsRuntimeException {
        String groupId = this.getSelectedItem().getId();
        String groupName = this.getSelectedItem().get("cn").toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("groupid", groupId);
        params.put("groupname", groupName);
        params.put("oufqn", this.getSelectedItem().get(LIST_COLUMN_ORGUNIT).toString().substring(1));
        params.put("action", "initial");
        if (this.getParamListAction().equals(LIST_ACTION_OVERVIEW)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/accounts/orgunit/groups/edit", params);
        } else if (this.getParamListAction().equals("de")) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/accounts/orgunit/groups/edit", params);
        } else {
            super.executeListSingleActions();
        }
        this.listSave();
    }

    protected void fillDetails(String detailId) {
        super.fillDetails(detailId);
        List groups = this.getList().getAllContent();
        Iterator itGroups = groups.iterator();
        while (itGroups.hasNext()) {
            CmsListItem item = (CmsListItem)itGroups.next();
            String groupName = item.get("cn").toString();
            StringBuffer html = new StringBuffer(512);
            try {
                if (!detailId.equals(LIST_DETAIL_ORGUNIT_DESC)) continue;
                CmsGroup group = this.getCms().readGroup(groupName);
                html.append(OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), group.getOuFqn()).getDescription(this.getLocale()));
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected List getGroups() throws CmsException {
        return CmsPrincipal.filterCore((List)OpenCms.getRoleManager().getManageableGroups(this.getCms(), "", true));
    }

    protected List getListItems() throws CmsException {
        List listItems = super.getListItems();
        Iterator itListItems = listItems.iterator();
        while (itListItems.hasNext()) {
            CmsListItem item = (CmsListItem)itListItems.next();
            CmsGroup group = this.getCms().readGroup(new CmsUUID(item.getId()));
            item.set(LIST_COLUMN_ORGUNIT, (Object)("/" + group.getOuFqn()));
        }
        return listItems;
    }

    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        metadata.getColumnDefinition("cu").setVisible(false);
        metadata.getColumnDefinition("ca").setVisible(false);
        metadata.getColumnDefinition("cd").setVisible(false);
        metadata.getColumnDefinition("cdn").setWidth("25%");
        metadata.getColumnDefinition("cc").setWidth("50%");
        CmsListColumnDefinition orgUnitCol = new CmsListColumnDefinition(LIST_COLUMN_ORGUNIT);
        orgUnitCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_ORGUNIT_0"));
        orgUnitCol.setWidth("25%");
        metadata.addColumn(orgUnitCol, metadata.getColumnDefinitions().indexOf(metadata.getColumnDefinition("cc")));
    }

    protected void setDeleteAction(CmsListColumnDefinition deleteCol) {
    }

    protected void setEditAction(CmsListColumnDefinition editCol) {
        CmsListDirectAction editAction = new CmsListDirectAction(LIST_ACTION_OVERVIEW);
        editAction.setName(Messages.get().container("GUI_GROUPS_LIST_DEFACTION_EDIT_NAME_0"));
        editAction.setHelpText(Messages.get().container("GUI_GROUPS_LIST_DEFACTION_EDIT_HELP_0"));
        editAction.setIconPath("tools/accounts/buttons/group.png");
        editCol.addDirectAction((I_CmsListDirectAction)editAction);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        super.setIndependentActions(metadata);
        CmsListItemDetails orgUnitDescDetails = new CmsListItemDetails(LIST_DETAIL_ORGUNIT_DESC);
        orgUnitDescDetails.setAtColumn("cdn");
        orgUnitDescDetails.setVisible(false);
        orgUnitDescDetails.setShowActionName(Messages.get().container("GUI_USERS_DETAIL_SHOW_ORGUNIT_DESC_NAME_0"));
        orgUnitDescDetails.setShowActionHelpText(Messages.get().container("GUI_USERS_DETAIL_SHOW_ORGUNIT_DESC_HELP_0"));
        orgUnitDescDetails.setHideActionName(Messages.get().container("GUI_USERS_DETAIL_HIDE_ORGUNIT_DESC_NAME_0"));
        orgUnitDescDetails.setHideActionHelpText(Messages.get().container("GUI_USERS_DETAIL_HIDE_ORGUNIT_DESC_HELP_0"));
        orgUnitDescDetails.setName(Messages.get().container("GUI_USERS_DETAIL_ORGUNIT_DESC_NAME_0"));
        orgUnitDescDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_USERS_DETAIL_ORGUNIT_DESC_NAME_0")));
        metadata.addItemDetails(orgUnitDescDetails);
        metadata.getSearchAction().addColumn(metadata.getColumnDefinition("cc"));
        metadata.getSearchAction().addColumn(metadata.getColumnDefinition(LIST_COLUMN_ORGUNIT));
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    protected void validateParamaters() throws Exception {
    }
}

