/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.accounts.A_CmsGroupUsersList;
import org.opencms.workplace.tools.accounts.A_CmsUsersList;
import org.opencms.workplace.tools.accounts.CmsGroupsList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsNotGroupUsersList
extends A_CmsGroupUsersList {
    public static final String LIST_ACTION_ADD = "aa";
    public static final String LIST_DEFACTION_ADD = "da";
    public static final String LIST_ID = "lngu";
    public static final String LIST_MACTION_ADD = "ma";
    protected static Set m_addActionIds = new HashSet();

    public CmsNotGroupUsersList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsNotGroupUsersList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsNotGroupUsersList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_NOTGROUPUSERS_LIST_NAME_0"), true);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_ADD)) {
            try {
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    this.getCms().addUserToGroup((String)listItem.get("cl"), this.getParamGroupname());
                }
            }
            catch (CmsException e) {
                Map objects = (Map)this.getSettings().getListObject();
                if (objects != null) {
                    objects.remove(CmsGroupsList.class.getName());
                    objects.remove(A_CmsUsersList.class.getName());
                }
                throw new CmsRuntimeException(Messages.get().container("ERR_ADD_SELECTED_GROUPS_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        if (m_addActionIds.contains(this.getParamListAction())) {
            CmsListItem listItem = this.getSelectedItem();
            try {
                this.getCms().addUserToGroup((String)listItem.get("cl"), this.getParamGroupname());
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_ADD_SELECTED_GROUP_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected List getUsers(boolean withOtherOus) throws CmsException {
        List groupusers = this.getCms().getUsersOfGroup(this.getParamGroupname(), withOtherOus);
        List users = withOtherOus ? OpenCms.getRoleManager().getManageableUsers(this.getCms(), "", true) : OpenCms.getRoleManager().getManageableUsers(this.getCms(), this.getParamOufqn(), false);
        users.removeAll(groupusers);
        return users;
    }

    protected void setDefaultAction(CmsListColumnDefinition loginCol) {
        CmsListDefaultAction addAction = new CmsListDefaultAction(LIST_DEFACTION_ADD);
        addAction.setName(Messages.get().container("GUI_USERS_LIST_DEFACTION_ADD_NAME_0"));
        addAction.setHelpText(Messages.get().container("GUI_USERS_LIST_DEFACTION_ADD_HELP_0"));
        loginCol.addDefaultAction(addAction);
        m_addActionIds.add(addAction.getId());
    }

    protected void setIconAction(CmsListColumnDefinition iconCol) {
        CmsListDefaultAction iconAction = new CmsListDefaultAction("ai"){

            public String getIconPath() {
                return ((A_CmsGroupUsersList)this.getWp()).getIconPath(this.getItem());
            }
        };
        iconAction.setName(Messages.get().container("GUI_USERS_LIST_AVAILABLE_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_USERS_LIST_AVAILABLE_HELP_0"));
        iconAction.setIconPath("tools/accounts/buttons/user.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)iconAction);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        super.setIndependentActions(metadata);
        metadata.getItemDetailDefinition("doo").setVisible(false);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction addMultiAction = new CmsListMultiAction(LIST_MACTION_ADD);
        addMultiAction.setName(Messages.get().container("GUI_USERS_LIST_MACTION_ADD_NAME_0"));
        addMultiAction.setHelpText(Messages.get().container("GUI_USERS_LIST_MACTION_ADD_HELP_0"));
        addMultiAction.setConfirmationMessage(Messages.get().container("GUI_USERS_LIST_MACTION_ADD_CONF_0"));
        addMultiAction.setIconPath("list/multi_add.png");
        metadata.addMultiAction(addMultiAction);
    }

    protected void setStateActionCol(CmsListMetadata metadata) {
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition("cs");
        stateCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_STATE_0"));
        stateCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_STATE_HELP_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_ADD);
        stateAction.setName(Messages.get().container("GUI_USERS_LIST_DEFACTION_ADD_NAME_0"));
        stateAction.setHelpText(Messages.get().container("GUI_USERS_LIST_DEFACTION_ADD_HELP_0"));
        stateAction.setIconPath("list/add.png");
        stateCol.addDirectAction((I_CmsListDirectAction)stateAction);
        metadata.addColumn(stateCol);
        m_addActionIds.add(stateAction.getId());
    }
}

