/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.accounts.A_CmsRoleUsersList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsNotRoleUsersList
extends A_CmsRoleUsersList {
    public static final String LIST_ACTION_ADD = "aa";
    public static final String LIST_DEFACTION_ADD = "da";
    public static final String LIST_ID = "lnru";
    public static final String LIST_MACTION_ADD = "ma";
    protected static Set m_addActionIds = new HashSet();

    public CmsNotRoleUsersList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsNotRoleUsersList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsNotRoleUsersList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_NOTROLEUSERS_LIST_NAME_0"), true);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_ADD)) {
            try {
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    OpenCms.getRoleManager().addUserToRole(this.getCms(), CmsRole.valueOf((CmsGroup)this.getCms().readGroup(this.getParamRole())), (String)listItem.get("cl"));
                }
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_ADD_SELECTED_USERS_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        if (m_addActionIds.contains(this.getParamListAction())) {
            CmsListItem listItem = this.getSelectedItem();
            try {
                OpenCms.getRoleManager().addUserToRole(this.getCms(), CmsRole.valueOf((CmsGroup)this.getCms().readGroup(this.getParamRole())), (String)listItem.get("cl"));
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_ADD_SELECTED_USER_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected List getUsers(boolean withOtherOus) throws CmsException {
        List roleUsers = OpenCms.getRoleManager().getUsersOfRole(this.getCms(), CmsRole.valueOf((CmsGroup)this.getCms().readGroup(this.getParamRole())), withOtherOus, false);
        List users = withOtherOus ? OpenCms.getRoleManager().getManageableUsers(this.getCms(), "", true) : OpenCms.getRoleManager().getManageableUsers(this.getCms(), this.getParamOufqn(), false);
        users.removeAll(roleUsers);
        return users;
    }

    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition("cs");
        stateCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_STATE_0"));
        stateCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_STATE_HELP_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_ADD);
        stateAction.setName(Messages.get().container("GUI_USERS_LIST_DEFACTION_ADD_NAME_0"));
        stateAction.setHelpText(Messages.get().container("GUI_USERS_LIST_DEFACTION_ADD_HELP_0"));
        stateAction.setIconPath("list/add.png");
        stateCol.addDirectAction((I_CmsListDirectAction)stateAction);
        metadata.addColumn(stateCol, 1);
        m_addActionIds.add(stateAction.getId());
        CmsListDirectAction iconAction = new CmsListDirectAction("ai"){

            public String getIconPath() {
                try {
                    CmsUser user = CmsNotRoleUsersList.this.getCms().readUser((String)this.getItem().get("cl"));
                    if (user.getOuFqn().equals(((A_CmsRoleUsersList)this.getWp()).getParamOufqn())) {
                        return "tools/accounts/buttons/user.png";
                    }
                    return "tools/accounts/buttons/user_other_ou.png";
                }
                catch (CmsException e) {
                    return "tools/accounts/buttons/user.png";
                }
            }
        };
        iconAction.setName(Messages.get().container("GUI_USERS_LIST_INROLE_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_USERS_LIST_INROLE_HELP_0"));
        iconAction.setIconPath("tools/accounts/buttons/user.png");
        iconAction.setEnabled(false);
        metadata.getColumnDefinition("ci").removeDirectAction("ai");
        metadata.getColumnDefinition("ci").addDirectAction((I_CmsListDirectAction)iconAction);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        super.setIndependentActions(metadata);
        metadata.getItemDetailDefinition("dou").setVisible(false);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction addMultiAction = new CmsListMultiAction(LIST_MACTION_ADD);
        addMultiAction.setName(Messages.get().container("GUI_USERS_LIST_MACTION_ADD_NAME_0"));
        addMultiAction.setHelpText(Messages.get().container("GUI_USERS_LIST_MACTION_ADD_HELP_0"));
        addMultiAction.setConfirmationMessage(Messages.get().container("GUI_USERS_LIST_MACTION_ADD_CONF_0"));
        addMultiAction.setIconPath("list/multi_add.png");
        metadata.addMultiAction(addMultiAction);
    }
}

