/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.accounts.A_CmsUserGroupsList;
import org.opencms.workplace.tools.accounts.A_CmsUsersList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsNotUserGroupsList
extends A_CmsUserGroupsList {
    public static final String LIST_ACTION_ADD = "aa";
    public static final String LIST_DEFACTION_ADD = "da";
    public static final String LIST_ID = "lnug";
    public static final String LIST_MACTION_ADD = "ma";
    protected static Set m_addActionIds = new HashSet();

    public CmsNotUserGroupsList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsNotUserGroupsList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsNotUserGroupsList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_NOTUSERGROUPS_LIST_NAME_0"), true);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_ADD)) {
            try {
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    this.getCms().addUserToGroup(this.getParamUsername(), (String)listItem.get("cn"));
                }
            }
            catch (CmsException e) {
                Map objects = (Map)this.getSettings().getListObject();
                if (objects != null) {
                    objects.remove(A_CmsUsersList.class.getName());
                }
                throw new CmsRuntimeException(Messages.get().container("ERR_ADD_SELECTED_GROUPS_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        if (m_addActionIds.contains(this.getParamListAction())) {
            CmsListItem listItem = this.getSelectedItem();
            try {
                this.getCms().addUserToGroup(this.getParamUsername(), (String)listItem.get("cn"));
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_ADD_SELECTED_GROUP_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected List getGroups(boolean withOtherOus) throws CmsException {
        List usergroups = this.getCms().getGroupsOfUser(this.getParamUsername(), false, withOtherOus);
        List groups = withOtherOus ? OpenCms.getRoleManager().getManageableGroups(this.getCms(), "", true) : OpenCms.getRoleManager().getManageableGroups(this.getCms(), this.getParamOufqn(), false);
        groups.removeAll(usergroups);
        return groups;
    }

    protected void setDefaultAction(CmsListColumnDefinition nameCol) {
        CmsListDefaultAction addAction = new CmsListDefaultAction(LIST_DEFACTION_ADD);
        addAction.setName(Messages.get().container("GUI_GROUPS_LIST_DEFACTION_ADD_NAME_0"));
        addAction.setHelpText(Messages.get().container("GUI_GROUPS_LIST_DEFACTION_ADD_HELP_0"));
        nameCol.addDefaultAction(addAction);
        m_addActionIds.add(addAction.getId());
    }

    protected void setIconAction(CmsListColumnDefinition iconCol) {
        CmsListDirectAction iconAction = new CmsListDirectAction("ai");
        iconAction.setName(Messages.get().container("GUI_GROUPS_LIST_AVAILABLE_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_GROUPS_LIST_AVAILABLE_HELP_0"));
        iconAction.setIconPath("tools/accounts/buttons/group.png");
        iconAction.setEnabled(false);
        iconCol.addDirectAction((I_CmsListDirectAction)iconAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction addMultiAction = new CmsListMultiAction(LIST_MACTION_ADD);
        addMultiAction.setName(Messages.get().container("GUI_GROUPS_LIST_MACTION_ADD_NAME_0"));
        addMultiAction.setHelpText(Messages.get().container("GUI_GROUPS_LIST_MACTION_ADD_HELP_0"));
        addMultiAction.setConfirmationMessage(Messages.get().container("GUI_GROUPS_LIST_MACTION_ADD_CONF_0"));
        addMultiAction.setIconPath("list/multi_add.png");
        metadata.addMultiAction(addMultiAction);
    }

    protected void setStateActionCol(CmsListMetadata metadata) {
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition("cs");
        stateCol.setName(Messages.get().container("GUI_GROUPS_LIST_COLS_STATE_0"));
        stateCol.setHelpText(Messages.get().container("GUI_GROUPS_LIST_COLS_STATE_HELP_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        metadata.addColumn(stateCol);
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_ADD);
        stateAction.setName(Messages.get().container("GUI_GROUPS_LIST_DEFACTION_ADD_NAME_0"));
        stateAction.setHelpText(Messages.get().container("GUI_GROUPS_LIST_DEFACTION_ADD_HELP_0"));
        stateAction.setIconPath("list/add.png");
        stateCol.addDirectAction((I_CmsListDirectAction)stateAction);
        m_addActionIds.add(stateAction.getId());
    }
}

