/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.accounts.A_CmsOrgUnitsList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsOrgUnitsAdminList
extends A_CmsOrgUnitsList {
    public static final String LIST_ID = "lsoua";
    protected static final String LIST_ACTION_OVERVIEW = "ao";
    protected static final String LIST_COLUMN_OVERVIEW = "co";

    public CmsOrgUnitsAdminList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_ADMINORGUNITS_LIST_NAME_0"));
    }

    public CmsOrgUnitsAdminList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String defaultActionHtml() {
        if (this.getList() != null && this.getList().getAllContent().isEmpty()) {
            this.refreshList();
        }
        StringBuffer result = new StringBuffer(2048);
        result.append(this.defaultActionHtmlStart());
        result.append(this.customHtmlStart());
        try {
            if (this.hasMoreAdminOUs()) {
                result.append(this.defaultActionHtmlContent());
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        result.append(this.customHtmlEnd());
        result.append(this.defaultActionHtmlEnd());
        return result.toString();
    }

    public void executeListSingleActions() throws IOException, ServletException {
        String ouFqn = this.getSelectedItem().get("cn").toString();
        if (ouFqn == null) {
            ouFqn = "";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oufqn", ouFqn.substring(1));
        params.put("action", "initial");
        if (this.getParamListAction().equals(LIST_ACTION_OVERVIEW)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/orgunit", params);
        } else if (this.getParamListAction().equals("au")) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getUsersToolPath(), params);
        } else if (this.getParamListAction().equals("ag")) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getGroupsToolPath(), params);
        } else if (this.getParamListAction().equals("do")) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/orgunit", params);
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected String getGroupsToolPath() {
        return this.getCurrentToolPath() + "/orgunit/groups";
    }

    protected String getUsersToolPath() {
        return this.getCurrentToolPath() + "/orgunit/users";
    }

    public void forwardToSingleAdminOU() throws ServletException, IOException, CmsException {
        List orgUnits = this.getOrgUnits();
        if (orgUnits.isEmpty()) {
            OpenCms.getWorkplaceManager().getToolManager().jspForwardTool((CmsWorkplace)this, "/", null);
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oufqn", ((CmsOrganizationalUnit)orgUnits.get(0)).getName());
        params.put("action", "initial");
        OpenCms.getWorkplaceManager().getToolManager().jspForwardTool((CmsWorkplace)this, this.getForwardToolPath(), params);
    }

    protected String getForwardToolPath() {
        return "/accounts/orgunit";
    }

    public String getOverviewIcon() {
        return "tools/accounts/buttons/orgunit.png";
    }

    public boolean hasMoreAdminOUs() throws CmsException {
        List orgUnits = this.getOrgUnits();
        if (orgUnits == null) {
            return false;
        }
        return orgUnits.size() > 1;
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition overviewCol = new CmsListColumnDefinition(LIST_COLUMN_OVERVIEW);
        overviewCol.setName(Messages.get().container("GUI_ORGUNITS_LIST_COLS_OVERVIEW_0"));
        overviewCol.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_OVERVIEW_HELP_0"));
        overviewCol.setWidth("20");
        overviewCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        overviewCol.setSorteable(false);
        CmsListDirectAction overviewAction = new CmsListDirectAction(LIST_ACTION_OVERVIEW){

            public CmsMessageContainer getName() {
                if (this.getItem() != null && ((Boolean)this.getItem().get("cw")).booleanValue()) {
                    return Messages.get().container("GUI_WEBOUS_LIST_ACTION_OVERVIEW_NAME_0");
                }
                return super.getName();
            }

            public String getIconPath() {
                if (this.getItem() != null && ((Boolean)this.getItem().get("cw")).booleanValue()) {
                    return "tools/accounts/buttons/webuser_ou.png";
                }
                return super.getIconPath();
            }
        };
        overviewAction.setName(Messages.get().container("GUI_ORGUNITS_LIST_ACTION_OVERVIEW_NAME_0"));
        overviewAction.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_OVERVIEW_HELP_0"));
        overviewAction.setIconPath(this.getOverviewIcon());
        overviewCol.addDirectAction((I_CmsListDirectAction)overviewAction);
        metadata.addColumn(overviewCol);
        CmsListColumnDefinition userCol = new CmsListColumnDefinition("cu");
        userCol.setName(Messages.get().container("GUI_ORGUNITS_LIST_COLS_USER_0"));
        userCol.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_USER_HELP_0"));
        userCol.setWidth("20");
        userCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        userCol.setSorteable(false);
        CmsListDirectAction userAction = new CmsListDirectAction("au");
        userAction.setName(Messages.get().container("GUI_ORGUNITS_LIST_ACTION_USER_NAME_0"));
        userAction.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_USER_HELP_0"));
        userAction.setIconPath(this.getUserIcon());
        userCol.addDirectAction((I_CmsListDirectAction)userAction);
        metadata.addColumn(userCol);
        CmsListColumnDefinition groupCol = new CmsListColumnDefinition("cg");
        groupCol.setName(Messages.get().container("GUI_ORGUNITS_LIST_COLS_GROUP_0"));
        groupCol.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_GROUP_HELP_0"));
        groupCol.setWidth("20");
        groupCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        groupCol.setSorteable(false);
        CmsListDirectAction groupAction = new CmsListDirectAction("ag");
        groupAction.setName(Messages.get().container("GUI_ORGUNITS_LIST_ACTION_GROUP_NAME_0"));
        groupAction.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_GROUP_HELP_0"));
        groupAction.setIconPath(this.getGroupIcon());
        groupCol.addDirectAction((I_CmsListDirectAction)groupAction);
        metadata.addColumn(groupCol);
        CmsListColumnDefinition descCol = new CmsListColumnDefinition("cb");
        descCol.setName(Messages.get().container("GUI_ORGUNITS_LIST_COLS_DESCRIPTION_0"));
        descCol.setWidth("60%");
        descCol.setSorteable(true);
        CmsListDefaultAction defOverviewAction = new CmsListDefaultAction("do");
        defOverviewAction.setName(Messages.get().container("GUI_ORGUNITS_LIST_DEFACTION_OVERVIEW_NAME_0"));
        defOverviewAction.setHelpText(Messages.get().container("GUI_ORGUNITS_LIST_COLS_OVERVIEW_HELP_0"));
        descCol.addDefaultAction(defOverviewAction);
        metadata.addColumn(descCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition("cn");
        nameCol.setName(Messages.get().container("GUI_ORGUNITS_LIST_COLS_NAME_0"));
        nameCol.setWidth("40%");
        nameCol.setSorteable(true);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition adminCol = new CmsListColumnDefinition("ca");
        adminCol.setVisible(false);
        metadata.addColumn(adminCol);
        CmsListColumnDefinition webuserCol = new CmsListColumnDefinition("cw");
        webuserCol.setVisible(false);
        metadata.addColumn(webuserCol);
    }
}

