/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemActionIconComparator;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListItemComparator;
import org.opencms.workplace.tools.accounts.A_CmsRolesList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsRoleEditList
extends A_CmsRolesList {
    public static final String LIST_ACTION_ACTIVATE = "aa";
    public static final String LIST_ACTION_DEACTIVATE = "ac";
    public static final String LIST_COLUMN_ACTIVATE = "ca";
    public static final String LIST_ID = "lsre";
    public static final String LIST_MACTION_ACTIVATE = "ma";
    public static final String LIST_MACTION_DEACTIVATE = "mc";
    private String m_paramUserid;

    public CmsRoleEditList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsRoleEditList(CmsJspActionElement jsp, String listId) {
        this(jsp, listId, Messages.get().container("GUI_ROLEEDIT_LIST_NAME_0"));
    }

    public CmsRoleEditList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        super(jsp, listId, listName);
    }

    public CmsRoleEditList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_ACTIVATE)) {
            try {
                CmsUser user = this.getCms().readUser(new CmsUUID(this.getParamUserid()));
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    CmsGroup group = this.getCms().readGroup((String)listItem.get("cgn"));
                    CmsRole role = CmsRole.valueOf((CmsGroup)group);
                    if (OpenCms.getRoleManager().hasRole(this.getCms(), user.getName(), role)) continue;
                    OpenCms.getRoleManager().addUserToRole(this.getCms(), role, user.getName());
                    this.getCms().writeUser(user);
                }
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_ACTIVATE_SELECTED_USERS_0"), (Throwable)e);
            }
        } else if (this.getParamListAction().equals(LIST_MACTION_DEACTIVATE)) {
            try {
                CmsUser user = this.getCms().readUser(new CmsUUID(this.getParamUserid()));
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    CmsGroup group = this.getCms().readGroup((String)listItem.get("cgn"));
                    CmsRole role = CmsRole.valueOf((CmsGroup)group);
                    if (!OpenCms.getRoleManager().hasRole(this.getCms(), user.getName(), role)) continue;
                    OpenCms.getRoleManager().removeUserFromRole(this.getCms(), role, user.getName());
                    this.getCms().writeUser(user);
                }
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_DEACTIVATE_SELECTED_USERS_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        String roleName = this.getSelectedItem().getId();
        try {
            CmsRole role = CmsRole.valueOf((CmsGroup)this.getCms().readGroup(roleName));
            CmsUser user = this.getCms().readUser(new CmsUUID(this.getParamUserid()));
            if (this.getParamListAction().equals(LIST_ACTION_ACTIVATE)) {
                try {
                    OpenCms.getRoleManager().addUserToRole(this.getCms(), role, user.getName());
                    this.getCms().writeUser(user);
                }
                catch (CmsException e) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_ACTIVATE_ROLE_2", (Object)roleName, (Object)user.getName()), (Throwable)e);
                }
            } else if (this.getParamListAction().equals(LIST_ACTION_DEACTIVATE)) {
                if (!OpenCms.getRoleManager().getRolesOfUser(this.getCms(), user.getName(), "", true, true, true).contains(role)) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_DEACTIVATE_INDIRECT_ROLE_2", (Object)roleName, (Object)user.getName()));
                }
                try {
                    OpenCms.getRoleManager().removeUserFromRole(this.getCms(), role, user.getName());
                    this.getCms().writeUser(user);
                }
                catch (CmsException e) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_DEACTIVATE_ROLE_2", (Object)roleName, (Object)user.getName()), (Throwable)e);
                }
            } else {
                this.throwListUnsupportedActionException();
            }
            this.listSave();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    public String getIconPath(CmsListItem item) {
        try {
            CmsRole role = CmsRole.valueOf((CmsGroup)this.getCms().readGroup((String)item.get("cgn")));
            if (OpenCms.getRoleManager().hasRole(this.getCms(), this.getCms().readUser(new CmsUUID(this.getParamUserid())).getName(), role)) {
                return "tools/accounts/buttons/role.png";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "tools/accounts/buttons/role_inactive.png";
    }

    public String getParamUserid() {
        return this.m_paramUserid;
    }

    public void setParamUserid(String userid) {
        this.m_paramUserid = userid;
    }

    protected String defaultActionHtmlStart() {
        return this.getList().listJs() + this.dialogContentStart(this.getParamTitle());
    }

    protected List getRoles() throws CmsException {
        return OpenCms.getRoleManager().getRolesOfUser(this.getCms(), this.getCms().getRequestContext().currentUser().getName(), this.getParamOufqn(), false, false, true);
    }

    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        CmsListColumnDefinition actCol = new CmsListColumnDefinition(LIST_COLUMN_ACTIVATE);
        actCol.setName(Messages.get().container("GUI_ROLEEDIT_LIST_COLS_ACTIVATE_0"));
        actCol.setHelpText(Messages.get().container("GUI_ROLEEDIT_LIST_COLS_ACTIVATE_HELP_0"));
        actCol.setWidth("20");
        actCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        actCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemActionIconComparator());
        CmsListDirectAction actAction = new CmsListDirectAction(LIST_ACTION_ACTIVATE){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    String roleName = this.getItem().getId();
                    try {
                        CmsRole role = CmsRole.valueOf((CmsGroup)CmsRoleEditList.this.getCms().readGroup(roleName));
                        return !OpenCms.getRoleManager().hasRole(CmsRoleEditList.this.getCms(), CmsRoleEditList.this.getCms().readUser(new CmsUUID(((CmsRoleEditList)this.getWp()).getParamUserid())).getName(), role);
                    }
                    catch (CmsException e) {
                        return false;
                    }
                }
                return super.isVisible();
            }
        };
        actAction.setName(Messages.get().container("GUI_ROLEEDIT_LIST_ACTION_ACTIVATE_NAME_0"));
        actAction.setHelpText(Messages.get().container("GUI_ROLEEDIT_LIST_ACTION_ACTIVATE_HELP_0"));
        actAction.setIconPath("list/inactive.png");
        actCol.addDirectAction((I_CmsListDirectAction)actAction);
        CmsListDirectAction deactAction = new CmsListDirectAction(LIST_ACTION_DEACTIVATE){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    String roleName = this.getItem().getId();
                    try {
                        CmsRole role = CmsRole.valueOf((CmsGroup)CmsRoleEditList.this.getCms().readGroup(roleName));
                        return OpenCms.getRoleManager().hasRole(CmsRoleEditList.this.getCms(), CmsRoleEditList.this.getCms().readUser(new CmsUUID(((CmsRoleEditList)this.getWp()).getParamUserid())).getName(), role);
                    }
                    catch (CmsException e) {
                        return false;
                    }
                }
                return super.isVisible();
            }
        };
        deactAction.setName(Messages.get().container("GUI_ROLEEDIT_LIST_ACTION_DEACTIVATE_NAME_0"));
        deactAction.setHelpText(Messages.get().container("GUI_ROLEEDIT_LIST_ACTION_DEACTIVATE_HELP_0"));
        deactAction.setIconPath("list/active.png");
        actCol.addDirectAction((I_CmsListDirectAction)deactAction);
        metadata.addColumn(actCol, 1);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails descriptionDetails = new CmsListItemDetails("dd");
        descriptionDetails.setAtColumn("cn");
        descriptionDetails.setVisible(true);
        descriptionDetails.setShowActionName(Messages.get().container("GUI_ROLEEDIT_DETAIL_SHOW_DESCRIPTION_NAME_0"));
        descriptionDetails.setShowActionHelpText(Messages.get().container("GUI_ROLEEDIT_DETAIL_SHOW_DESCRIPTION_HELP_0"));
        descriptionDetails.setHideActionName(Messages.get().container("GUI_ROLEEDIT_DETAIL_HIDE_DESCRIPTION_NAME_0"));
        descriptionDetails.setHideActionHelpText(Messages.get().container("GUI_ROLEEDIT_DETAIL_HIDE_DESCRIPTION_HELP_0"));
        descriptionDetails.setName(Messages.get().container("GUI_ROLEEDIT_DETAIL_DESCRIPTION_NAME_0"));
        descriptionDetails.setFormatter(new I_CmsListFormatter(){

            public String format(Object data, Locale locale) {
                StringBuffer html = new StringBuffer(512);
                html.append("<table border='0' cellspacing='0' cellpadding='0'>\n");
                html.append("\t<tr>\n");
                html.append("\t\t<td style='white-space:normal;' >\n");
                html.append("\t\t\t");
                html.append(data == null ? "" : data);
                html.append("\n");
                html.append("\t\t</td>\n");
                html.append("\t</tr>\n");
                html.append("</table>\n");
                return html.toString();
            }
        });
        metadata.addItemDetails(descriptionDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction activateRole = new CmsListMultiAction(LIST_MACTION_ACTIVATE);
        activateRole.setName(Messages.get().container("GUI_ROLEEDIT_LIST_MACTION_ACTIVATE_NAME_0"));
        activateRole.setHelpText(Messages.get().container("GUI_ROLEEDIT_LIST_MACTION_ACTIVATE_HELP_0"));
        activateRole.setIconPath("list/multi_activate.png");
        metadata.addMultiAction(activateRole);
        CmsListMultiAction deactivateRole = new CmsListMultiAction(LIST_MACTION_DEACTIVATE);
        deactivateRole.setName(Messages.get().container("GUI_ROLEEDIT_LIST_MACTION_DEACTIVATE_NAME_0"));
        deactivateRole.setHelpText(Messages.get().container("GUI_ROLEEDIT_LIST_MACTION_DEACTIVATE_HELP_0"));
        deactivateRole.setIconPath("list/multi_deactivate.png");
        metadata.addMultiAction(deactivateRole);
    }
}

