/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;

public class CmsRoleOverviewDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "role";
    public static final String[] PAGES = new String[]{"page1"};
    protected CmsRole m_role;
    private String m_paramOufqn;
    private String m_paramRole;

    public CmsRoleOverviewDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsRoleOverviewDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
    }

    /*
     * WARNING - void declaration
     */
    public String getDependency() {
        String dependency = "";
        CmsRole role = this.m_role;
        while (role.getParentRole() != null) {
            dependency = dependency + role.getParentRole().getName(this.getCms().getRequestContext().getLocale());
            if ((role = role.getParentRole()).getParentRole() == null) continue;
            dependency = dependency + ", ";
        }
        if (this.m_role.forOrgUnit(null).equals((Object)CmsRole.WORKPLACE_USER)) {
            void var3_3;
            dependency = "";
            try {
                Iterator itWuParents = OpenCms.getRoleManager().getRoles(this.getCms(), this.getParamOufqn(), false).iterator();
            }
            catch (CmsException e) {
                return dependency;
            }
            while (var3_3.hasNext()) {
                CmsRole wuParent = (CmsRole)var3_3.next();
                if (wuParent.forOrgUnit(null).equals((Object)CmsRole.WORKPLACE_USER)) continue;
                String roleName = wuParent.getName(this.getCms().getRequestContext().getLocale());
                if (dependency.length() > 0) {
                    roleName = roleName + ", ";
                }
                dependency = roleName + dependency;
            }
        }
        return dependency;
    }

    public String getDescription() {
        return this.m_role.getDescription(this.getCms().getRequestContext().getLocale());
    }

    public String getName() {
        return this.m_role.getName(this.getCms().getRequestContext().getLocale());
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public String getParamRole() {
        return this.m_paramRole;
    }

    public void setDependency(String dependency) {
        dependency.length();
    }

    public void setDescription(String description) {
        description.length();
    }

    public void setName(String name) {
        name.length();
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void setParamRole(String role) {
        this.m_paramRole = role;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_ROLE_OVERVIEW_LABEL_IDENTIFICATION_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 2));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.initRoleObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "dependency", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "description", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initRoleObject() {
        try {
            this.m_role = CmsRole.valueOf((CmsGroup)this.getCms().readGroup(this.m_paramRole));
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    protected void validateParamaters() throws Exception {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.ACCOUNT_MANAGER.forOrgUnit(this.getParamOufqn()));
        CmsRole.valueOf((CmsGroup)this.getCms().readGroup(this.getParamRole())).getGroupName();
    }
}

