/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.accounts.A_CmsRoleUsersList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsRoleUsersList
extends A_CmsRoleUsersList {
    public static final String LIST_ACTION_REMOVE = "ar";
    public static final String LIST_DEFACTION_REMOVE = "dr";
    public static final String LIST_ID = "lru";
    public static final String LIST_MACTION_REMOVE = "mr";
    protected static Set m_removeActionIds = new HashSet();

    public CmsRoleUsersList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsRoleUsersList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsRoleUsersList(CmsJspActionElement jsp, String listId) {
        super(jsp, listId, Messages.get().container("GUI_ROLEUSERS_LIST_NAME_0"), true);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_REMOVE)) {
            Iterator itItems = this.getSelectedItems().iterator();
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                String userName = (String)listItem.get("cl");
                try {
                    if (!this.getCms().readUser(userName).getOuFqn().equals(this.getParamOufqn())) continue;
                    OpenCms.getRoleManager().removeUserFromRole(this.getCms(), CmsRole.valueOf((CmsGroup)this.getCms().readGroup(this.getParamRole())), userName);
                }
                catch (CmsException e) {}
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        if (m_removeActionIds.contains(this.getParamListAction())) {
            CmsListItem listItem = this.getSelectedItem();
            try {
                OpenCms.getRoleManager().removeUserFromRole(this.getCms(), CmsRole.valueOf((CmsGroup)this.getCms().readGroup(this.getParamRole())), (String)listItem.get("cl"));
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_REMOVE_SELECTED_GROUP_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected List getUsers(boolean withOtherOus) throws CmsException {
        return OpenCms.getRoleManager().getUsersOfRole(this.getCms(), CmsRole.valueOf((CmsGroup)this.getCms().readGroup(this.getParamRole())), withOtherOus, true);
    }

    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition("cs");
        stateCol.setName(Messages.get().container("GUI_USERS_LIST_COLS_STATE_0"));
        stateCol.setHelpText(Messages.get().container("GUI_USERS_LIST_COLS_STATE_HELP_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_REMOVE);
        stateAction.setName(Messages.get().container("GUI_USERS_LIST_DEFACTION_REMOVE_NAME_0"));
        stateAction.setHelpText(Messages.get().container("GUI_ROLEUSERS_LIST_DEFACTION_REMOVE_HELP_0"));
        stateAction.setIconPath("list/minus.png");
        stateCol.addDirectAction((I_CmsListDirectAction)stateAction);
        metadata.addColumn(stateCol, 1);
        m_removeActionIds.add(stateAction.getId());
    }

    protected void setDefaultAction(CmsListColumnDefinition loginCol) {
        CmsListDefaultAction removeAction = new CmsListDefaultAction(LIST_DEFACTION_REMOVE);
        removeAction.setName(Messages.get().container("GUI_USERS_LIST_DEFACTION_REMOVE_NAME_0"));
        removeAction.setHelpText(Messages.get().container("GUI_USERS_LIST_DEFACTION_REMOVE_HELP_0"));
        loginCol.addDefaultAction(removeAction);
        m_removeActionIds.add(removeAction.getId());
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction removeMultiAction = new CmsListMultiAction(LIST_MACTION_REMOVE);
        removeMultiAction.setName(Messages.get().container("GUI_USERS_LIST_MACTION_REMOVE_NAME_0"));
        removeMultiAction.setHelpText(Messages.get().container("GUI_USERS_LIST_MACTION_REMOVE_HELP_0"));
        removeMultiAction.setConfirmationMessage(Messages.get().container("GUI_USERS_LIST_MACTION_REMOVE_CONF_0"));
        removeMultiAction.setIconPath("list/multi_minus.png");
        metadata.addMultiAction(removeMultiAction);
    }

    protected void validateParamaters() throws Exception {
        super.validateParamaters();
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.valueOf((CmsGroup)this.getCms().readGroup(this.getParamRole())));
    }
}

