/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.A_CmsRolesList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsRolesList
extends A_CmsRolesList {
    public static final String LIST_DEFACTION_OVERVIEW = "do";
    public static final String LIST_DETAIL_USERS = "du";
    public static final String LIST_ID = "lsrs";
    public static final String PARAM_ROLE = "role";

    public CmsRolesList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsRolesList(CmsJspActionElement jsp, String listId) {
        this(jsp, listId, Messages.get().container("GUI_ROLEEDIT_LIST_NAME_0"));
    }

    public CmsRolesList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsRolesList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        super(jsp, listId, listName);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        throw new UnsupportedOperationException();
    }

    public void executeListSingleActions() throws IOException, ServletException, CmsRuntimeException {
        block7: {
            String roleName = this.getSelectedItem().get("cgn").toString();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("oufqn", this.getParamOufqn());
            params.put(PARAM_ROLE, roleName);
            params.put("action", "initial");
            if (this.getParamListAction().equals("ai")) {
                try {
                    if (OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.valueOf((CmsGroup)this.getCms().readGroup(roleName)))) {
                        this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/overview/edit", params);
                        break block7;
                    }
                    this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/overview", params);
                }
                catch (CmsException cmsException) {}
            } else if (this.getParamListAction().equals(LIST_DEFACTION_OVERVIEW)) {
                this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/overview", params);
            } else {
                this.throwListUnsupportedActionException();
            }
        }
        this.listSave();
    }

    public String getEditIcon() {
        return "tools/accounts/buttons/user.png";
    }

    public String getIconPath(CmsListItem item) {
        return "tools/accounts/buttons/role.png";
    }

    protected void fillDetails(String detailId) {
        if (!detailId.equals(LIST_DETAIL_USERS)) {
            super.fillDetails(detailId);
            return;
        }
        List roles = this.getList().getAllContent();
        Iterator itRoles = roles.iterator();
        while (itRoles.hasNext()) {
            CmsListItem item = (CmsListItem)itRoles.next();
            String roleName = item.get("cgn").toString();
            StringBuffer html = new StringBuffer(512);
            try {
                if (!detailId.equals(LIST_DETAIL_USERS)) continue;
                CmsRole role = CmsRole.valueOf((CmsGroup)this.getCms().readGroup(roleName));
                List users = OpenCms.getRoleManager().getUsersOfRole(this.getCms(), role, true, true);
                Iterator itUsers = users.iterator();
                while (itUsers.hasNext()) {
                    CmsUser user = (CmsUser)itUsers.next();
                    if (user.getOuFqn().equals(this.getParamOufqn())) {
                        html.append(user.getSimpleName());
                    } else {
                        html.append(user.getDisplayName(this.getCms(), this.getLocale()));
                    }
                    if (itUsers.hasNext()) {
                        html.append("<br>");
                    }
                    html.append("\n");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected List getRoles() throws CmsException {
        return OpenCms.getRoleManager().getRoles(this.getCms(), this.getParamOufqn(), false);
    }

    protected void setColumns(CmsListMetadata metadata) {
        super.setColumns(metadata);
        CmsListDefaultAction defOverviewAction = new CmsListDefaultAction(LIST_DEFACTION_OVERVIEW);
        defOverviewAction.setName(Messages.get().container("GUI_ROLEEDIT_LIST_DEFACTION_OVERVIEW_NAME_0"));
        defOverviewAction.setHelpText(Messages.get().container("GUI_ROLEEDIT_LIST_DEFACTION_OVERVIEW_HELP_0"));
        metadata.getColumnDefinition("cn").addDefaultAction(defOverviewAction);
        metadata.getColumnDefinition("ci").getDirectAction("ai").setEnabled(true);
        metadata.getColumnDefinition("ci").setHelpText(Messages.get().container("GUI_ROLEEDIT_LIST_COLS_EDIT_HELP_0"));
    }

    protected boolean includeOuDetails() {
        return false;
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        super.setIndependentActions(metadata);
        CmsListItemDetails usersDetails = new CmsListItemDetails(LIST_DETAIL_USERS);
        usersDetails.setAtColumn("cn");
        usersDetails.setVisible(false);
        usersDetails.setShowActionName(Messages.get().container("GUI_ROLES_DETAIL_SHOW_USERS_NAME_0"));
        usersDetails.setShowActionHelpText(Messages.get().container("GUI_ROLES_DETAIL_SHOW_USERS_HELP_0"));
        usersDetails.setHideActionName(Messages.get().container("GUI_ROLES_DETAIL_HIDE_USERS_NAME_0"));
        usersDetails.setHideActionHelpText(Messages.get().container("GUI_ROLES_DETAIL_HIDE_USERS_HELP_0"));
        usersDetails.setName(Messages.get().container("GUI_ROLES_DETAIL_USERS_NAME_0"));
        usersDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_ROLES_DETAIL_USERS_NAME_0")));
        metadata.addItemDetails(usersDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

