/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.A_CmsRolesList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsShowUserRolesList
extends A_CmsRolesList {
    public static final String LIST_ID = "lsur";
    private Boolean m_hasRolesInOtherOus;
    private String m_paramUserid;

    public CmsShowUserRolesList(CmsJspActionElement jsp) {
        this(jsp, LIST_ID);
    }

    public CmsShowUserRolesList(CmsJspActionElement jsp, String listId) {
        this(jsp, listId, Messages.get().container("GUI_USERROLES_LIST_NAME_0"));
    }

    public CmsShowUserRolesList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsShowUserRolesList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName) {
        super(jsp, listId, listName);
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public String getIconPath(CmsListItem item) {
        List roles = this.getList().getAllContent();
        Iterator itRoles = roles.iterator();
        ArrayList<CmsRole> roleObjects = new ArrayList<CmsRole>();
        try {
            while (itRoles.hasNext()) {
                CmsListItem listItem = (CmsListItem)itRoles.next();
                roleObjects.add(CmsRole.valueOf((CmsGroup)this.getCms().readGroup((String)listItem.get("cgn"))));
            }
            CmsRole role = CmsRole.valueOf((CmsGroup)this.getCms().readGroup((String)item.get("cgn")));
            if (role.getParentRole() != null && roleObjects.contains(role.getParentRole())) {
                if (role.getOuFqn().equals(this.getParamOufqn())) {
                    return "tools/accounts/buttons/role_child.png";
                }
                return "tools/accounts/buttons/role_other_ou_inherit.png";
            }
            if (role.getOuFqn().equals(this.getParamOufqn())) {
                return "tools/accounts/buttons/role.png";
            }
            return "tools/accounts/buttons/role_other_ou.png";
        }
        catch (CmsException e) {
            return "tools/accounts/buttons/role.png";
        }
    }

    public String getParamUserid() {
        return this.m_paramUserid;
    }

    public void setParamUserid(String userid) {
        this.m_paramUserid = userid;
    }

    public void writeDialog() throws IOException {
        try {
            if (!this.getCms().readUser(new CmsUUID(this.getParamUserid())).isWebuser()) {
                super.writeDialog();
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    protected String defaultActionHtmlStart() {
        return this.dialogContentStart(this.getParamTitle());
    }

    protected List getRoles() throws CmsException {
        List allRoles = OpenCms.getRoleManager().getRolesOfUser(this.getCms(), this.getCms().readUser(new CmsUUID(this.getParamUserid())).getName(), "", true, true, false);
        List childRoles = OpenCms.getRoleManager().getRolesOfUser(this.getCms(), this.getCms().readUser(new CmsUUID(this.getParamUserid())).getName(), this.getParamOufqn(), false, false, false);
        Iterator itChildRoles = childRoles.iterator();
        while (itChildRoles.hasNext()) {
            CmsRole role = (CmsRole)itChildRoles.next();
            if (allRoles.contains(role)) continue;
            allRoles.add(role);
        }
        return allRoles;
    }

    protected boolean hasRolesInOtherOus() {
        if (this.m_hasRolesInOtherOus == null) {
            this.m_hasRolesInOtherOus = Boolean.FALSE;
            try {
                Iterator itRoles = this.getRoles().iterator();
                while (itRoles.hasNext()) {
                    CmsRole role = (CmsRole)itRoles.next();
                    if (role.getOuFqn().equals(this.getParamOufqn())) continue;
                    this.m_hasRolesInOtherOus = Boolean.TRUE;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_hasRolesInOtherOus;
    }

    protected boolean includeOuDetails() {
        return false;
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        super.setIndependentActions(metadata);
        CmsListItemDetails pathDetails = new CmsListItemDetails("dp");
        pathDetails.setAtColumn("cn");
        pathDetails.setVisible(false);
        pathDetails.setHideAction((I_CmsListAction)new CmsListIndependentAction("dp"){

            public String getIconPath() {
                return "list/details_hide.png";
            }

            public boolean isVisible() {
                return ((CmsShowUserRolesList)this.getWp()).hasRolesInOtherOus();
            }
        });
        pathDetails.setShowAction((I_CmsListAction)new CmsListIndependentAction("dp"){

            public String getIconPath() {
                return "list/details_show.png";
            }

            public boolean isVisible() {
                return ((CmsShowUserRolesList)this.getWp()).hasRolesInOtherOus();
            }
        });
        pathDetails.setShowActionName(Messages.get().container("GUI_ROLES_DETAIL_SHOW_PATH_NAME_0"));
        pathDetails.setShowActionHelpText(Messages.get().container("GUI_ROLES_DETAIL_SHOW_PATH_HELP_0"));
        pathDetails.setHideActionName(Messages.get().container("GUI_ROLES_DETAIL_HIDE_PATH_NAME_0"));
        pathDetails.setHideActionHelpText(Messages.get().container("GUI_ROLES_DETAIL_HIDE_PATH_HELP_0"));
        pathDetails.setName(Messages.get().container("GUI_ROLES_DETAIL_PATH_NAME_0"));
        pathDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_ROLES_DETAIL_PATH_NAME_0")));
        metadata.addItemDetails(pathDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

