/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsXsltUtil;
import org.opencms.widgets.CmsGroupWidget;
import org.opencms.widgets.CmsHttpUploadWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.accounts.A_CmsUserDataImexportDialog;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsUserDataImportDialog
extends A_CmsUserDataImexportDialog {
    public static final String KEY_PREFIX = "userdata.import";
    private String m_importFile;
    private String m_password;

    public CmsUserDataImportDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsUserDataImportDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() throws IOException, ServletException {
        ArrayList<Object> errors = new ArrayList<Object>();
        Iterator it = this.getMultiPartFileItems().iterator();
        FileItem fi = null;
        while (it.hasNext() && (fi = (FileItem)it.next()).getName() == null) {
        }
        if (fi != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)fi.getName())) {
            byte[] content = fi.get();
            File importFile = File.createTempFile("import_users", ".csv");
            this.m_importFile = importFile.getAbsolutePath();
            FileOutputStream fileOutput = new FileOutputStream(importFile);
            fileOutput.write(content);
            fileOutput.close();
            fi.delete();
            FileReader fileReader = new FileReader(importFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String line = bufferedReader.readLine();
            if (line != null) {
                List colDefs = CmsStringUtil.splitAsList((String)line, (String)CmsXsltUtil.getPreferredDelimiter((String)line));
                if (!colDefs.contains("name")) {
                    errors.add(new CmsRuntimeException(Messages.get().container("ERR_USERDATA_IMPORT_CSV_MISSING_NAME_0")));
                }
                if (line.indexOf("password") == -1 && CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_password)) {
                    errors.add(new CmsRuntimeException(Messages.get().container("ERR_USERDATA_IMPORT_CSV_MISSING_PASSWORD_0")));
                }
            }
            bufferedReader.close();
        } else {
            errors.add(new CmsIllegalArgumentException(Messages.get().container("ERR_USERDATA_IMPORT_NO_CONTENT_0")));
        }
        if (errors.isEmpty()) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("groups", CmsStringUtil.collectionAsString((Collection)this.getGroups(), (String)","));
            params.put("roles", CmsStringUtil.collectionAsString((Collection)this.getRoles(), (String)","));
            params.put("importfile", this.m_importFile);
            params.put("password", this.m_password);
            params.put("oufqn", this.getParamOufqn());
            params.put("action", "initial");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getCurrentToolPath() + "/list", params);
        }
        this.setCommitErrors(errors);
    }

    public String dialogButtonsCustom() {
        StringBuffer result = new StringBuffer(256);
        result.append(this.dialogButtonRow(0));
        result.append("<input name=\"ok\" value=\"");
        result.append(this.key("GUI_DIALOG_BUTTON_CONTINUE_0") + "\"");
        result.append(" type=\"submit\"");
        result.append(" class=\"dialogbutton\"");
        result.append(">\n");
        this.dialogButtonsHtml(result, 1, "");
        result.append(this.dialogButtonRow(1));
        return result.toString();
    }

    public String getImportFile() {
        return this.m_importFile;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setImportFile(String importFile) {
        this.m_importFile = importFile;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_USERDATA_IMPORT_LABEL_HINT_BLOCK_0")));
            result.append(this.key("GUI_USERDATA_IMPORT_LABEL_HINT_TEXT_0"));
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_USERDATA_IMPORT_LABEL_DATA_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 3));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlContent() {
        StringBuffer result = new StringBuffer(2048);
        result.append("<form name=\"EDITOR\" id=\"EDITOR\" method=\"post\" action=\"").append(this.getDialogRealUri());
        result.append("\" class=\"nomargin\" onsubmit=\"return submitAction('").append("ok").append("', null, 'EDITOR');\" enctype=\"multipart/form-data\">\n");
        result.append(this.dialogContentStart(this.getDialogTitle()));
        result.append(this.buildDialogForm());
        result.append(this.dialogContentEnd());
        result.append(this.dialogButtonsCustom());
        result.append(this.paramsAsHidden());
        if (this.getParamFramename() == null) {
            result.append("\n<input type=\"hidden\" name=\"").append("framename").append("\" value=\"\">\n");
        }
        result.append("</form>\n");
        result.append(this.getWidgetHtmlEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initImportObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "groups", PAGES[0], (I_CmsWidget)new CmsGroupWidget(null, null, this.getParamOufqn())));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "roles", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getSelectRoles())));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "password", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "importFile", PAGES[0], (I_CmsWidget)new CmsHttpUploadWidget()));
    }

    protected void fillWidgetValues(HttpServletRequest request) {
        Map parameters = this.getMultiPartFileItems() != null ? CmsRequestUtil.readParameterMapFromMultiPart((String)this.getCms().getRequestContext().getEncoding(), (List)this.getMultiPartFileItems()) : request.getParameterMap();
        HashMap<String, String[]> processedParameters = new HashMap<String, String[]>();
        Iterator p = parameters.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (key.startsWith("hidden.")) {
                key = key.substring("hidden.".length());
                String[] newValues = new String[values.length];
                for (int l = 0; l < values.length; ++l) {
                    newValues[l] = CmsEncoder.decode((String)values[l], (String)this.getCms().getRequestContext().getEncoding());
                }
                values = newValues;
            }
            processedParameters.put(key, values);
        }
        this.m_widgetParamValues = new HashMap();
        Iterator i = this.getWidgets().iterator();
        while (i.hasNext()) {
            CmsWidgetDialogParameter base = (CmsWidgetDialogParameter)i.next();
            ArrayList<CmsWidgetDialogParameter> params = new ArrayList<CmsWidgetDialogParameter>();
            int maxOccurs = base.getMaxOccurs();
            boolean onPage = false;
            if (base.isCollectionBase() && CmsStringUtil.isNotEmpty((String)this.getParamAction()) && !"initial".equals(this.getParamAction())) {
                String page = this.getParamPage();
                onPage = CmsStringUtil.isEmpty((String)page) || CmsStringUtil.isEmpty((String)base.getDialogPage()) || base.getDialogPage().equals(page);
            }
            for (int j = 0; j < maxOccurs; ++j) {
                boolean required;
                String id = CmsWidgetDialogParameter.createId((String)base.getName(), (int)j);
                boolean bl = required = params.size() < base.getMinOccurs() || processedParameters.get(id) != null || !onPage && base.hasValue(j);
                if (!required) continue;
                CmsWidgetDialogParameter param = new CmsWidgetDialogParameter(base, params.size(), j);
                param.setKeyPrefix(KEY_PREFIX);
                base.getWidget().setEditorValue(this.getCms(), processedParameters, (I_CmsWidgetDialog)this, (I_CmsWidgetParameter)param);
                params.add(param);
            }
            this.m_widgetParamValues.put(base.getName(), params);
        }
    }

    protected void initImportObject() {
        try {
            if (CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction())) {
                this.setGroups(new ArrayList());
                this.setRoles(new ArrayList());
            } else {
                this.setGroups((List)((Map)this.getDialogObject()).get("groups"));
                this.setRoles((List)((Map)this.getDialogObject()).get("roles"));
                this.m_importFile = (String)((Map)this.getDialogObject()).get("importfile");
                this.m_password = (String)((Map)this.getDialogObject()).get("password");
            }
        }
        catch (Exception e) {
            this.setGroups(new ArrayList());
            this.setRoles(new ArrayList());
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        HashMap<String, Object> objectsMap = new HashMap<String, Object>();
        objectsMap.put("groups", this.getGroups());
        objectsMap.put("roles", this.getRoles());
        objectsMap.put("importfile", this.m_importFile);
        objectsMap.put("password", this.m_password);
        this.setDialogObject(objectsMap);
    }
}

