/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPasswordEncryptionException;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsXsltUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.A_CmsUsersList;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsUserDataImportList
extends A_CmsUsersList {
    public static final int ACTION_IMPORT = 121;
    public static final String IMPORT_ACTION = "import";
    public static final String LIST_ACTION_VALIDATION = "av";
    public static final String LIST_COLUMN_VALIDATION = "cv";
    public static final String LIST_COLUMN_VALIDATION_HIDDEN = "cvh";
    public static final String LIST_DETAIL_REASON = "dre";
    public static final String LIST_ID = "lsudi";
    public static final String LIST_MACTION_SELECT = "ms";
    private String m_paramGroups;
    private String m_paramImportfile;
    private String m_paramOufqn;
    private String m_paramPassword;
    private String m_paramRoles;
    private Map m_reasons;
    private File m_uploadFile;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$opencms$file$CmsUser;

    public CmsUserDataImportList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_IMPORTLISTCSV_LIST_NAME_0"));
        this.getList().setSortedColumn(LIST_COLUMN_VALIDATION_HIDDEN);
    }

    public CmsUserDataImportList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionDialog() throws JspException, ServletException, IOException {
        switch (this.getAction()) {
            case 121: {
                List users = this.getUsers();
                Iterator itUsers = users.iterator();
                while (itUsers.hasNext()) {
                    CmsUser createdUser;
                    CmsUser user = (CmsUser)itUsers.next();
                    if (this.m_reasons != null && this.m_reasons.containsKey(user.getName()) || this.isAlreadyAvailable(user.getName())) continue;
                    String password = user.getPassword();
                    if (password.indexOf("_") == -1) {
                        try {
                            password = OpenCms.getPasswordHandler().digest(password);
                        }
                        catch (CmsPasswordEncryptionException e) {
                            throw new CmsRuntimeException(Messages.get().container("ERR_DIGEST_PASSWORD_0"), (Throwable)e);
                        }
                    } else {
                        password = password.substring(password.indexOf("_") + 1);
                    }
                    try {
                        createdUser = this.getCms().importUser(new CmsUUID().toString(), this.getParamOufqn() + user.getName(), password, user.getFirstname(), user.getLastname(), user.getEmail(), user.getFlags(), System.currentTimeMillis(), user.getAdditionalInfo());
                    }
                    catch (CmsException e) {
                        throw new CmsRuntimeException(Messages.get().container("ERR_IMPORT_USER_0"), (Throwable)e);
                    }
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getParamGroups())) {
                        List groups = CmsStringUtil.splitAsList((String)this.getParamGroups(), (String)",");
                        Iterator itGroups = groups.iterator();
                        while (itGroups.hasNext()) {
                            try {
                                this.getCms().addUserToGroup(createdUser.getName(), (String)itGroups.next());
                            }
                            catch (CmsException e) {
                                throw new CmsRuntimeException(Messages.get().container("ERR_ADD_USER_TO_GROUP_0"), (Throwable)e);
                            }
                        }
                    }
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getParamRoles())) continue;
                    List roles = CmsStringUtil.splitAsList((String)this.getParamRoles(), (String)",");
                    Iterator itRoles = roles.iterator();
                    while (itRoles.hasNext()) {
                        try {
                            OpenCms.getRoleManager().addUserToRole(this.getCms(), CmsRole.valueOfGroupName((String)((String)itRoles.next())), createdUser.getName());
                        }
                        catch (CmsException e) {
                            throw new CmsRuntimeException(Messages.get().container("ERR_ADD_USER_TO_ROLE_0"), (Throwable)e);
                        }
                    }
                }
                this.setAction(4);
                this.actionCloseDialog();
                break;
            }
            default: {
                super.actionDialog();
            }
        }
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_SELECT)) {
            Iterator itItems = this.getSelectedItems().iterator();
            block5: while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                String userName = listItem.get("cdn").toString();
                List users = this.getUsers();
                Iterator itUsers = users.iterator();
                while (itUsers.hasNext()) {
                    CmsUser user = (CmsUser)itUsers.next();
                    try {
                        if (!user.getName().equals(userName) || this.m_reasons != null && this.m_reasons.containsKey(userName) || this.isAlreadyAvailable(user.getName())) continue;
                        String password = user.getPassword();
                        password = password.indexOf("_") == -1 ? OpenCms.getPasswordHandler().digest(password) : password.substring(password.indexOf("_") + 1);
                        CmsUser createdUser = this.getCms().importUser(new CmsUUID().toString(), this.getParamOufqn() + user.getName(), password, user.getFirstname(), user.getLastname(), user.getEmail(), user.getFlags(), System.currentTimeMillis(), user.getAdditionalInfo());
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getParamGroups())) {
                            List groups = CmsStringUtil.splitAsList((String)this.getParamGroups(), (String)",");
                            Iterator itGroups = groups.iterator();
                            while (itGroups.hasNext()) {
                                this.getCms().addUserToGroup(createdUser.getName(), (String)itGroups.next());
                            }
                        }
                        if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getParamRoles())) continue block5;
                        List roles = CmsStringUtil.splitAsList((String)this.getParamRoles(), (String)",");
                        Iterator itRoles = roles.iterator();
                        while (itRoles.hasNext()) {
                            OpenCms.getRoleManager().addUserToRole(this.getCms(), CmsRole.valueOfGroupName((String)((String)itRoles.next())), createdUser.getName());
                        }
                        continue block5;
                    }
                    catch (CmsException e) {
                    }
                }
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("oufqn", this.getParamOufqn());
            params.put("action", "initial");
            try {
                this.getToolManager().jspForwardTool((CmsWorkplace)this, this.getParentPath(), params);
            }
            catch (ServletException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_FORWARDING_TO_PARENT_TOOL_0"), (Throwable)e);
            }
            catch (IOException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_FORWARDING_TO_PARENT_TOOL_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public String getParamGroups() {
        return this.m_paramGroups;
    }

    public String getParamImportfile() {
        return this.m_paramImportfile;
    }

    public String getParamOufqn() {
        return this.m_paramOufqn;
    }

    public String getParamPassword() {
        return this.m_paramPassword;
    }

    public String getParamRoles() {
        return this.m_paramRoles;
    }

    public Map getReasons() {
        return this.m_reasons;
    }

    public void setParamGroups(String paramGroups) {
        this.m_paramGroups = paramGroups;
    }

    public void setParamImportfile(String paramImportfile) {
        this.m_paramImportfile = paramImportfile;
    }

    public void setParamOufqn(String ouFqn) {
        if (ouFqn == null) {
            ouFqn = "";
        }
        this.m_paramOufqn = ouFqn;
    }

    public void setParamPassword(String paramPassword) {
        this.m_paramPassword = paramPassword;
    }

    public void setParamRoles(String paramRoles) {
        this.m_paramRoles = paramRoles;
    }

    public void setReasons(Map reasons) {
        this.m_reasons = reasons;
    }

    protected String customHtmlEnd() {
        StringBuffer result = new StringBuffer(512);
        result.append(super.customHtmlEnd());
        result.append("<form name='actions' method='post' action='");
        result.append(this.getDialogRealUri());
        result.append("' class='nomargin' onsubmit=\"return submitAction('ok', null, 'actions');\">\n");
        result.append(this.allParamsAsHidden());
        result.append(this.dialogButtonRow(0));
        result.append("<input name='");
        result.append(IMPORT_ACTION);
        result.append("' type='button' value='");
        result.append(this.key("GUI_DIALOG_BUTTON_OK_0"));
        result.append("' onclick=\"submitAction('");
        result.append(IMPORT_ACTION);
        result.append("', form);\" class='dialogbutton'>\n");
        this.dialogButtonsHtml(result, 1, "");
        result.append(this.dialogButtonRow(1));
        result.append("</form>\n");
        return result.toString();
    }

    protected String customHtmlStart() {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.dialogBlockStart(this.key("GUI_USERDATA_IMPORT_LABEL_HINT_BLOCK_0")));
        result.append(this.key("GUI_IMPORTLISTCSV_IMPORT_LABEL_HINT_TEXT_0"));
        result.append(this.dialogBlockEnd());
        result.append("<div class=\"dialogspacer\" unselectable=\"on\">&nbsp;</div>");
        return result.toString();
    }

    protected void fillDetails(String detailId) {
        List users = this.getList().getAllContent();
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            CmsListItem item = (CmsListItem)itUsers.next();
            String userName = item.get("cdn").toString();
            StringBuffer html = new StringBuffer(512);
            try {
                if (detailId.equals(LIST_DETAIL_REASON) && this.m_reasons != null && this.m_reasons.containsKey(userName)) {
                    html.append(this.m_reasons.get(userName));
                } else {
                    html.append(this.key("GUI_IMPORTLISTCSV_VALID_USER_0"));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected String getGroupIcon() {
        return null;
    }

    protected List getListItems() {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List users = this.getUsers();
        Iterator itUsers = users.iterator();
        while (itUsers.hasNext()) {
            CmsUser user = (CmsUser)itUsers.next();
            CmsListItem item = this.getList().newItem(user.getName());
            item.set("cdn", (Object)user.getName());
            if (this.isAlreadyAvailable(user.getName())) {
                if (this.m_reasons == null) {
                    this.m_reasons = new HashMap();
                }
                this.m_reasons.put(user.getName(), Messages.get().container("GUI_IMPORTLISTCSV_ALREADY_EXISTS_0").key(this.getLocale()));
            }
            if (this.m_reasons != null && this.m_reasons.containsKey(user.getName())) {
                item.set(LIST_COLUMN_VALIDATION_HIDDEN, (Object)"invalid");
            } else {
                item.set(LIST_COLUMN_VALIDATION_HIDDEN, (Object)"valid");
            }
            ret.add(item);
        }
        return ret;
    }

    protected List getUsers() {
        String separator = null;
        ArrayList values = null;
        this.m_uploadFile = new File(this.m_paramImportfile);
        ArrayList<CmsUser> users = null;
        try {
            String line;
            FileReader fileReader = new FileReader(this.m_uploadFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            boolean headline = true;
            while ((line = bufferedReader.readLine()) != null) {
                if (users == null) {
                    users = new ArrayList<CmsUser>();
                }
                if (separator == null) {
                    separator = CmsXsltUtil.getPreferredDelimiter((String)line);
                }
                List lineValues = CmsStringUtil.splitAsList((String)line, (String)separator);
                if (headline) {
                    values = new ArrayList();
                    Iterator itLineValues = lineValues.iterator();
                    while (itLineValues.hasNext()) {
                        values.add(itLineValues.next());
                    }
                    headline = false;
                    continue;
                }
                if (values == null) continue;
                CmsUser curUser = new CmsUser();
                try {
                    for (int i = 0; i < values.size(); ++i) {
                        String curValue = (String)values.get(i);
                        try {
                            Method method = (class$org$opencms$file$CmsUser == null ? CmsUserDataImportList.class$("org.opencms.file.CmsUser") : class$org$opencms$file$CmsUser).getMethod("set" + curValue.substring(0, 1).toUpperCase() + curValue.substring(1), class$java$lang$String == null ? CmsUserDataImportList.class$("java.lang.String") : class$java$lang$String);
                            if (lineValues.size() <= i || lineValues.get(i) == null) continue;
                            String value = (String)lineValues.get(i);
                            if (curValue.equals("password") && CmsStringUtil.isEmptyOrWhitespaceOnly((String)value)) {
                                value = this.m_paramPassword;
                            }
                            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)value) || value.equals("null")) continue;
                            method.invoke((Object)curUser, value);
                            continue;
                        }
                        catch (NoSuchMethodException ne) {
                            curUser.setAdditionalInfo(curValue, lineValues.get(i));
                            continue;
                        }
                        catch (IllegalAccessException le) {
                            if (this.m_reasons == null) {
                                this.m_reasons = new HashMap();
                            }
                            this.m_reasons.put(curUser.getName(), le);
                            continue;
                        }
                        catch (InvocationTargetException te) {
                            if (this.m_reasons == null) {
                                this.m_reasons = new HashMap();
                            }
                            this.m_reasons.put(curUser.getName(), te);
                        }
                    }
                }
                catch (CmsRuntimeException e) {
                    if (this.m_reasons == null) {
                        this.m_reasons = new HashMap();
                    }
                    if (curUser.getName() == null) {
                        this.m_reasons.put(lineValues.get(0), e);
                    }
                    this.m_reasons.put(curUser.getName(), e);
                }
                users.add(curUser);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return users;
    }

    protected void initExportObject() {
        try {
            if (CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction())) {
                this.m_reasons = new HashMap();
            } else {
                Hashtable objects = (Hashtable)this.getSettings().getDialogObject();
                if (objects == null) {
                    objects = new Hashtable();
                    this.getSettings().setDialogObject(objects);
                }
                this.m_reasons = (Map)objects.get(((Object)((Object)this)).getClass().getName());
            }
        }
        catch (Exception e) {
            this.m_reasons = new HashMap();
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        if (IMPORT_ACTION.equals(this.getParamAction())) {
            this.setAction(121);
        }
        if (this.m_reasons == null) {
            Hashtable objects = (Hashtable)this.getSettings().getDialogObject();
            if (objects == null) {
                objects = new Hashtable();
                this.getSettings().setDialogObject(objects);
            }
            objects.remove(((Object)((Object)this)).getClass().getName());
        } else {
            Hashtable<String, Map> objects = (Hashtable<String, Map>)this.getSettings().getDialogObject();
            if (objects == null) {
                objects = new Hashtable<String, Map>();
                this.getSettings().setDialogObject(objects);
            }
            objects.put(((Object)((Object)this)).getClass().getName(), this.m_reasons);
        }
    }

    protected boolean isAlreadyAvailable(String userName) {
        List availableUsers;
        try {
            availableUsers = OpenCms.getOrgUnitManager().getUsers(this.getCms(), this.getParamOufqn(), false);
        }
        catch (CmsException e) {
            availableUsers = new ArrayList();
        }
        Iterator itAvailableUsers = availableUsers.iterator();
        while (itAvailableUsers.hasNext()) {
            if (!userName.equals(((CmsUser)itAvailableUsers.next()).getSimpleName())) continue;
            return true;
        }
        return false;
    }

    protected CmsUser readUser(String name) {
        return null;
    }

    protected void setColumns(CmsListMetadata metadata) {
        this.initExportObject();
        super.setColumns(metadata);
        metadata.getColumnDefinition("cg").setVisible(false);
        metadata.getColumnDefinition("cr").setVisible(false);
        metadata.getColumnDefinition("ca").setVisible(false);
        metadata.getColumnDefinition("cd").setVisible(false);
        metadata.getColumnDefinition("cn").setVisible(false);
        metadata.getColumnDefinition("cm").setVisible(false);
        metadata.getColumnDefinition("cl").setVisible(false);
        metadata.getColumnDefinition("cdn").getDefaultAction("de").setEnabled(false);
        metadata.getColumnDefinition("cdn").setWidth("100%");
        CmsListColumnDefinition hiddenStateCol = new CmsListColumnDefinition(LIST_COLUMN_VALIDATION_HIDDEN);
        hiddenStateCol.setName(Messages.get().container("GUI_IMPORTLISTCSV_LIST_COLS_VAIDATION_0"));
        hiddenStateCol.setVisible(false);
        hiddenStateCol.setSorteable(true);
        metadata.addColumn(hiddenStateCol);
        CmsListColumnDefinition stateCol = new CmsListColumnDefinition(LIST_COLUMN_VALIDATION);
        stateCol.setName(Messages.get().container("GUI_IMPORTLISTCSV_LIST_COLS_VAIDATION_0"));
        stateCol.setWidth("20");
        stateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        stateCol.setSorteable(false);
        CmsListDirectAction stateAction = new CmsListDirectAction(LIST_ACTION_VALIDATION){

            public String getIconPath() {
                String userName = this.getItem().getId();
                if (((CmsUserDataImportList)this.getWp()).getReasons() != null && ((CmsUserDataImportList)this.getWp()).getReasons().containsKey(userName) || ((CmsUserDataImportList)this.getWp()).isAlreadyAvailable(userName)) {
                    return "list/multi_delete.png";
                }
                return "list/multi_activate.png";
            }
        };
        stateAction.setName(Messages.get().container("GUI_IMPORTLISTCSV_LIST_COLS_VAIDATION_0"));
        stateAction.setIconPath("list/multi_activate.png");
        stateAction.setEnabled(false);
        stateCol.addDirectAction((I_CmsListDirectAction)stateAction);
        metadata.addColumn(stateCol, 1);
    }

    protected void setDeleteAction(CmsListColumnDefinition deleteCol) {
    }

    protected void setEditAction(CmsListColumnDefinition editCol) {
        CmsListDirectAction editAction = new CmsListDirectAction("ae");
        editAction.setName(Messages.get().container("GUI_USERS_LIST_ACTION_EDIT_NAME_0"));
        editAction.setIconPath("tools/accounts/buttons/user.png");
        editAction.setEnabled(false);
        editCol.addDirectAction((I_CmsListDirectAction)editAction);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails reasonDetails = new CmsListItemDetails(LIST_DETAIL_REASON);
        reasonDetails.setAtColumn("cdn");
        reasonDetails.setVisible(true);
        reasonDetails.setShowActionName(Messages.get().container("GUI_IMPORTLISTCSV_DETAIL_SHOW_REASON_NAME_0"));
        reasonDetails.setShowActionHelpText(Messages.get().container("GUI_IMPORTLISTCSV_DETAIL_SHOW_REASON_HELP_0"));
        reasonDetails.setHideActionName(Messages.get().container("GUI_IMPORTLISTCSV_DETAIL_HIDE_REASON_NAME_0"));
        reasonDetails.setHideActionHelpText(Messages.get().container("GUI_IMPORTLISTCSV_DETAIL_HIDE_REASON_HELP_0"));
        reasonDetails.setName(Messages.get().container("GUI_IMPORTLISTCSV_DETAIL_REASON_NAME_0"));
        reasonDetails.setFormatter(new I_CmsListFormatter(){

            public String format(Object data, Locale locale) {
                StringBuffer html = new StringBuffer(512);
                html.append("<table border='0' cellspacing='0' cellpadding='0'>\n");
                html.append("\t<tr>\n");
                html.append("\t\t<td style='white-space:normal;' >\n");
                html.append("\t\t\t");
                html.append(data == null ? "" : data);
                html.append("\n");
                html.append("\t\t</td>\n");
                html.append("\t</tr>\n");
                html.append("</table>\n");
                return html.toString();
            }
        });
        metadata.addItemDetails(reasonDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction selectUser = new CmsListMultiAction(LIST_MACTION_SELECT);
        selectUser.setName(Messages.get().container("GUI_IMPORTLISTCSV_LIST_MACTION_SELECT_NAME_0"));
        selectUser.setHelpText(Messages.get().container("GUI_IMPORTLISTCSV_LIST_MACTION_SELECT_HELP_0"));
        selectUser.setIconPath("list/multi_add.png");
        metadata.addMultiAction(selectUser);
    }
}

