/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.accounts;

import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsUser;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsSessionManager;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.tools.accounts.Messages;

public class CmsUserOverviewDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "user.ov";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_USERID = "userid";
    private static final I_CmsListFormatter LAST_LOGIN_FORMATTER = CmsListDateMacroFormatter.getDefaultDateFormatter();
    protected CmsUser m_user;
    private String m_paramUserid;

    public CmsUserOverviewDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsUserOverviewDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        this.setCommitErrors(new ArrayList());
    }

    public void actionSwitchUser() throws CmsException {
        try {
            CmsSessionManager sessionManager = OpenCms.getSessionManager();
            sessionManager.switchUser(this.getCms(), this.getJsp().getRequest(), this.getCms().readUser(new CmsUUID(this.getJsp().getRequest().getParameter(PARAM_USERID))));
        }
        catch (CmsException e) {
            String toolPath = this.getCurrentToolPath().substring(0, this.getCurrentToolPath().lastIndexOf("/"));
            this.getToolManager().setCurrentToolPath((CmsWorkplace)this, toolPath);
            throw e;
        }
    }

    public String getAssignedOu() {
        try {
            return OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.m_user.getOuFqn()).getDisplayName(this.getLocale());
        }
        catch (CmsException e) {
            return null;
        }
    }

    public String getCreated() {
        return LAST_LOGIN_FORMATTER.format((Object)new Date(this.m_user.getDateCreated()), this.getLocale());
    }

    public String getDescription() {
        return this.m_user.getDescription(this.getLocale());
    }

    public String getLastlogin() {
        return LAST_LOGIN_FORMATTER.format((Object)new Date(this.m_user.getLastlogin()), this.getLocale());
    }

    public String getName() {
        return this.m_user.getSimpleName();
    }

    public String getParamUserid() {
        return this.m_paramUserid;
    }

    public boolean isSelfManagement() {
        return !this.m_user.isManaged();
    }

    public void setAssignedOu(String assignedOu) {
        assignedOu.length();
    }

    public void setCreated(String created) {
        if (created == null) {
            // empty if block
        }
    }

    public void setDescription(String description) {
        this.m_user.setDescription(description);
    }

    public void setLastlogin(String lastlogin) {
        if (lastlogin == null) {
            // empty if block
        }
    }

    public void setName(String name) {
        name.length();
    }

    public void setParamUserid(String userId) {
        this.m_paramUserid = userId;
    }

    public void setSelfManagement(boolean selfManagement) {
        this.m_user.setManaged(!selfManagement);
    }

    protected String createDialogHtml(String dialog) {
        int n;
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        int n2 = n = !this.isOverview() ? 3 : 5;
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_USER_EDITOR_LABEL_IDENTIFICATION_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, n));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            if (!this.isOverview()) {
                result.append(this.createWidgetTableEnd());
                return result.toString();
            }
            result.append(this.dialogBlockStart(this.key("GUI_USER_EDITOR_LABEL_ADDRESS_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(6, 9));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_USER_EDITOR_LABEL_AUTHENTIFICATION_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(10, 13));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        return "";
    }

    protected void defineWidgets() {
        this.initUserObject();
        this.setKeyPrefix(KEY_PREFIX);
        if (this.isOverview()) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "description", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "lastname", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "firstname", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "email", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "assignedOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "address", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "zipcode", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "city", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "country", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "enabled", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "selfManagement", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "lastlogin", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "created", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "lastname", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_user, "firstname", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "assignedOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initUserObject() {
        try {
            this.m_user = this.getCms().readUser(new CmsUUID(this.getParamUserid()));
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        super.initWorkplaceMembers(jsp);
        this.setOnlineHelpUriCustom("/accounts/users/overview/");
    }

    protected void validateParamaters() throws Exception {
        this.getCms().readUser(new CmsUUID(this.getParamUserid())).getName();
    }

    private boolean isOverview() {
        return this.getCurrentToolPath().endsWith("/users/edit");
    }
}

