/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.database;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.importexport.CmsExportParameters;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsComboWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.database.CmsDatabaseImportFromServer;
import org.opencms.workplace.tools.database.Messages;

public class CmsDatabaseExportDialog
extends CmsWidgetDialog {
    public static final String[] PAGES = new String[]{"page1"};
    protected static final String EXPORT_ACTION_REPORT = "/system/workplace/admin/database/reports/export.jsp";
    private CmsExportParameters m_exportParams;

    public CmsDatabaseExportDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDatabaseExportDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() throws IOException, ServletException {
        ArrayList errors = new ArrayList();
        String exportFileName = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSystemInfo().getPackagesRfsPath() + File.separator + this.m_exportParams.getPath());
        this.m_exportParams.setPath(exportFileName);
        this.setDialogObject(this.m_exportParams);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("classname", ((Object)((Object)this)).getClass().getName());
        params.put("style", "new");
        params.put("closelink", CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/database"));
        this.getToolManager().jspForwardPage((CmsWorkplace)this, EXPORT_ACTION_REPORT, params);
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        result.append(this.createWidgetBlockStart(this.key("GUI_DATABASE_EXPORT_FILE_BLOCK_0")));
        result.append(this.createDialogRowsHtml(0, 0));
        result.append(this.createWidgetBlockEnd());
        result.append(this.createWidgetBlockStart(this.key("GUI_DATABASE_EXPORT_TYPES_BLOCK_0")));
        result.append(this.createDialogRowsHtml(1, 3));
        result.append(this.createWidgetBlockEnd());
        result.append(this.createWidgetBlockStart(this.key("GUI_DATABASE_EXPORT_SETTINGS_BLOCK_0")));
        result.append(this.createDialogRowsHtml(4, 8));
        result.append(this.createWidgetBlockEnd());
        result.append(this.createWidgetBlockStart(this.key("GUI_DATABASE_EXPORT_RESOURCES_BLOCK_0")));
        result.append(this.createDialogRowsHtml(9, 9));
        result.append(this.createWidgetBlockEnd());
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initDatabaseExportObject();
        List exportFiles = this.getComboExportFiles();
        if (exportFiles.isEmpty()) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "path", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "path", PAGES[0], (I_CmsWidget)new CmsComboWidget(exportFiles)));
        }
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "exportResourceData", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "exportAccountData", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "exportProjectData", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "includeUnchangedResources", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "includeSystemFolder", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "contentAge", "0", PAGES[0], (I_CmsWidget)new CmsCalendarWidget(), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "recursive", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "inProject", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_exportParams, "resources", "/", PAGES[0], (I_CmsWidget)new CmsVfsFileWidget(false, this.getCms().getRequestContext().getSiteRoot()), 1, 200));
    }

    protected List getComboExportFiles() {
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>(8);
        Iterator i = CmsDatabaseImportFromServer.getFileListFromServer(false).iterator();
        while (i.hasNext()) {
            String fileName = (String)i.next();
            String helpText = this.key("GUI_EDITOR_HELP_EXPORTFILE_1", new String[]{fileName});
            result.add(new CmsSelectWidgetOption(fileName, false, null, helpText));
        }
        return result;
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initDatabaseExportObject() {
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) ? new CmsExportParameters() : this.getDialogObject();
        this.m_exportParams = !(o instanceof CmsExportParameters) ? new CmsExportParameters() : (CmsExportParameters)o;
        if (CmsStringUtil.isEmpty((String)this.getParamAction()) && this.m_exportParams.getResources().size() < 1) {
            ArrayList<String> initialPaths = new ArrayList<String>(1);
            initialPaths.add("/");
            this.m_exportParams.setResources(initialPaths);
        }
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_exportParams);
    }
}

