/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.database;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.opencms.configuration.CmsImportExportConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.importexport.CmsExtendedHtmlImportDefault;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsHttpUploadWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.explorer.CmsNewResourceXmlPage;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.database.CmsHtmlImport;
import org.opencms.workplace.tools.database.Messages;

public class CmsHtmlImportDialog
extends CmsWidgetDialog {
    public static final String IMPORT_DEFAULT_PATH = "htmldefault.jsp";
    public static final String IMPORT_STANDARD_PATH = "htmlimport.jsp";
    public static final String KEY_PREFIX = "htmlimport";
    public static final String MODE_ADVANCED = "advanced";
    public static final String MODE_DEFAULT = "default";
    public static final String MODE_STANDARD = "standard";
    public static final String[] PAGES = new String[]{"page1"};
    protected static final String IMPORT_ACTION_REPORT = "/system/workplace/admin/database/reports/htmlimport.jsp";
    protected CmsHtmlImport m_htmlimport;
    private String m_dialogMode;

    public CmsHtmlImportDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsHtmlImportDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        this.setDialogObject(this.m_htmlimport);
        try {
            if (this.isDisplayMode(MODE_DEFAULT)) {
                this.m_htmlimport.validate(null, true);
                this.fillExtendedHtmlImportDefault();
                OpenCms.writeConfiguration((Class)CmsImportExportConfiguration.class);
            } else {
                FileItem fi = this.getHttpImportFileItem();
                this.m_htmlimport.validate(fi, false);
                this.writeHttpImportDir(fi);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("classname", ((Object)((Object)this)).getClass().getName());
                params.put("style", "new");
                params.put("closelink", CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/database"));
                this.getToolManager().jspForwardPage((CmsWorkplace)this, IMPORT_ACTION_REPORT, params);
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            int row = this.isDisplayMode(MODE_DEFAULT) ? 1 : (this.isDisplayMode(MODE_ADVANCED) ? 0 : 2);
            result.append(this.createWidgetBlockStart(this.key("GUI_HTMLIMPORT_BLOCK_LABEL_FOLDER_0")));
            result.append(this.createDialogRowsHtml(0, row));
            result.append(this.createWidgetBlockEnd());
            result.append(this.createWidgetBlockStart(this.key("GUI_HTMLIMPORT_BLOCK_LABEL_GALLERY_0")));
            result.append(this.createDialogRowsHtml(++row, row + 2));
            result.append(this.createWidgetBlockEnd());
            result.append(this.createWidgetBlockStart(this.key("GUI_HTMLIMPORT_BLOCK_LABEL_SETTINGS_0")));
            result.append(this.createDialogRowsHtml(row + 3, row + 10));
            result.append(this.createWidgetBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected String defaultActionHtmlContent() {
        StringBuffer result = new StringBuffer(2048);
        result.append("<form name=\"EDITOR\" id=\"EDITOR\" method=\"post\" action=\"").append(this.getDialogRealUri());
        result.append("\" class=\"nomargin\" onsubmit=\"return submitAction('").append("ok").append("', null, 'EDITOR');\" enctype=\"multipart/form-data\">\n");
        result.append(this.dialogContentStart(this.getDialogTitle()));
        result.append(this.buildDialogForm());
        result.append(this.dialogContentEnd());
        result.append(this.dialogButtonsCustom());
        result.append(this.paramsAsHidden());
        if (this.getParamFramename() == null) {
            result.append("\n<input type=\"hidden\" name=\"").append("framename").append("\" value=\"\">\n");
        }
        result.append("</form>\n");
        result.append(this.getWidgetHtmlEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initHtmlImportObject();
        this.setKeyPrefix(KEY_PREFIX);
        if (!this.isDisplayMode(MODE_ADVANCED)) {
            this.addWidget(this.getDialogParameter("inputDir", (I_CmsWidget)new CmsInputWidget()));
        }
        if (!this.isDisplayMode(MODE_DEFAULT)) {
            this.addWidget(this.getDialogParameter("httpDir", (I_CmsWidget)new CmsHttpUploadWidget()));
        }
        if (!this.isDisplayMode(MODE_ADVANCED)) {
            this.addWidget(this.getDialogParameter("destinationDir", (I_CmsWidget)new CmsVfsFileWidget(false, this.getCms().getRequestContext().getSiteRoot())));
        }
        this.addWidget(this.getDialogParameter("imageGallery", (I_CmsWidget)new CmsVfsFileWidget(false, this.getCms().getRequestContext().getSiteRoot())));
        this.addWidget(this.getDialogParameter("downloadGallery", (I_CmsWidget)new CmsVfsFileWidget(false, this.getCms().getRequestContext().getSiteRoot())));
        this.addWidget(this.getDialogParameter("linkGallery", (I_CmsWidget)new CmsVfsFileWidget(false, this.getCms().getRequestContext().getSiteRoot())));
        this.addWidget(this.getDialogParameter("template", (I_CmsWidget)new CmsSelectWidget(this.getTemplates())));
        this.addWidget(this.getDialogParameter("element", (I_CmsWidget)new CmsInputWidget()));
        this.addWidget(this.getDialogParameter("locale", (I_CmsWidget)new CmsSelectWidget(this.getLocales())));
        this.addWidget(this.getDialogParameter("inputEncoding", (I_CmsWidget)new CmsInputWidget()));
        this.addWidget(this.getDialogParameter("startPattern", (I_CmsWidget)new CmsInputWidget()));
        this.addWidget(this.getDialogParameter("endPattern", (I_CmsWidget)new CmsInputWidget()));
        this.addWidget(this.getDialogParameter("overwrite", (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(this.getDialogParameter("keepBrokenLinks", (I_CmsWidget)new CmsCheckboxWidget()));
    }

    protected void fillHtmlImport() {
        CmsExtendedHtmlImportDefault extimport = OpenCms.getImportExportManager().getExtendedHtmlImportDefault();
        this.m_htmlimport.setDestinationDir(extimport.getDestinationDir());
        this.m_htmlimport.setInputDir(extimport.getInputDir());
        this.m_htmlimport.setDownloadGallery(extimport.getDownloadGallery());
        this.m_htmlimport.setImageGallery(extimport.getImageGallery());
        this.m_htmlimport.setLinkGallery(extimport.getLinkGallery());
        this.m_htmlimport.setTemplate(extimport.getTemplate());
        this.m_htmlimport.setElement(extimport.getElement());
        this.m_htmlimport.setLocale(extimport.getLocale());
        this.m_htmlimport.setInputEncoding(extimport.getEncoding());
        this.m_htmlimport.setStartPattern(extimport.getStartPattern());
        this.m_htmlimport.setEndPattern(extimport.getEndPattern());
        this.m_htmlimport.setOverwrite(Boolean.valueOf(extimport.getOverwrite()));
        this.m_htmlimport.setKeepBrokenLinks(Boolean.valueOf(extimport.getKeepBrokenLinks()));
    }

    protected void fillWidgetValues(HttpServletRequest request) {
        Map parameters = this.getMultiPartFileItems() != null ? CmsRequestUtil.readParameterMapFromMultiPart((String)this.getCms().getRequestContext().getEncoding(), (List)this.getMultiPartFileItems()) : request.getParameterMap();
        HashMap<String, String[]> processedParameters = new HashMap<String, String[]>();
        Iterator p = parameters.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (key.startsWith("hidden.")) {
                key = key.substring("hidden.".length());
                String[] newValues = new String[values.length];
                for (int l = 0; l < values.length; ++l) {
                    newValues[l] = CmsEncoder.decode((String)values[l], (String)this.getCms().getRequestContext().getEncoding());
                }
                values = newValues;
            }
            processedParameters.put(key, values);
        }
        this.m_widgetParamValues = new HashMap();
        Iterator i = this.getWidgets().iterator();
        while (i.hasNext()) {
            CmsWidgetDialogParameter base = (CmsWidgetDialogParameter)i.next();
            ArrayList<CmsWidgetDialogParameter> params = new ArrayList<CmsWidgetDialogParameter>();
            int maxOccurs = base.getMaxOccurs();
            boolean onPage = false;
            if (base.isCollectionBase() && CmsStringUtil.isNotEmpty((String)this.getParamAction()) && !"initial".equals(this.getParamAction())) {
                String page = this.getParamPage();
                onPage = CmsStringUtil.isEmpty((String)page) || CmsStringUtil.isEmpty((String)base.getDialogPage()) || base.getDialogPage().equals(page);
            }
            for (int j = 0; j < maxOccurs; ++j) {
                boolean required;
                String id = CmsWidgetDialogParameter.createId((String)base.getName(), (int)j);
                boolean bl = required = params.size() < base.getMinOccurs() || processedParameters.get(id) != null || !onPage && base.hasValue(j);
                if (!required) continue;
                CmsWidgetDialogParameter param = new CmsWidgetDialogParameter(base, params.size(), j);
                param.setKeyPrefix(KEY_PREFIX);
                base.getWidget().setEditorValue(this.getCms(), processedParameters, (I_CmsWidgetDialog)this, (I_CmsWidgetParameter)param);
                params.add(param);
            }
            this.m_widgetParamValues.put(base.getName(), params);
        }
    }

    protected CmsWidgetDialogParameter getDialogParameter(String property, I_CmsWidget widget) {
        return new CmsWidgetDialogParameter((Object)this.m_htmlimport, property, PAGES[0], widget);
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initHtmlImportObject() {
        String uri = this.getJsp().getRequestContext().getUri();
        this.m_dialogMode = uri == null || uri.endsWith(IMPORT_STANDARD_PATH) ? MODE_STANDARD : (uri.endsWith(IMPORT_DEFAULT_PATH) ? MODE_DEFAULT : MODE_ADVANCED);
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) ? new CmsHtmlImport(this.getJsp().getCmsObject()) : this.getDialogObject();
        if (!(o instanceof CmsHtmlImport)) {
            this.m_htmlimport = new CmsHtmlImport(this.getJsp().getCmsObject());
        } else {
            this.m_htmlimport = (CmsHtmlImport)o;
            this.m_htmlimport.setCmsObject(this.getJsp().getCmsObject());
        }
        this.fillHtmlImport();
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    private void fillExtendedHtmlImportDefault() {
        CmsExtendedHtmlImportDefault extimport = OpenCms.getImportExportManager().getExtendedHtmlImportDefault();
        extimport.setDestinationDir(this.m_htmlimport.getDestinationDir());
        extimport.setInputDir(this.m_htmlimport.getInputDir());
        extimport.setDownloadGallery(this.m_htmlimport.getDownloadGallery());
        extimport.setImageGallery(this.m_htmlimport.getImageGallery());
        extimport.setLinkGallery(this.m_htmlimport.getLinkGallery());
        extimport.setTemplate(this.m_htmlimport.getTemplate());
        extimport.setElement(this.m_htmlimport.getElement());
        extimport.setLocale(this.m_htmlimport.getLocale());
        extimport.setEncoding(this.m_htmlimport.getInputEncoding());
        extimport.setStartPattern(this.m_htmlimport.getStartPattern());
        extimport.setEndPattern(this.m_htmlimport.getEndPattern());
        extimport.setOverwrite(Boolean.toString(this.m_htmlimport.isOverwrite()));
        extimport.setKeepBrokenLinks(Boolean.toString(this.m_htmlimport.isKeepBrokenLinks()));
        OpenCms.getImportExportManager().setExtendedHtmlImportDefault(extimport);
    }

    private List getLocales() {
        ArrayList<CmsSelectWidgetOption> ret = new ArrayList<CmsSelectWidgetOption>();
        try {
            Iterator i = OpenCms.getLocaleManager().getAvailableLocales().iterator();
            while (i.hasNext()) {
                Locale locale = (Locale)i.next();
                String language = locale.getLanguage();
                String displayLanguage = locale.getDisplayLanguage();
                ret.add(new CmsSelectWidgetOption(language, false, displayLanguage));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    private List getTemplates() {
        ArrayList<CmsSelectWidgetOption> ret = new ArrayList<CmsSelectWidgetOption>();
        TreeMap templates = null;
        try {
            templates = CmsNewResourceXmlPage.getTemplates((CmsObject)this.getJsp().getCmsObject(), null);
            Iterator i = templates.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String title = (String)entry.getKey();
                String path = (String)entry.getValue();
                ret.add(new CmsSelectWidgetOption(path, false, title));
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        return ret;
    }

    private boolean isDisplayMode(String mode) {
        return this.m_dialogMode.equals(mode);
    }

    private void writeHttpImportDir(FileItem fi) throws CmsException {
        try {
            if (fi != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)fi.getName())) {
                byte[] content = fi.get();
                File importFile = File.createTempFile("import_html", ".zip");
                FileOutputStream fileOutput = new FileOutputStream(importFile.getAbsolutePath());
                fileOutput.write(content);
                fileOutput.close();
                fi.delete();
                this.m_htmlimport.setHttpDir(importFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new CmsException(Messages.get().container("ERR_ACTION_ZIPFILE_UPLOAD_0"));
        }
    }

    private FileItem getHttpImportFileItem() {
        FileItem result = null;
        this.m_htmlimport.setHttpDir("");
        Iterator it = this.getMultiPartFileItems().iterator();
        FileItem fi = null;
        while (it.hasNext() && (fi = (FileItem)it.next()).getName() == null) {
        }
        if (fi != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)fi.getName())) {
            result = fi;
        }
        return result;
    }
}

