/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.report.A_CmsReportThread;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.content.CmsElementChangeLocaleSettings;
import org.opencms.workplace.tools.content.Messages;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsChangeElementLocaleThread
extends A_CmsReportThread {
    private CmsElementChangeLocaleSettings m_settings;

    public CmsChangeElementLocaleThread(CmsObject cms, CmsElementChangeLocaleSettings settings) {
        super(cms, Messages.get().getBundle().key("GUI_CHANGEELEMENTLOCALE_THREAD_NAME_0"));
        this.initHtmlReport(cms.getRequestContext().getLocale());
        this.m_settings = settings;
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public void run() {
        this.getReport().println(Messages.get().container("RPT_CHANGEELEMENTLOCALE_BEGIN_2", (Object)this.m_settings.getOldLocale(), (Object)this.m_settings.getNewLocale()), 2);
        try {
            this.changeElementLocales();
        }
        catch (CmsException e) {
            this.getReport().println((Throwable)e);
        }
        this.getReport().print(org.opencms.report.Messages.get().container("RPT_STAT_0"));
        this.getReport().println(org.opencms.report.Messages.get().container("RPT_STAT_DURATION_1", (Object)this.getReport().formatRuntime()));
        this.getReport().println(Messages.get().container("RPT_CHANGEELEMENTLOCALE_END_0"), 2);
    }

    private void changeElementLocales() throws CmsException {
        Locale oldLocale = CmsLocaleManager.getLocale((String)this.m_settings.getOldLocale());
        Locale newLocale = CmsLocaleManager.getLocale((String)this.m_settings.getNewLocale());
        boolean checkTemplate = CmsStringUtil.isNotEmpty((String)this.m_settings.getTemplate());
        CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(CmsResourceTypeXmlPage.getStaticTypeId());
        String path = CmsResource.getFolderPath((String)this.m_settings.getVfsFolder());
        List resources = this.getCms().readResources(path, filter, this.m_settings.isIncludeSubFolders());
        int count = 0;
        int resSize = resources.size();
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            CmsResource res = (CmsResource)i.next();
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", (Object)String.valueOf(++count), (Object)String.valueOf(resSize)), 3);
            this.getReport().print(Messages.get().container("RPT_PROCESSING_PAGE_0"), 3);
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)this.getCms().getSitePath(res)));
            this.getReport().print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                if (checkTemplate) {
                    String template = this.getCms().readPropertyObject(res, "template", true).getValue("");
                    if (!this.m_settings.getTemplate().equals(template)) {
                        this.getReport().println(Messages.get().container("RPT_CHANGEELEMENTLOCALE_TEMPLATE_0"), 3);
                        continue;
                    }
                }
                CmsFile file = this.getCms().readFile(res);
                CmsXmlPage page = CmsXmlPageFactory.unmarshal((CmsObject)this.getCms(), (CmsFile)file);
                if (!page.hasLocale(oldLocale)) {
                    this.getReport().println(Messages.get().container("RPT_CHANGEELEMENTLOCALE_OLDLOCALE_1", (Object)this.m_settings.getOldLocale()), 3);
                    continue;
                }
                if (page.hasLocale(newLocale)) {
                    this.getReport().println(Messages.get().container("RPT_CHANGEELEMENTLOCALE_NEWLOCALE_1", (Object)this.m_settings.getNewLocale()), 3);
                    continue;
                }
                page.moveLocale(oldLocale, newLocale);
                file.setContents(page.marshal());
                CmsLock lock = this.getCms().getLock(res);
                boolean isLocked = false;
                boolean canWrite = false;
                if (lock.isNullLock()) {
                    this.getCms().lockResource(this.getCms().getSitePath(res));
                    isLocked = true;
                    canWrite = true;
                } else if (lock.isOwnedBy(this.getCms().getRequestContext().currentUser())) {
                    canWrite = true;
                }
                if (canWrite) {
                    this.getCms().writeFile(file);
                } else {
                    this.getReport().println(Messages.get().container("RPT_CHANGEELEMENTLOCALE_NOTLOCKED_0"), 3);
                }
                if (isLocked) {
                    this.getCms().unlockResource(this.getCms().getSitePath(res));
                }
                if (!canWrite) continue;
                this.getReport().println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
            catch (CmsException e) {
                this.getReport().println((Throwable)e);
            }
        }
    }
}

