/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.importexport.CmsVfsImportExportHandler;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsNewResourceXmlPage;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.content.CmsElementChangeLocaleSettings;
import org.opencms.workplace.tools.content.Messages;

public class CmsElementChangeLocaleDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "changelocale";
    public static final String[] PAGES = new String[]{"page1"};
    protected static final String CHANGELOCALE_ACTION_REPORT = "/system/workplace/admin/contenttools/reports/changelocale.jsp";
    private static final Log LOG = CmsLog.getLog((Object)CmsElementChangeLocaleDialog.class);
    private CmsElementChangeLocaleSettings m_settings;

    public CmsElementChangeLocaleDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsElementChangeLocaleDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() throws IOException, ServletException {
        ArrayList<CmsIllegalArgumentException> errors = new ArrayList<CmsIllegalArgumentException>();
        this.setDialogObject(this.m_settings);
        try {
            if (this.m_settings.getOldLocale().equals(this.m_settings.getNewLocale())) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_CHANGEELEMENTLOCALE_LOCALE_EQUAL_0"));
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("classname", ((Object)((Object)this)).getClass().getName());
            params.put("style", "new");
            params.put("closelink", CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/contenttools"));
            this.getToolManager().jspForwardPage((CmsWorkplace)this, CHANGELOCALE_ACTION_REPORT, params);
        }
        catch (CmsIllegalArgumentException e) {
            errors.add(e);
        }
        this.setCommitErrors(errors);
    }

    public List getLocaleConfigOptions() {
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        List locales = OpenCms.getLocaleManager().getAvailableLocales();
        Iterator i = locales.iterator();
        while (i.hasNext()) {
            Locale locale = (Locale)i.next();
            String language = locale.toString();
            String displayLanguage = locale.getDisplayLanguage(this.getLocale());
            result.add(new CmsSelectWidgetOption(language, false, displayLanguage));
        }
        return result;
    }

    public List getTemplateConfigOptions() {
        TreeMap templates;
        ArrayList<CmsSelectWidgetOption> result;
        block4: {
            result = new ArrayList<CmsSelectWidgetOption>();
            result.add(new CmsSelectWidgetOption("", true, this.key("GUI_CHANGEELEMENTLOCALE_DIALOG_TEMPLATE_ALL_0")));
            templates = null;
            try {
                templates = CmsNewResourceXmlPage.getTemplates((CmsObject)this.getCms(), null);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block4;
                LOG.info((Object)e);
            }
        }
        if (templates != null) {
            Iterator i = templates.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                String path = (String)entry.getValue();
                result.add(new CmsSelectWidgetOption(path, false, key));
            }
        }
        return result;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        result.append(this.createWidgetBlockStart(this.key("GUI_CHANGEELEMENTLOCALE_DIALOG_BLOCK_SETTINGS_0")));
        result.append(this.createDialogRowsHtml(0, 4));
        result.append(this.createWidgetBlockEnd());
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initSettingsObject();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_settings, "vfsFolder", "/", PAGES[0], (I_CmsWidget)new CmsVfsFileWidget(false, this.getCms().getRequestContext().getSiteRoot()), 1, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_settings, "includeSubFolders", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_settings, "template", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getTemplateConfigOptions())));
        List localeSelections = this.getLocaleConfigOptions();
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_settings, "oldLocale", PAGES[0], (I_CmsWidget)new CmsSelectWidget(localeSelections)));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_settings, "newLocale", PAGES[0], (I_CmsWidget)new CmsSelectWidget(localeSelections)));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        this.addMessages("org.opencms.workplace.workplace");
        super.initMessages();
    }

    protected void initSettingsObject() {
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) ? new CmsVfsImportExportHandler() : this.getDialogObject();
        this.m_settings = !(o instanceof CmsElementChangeLocaleSettings) ? new CmsElementChangeLocaleSettings() : (CmsElementChangeLocaleSettings)o;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_settings);
    }
}

