/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsReport;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.content.CmsMergePagesThread;
import org.opencms.workplace.tools.content.Messages;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsMergePages
extends CmsReport {
    public static final String ALL = "ALL";
    public static final int FOLDER1_EXCLUSIVE = 0;
    public static final int FOLDER2_EXCLUSIVE = 1;
    public static final int FOLDERS_DIFFERENTTYPES = 4;
    public static final int FOLDERS_EQUALNAMES = 3;
    public static final int FOLDERS_SIBLING = 2;
    public static final String DIALOG_TYPE = "mergepages";
    public static final String PARAM_FOLDER1 = "folder1";
    public static final String PARAM_FOLDER2 = "folder2";
    private CmsObject m_cms;
    private String m_errorMessage;
    private List m_folder1Exclusive = new ArrayList();
    private List m_folder2Exclusive = new ArrayList();
    private List m_foldersDifferenttypes;
    private List m_foldersEqualnames;
    private List m_foldersSibling = new ArrayList();
    private String m_paramFolder1;
    private String m_paramFolder2;
    private I_CmsReport m_report;

    public CmsMergePages(CmsJspActionElement jsp) {
        super(jsp);
        this.m_foldersEqualnames = new ArrayList();
        this.m_foldersDifferenttypes = new ArrayList();
    }

    public CmsMergePages(CmsObject cms, PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
        this.m_cms = cms;
    }

    public void actionMerge(I_CmsReport report) {
        this.m_report = report;
        this.m_report.println(Messages.get().container("RPT_MERGE_PAGES_BEGIN_0"), 2);
        try {
            this.collectResources();
            this.mergePages();
            this.cleanup();
        }
        catch (CmsException e) {
            this.m_report.println((Throwable)e);
        }
    }

    public void actionReport() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        switch (this.getAction()) {
            case 92: {
                this.actionCloseDialog();
                break;
            }
            case 91: {
                this.setParamAction("reportupdate");
                this.getJsp().include("/system/workplace/commons/includes/report.jsp");
                break;
            }
            default: {
                CmsMergePagesThread thread = new CmsMergePagesThread(this.getCms(), this);
                thread.start();
                this.setParamAction("reportbegin");
                this.setParamThread(thread.getUUID().toString());
                this.getJsp().include("/system/workplace/commons/includes/report.jsp");
            }
        }
    }

    public CmsObject getCms() {
        if (this.m_cms == null) {
            return super.getCms();
        }
        return this.m_cms;
    }

    public String getErrorMessage() {
        if (CmsStringUtil.isEmpty((String)this.m_errorMessage)) {
            return "";
        }
        return this.m_errorMessage;
    }

    public String getParamFolder1() {
        return this.m_paramFolder1;
    }

    public String getParamFolder2() {
        return this.m_paramFolder2;
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public void setParamFolder1(String folder1) {
        this.m_paramFolder1 = folder1;
    }

    public void setParamFolder2(String folder2) {
        this.m_paramFolder2 = folder2;
    }

    public void validateParameters(CmsObject cms) {
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        StringBuffer validationErrors = new StringBuffer();
        if (CmsStringUtil.isEmpty((String)this.getParamFolder1())) {
            validationErrors.append(messages.key("GUI_MERGE_PAGES_VALIDATE_FIRST_FOLDER_0")).append("<br>");
        } else {
            try {
                cms.readResource(this.getParamFolder1());
            }
            catch (CmsException e) {
                validationErrors.append(messages.key("GUI_MERGE_PAGES_VALIDATE_FIRST_FOLDER_1", (Object)this.getParamFolder1())).append("<br>");
            }
        }
        if (CmsStringUtil.isEmpty((String)this.getParamFolder2())) {
            validationErrors.append(messages.key("GUI_MERGE_PAGES_VALIDATE_SECOND_FOLDER_0")).append("<br>");
        } else {
            try {
                cms.readResource(this.getParamFolder2());
            }
            catch (CmsException e) {
                validationErrors.append(messages.key("GUI_MERGE_PAGES_VALIDATE_SECOND_FOLDER_1", (Object)this.getParamFolder2())).append("<br>");
            }
        }
        if (this.getParamFolder1().equals(this.getParamFolder2())) {
            validationErrors.append(messages.key("GUI_MERGE_PAGES_VALIDATE_SAME_FOLDER_0")).append("<br>");
        }
        this.setErrorMessage(validationErrors.toString());
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        if ("confirmed".equals(this.getParamAction())) {
            this.setAction(1);
        } else if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else if ("reportupdate".equals(this.getParamAction())) {
            this.setAction(91);
        } else if ("reportbegin".equals(this.getParamAction())) {
            this.setAction(90);
        } else if ("reportend".equals(this.getParamAction())) {
            this.setAction(92);
        } else {
            this.setAction(0);
            this.setParamTitle(Messages.get().getBundle(this.getLocale()).key("GUI_TITLE_MERGEPAGES_0"));
        }
    }

    private int analyse(CmsResource res, String sourceMergeFolder, String targetMergefolder, int currentFolder) {
        int retValue = -1;
        String resourcenameOther = this.getResourceNameInOtherFolder(this.m_cms.getSitePath(res), sourceMergeFolder, targetMergefolder);
        try {
            CmsResource otherRes = this.m_cms.readResource(resourcenameOther, CmsResourceFilter.IGNORE_EXPIRATION);
            retValue = res.getResourceId().equals((Object)otherRes.getResourceId()) ? 2 : (res.getTypeId() == otherRes.getTypeId() ? 3 : 4);
        }
        catch (CmsException e) {
            retValue = currentFolder == 1 ? 0 : 1;
        }
        return retValue;
    }

    private void cleanup() {
        this.m_folder1Exclusive = null;
        this.m_folder2Exclusive = null;
        this.m_foldersSibling = null;
        this.m_foldersEqualnames = null;
        this.m_foldersDifferenttypes = null;
    }

    private void collectFolder(String sourceMergeFolder, String targetMergefolder, int currentFolder) throws CmsException {
        CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION.addRequireType(CmsResourceTypeXmlPage.getStaticTypeId());
        List folderResources = this.m_cms.readResources(sourceMergeFolder, filter, true);
        Iterator i = folderResources.iterator();
        int size = folderResources.size();
        this.m_report.println(Messages.get().container("RPT_SCAN_PAGES_IN_FOLDER_BEGIN_2", (Object)sourceMergeFolder, (Object)new Integer(size)), 2);
        int count = 1;
        while (i.hasNext()) {
            CmsResource res = (CmsResource)i.next();
            String resName = this.m_cms.getSitePath(res);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", (Object)String.valueOf(count++), (Object)String.valueOf(size)), 3);
            this.m_report.println(Messages.get().container("RPT_PROCESS_1", (Object)resName), 3);
            int action = this.analyse(res, sourceMergeFolder, targetMergefolder, currentFolder);
            switch (action) {
                case 0: {
                    this.m_folder1Exclusive.add(resName);
                    this.m_report.println(Messages.get().container("RPT_FOLDER1_EXCLUSIVE_0"), 4);
                    break;
                }
                case 1: {
                    this.m_folder2Exclusive.add(resName);
                    this.m_report.println(Messages.get().container("RPT_FOLDER2_EXCLUSIVE_0"), 4);
                    break;
                }
                case 2: {
                    if (!this.m_foldersSibling.contains(this.getResourceNameInOtherFolder(resName, sourceMergeFolder, targetMergefolder))) {
                        this.m_foldersSibling.add(resName);
                    }
                    this.m_report.println(Messages.get().container("RPT_FOLDERS_SIBLING_0"), 4);
                    break;
                }
                case 3: {
                    if (!this.m_foldersEqualnames.contains(this.getResourceNameInOtherFolder(resName, sourceMergeFolder, targetMergefolder))) {
                        this.m_foldersEqualnames.add(resName);
                    }
                    this.m_report.println(Messages.get().container("RPT_FOLDERS_EQUALNAMES_0"), 4);
                    break;
                }
                case 4: {
                    if (!this.m_foldersDifferenttypes.contains(this.getResourceNameInOtherFolder(resName, sourceMergeFolder, targetMergefolder))) {
                        this.m_foldersDifferenttypes.add(resName);
                    }
                    this.m_report.println(Messages.get().container("RPT_FOLDERS_DIFFERENTTYPES_0"), 4);
                    break;
                }
            }
            res = null;
        }
        folderResources = null;
        this.m_report.println(Messages.get().container("RPT_SCAN_PAGES_IN_FOLDER_END_0"), 2);
    }

    private void collectResources() throws CmsException {
        String defaultLocale = CmsLocaleManager.getDefaultLocale().toString();
        String locale1 = this.m_cms.readPropertyObject(this.getParamFolder1(), "locale", true).getValue(defaultLocale);
        String locale2 = this.m_cms.readPropertyObject(this.getParamFolder2(), "locale", true).getValue(defaultLocale);
        this.m_report.println(Messages.get().container("RPT_CREATE_EXTERNAL_LINK_0", (Object)this.getParamFolder1(), (Object)locale1), 3);
        this.m_report.println(Messages.get().container("RPT_CREATE_EXTERNAL_LINK_0", (Object)this.getParamFolder2(), (Object)locale2), 3);
        this.collectFolder(this.getParamFolder1(), this.getParamFolder2(), 1);
        this.collectFolder(this.getParamFolder2(), this.getParamFolder1(), 2);
        this.m_report.println(Messages.get().container("RPT_SCANNING_RESULTS_0"), 2);
        this.m_report.println(Messages.get().container("RPT_FOLDER1_EXCLUSIVE_0"), 2);
        this.reportList(this.m_folder1Exclusive, false);
        this.m_report.println(Messages.get().container("RPT_FOLDER2_EXCLUSIVE_0"), 2);
        this.reportList(this.m_folder2Exclusive, false);
        this.m_report.println(Messages.get().container("RPT_FOLDERS_SIBLING_0"), 2);
        this.reportList(this.m_foldersSibling, false);
        this.m_report.println(Messages.get().container("RPT_FOLDERS_EQUALNAMES_0"), 2);
        this.reportList(this.m_foldersEqualnames, true);
        this.m_report.println(Messages.get().container("RPT_FOLDERS_DIFFERENTTYPES_0"), 2);
        this.reportList(this.m_foldersDifferenttypes, false);
    }

    private String getResourceNameInOtherFolder(String resName, String sourceMergeFolder, String targetMergefolder) {
        String resourcename = resName.substring(sourceMergeFolder.length());
        return targetMergefolder + resourcename;
    }

    private void mergePages() throws CmsException {
        int size = this.m_foldersEqualnames.size();
        if (size > 0) {
            this.m_report.println(Messages.get().container("RPT_MERGE_PAGES_BEGIN_1", (Object)String.valueOf(size)), 2);
            String defaultLocale = CmsLocaleManager.getDefaultLocale().toString();
            String locale2 = this.m_cms.readPropertyObject(this.getParamFolder2(), "locale", true).getValue(defaultLocale);
            this.m_report.print(Messages.get().container("RPT_LOCK_FOLDER_0"), 3);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)this.getParamFolder1()));
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            this.m_cms.lockResource(this.getParamFolder1());
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            this.m_report.print(Messages.get().container("RPT_LOCK_FOLDER_0"), 3);
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)this.getParamFolder2()));
            this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            this.m_cms.lockResource(this.getParamFolder2());
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            int count = 1;
            Iterator i = this.m_foldersEqualnames.iterator();
            while (i.hasNext()) {
                String resFolder1Name = (String)i.next();
                try {
                    String resFolder2Name = this.getResourceNameInOtherFolder(resFolder1Name, this.getParamFolder1(), this.getParamFolder2());
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", (Object)String.valueOf(count++), (Object)String.valueOf(size)), 3);
                    this.m_report.print(Messages.get().container("RPT_PROCESS_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)resFolder1Name));
                    this.m_report.print(Messages.get().container("RPT_DOUBLE_ARROW_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", (Object)resFolder2Name));
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    String locale = this.m_cms.readPropertyObject(resFolder1Name, "locale", true).getValue(defaultLocale);
                    this.m_report.print(Messages.get().container("RPT_READ_CONTENT_2", (Object)resFolder1Name, (Object)locale), 3);
                    CmsResource resFolder1 = this.m_cms.readResource(resFolder1Name, CmsResourceFilter.IGNORE_EXPIRATION);
                    CmsFile fileFolder1 = this.m_cms.readFile(resFolder1);
                    CmsXmlPage pageFolder1 = CmsXmlPageFactory.unmarshal((CmsObject)this.m_cms, (CmsFile)fileFolder1);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    locale = this.m_cms.readPropertyObject(resFolder2Name, "locale", true).getValue(defaultLocale);
                    this.m_report.print(Messages.get().container("RPT_READ_CONTENT_2", (Object)resFolder2Name, (Object)locale), 3);
                    CmsResource resFolder2 = this.m_cms.readResource(resFolder2Name, CmsResourceFilter.IGNORE_EXPIRATION);
                    CmsFile fileFolder2 = this.m_cms.readFile(resFolder2);
                    CmsXmlPage pageFolder2 = CmsXmlPageFactory.unmarshal((CmsObject)this.m_cms, (CmsFile)fileFolder2);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    Locale loc = new Locale(locale2);
                    List textElements2 = pageFolder2.getNames(loc);
                    Iterator j = textElements2.iterator();
                    while (j.hasNext()) {
                        String textElementName = (String)j.next();
                        this.m_report.print(Messages.get().container("RPT_PROCESS_TEXT_ELEM_1", (Object)textElementName), 3);
                        String textElement = pageFolder2.getValue(textElementName, loc).getStringValue(this.m_cms);
                        if (!pageFolder1.hasValue(textElementName, loc)) {
                            pageFolder1.addValue(textElementName, loc);
                        }
                        pageFolder1.setStringValue(this.m_cms, textElementName, loc, textElement);
                        this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    }
                    this.m_report.print(Messages.get().container("RPT_WRITE_CONTENT_1", (Object)resFolder1Name), 3);
                    fileFolder1.setContents(pageFolder1.marshal());
                    this.m_cms.writeFile(fileFolder1);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    this.m_report.print(Messages.get().container("RPT_READ_PROPERTIES_1", (Object)resFolder2Name), 3);
                    List properties = this.m_cms.readPropertyObjects(resFolder2Name, false);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    this.m_report.print(Messages.get().container("RPT_DELETE_PAGE_1", (Object)resFolder2Name), 3);
                    this.m_cms.deleteResource(resFolder2Name, CmsResource.DELETE_PRESERVE_SIBLINGS);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    this.m_report.print(Messages.get().container("RPT_COPY_2", (Object)resFolder1Name, (Object)resFolder2Name), 3);
                    this.m_cms.copyResource(resFolder1Name, resFolder2Name, CmsResource.COPY_AS_SIBLING);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    this.m_report.print(Messages.get().container("RPT_RESORE_PROPERTIES_1", (Object)resFolder2Name), 3);
                    this.m_cms.writePropertyObjects(resFolder2Name, properties);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    resFolder1 = null;
                    resFolder2 = null;
                    fileFolder1 = null;
                    fileFolder2 = null;
                    pageFolder1 = null;
                    pageFolder2 = null;
                }
                catch (CmsException e) {
                    this.m_report.println((Throwable)e);
                }
            }
            this.m_report.print(Messages.get().container("RPT_UNLOCK_1", (Object)this.getParamFolder1()), 3);
            this.m_cms.unlockResource(this.getParamFolder1());
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            this.m_report.print(Messages.get().container("RPT_UNLOCK_1", (Object)this.getParamFolder2()), 3);
            this.m_cms.unlockResource(this.getParamFolder2());
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            this.m_report.println(Messages.get().container("RPT_MERGE_PAGES_END_0"), 2);
        }
    }

    private void reportList(List collected, boolean doReport) {
        int size = collected.size();
        this.m_report.println(Messages.get().container("RPT_NUM_PAGES_1", (Object)new Integer(size)), 2);
        if (doReport) {
            int count = 1;
            Iterator i = collected.iterator();
            while (i.hasNext()) {
                String resName = (String)i.next();
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", (Object)String.valueOf(count++), (Object)String.valueOf(size)), 3);
                this.m_report.println(Messages.get().container("RPT_PROCESS_1", (Object)resName), 3);
            }
        }
        this.m_report.println(Messages.get().container("RPT_MERGE_PAGES_END_0"), 2);
    }
}

