/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.content.Messages;

public class CmsPropertyChange
extends CmsDialog {
    public static final int ACTION_SHOWRESULT = 100;
    public static final String DIALOG_SHOWRESULT = "showresult";
    public static final String DIALOG_TYPE = "propertychange";
    public static final String PARAM_NEWVALUE = "newvalue";
    public static final String PARAM_OLDVALUE = "oldvalue";
    public static final String PARAM_PROPERTYNAME = "propertyname";
    public static final String PARAM_RECURSIVE = "recursive";
    private static final Log LOG = CmsLog.getLog((Object)CmsPropertyChange.class);
    private List m_changedResources;
    private String m_errorMessage;
    private String m_paramNewValue;
    private String m_paramOldValue;
    private String m_paramPropertyName;
    private String m_paramRecursive;
    private boolean m_validationErrors;

    public CmsPropertyChange(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPropertyChange(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static String buildSelectProperty(CmsObject cms, String selectValue, String attributes, String selectedValue) {
        List propertyDef;
        block4: {
            propertyDef = new ArrayList();
            try {
                propertyDef = cms.readAllPropertyDefinitions();
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block4;
                LOG.info((Object)e);
            }
        }
        int propertyCount = propertyDef.size();
        ArrayList<String> options = new ArrayList<String>(propertyCount + 1);
        ArrayList<String> values = new ArrayList<String>(propertyCount + 1);
        options.add(CmsEncoder.escapeXml((String)selectValue));
        values.add("");
        int selectedIndex = 0;
        int count = 1;
        for (int i = 0; i < propertyCount; ++i) {
            CmsPropertyDefinition currDef = (CmsPropertyDefinition)propertyDef.get(i);
            if (currDef.getName().equals(selectedValue)) {
                selectedIndex = count;
            }
            options.add(CmsEncoder.escapeXml((String)currDef.getName()));
            values.add(CmsEncoder.escapeXml((String)currDef.getName()));
            ++count;
        }
        CmsDialog wp = new CmsDialog(null);
        return wp.buildSelect(attributes, options, values, selectedIndex);
    }

    public void actionChange() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            boolean recursive = Boolean.valueOf(this.getParamRecursive());
            if (this.performChangeOperation(recursive)) {
                this.setAction(100);
            } else {
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
        }
        catch (Throwable e) {
            this.includeErrorpage((CmsWorkplace)this, e);
        }
    }

    public String buildResultList() {
        StringBuffer result = new StringBuffer(16);
        if (this.getChangedResources() != null && this.getChangedResources().size() > 0) {
            for (int i = 0; i < this.getChangedResources().size(); ++i) {
                CmsResource res = (CmsResource)this.getChangedResources().get(i);
                String resName = this.getCms().getSitePath(res);
                result.append(resName);
                result.append("<br>\n");
            }
        } else {
            result.append(Messages.get().getBundle(this.getLocale()).key("GUI_INPUT_PROPERTYCHANGE_RESULT_NONE_0"));
        }
        return result.toString();
    }

    public String buildSelectProperty(String attributes) {
        return CmsPropertyChange.buildSelectProperty(this.getCms(), Messages.get().getBundle(this.getLocale()).key("GUI_PLEASE_SELECT_0"), attributes, this.getParamPropertyName());
    }

    public String getErrorMessage() {
        if (CmsStringUtil.isEmpty((String)this.m_errorMessage)) {
            return "";
        }
        return this.m_errorMessage;
    }

    public String getParamNewValue() {
        if (this.m_paramNewValue != null) {
            return this.m_paramNewValue;
        }
        return "";
    }

    public String getParamOldValue() {
        return this.m_paramOldValue;
    }

    public String getParamPropertyName() {
        return this.m_paramPropertyName;
    }

    public String getParamRecursive() {
        return this.m_paramRecursive;
    }

    public String getResultListHeight() {
        if (this.getChangedResources() != null && this.getChangedResources().size() > 0) {
            int height = this.getChangedResources().size() * 14;
            if (height > 300) {
                height = 300;
            }
            return "" + height;
        }
        return "14";
    }

    public boolean hasValidationErrors() {
        return this.m_validationErrors;
    }

    public void setParamNewValue(String paramNewValue) {
        this.m_paramNewValue = paramNewValue;
    }

    public void setParamOldValue(String paramOldValue) {
        this.m_paramOldValue = paramOldValue;
    }

    public void setParamPropertyName(String paramPropertyName) {
        this.m_paramPropertyName = paramPropertyName;
    }

    public void setParamRecursive(String paramRecursive) {
        this.m_paramRecursive = paramRecursive;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        if ("ok".equals(this.getParamAction())) {
            if (this.validateParameters()) {
                this.setAction(3);
            } else {
                this.setAction(0);
            }
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setParamTitle(Messages.get().getBundle(this.getLocale()).key("GUI_TITLE_PROPERTYCHANGE_0"));
        }
    }

    protected void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    protected void setValidationErrors(boolean validationErrors) {
        this.m_validationErrors = validationErrors;
    }

    private List getChangedResources() {
        return this.m_changedResources;
    }

    private boolean performChangeOperation(boolean recursive) throws CmsException {
        if (recursive && !"wait".equals(this.getParamAction())) {
            return false;
        }
        this.checkLock(this.getParamResource());
        List changedResources = null;
        changedResources = CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getParamOldValue()) ? this.getCms().changeResourcesInFolderWithProperty(this.getParamResource(), this.getParamPropertyName(), this.getParamOldValue(), this.getParamNewValue(), recursive) : this.setPropertyInFolder(this.getParamResource(), this.getParamPropertyName(), this.getParamNewValue(), recursive);
        this.setChangedResources(changedResources);
        return true;
    }

    private List setPropertyInFolder(String resourceRootPath, String propertyDefinition, String newValue, boolean recursive) throws CmsException, CmsVfsException {
        CmsObject cms = this.getCms();
        List resources = new ArrayList<String>();
        if (recursive) {
            resources = cms.readResources(resourceRootPath, CmsResourceFilter.IGNORE_EXPIRATION);
        } else {
            resources.add(resourceRootPath);
        }
        ArrayList<CmsResource> changedResources = new ArrayList<CmsResource>(resources.size());
        CmsProperty newProperty = new CmsProperty(propertyDefinition, null, null);
        for (int i = 0; i < resources.size(); ++i) {
            CmsResource res = (CmsResource)resources.get(i);
            CmsProperty property = cms.readPropertyObject(res, propertyDefinition, false);
            if (!property.isNullProperty()) continue;
            newProperty.setStructureValue(newValue);
            newProperty.setName(propertyDefinition);
            cms.writePropertyObject(cms.getRequestContext().removeSiteRoot(res.getRootPath()), newProperty);
            changedResources.add(res);
        }
        return changedResources;
    }

    private void setChangedResources(List changedResources) {
        this.m_changedResources = changedResources;
    }

    private boolean validateParameters() {
        boolean allOk = true;
        StringBuffer validationErrors = new StringBuffer(32);
        CmsMessages messages = Messages.get().getBundle(this.getLocale());
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getParamResource()) || !this.getCms().existsResource(this.getParamResource())) {
            allOk = false;
            validationErrors.append(messages.key("GUI_PROP_CHANGE_VALIDATE_VFS_RESOURCE_0")).append("<br>");
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getParamPropertyName())) {
            allOk = false;
            validationErrors.append(messages.key("GUI_PROP_CHANGE_VALIDATE_SELECT_PROPERTY_0")).append("<br>");
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getParamOldValue())) {
            allOk = false;
            validationErrors.append(messages.key("GUI_PROP_CHANGE_VALIDATE_OLD_PROP_VALUE_0")).append("<br>");
        } else {
            try {
                Pattern.compile(this.getParamOldValue());
            }
            catch (PatternSyntaxException e) {
                allOk = false;
                validationErrors.append(messages.key("GUI_PROP_CHANGE_VALIDATE_OLD_PROP_PATTERN_0")).append("<br>");
            }
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.getParamNewValue())) {
            this.setParamNewValue("");
        }
        this.setErrorMessage(validationErrors.toString());
        this.setValidationErrors(!allOk);
        return allOk;
    }
}

