/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content;

import java.util.Iterator;
import org.htmlparser.NodeFactory;
import org.htmlparser.Parser;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;
import org.opencms.util.CmsHtmlParser;
import org.opencms.util.CmsHtmlTagRemoveFactory;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsHtmlNodeVisitor;
import org.opencms.workplace.tools.content.CmsTagReplaceSettings;

public final class CmsTagReplaceParser
extends CmsHtmlParser
implements I_CmsHtmlNodeVisitor {
    private final NodeFactory m_nodeFactory;
    private boolean m_changedContent;
    private final CmsTagReplaceSettings m_settings;

    public CmsTagReplaceParser(CmsTagReplaceSettings settings) {
        super(true);
        this.m_settings = settings;
        CmsHtmlTagRemoveFactory nodeFactory = new CmsHtmlTagRemoveFactory();
        Iterator itDeleteTags = this.m_settings.getDeleteTags().iterator();
        while (itDeleteTags.hasNext()) {
            nodeFactory.addTagRemoval((Tag)itDeleteTags.next());
        }
        this.m_nodeFactory = nodeFactory;
    }

    public String getTagHtml(Tag tag) {
        if (CmsStringUtil.isEmpty((String)tag.getTagName())) {
            return "";
        }
        StringBuffer result = new StringBuffer(32);
        result.append('<');
        Iterator itAttributes = tag.getAttributesEx().iterator();
        while (itAttributes.hasNext()) {
            result.append(itAttributes.next().toString());
            if (!itAttributes.hasNext()) continue;
            result.append(' ');
        }
        result.append('>');
        return result.toString();
    }

    public String process(String html, String encoding) throws ParserException {
        this.m_result = new StringBuffer();
        this.m_changedContent = false;
        Parser parser = new Parser();
        parser.setNodeFactory(this.m_nodeFactory);
        Lexer lexer = new Lexer();
        Page page = new Page(html, encoding);
        lexer.setPage(page);
        parser.setLexer(lexer);
        parser.visitAllNodesWith((NodeVisitor)this);
        return this.getResult();
    }

    public void visitEndTag(Tag tag) {
        boolean change = this.m_settings.replace(tag);
        if (change) {
            this.m_changedContent = true;
        }
        super.visitEndTag(tag);
    }

    public void visitTag(Tag tag) {
        boolean change = this.m_settings.replace(tag);
        if (change) {
            this.m_changedContent = true;
        }
        super.visitTag(tag);
    }

    public boolean isChangedContent() {
        return this.m_changedContent;
    }
}

