/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.htmlparser.Attribute;
import org.htmlparser.NodeFactory;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.Tag;
import org.htmlparser.util.ParserException;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.content.Messages;

public final class CmsTagReplaceSettings {
    public static final String PROPERTY_CONTENTOOLS_TAGREPLACE = "contentools.tagreplace";
    private static final Log LOG = CmsLog.getLog((Object)CmsTagReplaceSettings.class);
    private final CmsObject m_cms;
    private final Set m_deleteTags;
    private NodeFactory m_nodeFactory;
    private String m_propertyValueTagReplaceID;
    private SortedMap m_tags2replacementTags = new TreeMap();
    private String m_workPath;

    public CmsTagReplaceSettings(CmsObject cms) {
        this.m_cms = cms;
        this.m_nodeFactory = new PrototypicalNodeFactory();
        this.m_deleteTags = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        });
    }

    public String getPropertyValueTagReplaceID() {
        return this.m_propertyValueTagReplaceID;
    }

    public SortedMap getReplacements() {
        return this.m_tags2replacementTags;
    }

    public String getWorkPath() {
        return this.m_workPath;
    }

    public void setPropertyValueTagReplaceID(String propertyValueTagreplaceID) throws CmsIllegalArgumentException {
        this.m_propertyValueTagReplaceID = CmsStringUtil.isEmptyOrWhitespaceOnly((String)propertyValueTagreplaceID) ? this.getDefaultTagReplaceID() : propertyValueTagreplaceID;
    }

    public void setReplacements(SortedMap replacements) throws CmsIllegalArgumentException {
        Iterator itMappings = replacements.entrySet().iterator();
        while (itMappings.hasNext()) {
            Map.Entry entry = itMappings.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)value)) {
                String tagName = key.toLowerCase().trim();
                try {
                    Vector<Attribute> attributeList = new Vector<Attribute>(1);
                    Attribute tagNameAttribute = new Attribute();
                    tagNameAttribute.setName(tagName);
                    attributeList.add(tagNameAttribute);
                    Tag deleteTag = this.m_nodeFactory.createTagNode(null, 0, 0, attributeList);
                    this.m_deleteTags.add(deleteTag);
                    itMappings.remove();
                }
                catch (ParserException e) {
                    CmsMessageContainer container = Messages.get().container("GUI_ERR_TAGREPLACE_TAGNAME_INVALID_1", (Object)tagName);
                    throw new CmsIllegalArgumentException(container, (Throwable)e);
                }
            }
            this.m_tags2replacementTags = replacements;
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_propertyValueTagReplaceID)) {
            this.setPropertyValueTagReplaceID(null);
        }
    }

    public void setWorkPath(String workPath) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)workPath)) {
            throw new CmsIllegalArgumentException(Messages.get().container("GUI_ERR_WIDGETVALUE_EMPTY_0"));
        }
        if (!this.m_cms.existsResource(workPath)) {
            throw new CmsIllegalArgumentException(Messages.get().container("GUI_ERR_TAGREPLACE_WORKPATH_1", (Object)workPath));
        }
        this.m_workPath = workPath;
    }

    protected Set getDeleteTags() {
        return this.m_deleteTags;
    }

    protected boolean replace(Tag tag) {
        boolean result = false;
        String tagName = tag.getTagName().trim().toLowerCase();
        String replacementName = (String)this.m_tags2replacementTags.get(tagName);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)replacementName)) {
            if (tag.isEndTag()) {
                replacementName = "/" + replacementName;
            }
            tag.setTagName(replacementName);
            result = true;
            Vector attributes = tag.getAttributesEx();
            Iterator itAttribs = attributes.iterator();
            itAttribs.next();
            while (itAttribs.hasNext()) {
                Attribute attribute = (Attribute)itAttribs.next();
                String attName = attribute.getName();
                if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)attName)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_TAG_REMOVE_ATTRIB_2", (Object)attName, (Object)tag.getTagName()));
                }
                itAttribs.remove();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_TAG_REMOVE_ATTRIB_OK_0"));
            }
        }
        return result;
    }

    private String getDefaultTagReplaceID() {
        if (this.m_tags2replacementTags.size() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Iterator itEntries = this.m_tags2replacementTags.entrySet().iterator();
        while (itEntries.hasNext()) {
            Map.Entry entry = itEntries.next();
            result.append(entry.getKey()).append('=').append(entry.getValue());
            if (!itEntries.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    }
}

