/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.htmlparser.util.ParserException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.A_CmsReportThread;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.tools.content.CmsTagReplaceParser;
import org.opencms.workplace.tools.content.CmsTagReplaceSettings;
import org.opencms.workplace.tools.content.Messages;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsTagReplaceThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog((Object)CmsTagReplaceThread.class);
    private CmsProperty m_markerProperty;
    private CmsTagReplaceSettings m_settings;

    public CmsTagReplaceThread(CmsObject cms, CmsTagReplaceSettings settings) {
        super(cms, Messages.get().getBundle().key("GUI_TAGREPLACE_THREAD_NAME_0"));
        this.initHtmlReport(cms.getRequestContext().getLocale());
        this.m_settings = settings;
        this.m_markerProperty = new CmsProperty("contentools.tagreplace", null, this.m_settings.getPropertyValueTagReplaceID(), true);
    }

    public String getReportUpdate() {
        return this.getReport().getReportUpdate();
    }

    public void run() {
        block4: {
            this.getReport().println(Messages.get().container("RPT_TAGREPLACE_BEGIN_1", (Object)this.m_settings.getWorkPath()), 2);
            try {
                this.replaceTags();
            }
            catch (CmsException e) {
                this.getReport().println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                this.getReport().println(e.getMessageContainer(), 5);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e.getMessageContainer(), (Throwable)e);
                }
            }
            catch (Throwable f) {
                this.getReport().println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                this.getReport().println(f);
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)f);
            }
        }
        this.getReport().print(org.opencms.report.Messages.get().container("RPT_STAT_0"));
        this.getReport().println(org.opencms.report.Messages.get().container("RPT_STAT_DURATION_1", (Object)this.getReport().formatRuntime()));
        this.getReport().println(Messages.get().container("RPT_TAGREPLACE_END_0"), 2);
    }

    private boolean isProcessedBefore(CmsResource resource) throws CmsException {
        CmsProperty testProp = this.getCms().readPropertyObject(resource, "contentools.tagreplace", false);
        if (testProp.isNullProperty()) {
            return false;
        }
        String testValue = testProp.getResourceValue();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)testValue)) {
            return false;
        }
        return testValue.equals(this.m_settings.getPropertyValueTagReplaceID());
    }

    private void replaceTags() throws CmsException {
        I_CmsReport report = this.getReport();
        report.print(Messages.get().container("RPT_TAGREPLACE_READ_RESOURCES_1", (Object)this.m_settings.getWorkPath()));
        report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("RPT_TAGREPLACE_READ_RESOURCES_1", (Object)this.m_settings.getWorkPath()));
        }
        CmsResourceFilter filter = CmsResourceFilter.ALL.addRequireType(OpenCms.getResourceManager().getResourceType("xmlpage").getTypeId());
        List resources = this.getCms().readResources(this.m_settings.getWorkPath(), filter, true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TAGREPLACE_READ_RESOURCES_OK_1", (Object)this.m_settings.getWorkPath()));
        }
        report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        Integer size = new Integer(resources.size());
        Iterator itResources = resources.iterator();
        int count = 1;
        while (itResources.hasNext()) {
            CmsResource resource = (CmsResource)itResources.next();
            this.replaceTags(resource, size, new Integer(count));
            ++count;
        }
    }

    private void replaceTags(CmsResource resource, Integer totalJobCount, Integer actualJobCount) throws CmsException {
        Object content;
        I_CmsReport report;
        block35: {
            report = this.getReport();
            report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", (Object)actualJobCount, (Object)totalJobCount));
            report.print(Messages.get().container("RPT_TAGREPLACE_PROCESS_FILE_1", (Object)this.getCms().getRequestContext().removeSiteRoot(resource.getRootPath())));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            if (this.isProcessedBefore(resource)) {
                report.print(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 4);
                report.println(Messages.get().container("RPT_TAGREPLACE_SKIP_REASON_PROPERTY_0"), 4);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_LOCK_RESOURCE_1", (Object)resource.getRootPath()));
            }
            try {
                block36: {
                    boolean myLock;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_LOCK_READ_1", (Object)resource.getRootPath()));
                    }
                    CmsLock lock = this.getCms().getLock(resource);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_LOCK_READ_1", (Object)resource.getRootPath()));
                    }
                    boolean bl = myLock = !lock.isNullLock() && lock.isOwnedBy(this.getCms().getRequestContext().currentUser());
                    if (lock.isNullLock() || myLock) {
                        if (!myLock) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_LOCK_RESOURCE_1", (Object)resource.getRootPath()));
                            }
                            this.getCms().lockResource(this.getCms().getRequestContext().removeSiteRoot(resource.getRootPath()));
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_LOCK_RESOURCE_OK_1", (Object)resource.getRootPath()));
                            }
                        }
                        break block35;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_RESOURCE_SKIPPED_1", (Object)resource.getRootPath()));
                        LOG.debug((Object)Messages.get().getBundle().key("RPT_TAGREPLACE_SKIP_REASON_LOCKED_0"));
                    }
                    report.print(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 1);
                    try {
                        CmsUser locker = this.getCms().readUser(lock.getUserId());
                        report.println(Messages.get().container("RPT_TAGREPLACE_SKIP_REASON_LOCKED_1", (Object)locker.getName()), 1);
                    }
                    catch (Throwable f) {
                        report.println(Messages.get().container("RPT_TAGREPLACE_SKIP_REASON_ERR_LOCK_0"), 1);
                        if (!LOG.isDebugEnabled()) break block36;
                        LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_RESOURCE_SKIPPED_1", (Object)resource.getRootPath()));
                        LOG.debug((Object)Messages.get().getBundle().key("RPT_TAGREPLACE_SKIP_REASON_ERR_LOCK_0"));
                    }
                }
                return;
            }
            catch (CmsException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_WARN_TAGREPLACE_LOCK_RESOURCE_FAILED_1", (Object)resource.getRootPath()), (Throwable)e);
                }
                report.print(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 1);
                report.println(Messages.get().container("RPT_TAGREPLACE_SKIP_REASON_LOCKED_0"), 1);
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_LOAD_FILE_1", (Object)resource.getRootPath()));
        }
        CmsFile file = this.getCms().readFile(resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_LOAD_FILE_OK_1", (Object)resource.getRootPath()));
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_UNMARSHAL_1", (Object)resource.getRootPath()));
        }
        CmsXmlContent xmlcontent = CmsXmlContentFactory.unmarshal((CmsObject)this.getCms(), (CmsFile)file);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_UNMARSHAL_OK_1", (Object)resource.getRootPath()));
        }
        List locales = xmlcontent.getLocales();
        Iterator itLocales = locales.iterator();
        CmsTagReplaceParser parser = new CmsTagReplaceParser(this.m_settings);
        int count = 1;
        while (itLocales.hasNext()) {
            Locale locale = (Locale)itLocales.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_LOCALE_1", (Object)locale.getLanguage()));
            }
            List elements = xmlcontent.getValues(locale);
            Iterator itElements = elements.iterator();
            while (itElements.hasNext()) {
                I_CmsXmlContentValue value = (I_CmsXmlContentValue)itElements.next();
                content = value.getStringValue(this.getCms());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_ELEMENT_2", (Object)value.getPath(), content));
                }
                try {
                    parser.process((String)content, xmlcontent.getEncoding());
                    value.setStringValue(this.getCms(), parser.getResult());
                }
                catch (ParserException e) {
                    CmsMessageContainer container = Messages.get().container("ERR_TAGREPLACE_PARSE_4", new Object[]{this.getCms().getRequestContext().removeSiteRoot(resource.getRootPath()), locale.getLanguage(), value.getPath(), parser.getResult()});
                    throw new CmsXmlException(container, (Throwable)e);
                }
            }
            ++count;
        }
        if (parser.isChangedContent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_MARSHAL_1", (Object)resource.getRootPath()));
            }
            content = xmlcontent.marshal();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_MARSHAL_OK_1", (Object)resource.getRootPath()));
            }
            file.setContents(content);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_WRITE_1", (Object)resource.getRootPath()));
            }
            this.getCms().writeFile(file);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_WRITE_OK_1", (Object)resource.getRootPath()));
            }
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_PROPERTY_WRITE_3", new Object[]{this.m_markerProperty.getName(), this.m_markerProperty.getResourceValue(), resource.getRootPath()}));
                }
                this.getCms().writePropertyObject(this.getCms().getRequestContext().removeSiteRoot(resource.getRootPath()), this.m_markerProperty);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_TAGREPLACE_PROPERTY_WRITE_OK_0"));
                }
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
            catch (CmsException e) {
                CmsMessageContainer container = Messages.get().container("LOG_ERROR_TAGREPLACE_PROPERTY_WRITE_3", new Object[]{this.m_markerProperty.getName(), this.m_markerProperty.getResourceValue(), resource.getRootPath()});
                throw new CmsXmlException(container, (Throwable)e);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().container("LOG_DEBUG_TAGREPLACE_UNLOCK_FILE_1", (Object)resource.getRootPath()));
            }
            this.getCms().unlockResource(this.getCms().getRequestContext().removeSiteRoot(resource.getRootPath()));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().container("LOG_DEBUG_TAGREPLACE_UNLOCK_FILE_OK_0"));
            }
            report.print(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 4);
            report.println(Messages.get().container("RPT_TAGREPLACE_SKIP_REASON_UNMODIFIED_0"), 4);
        }
    }
}

