/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.content.check;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListResourceCollector;
import org.opencms.workplace.tools.content.check.CmsContentCheck;
import org.opencms.workplace.tools.content.check.CmsContentCheckCollector;
import org.opencms.workplace.tools.content.check.CmsContentCheckDialog;
import org.opencms.workplace.tools.content.check.CmsContentCheckResult;
import org.opencms.workplace.tools.content.check.Messages;

public class CmsContentCheckFilesDialog
extends A_CmsListExplorerDialog {
    public static final String LIST_DETAIL_ERROR = "de";
    public static final String LIST_DETAIL_WARNING = "dw";
    public static final String LIST_ID = "checkcontent";
    CmsContentCheckResult m_results;
    private I_CmsListResourceCollector m_collector;

    public CmsContentCheckFilesDialog(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_CHECKCONTENT_LIST_NAME_0"));
    }

    public CmsContentCheckFilesDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    public I_CmsListResourceCollector getCollector() {
        if (this.m_collector == null) {
            Map objects = (Map)this.getSettings().getDialogObject();
            Object o = objects.get(CmsContentCheckDialog.class.getName());
            this.m_results = o != null && o instanceof CmsContentCheck ? ((CmsContentCheck)o).getResults() : new CmsContentCheckResult();
            this.m_collector = new CmsContentCheckCollector(this, this.m_results);
        }
        return this.m_collector;
    }

    protected void fillDetails(String detailId) {
        List resourceNames = this.getList().getAllContent();
        Iterator i = resourceNames.iterator();
        while (i.hasNext()) {
            List warnings;
            Iterator j;
            List errors;
            CmsListItem item = (CmsListItem)i.next();
            CmsResource res = this.getCollector().getResource(this.getCms(), item);
            StringBuffer html = new StringBuffer();
            if (detailId.equals(LIST_DETAIL_ERROR) && (errors = this.m_results.getErrors(res.getRootPath())) != null) {
                j = errors.iterator();
                while (j.hasNext()) {
                    String errorMessage = (String)j.next();
                    html.append(errorMessage);
                    html.append("<br>");
                }
                item.set(detailId, (Object)html.toString());
            }
            if (!detailId.equals(LIST_DETAIL_WARNING) || (warnings = this.m_results.getWarnings(res.getRootPath())) == null) continue;
            j = warnings.iterator();
            while (j.hasNext()) {
                String warningsMessage = (String)j.next();
                html.append(warningsMessage);
                html.append("<br>");
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected void initMessages() {
        this.addMessages(org.opencms.workplace.tools.content.Messages.get().getBundleName());
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails errorDetails = new CmsListItemDetails(LIST_DETAIL_ERROR);
        errorDetails.setAtColumn("ecn");
        errorDetails.setShowActionName(Messages.get().container("GUI_CHECKCONTENT_DETAIL_SHOW_ERRORINFO_NAME_0"));
        errorDetails.setShowActionHelpText(Messages.get().container("GUI_CHECKCONTENT_DETAIL_SHOW_ERRORINFO_HELP_0"));
        errorDetails.setHideActionName(Messages.get().container("GUI_CHECKCONTENT_DETAIL_HIDE_ERRORINFO_NAME_0"));
        errorDetails.setHideActionHelpText(Messages.get().container("GUI_CHECKCONTENT_DETAIL_HIDE_ERRORINFO_HELP_0"));
        errorDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_CHECKCONTENT_LABEL_ERROR_0")));
        metadata.addItemDetails(errorDetails);
        CmsListItemDetails warningDetails = new CmsListItemDetails(LIST_DETAIL_WARNING);
        warningDetails.setAtColumn("ecn");
        warningDetails.setShowActionName(Messages.get().container("GUI_CHECKCONTENT_DETAIL_SHOW_WARNINGINFO_NAME_0"));
        warningDetails.setShowActionHelpText(Messages.get().container("GUI_CHECKCONTENT_DETAIL_SHOW_WARNINGINFO_NAME_0"));
        warningDetails.setHideActionName(Messages.get().container("GUI_CHECKCONTENT_DETAIL_SHOW_WARNINGINFO_NAME_0"));
        warningDetails.setHideActionHelpText(Messages.get().container("GUI_CHECKCONTENT_DETAIL_HIDE_WARNINGINFO_HELP_0"));
        warningDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_CHECKCONTENT_LABEL_WARNING_0")));
        metadata.addItemDetails(warningDetails);
        super.setIndependentActions(metadata);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

