/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.modules;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.modules.CmsModulesDependenciesList;
import org.opencms.workplace.tools.modules.CmsModulesList;
import org.opencms.workplace.tools.modules.Messages;

public class CmsDependenciesEdit
extends CmsWidgetDialog {
    public static final String DIALOG_TYPE = "DependenciesEdit";
    public static final String KEY_PREFIX = "modules";
    public static final String[] PAGES = new String[]{"page1"};
    private CmsModuleDependency m_dependency;
    private String m_paramDependency;
    private String m_paramModule;

    public CmsDependenciesEdit(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDependenciesEdit(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            String moduleName = this.getParamModule();
            CmsModule module = (CmsModule)OpenCms.getModuleManager().getModule(moduleName).clone();
            List oldDependencies = module.getDependencies();
            ArrayList<CmsModuleDependency> newDependencies = new ArrayList<CmsModuleDependency>();
            Iterator i = oldDependencies.iterator();
            while (i.hasNext()) {
                CmsModuleDependency dep = (CmsModuleDependency)i.next();
                if (dep.getName().equals(this.m_dependency.getName())) continue;
                newDependencies.add(dep);
            }
            newDependencies.add(this.m_dependency);
            module.setDependencies(newDependencies);
            OpenCms.getModuleManager().updateModule(this.getCms(), module);
            Map objects = (Map)this.getSettings().getListObject();
            if (objects != null) {
                objects.remove(CmsModulesList.class.getName());
                objects.remove(CmsModulesDependenciesList.class.getName());
            }
        }
        catch (CmsConfigurationException ce) {
            errors.add(ce);
        }
        catch (CmsSecurityException se) {
            errors.add(se);
        }
        this.setCommitErrors(errors);
    }

    public String buildDialogForm() {
        StringBuffer result = new StringBuffer(1024);
        try {
            result.append(this.createDialogHtml(this.getParamPage()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result.toString();
    }

    public String getCancelAction() {
        this.setParamPage((String)this.getPages().get(0));
        return "set";
    }

    public String getParamDependency() {
        return this.m_paramDependency;
    }

    public String getParamModule() {
        return this.m_paramModule;
    }

    public void setParamDependency(String paramDependency) {
        this.m_paramDependency = paramDependency;
    }

    public void setParamModule(String paramModule) {
        this.m_paramModule = paramModule;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("label.dependencyinformation")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 1));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initModule();
        this.setKeyPrefix(KEY_PREFIX);
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_dependency, "name", PAGES[0], (I_CmsWidget)new CmsSelectWidget(this.getModules())));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_dependency, "version.version", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initModule() {
        CmsModule module = CmsStringUtil.isNotEmpty((String)this.m_paramModule) ? (CmsModule)OpenCms.getModuleManager().getModule(this.m_paramModule).clone() : new CmsModule();
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction()) ? null : this.getDialogObject();
        if (!(o instanceof CmsModuleDependency)) {
            if (this.m_paramDependency == null) {
                this.m_dependency = new CmsModuleDependency();
            } else {
                List dependencies = module.getDependencies();
                this.m_dependency = new CmsModuleDependency();
                if (dependencies != null && dependencies.size() > 0) {
                    Iterator i = dependencies.iterator();
                    while (i.hasNext()) {
                        CmsModuleDependency dependency = (CmsModuleDependency)i.next();
                        if (!dependency.getName().equals(this.m_paramDependency)) continue;
                        this.m_dependency = dependency;
                    }
                }
            }
        } else {
            this.m_dependency = (CmsModuleDependency)o;
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_dependency);
    }

    protected void validateParamaters() throws Exception {
        String moduleName = this.getParamModule();
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        if (module == null) {
            throw new Exception();
        }
        if (!this.isNewDependency()) {
            Iterator it = module.getDependencies().iterator();
            while (it.hasNext()) {
                CmsModuleDependency dep = (CmsModuleDependency)it.next();
                if (!dep.getName().equals(this.getParamDependency())) continue;
                return;
            }
            throw new Exception();
        }
    }

    private List getModules() {
        ArrayList<CmsSelectWidgetOption> retVal = new ArrayList<CmsSelectWidgetOption>();
        Iterator i = OpenCms.getModuleManager().getModuleNames().iterator();
        while (i.hasNext()) {
            String moduleName = (String)i.next();
            if (moduleName.equals(this.getParamDependency())) {
                retVal.add(new CmsSelectWidgetOption(moduleName, true));
                continue;
            }
            retVal.add(new CmsSelectWidgetOption(moduleName, false));
        }
        Collections.sort(retVal, new Comparator(){
            private Collator m_collator;
            {
                this.m_collator = Collator.getInstance(CmsDependenciesEdit.this.getLocale());
            }

            public int compare(Object arg0, Object arg1) {
                CmsSelectWidgetOption o1 = (CmsSelectWidgetOption)arg0;
                CmsSelectWidgetOption o2 = (CmsSelectWidgetOption)arg1;
                return this.m_collator.compare(o1.getOption(), o2.getOption());
            }
        });
        return retVal;
    }

    private boolean isNewDependency() {
        return this.getCurrentToolPath().equals("/modules/edit/dependencies/new");
    }
}

