/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.modules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.tools.modules.CmsModulesList;
import org.opencms.workplace.tools.modules.Messages;

public class CmsModulesDependenciesList
extends A_CmsListDialog {
    public static final String LIST_ACTION_DELETE = "ad";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_COLUMN_DELETE = "cd";
    public static final String LIST_COLUMN_EDIT = "ce";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_VERSION = "cv";
    public static final String LIST_DEFACTION_EDIT = "de";
    public static final String LIST_ID = "lmd";
    public static final String LIST_MACTION_DELETE = "md";
    public static final String PARAM_DEPENDENCY = "dependency";
    public static final String PARAM_MODULE = "module";
    public static final String PATH_BUTTONS = "tools/modules/buttons/";
    private String m_paramModule;

    public CmsModulesDependenciesList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_DEPENDENCIES_LIST_NAME_0"), LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsModulesDependenciesList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() {
        Map objects;
        if (this.getParamListAction().equals(LIST_MACTION_DELETE)) {
            String moduleName = this.getParamModule();
            Iterator itItems = this.getSelectedItems().iterator();
            while (itItems.hasNext()) {
                CmsModule module = (CmsModule)OpenCms.getModuleManager().getModule(moduleName).clone();
                CmsListItem listItem = (CmsListItem)itItems.next();
                String dependencyName = listItem.getId();
                this.deleteDependency(module, dependencyName);
            }
        }
        if ((objects = (Map)this.getSettings().getListObject()) != null) {
            objects.remove(CmsModulesList.class.getName());
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException {
        String moduleName = this.getParamModule();
        String dependencyName = this.getSelectedItem().getId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_MODULE, moduleName);
        params.put(PARAM_DEPENDENCY, dependencyName);
        if (this.getParamListAction().equals(LIST_ACTION_DELETE)) {
            CmsModule module = (CmsModule)OpenCms.getModuleManager().getModule(moduleName).clone();
            this.deleteDependency(module, dependencyName);
        } else if (this.getParamListAction().equals(LIST_ACTION_EDIT) || this.getParamListAction().equals(LIST_DEFACTION_EDIT)) {
            params.put("action", "initial");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/modules/edit/dependencies/edit", params);
        }
        Map objects = (Map)this.getSettings().getListObject();
        if (objects != null) {
            objects.remove(CmsModulesList.class.getName());
        }
        this.listSave();
    }

    public String getParamModule() {
        return this.m_paramModule;
    }

    public void setParamModule(String paramModule) {
        this.m_paramModule = paramModule;
    }

    protected void fillDetails(String detailId) {
    }

    protected List getListItems() {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        String moduleName = this.getParamModule();
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        List dependencies = module.getDependencies();
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            CmsModuleDependency dependency = (CmsModuleDependency)i.next();
            CmsListItem item = this.getList().newItem(dependency.getName());
            item.set(LIST_COLUMN_NAME, (Object)dependency.getName());
            item.set(LIST_COLUMN_VERSION, (Object)dependency.getVersion());
            ret.add(item);
        }
        return ret;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_MODULES_LIST_COLS_EDIT_0"));
        editCol.setWidth("20");
        editCol.setSorteable(false);
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        CmsListDirectAction editColAction = new CmsListDirectAction(LIST_ACTION_EDIT);
        editColAction.setName(Messages.get().container("GUI_DEPENDENCIES_LIST_ACTION_EDIT_NAME_0"));
        editColAction.setHelpText(Messages.get().container("GUI_DEPENDENCIES_LIST_ACTION_EDIT_HELP_0"));
        editColAction.setIconPath("tools/modules/buttons/module_dependencies.png");
        editColAction.setEnabled(true);
        editColAction.setConfirmationMessage(null);
        editCol.addDirectAction((I_CmsListDirectAction)editColAction);
        metadata.addColumn(editCol);
        CmsListColumnDefinition delCol = new CmsListColumnDefinition(LIST_COLUMN_DELETE);
        delCol.setName(Messages.get().container("GUI_MODULES_LIST_COLS_DELETE_0"));
        delCol.setWidth("20");
        delCol.setSorteable(false);
        delCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        CmsListDirectAction delDependency = new CmsListDirectAction(LIST_ACTION_DELETE);
        delDependency.setName(Messages.get().container("GUI_DEPENDENCIES_LIST_ACTION_DELETE_NAME_0"));
        delDependency.setConfirmationMessage(Messages.get().container("GUI_DEPENDENCIES_LIST_ACTION_DELETE_CONF_0"));
        delDependency.setIconPath("list/delete.png");
        delDependency.setEnabled(true);
        delDependency.setHelpText(Messages.get().container("GUI_DEPENDENCIES_LIST_ACTION_DELETE_HELP_0"));
        delCol.addDirectAction((I_CmsListDirectAction)delDependency);
        metadata.addColumn(delCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_DEPENDENCIES_LIST_COLS_NAME_0"));
        nameCol.setWidth("80%");
        nameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        CmsListDefaultAction nameColAction = new CmsListDefaultAction(LIST_DEFACTION_EDIT);
        nameColAction.setName(Messages.get().container("GUI_DEPENDENCIES_LIST_ACTION_OVERVIEW_NAME_0"));
        nameColAction.setIconPath(null);
        nameColAction.setHelpText(Messages.get().container("GUI_DEPENDENCIES_LIST_ACTION_OVERVIEW_HELP_0"));
        nameColAction.setEnabled(true);
        nameColAction.setConfirmationMessage(null);
        nameCol.addDefaultAction(nameColAction);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition versionCol = new CmsListColumnDefinition(LIST_COLUMN_VERSION);
        versionCol.setName(Messages.get().container("GUI_DEPENDENCIES_LIST_COLS_VERSION_0"));
        versionCol.setWidth("20%");
        versionCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        metadata.addColumn(versionCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction deleteDependencies = new CmsListMultiAction(LIST_MACTION_DELETE);
        deleteDependencies.setName(Messages.get().container("GUI_DEPENDENCIES_LIST_ACTION_MDELETE_NAME_0"));
        deleteDependencies.setConfirmationMessage(Messages.get().container("GUI_DEPENDENCIES_LIST_ACTION_MDELETE_CONF_0"));
        deleteDependencies.setIconPath("list/multi_delete.png");
        deleteDependencies.setEnabled(true);
        deleteDependencies.setHelpText(Messages.get().container("GUI_DEPENDENCIES_LIST_ACTION_MDELETE_HELP_0"));
        metadata.addMultiAction(deleteDependencies);
    }

    protected void validateParamaters() throws Exception {
        if (OpenCms.getModuleManager().getModule(this.getParamModule()) == null) {
            throw new Exception();
        }
    }

    private void deleteDependency(CmsModule module, String dependencyName) {
        List oldDependencies = module.getDependencies();
        ArrayList<CmsModuleDependency> newDependencies = new ArrayList<CmsModuleDependency>();
        Iterator i = oldDependencies.iterator();
        while (i.hasNext()) {
            CmsModuleDependency dep = (CmsModuleDependency)i.next();
            if (dep.getName().equals(dependencyName)) continue;
            newDependencies.add(dep);
        }
        module.setDependencies(newDependencies);
        try {
            OpenCms.getModuleManager().updateModule(this.getCms(), module);
        }
        catch (CmsConfigurationException ce) {
            throw new CmsRuntimeException(Messages.get().container("ERR_ACTION_DEPENDENCIES_DELETE_2", (Object)dependencyName, (Object)module.getName()), (Throwable)ce);
        }
        catch (CmsRoleViolationException re) {
            throw new CmsRuntimeException(Messages.get().container("ERR_ACTION_DEPENDENCIES_DELETE_2", (Object)dependencyName, (Object)module.getName()), (Throwable)re);
        }
    }
}

