/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.modules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.importexport.I_CmsImportExportHandler;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.report.I_CmsReportThread;
import org.opencms.util.CmsFileUtil;
import org.opencms.workplace.list.A_CmsListReport;
import org.opencms.workplace.threads.CmsExportThread;
import org.opencms.workplace.tools.modules.Messages;

public class CmsModulesListExportReport
extends A_CmsListReport {
    private String m_paramModule;
    private static final Log LOG = CmsLog.getLog((Object)CmsModulesListExportReport.class);

    public CmsModulesListExportReport(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsModulesListExportReport(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String getParamModule() {
        return this.m_paramModule;
    }

    public I_CmsReportThread initializeThread() {
        CmsExportThread exportThread = new CmsExportThread(this.getCms(), (I_CmsImportExportHandler)this.getExportHandler(), false);
        return exportThread;
    }

    public void setParamModule(String paramModule) {
        this.m_paramModule = paramModule;
    }

    private CmsModuleImportExportHandler getExportHandler() {
        String moduleName = this.getParamModule();
        List resList = OpenCms.getModuleManager().getModule(moduleName).getResources();
        List<String> resListCopy = new ArrayList();
        Iterator it = resList.iterator();
        while (it.hasNext()) {
            String res = (String)it.next();
            try {
                if (res == null) continue;
                this.getCms().readResource(res);
                resListCopy.add(res);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.warn((Object)Messages.get().getBundle().key("ERR_READ_RESOURCE_1", (Object)res), (Throwable)e);
            }
        }
        resListCopy = CmsFileUtil.removeRedundancies(resListCopy);
        String[] resources = new String[resListCopy.size()];
        for (int i = 0; i < resListCopy.size(); ++i) {
            resources[i] = (String)resListCopy.get(i);
        }
        String filename = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(OpenCms.getSystemInfo().getPackagesRfsPath() + CmsSystemInfo.FOLDER_MODULES + moduleName + "_" + OpenCms.getModuleManager().getModule(moduleName).getVersion().toString());
        CmsModuleImportExportHandler moduleExportHandler = new CmsModuleImportExportHandler();
        moduleExportHandler.setFileName(filename);
        moduleExportHandler.setModuleName(moduleName.replace('\\', '/'));
        moduleExportHandler.setAdditionalResources(resources);
        moduleExportHandler.setDescription(Messages.get().getBundle(this.getLocale()).key("GUI_MODULES_LIST_EXPORT_REPORT_HANDLER_NAME_1", (Object)moduleExportHandler.getModuleName()));
        return moduleExportHandler;
    }
}

