/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.modules;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.modules.CmsExportpointsList;
import org.opencms.workplace.tools.modules.CmsModulesDependenciesList;
import org.opencms.workplace.tools.modules.Messages;

public class CmsModulesOverview
extends CmsWidgetDialog {
    public static final String DIALOG_TYPE = "ModulesOverview";
    public static final String[] PAGES = new String[]{"page1"};
    private CmsModule m_module;
    private String m_paramModule;

    public CmsModulesOverview(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsModulesOverview(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
    }

    public String buildDialogForm() {
        StringBuffer result = new StringBuffer(1024);
        try {
            result.append(this.createDialogHtml(this.getParamPage()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result.toString();
    }

    public String getCancelAction() {
        this.setParamPage((String)this.getPages().get(0));
        return "set";
    }

    public String getParamModule() {
        return this.m_paramModule;
    }

    public void setParamModule(String paramModule) {
        this.m_paramModule = paramModule;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("label.moduleinformation")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 5));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("label.modulecreator")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(6, 7));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initModule();
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_module, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_module, "niceName", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_module, "description", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_module, "version.version", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_module, "group", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_module, "actionClass", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_module, "authorName", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_module, "authorEmail", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initModule() {
        Object o = CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction()) ? (CmsStringUtil.isNotEmpty((String)this.m_paramModule) ? OpenCms.getModuleManager().getModule(this.m_paramModule) : null) : this.getDialogObject();
        this.m_module = !(o instanceof CmsModule) ? new CmsModule() : (CmsModule)((CmsModule)o).clone();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.setParamDialogtype(DIALOG_TYPE);
        super.initWorkplaceRequestValues(settings, request);
        Map objects = (Map)this.getSettings().getListObject();
        if (objects != null) {
            objects.remove(CmsExportpointsList.class.getName());
            objects.remove(CmsModulesDependenciesList.class.getName());
        }
        this.setDialogObject(this.m_module);
    }

    protected void validateParamaters() throws Exception {
        String moduleName = this.getParamModule();
        CmsModule module = OpenCms.getModuleManager().getModule(moduleName);
        if (module == null) {
            throw new Exception();
        }
    }
}

