/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.modules;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.CmsSystemInfo;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleDependency;
import org.opencms.module.CmsModuleImportExportHandler;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.administration.A_CmsImportFromHttp;
import org.opencms.workplace.tools.CmsToolManager;
import org.opencms.workplace.tools.modules.CmsModulesList;
import org.opencms.workplace.tools.modules.Messages;

public class CmsModulesUploadFromHttp
extends A_CmsImportFromHttp {
    public static final String DIALOG_URI = "/system/workplace/admin/modules/modules_import.jsp";
    public static final String PARAM_MODULE = "module";
    private static final Log LOG = CmsLog.getLog((Object)CmsModulesUploadFromHttp.class);

    public CmsModulesUploadFromHttp(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsModulesUploadFromHttp(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() throws IOException, ServletException {
        try {
            this.copyFileToServer(OpenCms.getSystemInfo().getPackagesRfsPath() + File.separator + CmsSystemInfo.FOLDER_MODULES);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(this.getLocale()), (Throwable)e);
            }
            this.setException(e);
            return;
        }
        CmsConfigurationException exception = null;
        CmsModule module = null;
        try {
            String importpath = OpenCms.getSystemInfo().getPackagesRfsPath();
            importpath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebInf(importpath + "modules/" + this.getParamImportfile());
            module = CmsModuleImportExportHandler.readModuleFromImport((String)importpath);
            List dependencies = OpenCms.getModuleManager().checkDependencies(module, 1);
            if (!dependencies.isEmpty()) {
                StringBuffer dep = new StringBuffer(32);
                for (int i = 0; i < dependencies.size(); ++i) {
                    CmsModuleDependency dependency = (CmsModuleDependency)dependencies.get(i);
                    dep.append("\n - ");
                    dep.append(dependency.getName());
                    dep.append(" (Version: ");
                    dep.append(dependency.getVersion());
                    dep.append(")");
                }
                exception = new CmsConfigurationException(Messages.get().container("ERR_ACTION_MODULE_DEPENDENCY_2", (Object)this.getParamImportfile(), (Object)new String(dep)));
            }
        }
        catch (CmsConfigurationException e) {
            exception = e;
        }
        if (module != null && exception == null) {
            Map objects = (Map)this.getSettings().getListObject();
            if (objects != null) {
                objects.remove(CmsModulesList.class.getName());
            }
            HashMap<String, String> param = new HashMap<String, String>();
            param.put(PARAM_MODULE, this.getParamImportfile());
            param.put("style", "new");
            param.put("closelink", CmsToolManager.linkForToolPath((CmsJspActionElement)this.getJsp(), (String)"/modules"));
            if (OpenCms.getModuleManager().hasModule(module.getName())) {
                param.put("modulename", module.getName());
                this.getToolManager().jspForwardPage((CmsWorkplace)this, "/system/workplace/admin/modules/reports/replace.jsp", param);
            } else {
                this.getToolManager().jspForwardPage((CmsWorkplace)this, "/system/workplace/admin/modules/reports/import.jsp", param);
            }
        } else if (exception != null) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)exception.getLocalizedMessage(this.getLocale()), (Throwable)exception);
            }
            throw new CmsRuntimeException(exception.getMessageContainer(), (Throwable)exception);
        }
    }

    public String getDialogReturnUri() {
        return DIALOG_URI;
    }

    public String getImportMessage() {
        return this.key("GUI_MODULES_IMPORT_FILE_0");
    }

    public String getStarttext() {
        return this.key("GUI_MODULES_IMPORT_BLOCK_0");
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        this.addMessages(org.opencms.workplace.Messages.get().getBundleName());
        this.addMessages(org.opencms.workplace.tools.Messages.get().getBundleName());
    }
}

