/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.scheduler;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsContextInfo;
import org.opencms.workplace.list.I_CmsListFormatter;

public class CmsContextInfoDetailsFormatter
implements I_CmsListFormatter {
    private Map m_cache = new HashMap();
    private CmsMessageContainer m_encodingMessage;
    private CmsMessageContainer m_localeMessage;
    private CmsMessageContainer m_projectMessage;
    private CmsMessageContainer m_remoteAddrMessage;
    private CmsMessageContainer m_requestedURIMessage;
    private CmsMessageContainer m_rootSiteMessage;
    private CmsMessageContainer m_userMessage;

    public String format(Object data, Locale locale) {
        HashMap<CmsMessageContainer, String> cache = (HashMap<CmsMessageContainer, String>)this.m_cache.get(locale);
        if (cache == null) {
            cache = new HashMap<CmsMessageContainer, String>();
            cache.put(this.m_userMessage, this.m_userMessage.key(locale));
            cache.put(this.m_projectMessage, this.m_projectMessage.key(locale));
            cache.put(this.m_localeMessage, this.m_localeMessage.key(locale));
            cache.put(this.m_rootSiteMessage, this.m_rootSiteMessage.key(locale));
            cache.put(this.m_requestedURIMessage, this.m_requestedURIMessage.key(locale));
            cache.put(this.m_remoteAddrMessage, this.m_remoteAddrMessage.key(locale));
            cache.put(this.m_encodingMessage, this.m_encodingMessage.key(locale));
            this.m_cache.put(locale, cache);
        }
        String userMessage = (String)cache.get(this.m_userMessage);
        String projectMessage = (String)cache.get(this.m_projectMessage);
        String localeMessage = (String)cache.get(this.m_localeMessage);
        String rootSiteMessage = (String)cache.get(this.m_rootSiteMessage);
        String requestedURIMessage = (String)cache.get(this.m_requestedURIMessage);
        String remoteAddrMessage = (String)cache.get(this.m_remoteAddrMessage);
        String encodingMessage = (String)cache.get(this.m_encodingMessage);
        CmsContextInfo info = (CmsContextInfo)data;
        StringBuffer html = new StringBuffer(512);
        html.append("<table border='0' cellspacing='0' cellpadding='0'>\n");
        html.append("\t<tr>\n");
        html.append("\t\t<td width='150' align='right' class='listdetailhead'>\n");
        html.append("\t\t\t");
        html.append(userMessage);
        html.append("&nbsp;:&nbsp;\n");
        html.append("\t\t</td>\n");
        html.append("\t\t<td class='listdetailitem'>\n");
        html.append("\t\t\t");
        html.append(info.getUserName());
        html.append("\n");
        html.append("\t\t</td>\n");
        html.append("\t</tr>\n");
        html.append("\t<tr>\n");
        html.append("\t\t<td width='150' align='right' class='listdetailhead'>\n");
        html.append("\t\t\t");
        html.append(projectMessage);
        html.append("&nbsp;:&nbsp;\n");
        html.append("\t\t</td>\n");
        html.append("\t\t<td class='listdetailitem'>\n");
        html.append("\t\t\t");
        html.append(info.getProjectName());
        html.append("\n");
        html.append("\t\t</td>\n");
        html.append("\t</tr>\n");
        html.append("\t<tr>\n");
        html.append("\t\t<td width='150' align='right' class='listdetailhead'>\n");
        html.append("\t\t\t");
        html.append(localeMessage);
        html.append("&nbsp;:&nbsp;\n");
        html.append("\t\t</td>\n");
        html.append("\t\t<td class='listdetailitem'>\n");
        html.append("\t\t\t");
        html.append(info.getLocaleName());
        html.append("\n");
        html.append("\t\t</td>\n");
        html.append("\t</tr>\n");
        html.append("\t<tr>\n");
        html.append("\t\t<td width='150' align='right' class='listdetailhead'>\n");
        html.append("\t\t\t");
        html.append(rootSiteMessage);
        html.append("&nbsp;:&nbsp;\n");
        html.append("\t\t</td>\n");
        html.append("\t\t<td class='listdetailitem'>\n");
        html.append("\t\t\t");
        html.append(info.getSiteRoot());
        html.append("\n");
        html.append("\t\t</td>\n");
        html.append("\t</tr>\n");
        html.append("\t<tr>\n");
        html.append("\t\t<td width='150' align='right' class='listdetailhead'>\n");
        html.append("\t\t\t");
        html.append(requestedURIMessage);
        html.append("&nbsp;:&nbsp;\n");
        html.append("\t\t</td>\n");
        html.append("\t\t<td class='listdetailitem'>\n");
        html.append("\t\t\t");
        html.append(info.getRequestedUri());
        html.append("\n");
        html.append("\t\t</td>\n");
        html.append("\t</tr>\n");
        html.append("\t<tr>\n");
        html.append("\t\t<td width='150' align='right' class='listdetailhead'>\n");
        html.append("\t\t\t");
        html.append(remoteAddrMessage);
        html.append("&nbsp;:&nbsp;\n");
        html.append("\t\t</td>\n");
        html.append("\t\t<td class='listdetailitem'>\n");
        html.append("\t\t\t");
        html.append(info.getRemoteAddr());
        html.append("\n");
        html.append("\t\t</td>\n");
        html.append("\t</tr>\n");
        html.append("\t<tr>\n");
        html.append("\t\t<td width='150' align='right' class='listdetailhead'>\n");
        html.append("\t\t\t");
        html.append(encodingMessage);
        html.append("&nbsp;:&nbsp;\n");
        html.append("\t\t</td>\n");
        html.append("\t\t<td class='listdetailitem'>\n");
        html.append("\t\t\t");
        html.append(info.getEncoding());
        html.append("\n");
        html.append("\t\t</td>\n");
        html.append("\t</tr>\n");
        html.append("</table>\n");
        return html.toString();
    }

    public void setEncodingMessage(CmsMessageContainer encodingMessage) {
        this.m_encodingMessage = encodingMessage;
    }

    public void setLocaleMessage(CmsMessageContainer localeMessage) {
        this.m_localeMessage = localeMessage;
    }

    public void setProjectMessage(CmsMessageContainer projectMessage) {
        this.m_projectMessage = projectMessage;
    }

    public void setRemoteAddrMessage(CmsMessageContainer remoteAddrMessage) {
        this.m_remoteAddrMessage = remoteAddrMessage;
    }

    public void setRequestedURIMessage(CmsMessageContainer requestedURIMessage) {
        this.m_requestedURIMessage = requestedURIMessage;
    }

    public void setRootSiteMessage(CmsMessageContainer rootSiteMessage) {
        this.m_rootSiteMessage = rootSiteMessage;
    }

    public void setUserMessage(CmsMessageContainer userMessage) {
        this.m_userMessage = userMessage;
    }
}

