/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.modules;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsLayoutXmlContentHandler
extends CmsDefaultXmlContentHandler {
    public static final String CONFIG_RESTYPE_NAME = "layout";
    public static final String ELEMENT_COLLECTOR = "Collector";
    public static final String ELEMENT_COUNT = "Count";
    public static final String ELEMENT_LAYOUT = "Layout";
    public static final String ELEMENT_RESOURCETYPE = "Type";
    public static final String ELEMENT_VFSFOLDER = "Folder";
    public static final String PROPERTY_LAYOUT_COLUMN = "layout.column";

    public CmsFile prepareForWrite(CmsObject cms, CmsXmlContent content, CmsFile file) throws CmsException {
        super.prepareForWrite(cms, content, file);
        this.resolveLayoutMappings(cms, content);
        this.removeEmptyLayoutMappings(cms, content);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEmptyLayoutMappings(CmsObject cms, CmsXmlContent content) throws CmsException {
        super.removeEmptyMappings(cms, content);
        String rootPath = content.getFile().getRootPath();
        List siblings = null;
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot("/");
            siblings = cms.readSiblings(rootPath, CmsResourceFilter.IGNORE_EXPIRATION);
            for (int i = 0; i < siblings.size(); ++i) {
                String filename = ((CmsResource)siblings.get(i)).getRootPath();
                Locale locale = OpenCms.getLocaleManager().getDefaultLocale(cms, filename);
                if (!content.hasLocale(locale)) continue;
                List nestedItems = content.getValues(ELEMENT_LAYOUT, locale);
                int deleteIndex = nestedItems.size() + 1;
                CmsMacroResolver resolver = CmsMacroResolver.newInstance();
                resolver.addMacro("index", "" + deleteIndex);
                ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>(4);
                CmsProperty p = new CmsProperty(resolver.resolveMacros("layout.${index}.type"), "", null);
                properties.add(p);
                p = new CmsProperty(resolver.resolveMacros("layout.${index}.folder"), "", null);
                properties.add(p);
                p = new CmsProperty(resolver.resolveMacros("layout.${index}.count"), "", null);
                properties.add(p);
                p = new CmsProperty(resolver.resolveMacros("layout.${index}.collector"), "", null);
                properties.add(p);
                cms.writePropertyObjects(filename, properties);
            }
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveLayoutMappings(CmsObject cms, CmsXmlContent content) throws CmsException {
        CmsFile file = content.getFile();
        if (file == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_RESOLVE_FILE_NOT_FOUND_0"));
        }
        String rootPath = content.getFile().getRootPath();
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot("/");
            List siblings = cms.readSiblings(rootPath, CmsResourceFilter.IGNORE_EXPIRATION);
            for (int i = siblings.size() - 1; i >= 0; --i) {
                String filename = ((CmsResource)siblings.get(i)).getRootPath();
                Locale locale = OpenCms.getLocaleManager().getDefaultLocale(cms, filename);
                if (!content.hasLocale(locale)) continue;
                List nestedItems = content.getValues(ELEMENT_LAYOUT, locale);
                ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>(nestedItems.size() * 4);
                for (int k = 0; k < nestedItems.size(); ++k) {
                    I_CmsXmlContentValue layoutConfig = (I_CmsXmlContentValue)nestedItems.get(k);
                    String layoutConfigPath = layoutConfig.getPath() + "/";
                    CmsMacroResolver resolver = CmsMacroResolver.newInstance();
                    resolver.addMacro("index", "" + (layoutConfig.getIndex() + 1));
                    String resType = content.getStringValue(cms, layoutConfigPath + ELEMENT_RESOURCETYPE, locale);
                    CmsProperty p = new CmsProperty(resolver.resolveMacros("layout.${index}.type"), resType, null);
                    properties.add(p);
                    String folder = content.getStringValue(cms, layoutConfigPath + ELEMENT_VFSFOLDER, locale);
                    if (CmsStringUtil.isNotEmpty((String)folder)) {
                        if (folder.length() > 1 && folder.startsWith(storedSiteRoot)) {
                            folder = folder.substring(storedSiteRoot.length());
                        }
                    } else {
                        folder = "";
                    }
                    p = new CmsProperty(resolver.resolveMacros("layout.${index}.folder"), folder, null);
                    properties.add(p);
                    String count = content.getStringValue(cms, layoutConfigPath + ELEMENT_COUNT, locale);
                    p = new CmsProperty(resolver.resolveMacros("layout.${index}.count"), count, null);
                    properties.add(p);
                    String collector = content.getStringValue(cms, layoutConfigPath + ELEMENT_COLLECTOR, locale);
                    p = new CmsProperty(resolver.resolveMacros("layout.${index}.collector"), collector, null);
                    properties.add(p);
                }
                cms.writePropertyObjects(filename, properties);
            }
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
    }
}

