/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.frontend.templateone.modules;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.frontend.templateone.CmsPropertyTemplateOne;
import org.opencms.frontend.templateone.CmsTemplateBase;
import org.opencms.frontend.templateone.modules.Messages;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsTemplateModules
extends CmsTemplateBase {
    public static final String PARAM_CATEGORYFOLDER = "categoryfolder";
    public static final String PARAM_COLLECTOR = "collector";
    public static final String PARAM_COUNT = "count";
    public static final String PARAM_ELEMENTCOUNT = "elementcount";
    public static final String PARAM_FOLDER = "folder";
    private static final Log LOG = CmsLog.getLog((Object)CmsPropertyTemplateOne.class);
    private String m_categoryFolder;
    private boolean m_hasCategoryFolders;

    public CmsTemplateModules(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public String buildHtmlNavBreadcrumb(String separator) {
        StringBuffer result = new StringBuffer(16);
        String startfolder = this.getRequest().getParameter(PARAM_FOLDER);
        int displayLevels = -(CmsResource.getPathLevel((String)this.getCategoryFolder()) - CmsResource.getPathLevel((String)startfolder) + 1);
        List breadcrumb = this.getNavigation().getNavigationBreadCrumb(this.getCategoryFolder(), displayLevels, -1, true);
        int n = breadcrumb.size();
        for (int i = 0; i < n; ++i) {
            CmsJspNavElement navElement = (CmsJspNavElement)breadcrumb.get(i);
            String title = navElement.getTitle();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)title)) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_ERR_MISSING_PROP_2", (Object)navElement.getResourceName(), (Object)"Title"));
                }
                title = CmsResource.getName((String)navElement.getResourceName());
            }
            String folderUri = this.link(this.getRequestContext().getUri() + "?" + PARAM_CATEGORYFOLDER + "=" + navElement.getResourceName());
            result.append("<a href=\"");
            result.append(folderUri);
            result.append("\">");
            result.append(title);
            result.append("</a>");
            if (i >= n - 1) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public String buildHtmlNavList(int resourceTypeId, String attrs) throws CmsException {
        String startfolder = this.getCategoryFolder();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_DEBUG_BUILD_HTML_NAVLIST_2", (Object)startfolder, (Object)new Integer(resourceTypeId)));
        }
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addRequireType(0);
        List resourceTree = this.getCmsObject().readResources(startfolder, filter, true);
        String indent = "&nbsp;&nbsp;";
        StringBuffer result = new StringBuffer(32);
        if (resourceTree.size() > 0) {
            int startLevel;
            result.append("<ul");
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)attrs)) {
                result.append(" ").append(attrs);
            }
            result.append(">\n");
            int indentCount = 0;
            int lastLevel = startLevel = CmsResource.getPathLevel((String)this.getCmsObject().getSitePath((CmsResource)resourceTree.get(0)));
            this.m_hasCategoryFolders = true;
            int n = resourceTree.size();
            for (int i = 0; i < n; ++i) {
                CmsResource resource = (CmsResource)resourceTree.get(i);
                String resourceName = this.getCmsObject().getSitePath(resource);
                if (!resource.isFolder()) continue;
                int faqCount = this.getResourceCount(resourceName, resourceTypeId);
                int level = CmsResource.getPathLevel((String)resourceName);
                if (lastLevel < level) {
                    ++indentCount;
                } else if (lastLevel > level) {
                    --indentCount;
                }
                if (level == startLevel) {
                    if (i == 0) {
                        result.append("<li>\n");
                    } else {
                        result.append("<br>&nbsp;&nbsp;\n");
                        result.append("</li>\n");
                        result.append("<li>\n");
                    }
                }
                if (level > startLevel) {
                    result.append("<br>");
                }
                for (int j = 0; j < indentCount; ++j) {
                    result.append(indent);
                }
                String faqUri = this.link(this.getRequestContext().getUri() + "?" + PARAM_CATEGORYFOLDER + "=" + resourceName);
                String title = this.getCmsObject().readPropertyObject(resourceName, "Title", false).getValue(null);
                if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)title)) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_ERR_MISSING_PROP_2", (Object)resourceName, (Object)"Title"));
                    }
                    title = resource.getName();
                }
                result.append("<a href=\"");
                result.append(faqUri);
                result.append("\">");
                if (level == startLevel) {
                    result.append("<b>").append(title).append("</b>");
                } else {
                    result.append(title);
                }
                result.append("</a>");
                if (level == startLevel) {
                    result.append("&nbsp;&nbsp;(");
                    result.append(faqCount);
                    result.append(")\n");
                }
                result.append("\n");
                lastLevel = level;
            }
            result.append("</li>\n");
            result.append("</ul>\n");
        }
        return result.toString();
    }

    public String buildHtmlNavList(String resourceTypeName, String attrs) throws CmsException {
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resourceTypeName);
        return this.buildHtmlNavList(resType.getTypeId(), attrs);
    }

    public String getAnchor(String hrefAttrib, String descrAttrib, String targetAttrib) {
        String attribHref = (String)this.getJspContext().getAttribute(hrefAttrib);
        String attribDescr = (String)this.getJspContext().getAttribute(descrAttrib);
        boolean openBlank = Boolean.valueOf((String)this.getJspContext().getAttribute(targetAttrib));
        String description = attribDescr;
        if (CmsStringUtil.isEmpty((String)attribDescr) || attribDescr.startsWith("???")) {
            description = attribHref;
        }
        String href = attribHref;
        if (!attribHref.toLowerCase().startsWith("http")) {
            href = this.link(attribHref);
        }
        String target = "";
        if (openBlank) {
            target = "_blank";
        }
        StringBuffer anchor = new StringBuffer();
        anchor.append("<a href=\"").append(href).append("\"");
        if (CmsStringUtil.isNotEmpty((String)description)) {
            anchor.append(" title=\"").append(description).append("\"");
        }
        if (CmsStringUtil.isNotEmpty((String)target)) {
            anchor.append(" target=\"").append(target).append("\"");
        }
        anchor.append(">").append(description).append("</a>");
        return anchor.toString();
    }

    public String getCategoryFolder() {
        if (this.m_categoryFolder == null) {
            this.m_categoryFolder = this.getRequest().getParameter(PARAM_CATEGORYFOLDER);
            if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)this.m_categoryFolder)) {
                this.m_categoryFolder = this.getRequest().getParameter(PARAM_FOLDER);
            }
        }
        return this.m_categoryFolder;
    }

    public int getResourceCount(String foldername, int resourceTypeId) {
        int result = -1;
        try {
            CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addRequireType(resourceTypeId);
            List resources = this.getCmsObject().readResources(foldername, filter, false);
            result = resources.size();
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_READ_RESOURCES_WITH_TYPE_2", (Object)new Integer(resourceTypeId), (Object)foldername), (Throwable)e);
            }
            result = -1;
        }
        return result;
    }

    public int getResourceCount(String foldername, String resourceTypeName) {
        try {
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resourceTypeName);
            return this.getResourceCount(foldername, resType.getTypeId());
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_UNKNOWN_RESTYPE_NAME_REQ_1", (Object)resourceTypeName), (Throwable)e);
            }
            return -1;
        }
    }

    public boolean hasCategoryFolders() {
        return this.m_hasCategoryFolders;
    }

    public boolean isSameDate(String startDateAttrib, String endDateAttrib) {
        String timeString = (String)this.getJspContext().getAttribute(startDateAttrib);
        long timestamp = new Long(timeString);
        GregorianCalendar calStart = new GregorianCalendar();
        calStart.setTimeInMillis(timestamp);
        timeString = (String)this.getJspContext().getAttribute(endDateAttrib);
        timestamp = new Long(timeString);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTimeInMillis(timestamp);
        return calStart.get(6) == calEnd.get(6) && calStart.get(1) == calEnd.get(1);
    }

    public void setDate(String dateAttrib) {
        String timeString = (String)this.getJspContext().getAttribute(dateAttrib);
        long timestamp = new Long(timeString);
        Date date = new Date(timestamp);
        this.getJspContext().setAttribute("date", (Object)date);
    }

    public boolean showNavBreadCrumb() {
        return this.hasCategoryFolders() || !this.getRequest().getParameter(PARAM_FOLDER).equals(this.getCategoryFolder());
    }
}

