/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.link;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsResource;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsInternalLinksValidator;
import org.opencms.relations.CmsRelation;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListResourceCollector;
import org.opencms.workplace.tools.link.CmsInternalLinkValidationDialog;
import org.opencms.workplace.tools.link.CmsInternalLinkValidationFilesCollector;
import org.opencms.workplace.tools.link.Messages;

public class CmsInternalLinkValidationList
extends A_CmsListExplorerDialog {
    public static final String LIST_DETAIL_LINKS = "dl";
    public static final String LIST_ID = "lv";
    private I_CmsListResourceCollector m_collector;
    private CmsInternalLinksValidator m_validator;

    public CmsInternalLinkValidationList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_BROKENLINKS_LIST_NAME_0"));
    }

    public CmsInternalLinkValidationList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    public void executeListSingleActions() {
        this.throwListUnsupportedActionException();
    }

    public I_CmsListResourceCollector getCollector() {
        if (this.m_collector == null) {
            this.m_collector = new CmsInternalLinkValidationFilesCollector(this, this.getValidator().getResourcesWithBrokenLinks());
        }
        return this.m_collector;
    }

    protected String customHtmlStart() {
        StringBuffer result = new StringBuffer(512);
        if (this.getValidator().getNotVisibleResourcesCount() > 0) {
            result.append(this.dialogBlockStart(this.key("GUI_BROKENLINKS_NOTICE_0")));
            result.append("\n");
            result.append(this.key("GUI_BROKENLINKS_NOT_VISIBLE_RESOURCES_1", new Object[]{new Integer(this.getValidator().getNotVisibleResourcesCount())}));
            result.append("\n");
            result.append(this.dialogBlockEnd());
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillDetails(String detailId) {
        List resourceNames = this.getList().getAllContent();
        Iterator i = resourceNames.iterator();
        while (i.hasNext()) {
            List brokenLinks;
            CmsListItem item = (CmsListItem)i.next();
            CmsResource res = this.getCollector().getResource(this.getCms(), item);
            StringBuffer html = new StringBuffer();
            if (!detailId.equals(LIST_DETAIL_LINKS) || (brokenLinks = this.getValidator().getBrokenLinksForResource(res.getRootPath())) == null) continue;
            Iterator j = brokenLinks.iterator();
            while (j.hasNext()) {
                String siteRoot;
                CmsRelation brokenLink = (CmsRelation)j.next();
                String link = brokenLink.getTargetPath();
                String siteName = siteRoot = OpenCms.getSiteManager().getSiteRoot(link);
                if (siteRoot != null) {
                    String storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
                    try {
                        this.getCms().getRequestContext().setSiteRoot("/");
                        siteName = this.getCms().readPropertyObject(siteRoot, "Title", false).getValue(siteRoot);
                    }
                    catch (CmsException e) {
                        siteName = siteRoot;
                    }
                    finally {
                        this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                    }
                    link = link.substring(siteRoot.length());
                } else {
                    siteName = "/";
                }
                if (!this.getCms().getRequestContext().getSiteRoot().equals(siteRoot)) {
                    link = this.key("GUI_DELETE_SITE_RELATION_2", new Object[]{siteName, link});
                }
                html.append(link);
                html.append("<br>");
            }
            item.set(detailId, (Object)html.toString());
        }
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails brokenLinks = new CmsListItemDetails(LIST_DETAIL_LINKS);
        brokenLinks.setAtColumn("ecn");
        brokenLinks.setVisible(true);
        brokenLinks.setShowActionName(Messages.get().container("GUI_BROKENLINKS_DETAIL_SHOW_LINKS_NAME_0"));
        brokenLinks.setShowActionHelpText(Messages.get().container("GUI_BROKENLINKS_DETAIL_SHOW_LINKS_HELP_0"));
        brokenLinks.setHideActionName(Messages.get().container("GUI_BROKENLINKS_DETAIL_HIDE_LINKS_NAME_0"));
        brokenLinks.setHideActionHelpText(Messages.get().container("GUI_BROKENLINKS_DETAIL_HIDE_LINKS_HELP_0"));
        brokenLinks.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_BROKENLINKS_DETAIL_LINKS_NAME_0")));
        metadata.addItemDetails(brokenLinks);
        super.setIndependentActions(metadata);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
    }

    private CmsInternalLinksValidator getValidator() {
        if (this.m_validator == null) {
            Map objects = (Map)this.getSettings().getDialogObject();
            Object o = objects.get(CmsInternalLinkValidationDialog.class.getName());
            List resources = new ArrayList();
            if (o != null && o instanceof List) {
                resources = (List)o;
            }
            this.m_validator = new CmsInternalLinksValidator(this.getCms(), resources);
        }
        return this.m_validator;
    }
}

