/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.projects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsProject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsGroupWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsOrgUnitWidget;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.projects.CmsProjectsList;
import org.opencms.workplace.tools.projects.Messages;

public class CmsEditProjectDialog
extends CmsWidgetDialog {
    public static final String KEY_PREFIX = "project";
    public static final String[] PAGES = new String[]{"page1"};
    public static final String PARAM_PROJECTID = "projectid";
    public static final String PARAM_PROJECTNAME = "projectname";
    protected CmsProject m_project;
    private String m_paramProjectid;
    private List m_resources;

    public CmsEditProjectDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsEditProjectDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            if (this.m_project.getUuid() == null) {
                CmsProject newProject;
                this.m_project = newProject = this.getCms().createProject(this.m_project.getName(), this.m_project.getDescription(), this.getUserGroup(), this.getManagerGroup(), this.m_project.getType());
            } else {
                this.getCms().writeProject(this.m_project);
            }
            CmsProject currentProject = this.getCms().getRequestContext().currentProject();
            this.getCms().getRequestContext().setCurrentProject(this.m_project);
            String currentSite = this.getCms().getRequestContext().getSiteRoot();
            try {
                this.getCms().getRequestContext().setSiteRoot("");
                Iterator itDel = this.getCms().readProjectResources(this.m_project).iterator();
                while (itDel.hasNext()) {
                    String resName = itDel.next().toString();
                    if (this.getResources().contains(resName)) continue;
                    this.getCms().removeResourceFromProject(resName);
                }
                List currentResNames = this.getCms().readProjectResources(this.m_project);
                Iterator itAdd = this.getResources().iterator();
                while (itAdd.hasNext()) {
                    String resName = itAdd.next().toString();
                    if (currentResNames.contains(resName)) continue;
                    this.getCms().copyResourceToProject(resName);
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.getCms().getRequestContext().setSiteRoot(currentSite);
                this.getCms().getRequestContext().setCurrentProject(currentProject);
                throw throwable;
            }
            this.getCms().getRequestContext().setSiteRoot(currentSite);
            this.getCms().getRequestContext().setCurrentProject(currentProject);
            Map objects = (Map)this.getSettings().getListObject();
            if (objects != null) {
                objects.remove(CmsProjectsList.class.getName());
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    public String getAssignedOu() {
        try {
            CmsOrganizationalUnit ou = !this.isNewProject() ? OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.m_project.getOuFqn()) : (CmsOrganizationalUnit)OpenCms.getRoleManager().getOrgUnitsForRole(this.getCms(), CmsRole.PROJECT_MANAGER, true).get(0);
            return ou.getDisplayName(this.getLocale());
        }
        catch (CmsException e) {
            return null;
        }
    }

    public String getManagerGroup() {
        try {
            return this.getCms().readGroup(this.m_project.getManagerGroupId()).getName();
        }
        catch (Throwable e) {
            return "";
        }
    }

    public String getName() {
        String name = this.m_project.getSimpleName();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)name) || name.equals("/")) {
            name = "";
        }
        return name;
    }

    public String getOufqn() {
        return this.m_project.getOuFqn();
    }

    public String getParamProjectid() {
        return this.m_paramProjectid;
    }

    public List getResources() {
        if (this.m_resources == null) {
            return new ArrayList();
        }
        return this.m_resources;
    }

    public String getUserGroup() {
        try {
            return this.getCms().readGroup(this.m_project.getGroupId()).getName();
        }
        catch (Throwable e) {
            return "";
        }
    }

    public void setAssignedOu(String ou) {
        ou.length();
    }

    public void setManagerGroup(String managerGroup) {
        CmsGroup group = this.checkGroup(managerGroup);
        if (group != null) {
            this.m_project.setManagerGroupId(group.getId());
        }
    }

    public void setName(String name) {
        this.m_project.setName(this.getOufqn() + "/" + name);
    }

    public void setOufqn(String oufqn) {
        String name;
        if (oufqn != null) {
            if (!oufqn.endsWith("/")) {
                oufqn = oufqn + '/';
            }
        } else {
            oufqn = "/";
        }
        if ((name = this.m_project.getSimpleName()) == null) {
            name = "";
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly((String)(name = oufqn + name))) {
            name = "/";
        }
        this.m_project.setName(name);
    }

    public void setParamProjectid(String projectId) {
        this.m_paramProjectid = projectId;
    }

    public void setResources(List value) {
        if (value == null) {
            this.m_resources = new ArrayList();
            return;
        }
        this.m_resources = CmsFileUtil.removeRedundancies((List)value);
    }

    public void setUserGroup(String userGroup) {
        CmsGroup group = this.checkGroup(userGroup);
        if (group != null) {
            this.m_project.setGroupId(group.getId());
        }
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.dialogBlockStart(this.key("GUI_PROJECT_EDITOR_LABEL_IDENTIFICATION_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(0, 5));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
            result.append(this.dialogBlockStart(this.key("GUI_PROJECT_EDITOR_LABEL_CONTENT_BLOCK_0")));
            result.append(this.createWidgetTableStart());
            result.append(this.createDialogRowsHtml(6, 6));
            result.append(this.createWidgetTableEnd());
            result.append(this.dialogBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initProjectObject();
        this.setKeyPrefix(KEY_PREFIX);
        if (this.isNewProject()) {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "name", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_project, "description", "", PAGES[0], (I_CmsWidget)new CmsTextareaWidget(), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "managerGroup", PAGES[0], (I_CmsWidget)new CmsGroupWidget(new Integer(2), null)));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "userGroup", PAGES[0], (I_CmsWidget)new CmsGroupWidget(null, null)));
        if (this.isNewProject()) {
            int ous = 1;
            try {
                ous = OpenCms.getRoleManager().getOrgUnitsForRole(this.getCms(), CmsRole.PROJECT_MANAGER, true).size();
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            if (ous < 2) {
                this.addWidget(new CmsWidgetDialogParameter((Object)this, "assignedOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
            } else {
                this.addWidget(new CmsWidgetDialogParameter((Object)this, "oufqn", PAGES[0], (I_CmsWidget)new CmsOrgUnitWidget(CmsRole.PROJECT_MANAGER)));
            }
        } else {
            this.addWidget(new CmsWidgetDialogParameter((Object)this, "assignedOu", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        }
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_project, "deleteAfterPublishing", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "resources", PAGES[0], (I_CmsWidget)new CmsVfsFileWidget(false, "", false, false)));
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initProjectObject() {
        Object o = null;
        try {
            if (CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction())) {
                this.m_project = this.getCms().readProject(new CmsUUID(this.getParamProjectid()));
                this.m_resources = this.getCms().readProjectResources(this.m_project);
            } else {
                o = this.getDialogObject();
                Map map = (Map)o;
                this.m_project = (CmsProject)map.get("prj");
                this.m_project.getUuid();
                this.m_resources = (List)map.get("res");
                this.m_resources.isEmpty();
            }
        }
        catch (Exception e) {
            this.m_project = new CmsProject();
            this.m_resources = new ArrayList();
            this.setOufqn(this.getCms().getRequestContext().getOuFqn());
            this.setUserGroup(this.getCms().getRequestContext().getOuFqn() + OpenCms.getDefaultUsers().getGroupUsers());
        }
    }

    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        super.initWorkplaceMembers(jsp);
        this.setOnlineHelpUriCustom("/projects/project_edit.jsp");
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("prj", this.m_project);
        map.put("res", this.m_resources);
        this.setDialogObject(map);
    }

    protected boolean isNewProject() {
        return this.getCurrentToolPath().equals("/projects/new");
    }

    protected void validateParamaters() throws Exception {
        if (!this.isNewProject()) {
            this.getCms().readProject(new CmsUUID(this.getParamProjectid())).getName();
        }
    }

    private CmsGroup checkGroup(String groupName) {
        try {
            return this.getCms().readGroup(groupName);
        }
        catch (CmsException e) {
            throw new CmsIllegalArgumentException(e.getMessageContainer());
        }
    }
}

