/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.projects;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsProject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemActionIconComparator;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListItemComparator;
import org.opencms.workplace.tools.projects.Messages;

public class CmsProjectsList
extends A_CmsListDialog {
    public static final String LIST_ACTION_DELETE = "ad";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_ACTION_FILES = "af";
    public static final String LIST_ACTION_LOCK = "al";
    public static final String LIST_ACTION_PUBLISH_DISABLED = "apd";
    public static final String LIST_ACTION_PUBLISH_ENABLED = "ape";
    public static final String LIST_ACTION_UNLOCK = "au";
    public static final String LIST_COLUMN_CREATION = "cc";
    public static final String LIST_COLUMN_DELETE = "cd";
    public static final String LIST_COLUMN_DESCRIPTION = "cr";
    public static final String LIST_COLUMN_EDIT = "ce";
    public static final String LIST_COLUMN_FILES = "cf";
    public static final String LIST_COLUMN_LOCK = "cl";
    public static final String LIST_COLUMN_MANAGER = "cm";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_OWNER = "co";
    public static final String LIST_COLUMN_PUBLISH = "cp";
    public static final String LIST_COLUMN_USER = "cu";
    public static final String LIST_DEFACTION_FILES = "df";
    public static final String LIST_DETAIL_RESOURCES = "dr";
    public static final String LIST_ID = "lp";
    public static final String LIST_MACTION_DELETE = "md";
    public static final String LIST_MACTION_UNLOCK = "mu";
    public static final String PATH_BUTTONS = "tools/projects/buttons/";
    public static final String LIST_COLUMN_ORGUNIT = "cou";

    public CmsProjectsList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_PROJECTS_LIST_NAME_0"), LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsProjectsList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionDeleteProject() throws Exception {
        String pId = this.getJsp().getRequest().getParameter("projectid");
        this.getCms().deleteProject(new CmsUUID(pId));
        this.refreshList();
        this.actionCloseDialog();
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_DELETE)) {
            ArrayList<String> removedItems = new ArrayList<String>();
            try {
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    CmsUUID pId = new CmsUUID(listItem.getId());
                    this.getCms().deleteProject(pId);
                    removedItems.add(listItem.getId());
                }
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_DELETE_SELECTED_PROJECTS_0"), (Throwable)e);
            }
        } else if (this.getParamListAction().equals(LIST_MACTION_UNLOCK)) {
            try {
                Iterator itItems = this.getSelectedItems().iterator();
                while (itItems.hasNext()) {
                    CmsListItem listItem = (CmsListItem)itItems.next();
                    CmsUUID pId = new CmsUUID(listItem.getId());
                    this.getCms().unlockProject(pId);
                }
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_UNLOCK_SELECTED_PROJECTS_0"), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException {
        CmsUUID projectId = new CmsUUID(this.getSelectedItem().getId());
        String projectName = this.getSelectedItem().get(LIST_COLUMN_NAME).toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("projectid", projectId.toString());
        params.put("action", "initial");
        if (this.getParamListAction().equals(LIST_DEFACTION_FILES)) {
            params.put("showexplorer", Boolean.TRUE.toString());
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/projects/files", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_EDIT)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/projects/edit", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_FILES)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/projects/files", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_PUBLISH_ENABLED)) {
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/projects/publish", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_DELETE)) {
            try {
                this.getCms().deleteProject(projectId);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_DELETE_PROJECT_1", (Object)projectName), (Throwable)e);
            }
        } else if (!this.getParamListAction().equals(LIST_ACTION_LOCK)) {
            if (this.getParamListAction().equals(LIST_ACTION_UNLOCK)) {
                try {
                    this.getCms().unlockProject(projectId);
                }
                catch (CmsException e) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_UNLOCK_PROJECT_1", (Object)projectName), (Throwable)e);
                }
            } else {
                this.throwListUnsupportedActionException();
            }
        }
        this.listSave();
    }

    protected void fillDetails(String detailId) {
        List projects = this.getList().getAllContent();
        Iterator itProjects = projects.iterator();
        while (itProjects.hasNext()) {
            CmsListItem item = (CmsListItem)itProjects.next();
            try {
                if (!detailId.equals(LIST_DETAIL_RESOURCES)) continue;
                CmsProject project = this.getCms().readProject(new CmsUUID(item.getId()));
                StringBuffer html = new StringBuffer(512);
                Iterator resources = this.getCms().readProjectResources(project).iterator();
                while (resources.hasNext()) {
                    html.append(resources.next().toString());
                    html.append("<br>");
                }
                item.set(LIST_DETAIL_RESOURCES, (Object)html.toString());
            }
            catch (Exception e) {}
        }
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        List projects = OpenCms.getOrgUnitManager().getAllManageableProjects(this.getCms(), "", true);
        Iterator itProjects = projects.iterator();
        while (itProjects.hasNext()) {
            CmsProject project = (CmsProject)itProjects.next();
            CmsListItem item = this.getList().newItem(project.getUuid().toString());
            item.set(LIST_COLUMN_NAME, (Object)project.getSimpleName());
            item.set(LIST_COLUMN_DESCRIPTION, (Object)project.getDescription());
            item.set(LIST_COLUMN_ORGUNIT, (Object)OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), project.getOuFqn()).getDisplayName(this.getLocale()));
            try {
                item.set(LIST_COLUMN_OWNER, (Object)this.getCms().readUser(project.getOwnerId()).getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                item.set(LIST_COLUMN_MANAGER, (Object)this.getCms().readGroup(project.getManagerGroupId()).getSimpleName());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                item.set(LIST_COLUMN_USER, (Object)this.getCms().readGroup(project.getGroupId()).getSimpleName());
            }
            catch (Exception e) {
                // empty catch block
            }
            item.set(LIST_COLUMN_CREATION, (Object)new Date(project.getDateCreated()));
            StringBuffer html = new StringBuffer(512);
            Iterator resources = this.getCms().readProjectResources(project).iterator();
            while (resources.hasNext()) {
                html.append(resources.next().toString());
                html.append("<br>");
            }
            item.set(LIST_DETAIL_RESOURCES, (Object)html.toString());
            ret.add(item);
        }
        try {
            if (OpenCms.getOrgUnitManager().getOrganizationalUnits(this.getCms(), "", true).isEmpty()) {
                this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setVisible(false);
            } else {
                this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setVisible(true);
            }
        }
        catch (CmsException e) {
            // empty catch block
        }
        return ret;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition filesCol = new CmsListColumnDefinition(LIST_COLUMN_FILES);
        filesCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_FILES_0"));
        filesCol.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_COLS_FILES_HELP_0"));
        filesCol.setWidth("20");
        filesCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        filesCol.setSorteable(false);
        CmsListDirectAction filesAction = new CmsListDirectAction(LIST_ACTION_FILES);
        filesAction.setName(Messages.get().container("GUI_PROJECTS_LIST_ACTION_FILES_NAME_0"));
        filesAction.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_ACTION_FILES_HELP_0"));
        filesAction.setIconPath("tools/projects/buttons/project.png");
        filesCol.addDirectAction((I_CmsListDirectAction)filesAction);
        metadata.addColumn(filesCol);
        CmsListColumnDefinition lockCol = new CmsListColumnDefinition(LIST_COLUMN_LOCK);
        lockCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_LOCK_0"));
        lockCol.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_COLS_LOCK_HELP_0"));
        lockCol.setWidth("20");
        lockCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        lockCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemActionIconComparator());
        CmsListDirectAction lockAction = new CmsListDirectAction(LIST_ACTION_LOCK){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    try {
                        return CmsProjectsList.this.getCms().countLockedResources(new CmsUUID(this.getItem().getId())) == 0;
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                }
                return super.isVisible();
            }
        };
        lockAction.setName(Messages.get().container("GUI_PROJECTS_LIST_ACTION_LOCK_NAME_0"));
        lockAction.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_ACTION_LOCK_HELP_0"));
        lockAction.setConfirmationMessage(Messages.get().container("GUI_PROJECTS_LIST_ACTION_LOCK_CONF_0"));
        lockAction.setIconPath("tools/projects/buttons/project_lock.png");
        lockAction.setEnabled(false);
        lockCol.addDirectAction((I_CmsListDirectAction)lockAction);
        CmsListDirectAction unlockAction = new CmsListDirectAction(LIST_ACTION_UNLOCK){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    try {
                        return CmsProjectsList.this.getCms().countLockedResources(new CmsUUID(this.getItem().getId())) != 0;
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                }
                return super.isVisible();
            }
        };
        unlockAction.setName(Messages.get().container("GUI_PROJECTS_LIST_ACTION_UNLOCK_NAME_0"));
        unlockAction.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_ACTION_UNLOCK_HELP_0"));
        unlockAction.setConfirmationMessage(Messages.get().container("GUI_PROJECTS_LIST_ACTION_UNLOCK_CONF_0"));
        unlockAction.setIconPath("tools/projects/buttons/project_unlock.png");
        lockCol.addDirectAction((I_CmsListDirectAction)unlockAction);
        metadata.addColumn(lockCol);
        CmsListColumnDefinition publishCol = new CmsListColumnDefinition(LIST_COLUMN_PUBLISH);
        publishCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_PUBLISH_0"));
        publishCol.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_COLS_PUBLISH_HELP_0"));
        publishCol.setWidth("20");
        publishCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        publishCol.setSorteable(false);
        CmsListDirectAction publishEnabledAction = new CmsListDirectAction(LIST_ACTION_PUBLISH_ENABLED){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    try {
                        return CmsProjectsList.this.getCms().countLockedResources(new CmsUUID(this.getItem().getId())) == 0;
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                }
                return super.isVisible();
            }
        };
        publishEnabledAction.setName(Messages.get().container("GUI_PROJECTS_LIST_ACTION_PUBLISH_ENABLED_NAME_0"));
        publishEnabledAction.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_ACTION_PUBLISH_ENABLED_HELP_0"));
        publishEnabledAction.setConfirmationMessage(Messages.get().container("GUI_PROJECTS_LIST_ACTION_PUBLISH_ENABLED_CONF_0"));
        publishEnabledAction.setIconPath("tools/projects/buttons/project_publish.png");
        publishCol.addDirectAction((I_CmsListDirectAction)publishEnabledAction);
        CmsListDirectAction publishDisabledAction = new CmsListDirectAction(LIST_ACTION_PUBLISH_DISABLED){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    try {
                        return CmsProjectsList.this.getCms().countLockedResources(new CmsUUID(this.getItem().getId())) != 0;
                    }
                    catch (CmsException cmsException) {
                        // empty catch block
                    }
                }
                return super.isVisible();
            }
        };
        publishDisabledAction.setName(Messages.get().container("GUI_PROJECTS_LIST_ACTION_PUBLISH_DISABLED_NAME_0"));
        publishDisabledAction.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_ACTION_PUBLISH_DISABLED_HELP_0"));
        publishDisabledAction.setConfirmationMessage(Messages.get().container("GUI_PROJECTS_LIST_ACTION_PUBLISH_DISABLED_CONF_0"));
        publishDisabledAction.setIconPath("tools/projects/buttons/project_publish_disabled.png");
        publishDisabledAction.setEnabled(false);
        publishCol.addDirectAction((I_CmsListDirectAction)publishDisabledAction);
        metadata.addColumn(publishCol);
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_EDIT_0"));
        editCol.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_COLS_EDIT_HELP_0"));
        editCol.setWidth("20");
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        editCol.setSorteable(false);
        CmsListDirectAction editAction = new CmsListDirectAction(LIST_ACTION_EDIT);
        editAction.setName(Messages.get().container("GUI_PROJECTS_LIST_ACTION_EDIT_NAME_0"));
        editAction.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_ACTION_EDIT_HELP_0"));
        editAction.setIconPath("tools/projects/buttons/project_edit.png");
        editCol.addDirectAction((I_CmsListDirectAction)editAction);
        metadata.addColumn(editCol);
        CmsListColumnDefinition deleteCol = new CmsListColumnDefinition(LIST_COLUMN_DELETE);
        deleteCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_DELETE_0"));
        deleteCol.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_COLS_DELETE_HELP_0"));
        deleteCol.setWidth("20");
        deleteCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        deleteCol.setSorteable(false);
        CmsListDirectAction deleteAction = new CmsListDirectAction(LIST_ACTION_DELETE);
        deleteAction.setName(Messages.get().container("GUI_PROJECTS_LIST_ACTION_DELETE_NAME_0"));
        deleteAction.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_ACTION_DELETE_HELP_0"));
        deleteAction.setConfirmationMessage(Messages.get().container("GUI_PROJECTS_LIST_ACTION_DELETE_CONF_0"));
        deleteAction.setIconPath("list/delete.png");
        deleteCol.addDirectAction((I_CmsListDirectAction)deleteAction);
        metadata.addColumn(deleteCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_NAME_0"));
        nameCol.setWidth("15%");
        CmsListDefaultAction defEditAction = new CmsListDefaultAction(LIST_DEFACTION_FILES);
        defEditAction.setName(Messages.get().container("GUI_PROJECTS_LIST_DEFACTION_EDIT_NAME_0"));
        defEditAction.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_DEFACTION_EDIT_HELP_0"));
        nameCol.addDefaultAction(defEditAction);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition descriptionCol = new CmsListColumnDefinition(LIST_COLUMN_DESCRIPTION);
        descriptionCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_DESCRIPTION_0"));
        descriptionCol.setWidth("20%");
        descriptionCol.setTextWrapping(true);
        metadata.addColumn(descriptionCol);
        CmsListColumnDefinition ouCol = new CmsListColumnDefinition(LIST_COLUMN_ORGUNIT);
        ouCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_ORGUNIT_0"));
        ouCol.setWidth("15%");
        metadata.addColumn(ouCol);
        CmsListColumnDefinition ownerCol = new CmsListColumnDefinition(LIST_COLUMN_OWNER);
        ownerCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_OWNER_0"));
        ownerCol.setWidth("12%");
        metadata.addColumn(ownerCol);
        CmsListColumnDefinition managerCol = new CmsListColumnDefinition(LIST_COLUMN_MANAGER);
        managerCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_MANAGER_0"));
        managerCol.setWidth("12%");
        metadata.addColumn(managerCol);
        CmsListColumnDefinition userCol = new CmsListColumnDefinition(LIST_COLUMN_USER);
        userCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_USER_0"));
        userCol.setWidth("12%");
        metadata.addColumn(userCol);
        CmsListColumnDefinition creationCol = new CmsListColumnDefinition(LIST_COLUMN_CREATION);
        creationCol.setName(Messages.get().container("GUI_PROJECTS_LIST_COLS_CREATION_0"));
        creationCol.setWidth("14%");
        creationCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(creationCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails resourcesDetails = new CmsListItemDetails(LIST_DETAIL_RESOURCES);
        resourcesDetails.setAtColumn(LIST_COLUMN_NAME);
        resourcesDetails.setVisible(false);
        resourcesDetails.setShowActionName(Messages.get().container("GUI_PROJECTS_DETAIL_SHOW_RESOURCES_NAME_0"));
        resourcesDetails.setShowActionHelpText(Messages.get().container("GUI_PROJECTS_DETAIL_SHOW_RESOURCES_HELP_0"));
        resourcesDetails.setHideActionName(Messages.get().container("GUI_PROJECTS_DETAIL_HIDE_RESOURCES_NAME_0"));
        resourcesDetails.setHideActionHelpText(Messages.get().container("GUI_PROJECTS_DETAIL_HIDE_RESOURCES_HELP_0"));
        resourcesDetails.setName(Messages.get().container("GUI_PROJECTS_DETAIL_RESOURCES_NAME_0"));
        resourcesDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_PROJECTS_DETAIL_RESOURCES_NAME_0")));
        metadata.addItemDetails(resourcesDetails);
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_NAME));
        searchAction.addColumn(metadata.getColumnDefinition(LIST_COLUMN_DESCRIPTION));
        metadata.setSearchAction(searchAction);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction unlockProject = new CmsListMultiAction(LIST_MACTION_UNLOCK);
        unlockProject.setName(Messages.get().container("GUI_PROJECTS_LIST_MACTION_UNLOCK_NAME_0"));
        unlockProject.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_MACTION_UNLOCK_HELP_0"));
        unlockProject.setConfirmationMessage(Messages.get().container("GUI_PROJECTS_LIST_MACTION_UNLOCK_CONF_0"));
        unlockProject.setIconPath("tools/projects/buttons/project_unlock.png");
        metadata.addMultiAction(unlockProject);
        CmsListMultiAction deleteMultiAction = new CmsListMultiAction(LIST_MACTION_DELETE);
        deleteMultiAction.setName(Messages.get().container("GUI_PROJECTS_LIST_MACTION_DELETE_NAME_0"));
        deleteMultiAction.setHelpText(Messages.get().container("GUI_PROJECTS_LIST_MACTION_DELETE_HELP_0"));
        deleteMultiAction.setConfirmationMessage(Messages.get().container("GUI_PROJECTS_LIST_MACTION_DELETE_CONF_0"));
        deleteMultiAction.setIconPath("list/multi_delete.png");
        metadata.addMultiAction(deleteMultiAction);
    }
}

