/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cache;

import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.xml.Messages;

public final class CmsVfsMemoryObjectCache
implements I_CmsEventListener {
    private static final Log LOG = CmsLog.getLog(CmsVfsMemoryObjectCache.class);
    private static CmsVfsMemoryObjectCache m_vfsMemoryObjectCache;

    private CmsVfsMemoryObjectCache() {
        this.registerEventListener();
    }

    public static CmsVfsMemoryObjectCache getVfsMemoryObjectCache() {
        if (m_vfsMemoryObjectCache == null) {
            m_vfsMemoryObjectCache = new CmsVfsMemoryObjectCache();
        }
        return m_vfsMemoryObjectCache;
    }

    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 2: 
            case 5: {
                OpenCms.getMemoryMonitor().flushVfsObjects();
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ER_FLUSHED_CACHES_0"));
                break;
            }
            case 11: {
                CmsResource resource = (CmsResource)event.getData().get("resource");
                this.uncacheSystemId(resource.getRootPath());
                break;
            }
            case 22: 
            case 25: {
                List resources = (List)event.getData().get("resources");
                for (int i = 0; i < resources.size(); ++i) {
                    CmsResource resource = (CmsResource)resources.get(i);
                    this.uncacheSystemId(resource.getRootPath());
                }
                break;
            }
        }
    }

    public Object getCachedObject(CmsObject cms, String rootPath) {
        String key = this.getCacheKeyForCurrentProject(cms, rootPath);
        return OpenCms.getMemoryMonitor().getCachedVfsObject(key);
    }

    public void putCachedObject(CmsObject cms, String rootPath, Object value) {
        String key = this.getCacheKeyForCurrentProject(cms, rootPath);
        OpenCms.getMemoryMonitor().cacheVfsObject(key, value);
    }

    protected void registerEventListener() {
        OpenCms.addCmsEventListener(this, new int[]{5, 2, 11, 22, 25});
    }

    private String getCacheKey(String systemId, boolean online) {
        if (online) {
            return "online_".concat(systemId);
        }
        return "offline_".concat(systemId);
    }

    private String getCacheKeyForCurrentProject(CmsObject cms, String rootPath) {
        boolean project = cms != null ? cms.getRequestContext().currentProject().isOnlineProject() : false;
        return this.getCacheKey(rootPath, project);
    }

    private void uncacheSystemId(String systemId) {
        String key = this.getCacheKey(systemId, false);
        Object o = OpenCms.getMemoryMonitor().getCachedVfsObject(key);
        OpenCms.getMemoryMonitor().uncacheVfsObject(key);
        if (null != o && LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ER_UNCACHED_SYS_ID_1", key));
        }
    }
}

