/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.dom4j.Element;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.I_CmsXmlConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.module.CmsModuleManager;
import org.opencms.module.CmsModuleXmlHandler;

public class CmsModuleConfiguration
extends A_CmsXmlConfiguration
implements I_CmsXmlConfiguration {
    public static final String CONFIGURATION_DTD_NAME = "opencms-modules.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-modules.xml";
    public static final String N_MODULES = "modules";
    private CmsModuleManager m_moduleManager;
    private List m_modules;

    public CmsModuleConfiguration() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        this.m_modules = new ArrayList();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_MODULE_CONFIG_INIT_0"));
        }
    }

    public void addXmlDigesterRules(Digester digester) {
        digester.addCallMethod("*/modules", "initializeFinished");
        CmsModuleXmlHandler.addXmlDigesterRules(digester);
    }

    public Element generateXml(Element parent) {
        ArrayList<CmsModule> modules;
        if (OpenCms.getRunLevel() >= 3) {
            modules = new ArrayList<CmsModule>();
            Iterator names = OpenCms.getModuleManager().getModuleNames().iterator();
            while (names.hasNext()) {
                CmsModule module = OpenCms.getModuleManager().getModule((String)names.next());
                if (module == null) continue;
                modules.add(module);
            }
            Collections.sort(modules);
        } else {
            modules = this.m_modules;
        }
        Element modulesNode = parent.addElement(N_MODULES);
        for (int i = 0; i < modules.size(); ++i) {
            CmsModule module = (CmsModule)modules.get(i);
            Element moduleNode = CmsModuleXmlHandler.generateXml(module);
            modulesNode.add(moduleNode);
        }
        return modulesNode;
    }

    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsModuleManager getModuleManager() {
        return this.m_moduleManager;
    }

    public void initializeFinished() {
        this.m_moduleManager = new CmsModuleManager(this.m_modules);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_MODULE_CONFIG_FINISHED_0"));
        }
    }

    public void setModule(CmsModuleXmlHandler moduleHandler) {
        this.m_modules.add(moduleHandler.getModule());
    }
}

