/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.dom4j.Element;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.I_CmsXmlConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.i18n.CmsLocaleComparator;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchAnalyzer;
import org.opencms.search.CmsSearchDocumentType;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;

public class CmsSearchConfiguration
extends A_CmsXmlConfiguration
implements I_CmsXmlConfiguration {
    public static final String A_BOOST = "boost";
    public static final String A_DISPLAY = "display";
    public static final String A_EXCERPT = "excerpt";
    public static final String A_INDEX = "index";
    public static final String A_STORE = "store";
    public static final String CONFIGURATION_DTD_NAME = "opencms-search.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-search.xml";
    public static final String N_ANALYZER = "analyzer";
    public static final String N_ANALYZERS = "analyzers";
    public static final String N_CLASS = "class";
    public static final String N_CONFIGURATION = "configuration";
    public static final String N_DESCRIPTION = "description";
    public static final String N_DIRECTORY = "directory";
    public static final String N_DOCUMENTTYPE = "documenttype";
    public static final String N_DOCUMENTTYPES = "documenttypes";
    public static final String N_DOCUMENTTYPES_INDEXED = "documenttypes-indexed";
    public static final String N_EXCERPT = "excerpt";
    public static final String N_EXTRACTION_CACHE_MAX_AGE = "extractionCacheMaxAge";
    public static final String N_FIELD = "field";
    public static final String N_FIELDCONFIGURATION = "fieldconfiguration";
    public static final String N_FIELDCONFIGURATIONS = "fieldconfigurations";
    public static final String N_FIELDS = "fields";
    public static final String N_FORCEUNLOCK = "forceunlock";
    public static final String N_HIGHLIGHTER = "highlighter";
    public static final String N_INDEX = "index";
    public static final String N_INDEXER = "indexer";
    public static final String N_INDEXES = "indexes";
    public static final String N_INDEXSOURCE = "indexsource";
    public static final String N_INDEXSOURCES = "indexsources";
    public static final String N_LOCALE = "locale";
    public static final String N_MAPPING = "mapping";
    public static final String N_MIMETYPE = "mimetype";
    public static final String N_MIMETYPES = "mimetypes";
    public static final String N_PROJECT = "project";
    public static final String N_REBUILD = "rebuild";
    public static final String N_RESOURCES = "resources";
    public static final String N_RESOURCETYPE = "resourcetype";
    public static final String N_RESOURCETYPES = "resourcetypes";
    public static final String N_SEARCH = "search";
    public static final String N_SOURCE = "source";
    public static final String N_SOURCES = "sources";
    public static final String N_STEMMER = "stemmer";
    public static final String N_TIMEOUT = "timeout";
    private static final String XPATH_SEARCH = "*/search";
    private CmsSearchManager m_searchManager;

    public CmsSearchConfiguration() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_CONFIG_INIT_0"));
        }
    }

    public void addXmlDigesterRules(Digester digester) {
        String xPath = null;
        digester.addCallMethod(XPATH_SEARCH, "initializeFinished");
        digester.addObjectCreate(XPATH_SEARCH, CmsSearchManager.class);
        digester.addSetNext(XPATH_SEARCH, "setSearchManager");
        digester.addCallMethod("*/search/directory", "setDirectory", 0);
        digester.addCallMethod("*/search/timeout", "setTimeout", 0);
        digester.addCallMethod("*/search/forceunlock", "setForceunlock", 0);
        digester.addCallMethod("*/search/excerpt", "setMaxExcerptLength", 0);
        digester.addCallMethod("*/search/extractionCacheMaxAge", "setExtractionCacheMaxAge", 0);
        digester.addCallMethod("*/search/highlighter", "setHighlighter", 0);
        xPath = "*/search/documenttypes/documenttype";
        digester.addObjectCreate(xPath, CmsSearchDocumentType.class);
        digester.addCallMethod(xPath + "/" + "name", "setName", 0);
        digester.addCallMethod(xPath + "/" + N_CLASS, "setClassName", 0);
        digester.addCallMethod(xPath + "/" + N_MIMETYPES + "/" + N_MIMETYPE, "addMimeType", 0);
        digester.addCallMethod(xPath + "/" + N_RESOURCETYPES + "/" + N_RESOURCETYPE, "addResourceType", 0);
        digester.addSetNext(xPath, "addDocumentTypeConfig");
        xPath = "*/search/analyzers/analyzer";
        digester.addObjectCreate(xPath, CmsSearchAnalyzer.class);
        digester.addCallMethod(xPath + "/" + N_CLASS, "setClassName", 0);
        digester.addCallMethod(xPath + "/" + N_STEMMER, "setStemmerAlgorithm", 0);
        digester.addCallMethod(xPath + "/" + N_LOCALE, "setLocaleString", 0);
        digester.addSetNext(xPath, "addAnalyzer");
        xPath = "*/search/indexes/index";
        digester.addObjectCreate(xPath, CmsSearchIndex.class);
        digester.addCallMethod(xPath + "/" + "name", "setName", 0);
        digester.addCallMethod(xPath + "/" + N_REBUILD, "setRebuildMode", 0);
        digester.addCallMethod(xPath + "/" + N_PROJECT, "setProjectName", 0);
        digester.addCallMethod(xPath + "/" + N_LOCALE, "setLocaleString", 0);
        digester.addCallMethod(xPath + "/" + N_CONFIGURATION, "setFieldConfigurationName", 0);
        digester.addCallMethod(xPath + "/" + N_SOURCES + "/" + N_SOURCE, "addSourceName", 0);
        digester.addSetNext(xPath, "addSearchIndex");
        xPath = "*/search/indexsources/indexsource";
        digester.addObjectCreate(xPath, CmsSearchIndexSource.class);
        digester.addCallMethod(xPath + "/" + "name", "setName", 0);
        digester.addCallMethod(xPath + "/" + N_INDEXER, "setIndexerClassName", 1);
        digester.addCallParam(xPath + "/" + N_INDEXER, 0, N_CLASS);
        digester.addCallMethod(xPath + "/" + N_RESOURCES + "/" + "resource", "addResourceName", 0);
        digester.addCallMethod(xPath + "/" + N_DOCUMENTTYPES_INDEXED + "/" + "name", "addDocumentType", 0);
        digester.addSetNext(xPath, "addSearchIndexSource");
        xPath = "*/search/fieldconfigurations/fieldconfiguration";
        digester.addObjectCreate(xPath, CmsSearchFieldConfiguration.class);
        digester.addCallMethod(xPath + "/" + "name", "setName", 0);
        digester.addCallMethod(xPath + "/" + N_DESCRIPTION, "setDescription", 0);
        digester.addSetNext(xPath, "addFieldConfiguration");
        xPath = xPath + "/" + N_FIELDS + "/" + N_FIELD;
        digester.addObjectCreate(xPath, CmsSearchField.class);
        digester.addCallMethod(xPath, "setName", 1);
        digester.addCallParam(xPath, 0, "name");
        digester.addCallMethod(xPath, "setDisplayNameForConfiguration", 1);
        digester.addCallParam(xPath, 0, A_DISPLAY);
        digester.addCallMethod(xPath, "setStored", 1);
        digester.addCallParam(xPath, 0, A_STORE);
        digester.addCallMethod(xPath, "setIndexed", 1);
        digester.addCallParam(xPath, 0, "index");
        digester.addCallMethod(xPath, "setBoost", 1);
        digester.addCallParam(xPath, 0, A_BOOST);
        digester.addCallMethod(xPath, "setInExcerpt", 1);
        digester.addCallParam(xPath, 0, "excerpt");
        digester.addCallMethod(xPath, "setDefaultValue", 1);
        digester.addCallParam(xPath, 0, "default");
        digester.addSetNext(xPath, "addField");
        xPath = xPath + "/" + N_MAPPING;
        digester.addObjectCreate(xPath, CmsSearchFieldMapping.class);
        digester.addCallMethod(xPath, "setDefaultValue", 1);
        digester.addCallParam(xPath, 0, "default");
        digester.addCallMethod(xPath, "setType", 1);
        digester.addCallParam(xPath, 0, "type");
        digester.addCallMethod(xPath, "setParam", 0);
        digester.addSetNext(xPath, "addMapping");
        digester.addCallMethod("*/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/param", 0, "name");
        digester.addCallParam("*/param", 1);
    }

    public Element generateXml(Element parent) {
        Element searchElement = parent.addElement(N_SEARCH);
        if (OpenCms.getRunLevel() >= 3) {
            this.m_searchManager = OpenCms.getSearchManager();
        }
        searchElement.addElement(N_DIRECTORY).addText(this.m_searchManager.getDirectory());
        searchElement.addElement(N_TIMEOUT).addText(String.valueOf(this.m_searchManager.getTimeout()));
        if (this.m_searchManager.getForceunlock() != null) {
            searchElement.addElement(N_FORCEUNLOCK).addText(this.m_searchManager.getForceunlock().toString());
        }
        searchElement.addElement("excerpt").addText(String.valueOf(this.m_searchManager.getMaxExcerptLength()));
        searchElement.addElement(N_EXTRACTION_CACHE_MAX_AGE).addText(String.valueOf(this.m_searchManager.getExtractionCacheMaxAge()));
        searchElement.addElement(N_HIGHLIGHTER).addText(this.m_searchManager.getHighlighter().getClass().getName());
        Element documenttypesElement = searchElement.addElement(N_DOCUMENTTYPES);
        List docTypeKeyList = this.m_searchManager.getDocumentTypeConfigs();
        Iterator docTypeIterator = docTypeKeyList.iterator();
        while (docTypeIterator.hasNext()) {
            CmsSearchDocumentType currSearchDocType = (CmsSearchDocumentType)docTypeIterator.next();
            Element documenttypeElement = documenttypesElement.addElement(N_DOCUMENTTYPE);
            documenttypeElement.addElement("name").addText(currSearchDocType.getName());
            documenttypeElement.addElement(N_CLASS).addText(currSearchDocType.getClassName());
            Element mimetypesElement = documenttypeElement.addElement(N_MIMETYPES);
            Iterator mimeTypesIterator = currSearchDocType.getMimeTypes().iterator();
            while (mimeTypesIterator.hasNext()) {
                mimetypesElement.addElement(N_MIMETYPE).addText((String)mimeTypesIterator.next());
            }
            Element restypesElement = documenttypeElement.addElement(N_RESOURCETYPES);
            Iterator resTypesIterator = currSearchDocType.getResourceTypes().iterator();
            while (resTypesIterator.hasNext()) {
                restypesElement.addElement(N_RESOURCETYPE).addText((String)resTypesIterator.next());
            }
        }
        Element analyzersElement = searchElement.addElement(N_ANALYZERS);
        ArrayList analyzerLocaleList = new ArrayList(this.m_searchManager.getAnalyzers().keySet());
        Collections.sort(analyzerLocaleList, CmsLocaleComparator.getComparator());
        Iterator analyzersLocaleInterator = analyzerLocaleList.iterator();
        while (analyzersLocaleInterator.hasNext()) {
            CmsSearchAnalyzer searchAnalyzer = this.m_searchManager.getCmsSearchAnalyzer((Locale)analyzersLocaleInterator.next());
            Element analyzerElement = analyzersElement.addElement(N_ANALYZER);
            analyzerElement.addElement(N_CLASS).addText(searchAnalyzer.getClassName());
            if (searchAnalyzer.getStemmerAlgorithm() != null) {
                analyzerElement.addElement(N_STEMMER).addText(searchAnalyzer.getStemmerAlgorithm());
            }
            analyzerElement.addElement(N_LOCALE).addText(searchAnalyzer.getLocale().toString());
        }
        Element indexesElement = searchElement.addElement(N_INDEXES);
        Iterator indexIterator = this.m_searchManager.getSearchIndexes().iterator();
        while (indexIterator.hasNext()) {
            CmsSearchIndex searchIndex = (CmsSearchIndex)indexIterator.next();
            Element indexElement = indexesElement.addElement("index");
            indexElement.addElement("name").addText(searchIndex.getName());
            indexElement.addElement(N_REBUILD).addText(searchIndex.getRebuildMode());
            indexElement.addElement(N_PROJECT).addText(searchIndex.getProject());
            indexElement.addElement(N_LOCALE).addText(searchIndex.getLocale().toString());
            String fieldConfigurationName = searchIndex.getFieldConfigurationName();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(fieldConfigurationName)) {
                indexElement.addElement(N_CONFIGURATION).addText(fieldConfigurationName);
            }
            Element sourcesElement = indexElement.addElement(N_SOURCES);
            Iterator sourcesIterator = searchIndex.getSourceNames().iterator();
            while (sourcesIterator.hasNext()) {
                sourcesElement.addElement(N_SOURCE).addText((String)sourcesIterator.next());
            }
            Map indexConfiguration = searchIndex.getConfiguration();
            if (indexConfiguration == null) continue;
            Iterator it = indexConfiguration.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                Element paramNode = indexElement.addElement("param");
                paramNode.addAttribute("name", name);
                paramNode.addText(value);
            }
        }
        Element indexsourcesElement = searchElement.addElement(N_INDEXSOURCES);
        ArrayList indexSources = new ArrayList(this.m_searchManager.getSearchIndexSources().values());
        Iterator indexsourceIterator = indexSources.iterator();
        while (indexsourceIterator.hasNext()) {
            CmsSearchIndexSource searchIndexSource = (CmsSearchIndexSource)indexsourceIterator.next();
            Element indexsourceElement = indexsourcesElement.addElement(N_INDEXSOURCE);
            indexsourceElement.addElement("name").addText(searchIndexSource.getName());
            Element indexerElement = indexsourceElement.addElement(N_INDEXER).addAttribute(N_CLASS, searchIndexSource.getIndexerClassName());
            Map params = searchIndexSource.getParams();
            Iterator paramIterator = params.entrySet().iterator();
            while (paramIterator.hasNext()) {
                Map.Entry entry = paramIterator.next();
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                indexerElement.addElement("param").addAttribute("name", name).addText(value);
            }
            Element resourcesElement = indexsourceElement.addElement(N_RESOURCES);
            Iterator resourceIterator = searchIndexSource.getResourcesNames().iterator();
            while (resourceIterator.hasNext()) {
                resourcesElement.addElement("resource").addText((String)resourceIterator.next());
            }
            Element doctypes_indexedElement = indexsourceElement.addElement(N_DOCUMENTTYPES_INDEXED);
            Iterator doctypesIterator = searchIndexSource.getDocumentTypes().iterator();
            while (doctypesIterator.hasNext()) {
                doctypes_indexedElement.addElement("name").addText((String)doctypesIterator.next());
            }
        }
        Element configurationsElement = searchElement.addElement(N_FIELDCONFIGURATIONS);
        Iterator configs = this.m_searchManager.getFieldConfigurations().iterator();
        while (configs.hasNext()) {
            CmsSearchFieldConfiguration config = (CmsSearchFieldConfiguration)configs.next();
            Element configElement = configurationsElement.addElement(N_FIELDCONFIGURATION);
            configElement.addElement("name").setText(config.getName());
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(config.getDescription())) {
                configElement.addElement(N_DESCRIPTION).setText(config.getDescription());
            }
            Element fieldsElement = configElement.addElement(N_FIELDS);
            Iterator fields = config.getFields().iterator();
            while (fields.hasNext()) {
                CmsSearchField field = (CmsSearchField)fields.next();
                Element fieldElement = fieldsElement.addElement(N_FIELD);
                fieldElement.addAttribute("name", field.getName());
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(field.getDisplayNameForConfiguration())) {
                    fieldElement.addAttribute(A_DISPLAY, field.getDisplayNameForConfiguration());
                }
                fieldElement.addAttribute(A_STORE, String.valueOf(field.isStored()));
                String index = field.isIndexed() ? (field.isTokenizedAndIndexed() ? CmsStringUtil.TRUE : "untokenized") : CmsStringUtil.FALSE;
                fieldElement.addAttribute("index", index);
                if (field.getBoost() != 1.0f) {
                    fieldElement.addAttribute(A_BOOST, String.valueOf(field.getBoost()));
                }
                if (field.isInExcerptAndStored()) {
                    fieldElement.addAttribute("excerpt", String.valueOf(true));
                }
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(field.getDefaultValue())) {
                    fieldElement.addAttribute("default", field.getDefaultValue());
                }
                Iterator mappings = field.getMappings().iterator();
                while (mappings.hasNext()) {
                    CmsSearchFieldMapping mapping = (CmsSearchFieldMapping)mappings.next();
                    Element mappingElement = fieldElement.addElement(N_MAPPING);
                    mappingElement.addAttribute("type", mapping.getType().toString());
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(mapping.getDefaultValue())) {
                        mappingElement.addAttribute("default", mapping.getDefaultValue());
                    }
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(mapping.getParam())) continue;
                    mappingElement.setText(mapping.getParam());
                }
            }
        }
        return searchElement;
    }

    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsSearchManager getSearchManager() {
        return this.m_searchManager;
    }

    public void initializeFinished() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_CONFIG_FINISHED_0"));
        }
    }

    public void setSearchManager(CmsSearchManager manager) {
        this.m_searchManager = manager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SEARCH_MANAGER_FINISHED_0"));
        }
    }
}

