/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.pool.ObjectPool;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.db.CmsCacheSettings;
import org.opencms.db.CmsDbConsistencyException;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbException;
import org.opencms.db.CmsDbPool;
import org.opencms.db.CmsExportPointDriver;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.db.CmsSecurityManager;
import org.opencms.db.CmsSqlManager;
import org.opencms.db.CmsVfsOnlineResourceAlreadyExistsException;
import org.opencms.db.I_CmsCacheKey;
import org.opencms.db.I_CmsDbContextFactory;
import org.opencms.db.I_CmsDriver;
import org.opencms.db.I_CmsHistoryDriver;
import org.opencms.db.I_CmsProjectDriver;
import org.opencms.db.I_CmsUserDriver;
import org.opencms.db.I_CmsVfsDriver;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryFile;
import org.opencms.file.history.CmsHistoryFolder;
import org.opencms.file.history.CmsHistoryPrincipal;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexRequestContextInfo;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockFilter;
import org.opencms.lock.CmsLockManager;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsMultiException;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.publish.CmsPublishReport;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationSystemValidator;
import org.opencms.relations.CmsRelationType;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsAuthentificationException;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPasswordEncryptionException;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsPermissionHandler;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.commons.CmsProgressThread;

public final class CmsDriverManager
implements I_CmsEventListener {
    public static final String CACHE_ALL_PROPERTIES = "_CAP_";
    public static final int CHANGED_ACCESSCONTROL = 1;
    public static final int CHANGED_CONTENT = 16;
    public static final int CHANGED_LASTMODIFIED = 4;
    public static final int CHANGED_RESOURCE = 8;
    public static final int CHANGED_TIMEFRAME = 2;
    public static final String CONFIGURATION_BACKUP = "driver.backup";
    public static final String CONFIGURATION_CACHE = "cache";
    public static final String CONFIGURATION_DB = "db";
    public static final String CONFIGURATION_HISTORY = "driver.history";
    public static final String CONFIGURATION_PROJECT = "driver.project";
    public static final String CONFIGURATION_USER = "driver.user";
    public static final String CONFIGURATION_VFS = "driver.vfs";
    public static final String LOST_AND_FOUND_FOLDER = "/system/lost-found";
    public static final int MAX_VFS_RESOURCE_PATH_LENGTH = 512;
    public static final int NOTHING_CHANGED = 0;
    public static final String READ_IGNORE_PARENT = null;
    public static final long READ_IGNORE_TIME = 0L;
    public static final int READ_IGNORE_TYPE = -1;
    public static final int READMODE_EXCLUDE_STATE = 8;
    public static final int READMODE_EXCLUDE_TREE = 1;
    public static final int READMODE_EXCLUDE_TYPE = 4;
    public static final int READMODE_IGNORESTATE = 0;
    public static final int READMODE_INCLUDE_PROJECT = 2;
    public static final int READMODE_INCLUDE_TREE = 0;
    public static final int READMODE_MATCHSTATE = 1;
    public static final int READMODE_ONLY_FILES = 128;
    public static final int READMODE_ONLY_FOLDERS = 64;
    public static final int READMODE_UNMATCHSTATE = 2;
    public static final String TEMP_FILE_PREFIX = "~";
    public static final int UPDATE_ALL = 3;
    public static final int UPDATE_RESOURCE = 4;
    public static final int UPDATE_RESOURCE_PROJECT = 6;
    public static final int UPDATE_RESOURCE_STATE = 1;
    public static final int UPDATE_RESOURCE_STATE_CONTENT = 7;
    public static final int UPDATE_STRUCTURE = 5;
    public static final int UPDATE_STRUCTURE_STATE = 2;
    private static final Log LOG = CmsLog.getLog(CmsDriverManager.class);
    private static final CmsReadChangedProjectResourceMode RCPRM_FILES_AND_FOLDERS_MODE = new CmsReadChangedProjectResourceMode();
    private static final CmsReadChangedProjectResourceMode RCPRM_FILES_ONLY_MODE = new CmsReadChangedProjectResourceMode();
    private static final CmsReadChangedProjectResourceMode RCPRM_FOLDERS_ONLY_MODE = new CmsReadChangedProjectResourceMode();
    private List m_connectionPools;
    private I_CmsHistoryDriver m_historyDriver;
    private CmsRelationSystemValidator m_htmlLinkValidator;
    private I_CmsCacheKey m_keyGenerator;
    private CmsLockManager m_lockManager;
    private I_CmsProjectDriver m_projectDriver;
    private ExtendedProperties m_propertyConfiguration;
    private CmsPublishEngine m_publishEngine;
    private CmsSecurityManager m_securityManager;
    private CmsSqlManager m_sqlManager;
    private I_CmsUserDriver m_userDriver;
    private I_CmsVfsDriver m_vfsDriver;

    private CmsDriverManager() {
    }

    public static CmsDriverManager newInstance(CmsConfigurationManager configurationManager, CmsSecurityManager securityManager, I_CmsDbContextFactory runtimeInfoFactory, CmsPublishEngine publishEngine) throws CmsInitException {
        ExtendedProperties config = (ExtendedProperties)configurationManager.getConfiguration();
        List<String> drivers = null;
        String driverName = null;
        I_CmsVfsDriver vfsDriver = null;
        I_CmsUserDriver userDriver = null;
        I_CmsProjectDriver projectDriver = null;
        I_CmsHistoryDriver historyDriver = null;
        CmsDriverManager driverManager = null;
        try {
            driverManager = new CmsDriverManager();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_PHASE1_0"));
            }
            if (runtimeInfoFactory == null && CmsLog.INIT.isDebugEnabled()) {
                CmsLog.INIT.debug((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_RT_0"));
            }
        }
        catch (Exception exc) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("LOG_ERR_DRIVER_MANAGER_START_0");
            if (LOG.isFatalEnabled()) {
                LOG.fatal((Object)message.key(), (Throwable)exc);
            }
            throw new CmsInitException(message, (Throwable)exc);
        }
        driverManager.m_securityManager = securityManager;
        driverManager.m_connectionPools = new ArrayList();
        driverManager.m_lockManager = new CmsLockManager(driverManager);
        driverManager.m_sqlManager = new CmsSqlManager(driverManager);
        driverManager.m_publishEngine = publishEngine;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_PHASE2_0"));
        }
        String[] driverPoolNames = config.getStringArray("db.pools");
        if (CmsLog.INIT.isInfoEnabled()) {
            String names = "";
            for (int p = 0; p < driverPoolNames.length; ++p) {
                names = names + driverPoolNames[p] + " ";
            }
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_POOLS_1", names));
        }
        for (int p = 0; p < driverPoolNames.length; ++p) {
            driverManager.newPoolInstance((Map)config, driverPoolNames[p]);
        }
        if (runtimeInfoFactory != null) {
            runtimeInfoFactory.initialize(driverManager);
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_PHASE3_0"));
        }
        drivers = Arrays.asList(config.getStringArray(CONFIGURATION_VFS));
        String driverKey = drivers.get(0) + ".vfs.driver";
        driverName = config.getString(driverKey);
        List<String> list = drivers = drivers.size() > 1 ? drivers.subList(1, drivers.size()) : null;
        if (driverName == null) {
            CmsLog.INIT.error((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_FAILED_1", driverKey));
        }
        vfsDriver = (I_CmsVfsDriver)driverManager.newDriverInstance(configurationManager, driverName, drivers);
        drivers = Arrays.asList(config.getStringArray(CONFIGURATION_USER));
        driverKey = drivers.get(0) + ".user.driver";
        driverName = config.getString(driverKey);
        List<String> list2 = drivers = drivers.size() > 1 ? drivers.subList(1, drivers.size()) : null;
        if (driverName == null) {
            CmsLog.INIT.error((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_FAILED_1", driverKey));
        }
        userDriver = (I_CmsUserDriver)driverManager.newDriverInstance(configurationManager, driverName, drivers);
        drivers = Arrays.asList(config.getStringArray(CONFIGURATION_PROJECT));
        driverKey = drivers.get(0) + ".project.driver";
        driverName = config.getString(driverKey);
        List<String> list3 = drivers = drivers.size() > 1 ? drivers.subList(1, drivers.size()) : null;
        if (driverName == null) {
            CmsLog.INIT.error((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_FAILED_1", driverKey));
        }
        projectDriver = (I_CmsProjectDriver)driverManager.newDriverInstance(configurationManager, driverName, drivers);
        if (config.get((Object)CONFIGURATION_HISTORY) != null) {
            drivers = Arrays.asList(config.getStringArray(CONFIGURATION_HISTORY));
            driverKey = drivers.get(0) + ".history.driver";
            driverName = config.getString(driverKey);
            List<String> list4 = drivers = drivers.size() > 1 ? drivers.subList(1, drivers.size()) : null;
            if (driverName == null) {
                CmsLog.INIT.error((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_FAILED_1", driverKey));
            }
            historyDriver = (I_CmsHistoryDriver)driverManager.newDriverInstance(configurationManager, driverName, drivers);
        } else {
            drivers = Arrays.asList(config.getStringArray(CONFIGURATION_BACKUP));
            driverKey = drivers.get(0) + ".backup.driver";
            driverName = config.getString(driverKey);
            List<String> list5 = drivers = drivers.size() > 1 ? drivers.subList(1, drivers.size()) : null;
            if (driverName == null) {
                CmsLog.INIT.error((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_FAILED_1", driverKey));
            }
            historyDriver = (I_CmsHistoryDriver)driverManager.newDriverInstance(configurationManager, driverName, drivers);
        }
        driverManager.m_vfsDriver = vfsDriver;
        driverManager.m_userDriver = userDriver;
        driverManager.m_projectDriver = projectDriver;
        driverManager.m_historyDriver = historyDriver;
        driverManager.m_propertyConfiguration = config;
        OpenCms.addCmsEventListener(driverManager, new int[]{19, 5, 6, 2});
        return driverManager;
    }

    public void addRelationToResource(CmsDbContext dbc, CmsResource resource, CmsResource target, CmsRelationType type, boolean importCase) throws CmsException {
        if (type.isDefinedInContent()) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_ADD_RELATION_IN_CONTENT_3", dbc.removeSiteRoot(resource.getRootPath()), dbc.removeSiteRoot(target.getRootPath()), type.getLocalizedName(dbc.getRequestContext().getLocale())));
        }
        CmsRelation relation = new CmsRelation(resource, target, type);
        this.m_vfsDriver.createRelation(dbc, dbc.currentProject().getUuid(), relation);
        if (!importCase) {
            this.setDateLastModified(dbc, resource, System.currentTimeMillis());
        }
    }

    public void addResourceToOrgUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, CmsResource resource) throws CmsException {
        OpenCms.getMemoryMonitor().flushRoles();
        OpenCms.getMemoryMonitor().flushRoleLists();
        this.m_userDriver.addResourceToOrganizationalUnit(dbc, orgUnit, resource);
    }

    public void addUserToGroup(CmsDbContext dbc, String username, String groupname, boolean readRoles) throws CmsException, CmsDbEntryNotFoundException {
        CmsGroup group = this.readGroup(dbc, groupname);
        if (group == null) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", groupname));
        }
        if (group.isVirtual() && !readRoles) {
            this.addUserToGroup(dbc, username, CmsRole.valueOf(group).getGroupName(), true);
            return;
        }
        if (group.isVirtual()) {
            readRoles = false;
        }
        if (readRoles && !group.isRole() || !readRoles && group.isRole()) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", groupname));
        }
        if (this.userInGroup(dbc, username, groupname, readRoles)) {
            return;
        }
        CmsUser user = this.readUser(dbc, username);
        if (user == null) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_USER_1", username));
        }
        if (readRoles) {
            CmsRole role = CmsRole.valueOf(group);
            this.m_securityManager.checkRole(dbc, role);
            if (this.m_securityManager.hasRole(dbc, user, role)) {
                return;
            }
            List children = role.getChildren(true);
            Iterator itUserGroups = this.getGroupsOfUser(dbc, username, group.getOuFqn(), true, true, true, dbc.getRequestContext().getRemoteAddress()).iterator();
            while (itUserGroups.hasNext()) {
                CmsGroup roleGroup = (CmsGroup)itUserGroups.next();
                if (!children.contains(CmsRole.valueOf(roleGroup))) continue;
                this.removeUserFromGroup(dbc, username, roleGroup.getName(), true);
            }
            Iterator it = this.getVirtualGroupsForRole(dbc, role).iterator();
            while (it.hasNext()) {
                CmsGroup virtualGroup = (CmsGroup)it.next();
                this.addUserToGroup(dbc, username, virtualGroup.getName(), true);
            }
            CmsRole wpUser = CmsRole.WORKPLACE_USER.forOrgUnit(group.getOuFqn());
            if (!(role.equals(wpUser) || role.getChildren(true).contains(wpUser) || this.m_securityManager.hasRole(dbc, user, wpUser))) {
                this.addUserToGroup(dbc, username, wpUser.getGroupName(), true);
            }
        }
        this.m_userDriver.createUserInGroup(dbc, user.getId(), group.getId());
        if (readRoles) {
            OpenCms.getMemoryMonitor().flushRoles();
            OpenCms.getMemoryMonitor().flushRoleLists();
        }
        OpenCms.getMemoryMonitor().flushUserGroups();
    }

    public void changeLock(CmsDbContext dbc, CmsResource resource, CmsLockType lockType) throws CmsException, CmsSecurityException {
        CmsLock currentLock = this.getLock(dbc, resource);
        if (currentLock.getEditionLock().isUnlocked() && currentLock.getSystemLock().isUnlocked()) {
            throw new CmsLockException(org.opencms.db.Messages.get().container("ERR_CHANGE_LOCK_UNLOCKED_RESOURCE_1", dbc.getRequestContext().getSitePath(resource)));
        }
        if (lockType == CmsLockType.EXCLUSIVE && currentLock.isExclusiveOwnedInProjectBy(dbc.currentUser(), dbc.currentProject())) {
            return;
        }
        int denied = 0;
        boolean canIgnorePermissions = this.m_securityManager.hasRoleForResource(dbc, dbc.currentUser(), CmsRole.VFS_MANAGER, resource);
        if (!canIgnorePermissions && resource.getTypeId() == CmsResourceTypeJsp.getStaticTypeId() && !this.m_securityManager.hasRoleForResource(dbc, dbc.currentUser(), CmsRole.DEVELOPER, resource)) {
            denied |= 2;
        }
        CmsPermissionSetCustom permissions = canIgnorePermissions ? new CmsPermissionSetCustom(-1) : this.getPermissions(dbc, resource, dbc.currentUser());
        permissions.denyPermissions(denied);
        if ((CmsPermissionSet.ACCESS_WRITE.getPermissions() & permissions.getPermissions()) != CmsPermissionSet.ACCESS_WRITE.getPermissions()) {
            this.m_securityManager.checkPermissions(dbc.getRequestContext(), resource, CmsPermissionSet.ACCESS_WRITE, I_CmsPermissionHandler.PERM_DENIED);
        }
        this.m_lockManager.removeResource(dbc, resource, true, lockType.isSystem());
        this.lockResource(dbc, resource, lockType);
    }

    public List changeResourcesInFolderWithProperty(CmsDbContext dbc, CmsResource resource, String propertyDefinition, String oldValue, String newValue, boolean recursive) throws CmsVfsException, CmsException {
        Pattern oldPattern;
        CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION;
        List resources = new ArrayList<CmsResource>();
        if (recursive) {
            resources = this.readResourcesWithProperty(dbc, resource, propertyDefinition, null, filter);
        } else {
            resources.add(resource);
        }
        try {
            oldPattern = Pattern.compile(oldValue);
        }
        catch (PatternSyntaxException e) {
            throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_CHANGE_RESOURCES_IN_FOLDER_WITH_PROP_4", new Object[]{propertyDefinition, oldValue, newValue, resource.getRootPath()}), (Throwable)e);
        }
        ArrayList<CmsResource> changedResources = new ArrayList<CmsResource>(resources.size());
        CmsPermissionSet perm = CmsPermissionSet.ACCESS_WRITE;
        for (int i = 0; i < resources.size(); ++i) {
            CmsResource res = (CmsResource)resources.get(i);
            try {
                this.m_securityManager.checkPermissions(dbc, res, perm, true, filter);
            }
            catch (Exception e) {
                continue;
            }
            CmsProperty property = this.readPropertyObject(dbc, res, propertyDefinition, false);
            String structureValue = property.getStructureValue();
            String resourceValue = property.getResourceValue();
            boolean changed = false;
            if (structureValue != null && oldPattern.matcher(structureValue).matches()) {
                property.setStructureValue(newValue);
                changed = true;
            }
            if (resourceValue != null && oldPattern.matcher(resourceValue).matches()) {
                property.setResourceValue(newValue);
                changed = true;
            }
            if (!changed) continue;
            this.writePropertyObject(dbc, res, property);
            changedResources.add(res);
        }
        return changedResources;
    }

    public void chflags(CmsDbContext dbc, CmsResource resource, int flags) throws CmsException {
        CmsResource clone = (CmsResource)resource.clone();
        clone.setFlags(flags);
        this.writeResource(dbc, clone);
    }

    public void chtype(CmsDbContext dbc, CmsResource resource, int type) throws CmsException {
        CmsResource clone = (CmsResource)resource.clone();
        I_CmsResourceType newType = OpenCms.getResourceManager().getResourceType(type);
        clone.setType(newType.getTypeId());
        this.writeResource(dbc, clone);
    }

    public void cmsEvent(CmsEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.db.Messages.get().getBundle().key("LOG_CMS_EVENT_1", new Integer(event.getType())));
        }
        switch (event.getType()) {
            case 19: {
                CmsDbContext dbc = (CmsDbContext)event.getData().get("dbContext");
                this.updateExportPoints(dbc);
                break;
            }
            case 2: {
                CmsUUID publishHistoryId = new CmsUUID((String)event.getData().get("publishHistoryId"));
                I_CmsReport report = (I_CmsReport)event.getData().get("report");
                CmsDbContext dbc = (CmsDbContext)event.getData().get("dbContext");
                this.writeExportPoints(dbc, report, publishHistoryId);
                break;
            }
            case 5: {
                OpenCms.getMemoryMonitor().clearCache();
                break;
            }
            case 6: {
                OpenCms.getMemoryMonitor().clearPrincipalsCache();
                break;
            }
        }
    }

    public void copyAccessControlEntries(CmsDbContext dbc, CmsResource source, CmsResource destination, boolean updateLastModifiedInfo) throws CmsException {
        ListIterator aceList = this.m_userDriver.readAccessControlEntries(dbc, dbc.currentProject(), source.getResourceId(), false).listIterator();
        this.m_userDriver.removeAccessControlEntries(dbc, dbc.currentProject(), destination.getResourceId());
        while (aceList.hasNext()) {
            CmsAccessControlEntry ace = (CmsAccessControlEntry)aceList.next();
            this.m_userDriver.createAccessControlEntry(dbc, dbc.currentProject(), destination.getResourceId(), ace.getPrincipal(), ace.getPermissions().getAllowedPermissions(), ace.getPermissions().getDeniedPermissions(), ace.getFlags());
        }
        if (updateLastModifiedInfo) {
            this.setDateLastModified(dbc, destination, destination.getDateLastModified());
        }
        OpenCms.getMemoryMonitor().clearAccessControlListCache();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", destination);
        data.put("change", new Integer(1));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void copyResource(CmsDbContext dbc, CmsResource source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException, CmsIllegalArgumentException {
        CmsUUID userLastModified;
        long dateLastModified;
        boolean copyAsSibling = false;
        if (!source.isFolder()) {
            if (siblingMode == CmsResource.COPY_AS_SIBLING) {
                copyAsSibling = true;
            }
            if (siblingMode == CmsResource.COPY_PRESERVE_SIBLING && source.getSiblingCount() > 1) {
                copyAsSibling = true;
            }
        }
        List properties = this.readPropertyObjects(dbc, source, false);
        if (copyAsSibling) {
            CmsResource resource = this.createSibling(dbc, source, destination, properties);
            Iterator itRelations = this.getRelationsForResource(dbc, source, CmsRelationFilter.TARGETS.filterNotDefinedInContent()).iterator();
            while (itRelations.hasNext()) {
                CmsRelation relation = (CmsRelation)itRelations.next();
                CmsResource target = null;
                try {
                    target = this.readResource(dbc, relation.getTargetId(), CmsResourceFilter.ALL);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    try {
                        target = this.readResource(dbc, relation.getTargetPath(), CmsResourceFilter.ALL);
                    }
                    catch (CmsVfsResourceNotFoundException e1) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)e1.getLocalizedMessage(), (Throwable)e1);
                        continue;
                    }
                }
                this.addRelationToResource(dbc, resource, target, relation.getType(), true);
            }
            return;
        }
        byte[] content = null;
        if (source.isFile()) {
            if (source instanceof CmsFile) {
                content = ((CmsFile)source).getContents();
            }
            if (content == null || content.length < 1) {
                content = this.m_vfsDriver.readContent(dbc, dbc.currentProject().getUuid(), source.getResourceId());
            }
        }
        String destinationFoldername = CmsResource.getParentFolder(destination);
        CmsFolder destinationFolder = this.m_securityManager.readFolder(dbc, destinationFoldername, CmsResourceFilter.IGNORE_EXPIRATION);
        long currentTime = System.currentTimeMillis();
        if (source.isFolder()) {
            dateLastModified = currentTime;
            userLastModified = dbc.currentUser().getId();
        } else {
            dateLastModified = source.getDateLastModified();
            userLastModified = source.getUserLastModified();
        }
        int flags = source.getFlags();
        if (source.isLabeled()) {
            flags &= 0xFFFFFFFD;
        }
        CmsResource newResource = new CmsResource(new CmsUUID(), new CmsUUID(), destination, source.getTypeId(), source.isFolder(), flags, dbc.currentProject().getUuid(), CmsResource.STATE_NEW, currentTime, dbc.currentUser().getId(), dateLastModified, userLastModified, source.getDateReleased(), source.getDateExpired(), 1, source.getLength(), source.getDateContent(), source.getVersion());
        newResource.setDateLastModified(dateLastModified);
        newResource = this.createResource(dbc, destination, newResource, content, properties, false);
        Iterator itRelations = this.getRelationsForResource(dbc, source, CmsRelationFilter.TARGETS.filterNotDefinedInContent()).iterator();
        while (itRelations.hasNext()) {
            CmsRelation relation = (CmsRelation)itRelations.next();
            CmsResource target = null;
            try {
                target = this.readResource(dbc, relation.getTargetId(), CmsResourceFilter.ALL);
            }
            catch (CmsVfsResourceNotFoundException e) {
                try {
                    target = this.readResource(dbc, relation.getTargetPath(), CmsResourceFilter.ALL);
                }
                catch (CmsVfsResourceNotFoundException e1) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)e1.getLocalizedMessage(), (Throwable)e1);
                    continue;
                }
            }
            this.addRelationToResource(dbc, newResource, target, relation.getType(), true);
        }
        this.copyAccessControlEntries(dbc, source, newResource, false);
        OpenCms.getMemoryMonitor().clearAccessControlListCache();
        ArrayList<CmsResource> modifiedResources = new ArrayList<CmsResource>();
        modifiedResources.add(source);
        modifiedResources.add(newResource);
        modifiedResources.add(destinationFolder);
        OpenCms.fireCmsEvent(new CmsEvent(24, Collections.singletonMap("resources", modifiedResources)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyResourceToProject(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (this.isInsideCurrentProject(dbc, resource.getRootPath())) return;
        if (resource.isFolder()) {
            List projectResources = this.m_projectDriver.readProjectResources(dbc, dbc.currentProject());
            for (int i = 0; i < projectResources.size(); ++i) {
                String resname = (String)projectResources.get(i);
                if (!resname.startsWith(resource.getRootPath())) continue;
                this.m_projectDriver.deleteProjectResource(dbc, dbc.currentProject().getUuid(), resname);
            }
        }
        try {
            try {
                this.m_projectDriver.createProjectResource(dbc, dbc.currentProject().getUuid(), resource.getRootPath());
            }
            catch (CmsException cmsException) {
                Object var7_8 = null;
                OpenCms.getMemoryMonitor().flushProjectResources();
                OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
                return;
            }
            Object var7_7 = null;
            OpenCms.getMemoryMonitor().flushProjectResources();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            OpenCms.getMemoryMonitor().flushProjectResources();
            OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
            throw throwable;
        }
        OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
    }

    public int countLockedResources(CmsProject project) {
        return this.m_lockManager.countExclusiveLocksInProject(project);
    }

    public CmsGroup createGroup(CmsDbContext dbc, CmsUUID id, String name, String description, int flags, String parent) throws CmsIllegalArgumentException, CmsException {
        CmsGroup parentGroup;
        OpenCms.getValidationHandler().checkGroupName(CmsOrganizationalUnit.getSimpleName(name));
        name = name.trim();
        this.readOrganizationalUnit(dbc, CmsOrganizationalUnit.getParentFqn(name));
        if (CmsStringUtil.isNotEmpty(parent) && !(parentGroup = this.readGroup(dbc, parent)).isRole() && !CmsOrganizationalUnit.getParentFqn(parent).equals(CmsOrganizationalUnit.getParentFqn(name))) {
            throw new CmsDataAccessException(org.opencms.db.Messages.get().container("ERR_PARENT_GROUP_MUST_BE_IN_SAME_OU_3", CmsOrganizationalUnit.getSimpleName(name), CmsOrganizationalUnit.getParentFqn(name), parent));
        }
        CmsGroup group = this.m_userDriver.createGroup(dbc, id, name, description, flags, parent);
        if (group.isVirtual()) {
            String groupname = CmsRole.valueOf(group).getGroupName();
            Iterator it = this.getUsersOfGroup(dbc, groupname, true, false, true).iterator();
            while (it.hasNext()) {
                CmsUser user = (CmsUser)it.next();
                this.addUserToGroup(dbc, user.getName(), group.getName(), true);
            }
        }
        OpenCms.getMemoryMonitor().cacheGroup(group);
        return group;
    }

    public CmsOrganizationalUnit createOrganizationalUnit(CmsDbContext dbc, String ouFqn, String description, int flags, CmsResource resource) throws CmsException {
        CmsOrganizationalUnit parent = this.readOrganizationalUnit(dbc, CmsOrganizationalUnit.getParentFqn(ouFqn));
        String name = CmsOrganizationalUnit.getSimpleName(ouFqn);
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        CmsResource.checkResourceName(name);
        name = name.trim();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(description)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_BAD_OU_DESCRIPTION_EMPTY_0"));
        }
        CmsOrganizationalUnit orgUnit = this.m_userDriver.createOrganizationalUnit(dbc, name, description, flags, parent, resource != null ? resource.getRootPath() : null);
        OpenCms.getMemoryMonitor().cacheOrgUnit(orgUnit);
        OpenCms.getMemoryMonitor().clearPrincipalsCache();
        OpenCms.getMemoryMonitor().flushProperties();
        OpenCms.getMemoryMonitor().flushPropertyLists();
        CmsResource ouRes = this.readResource(dbc, orgUnit.getId(), CmsResourceFilter.DEFAULT);
        CmsPublishList pl = new CmsPublishList(ouRes, false);
        pl.add(ouRes, false);
        this.getProjectDriver().writePublishHistory(dbc, pl.getPublishHistoryId(), new CmsPublishedResource(ouRes, -1, CmsResourceState.STATE_NEW));
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("publishHistoryId", pl.getPublishHistoryId().toString());
        eventData.put("projectId", dbc.currentProject().getUuid());
        eventData.put("dbContext", dbc);
        CmsEvent afterPublishEvent = new CmsEvent(2, eventData);
        OpenCms.fireCmsEvent(afterPublishEvent);
        return orgUnit;
    }

    public CmsProject createProject(CmsDbContext dbc, String name, String description, String groupname, String managergroupname, CmsProject.CmsProjectType projecttype) throws CmsIllegalArgumentException, CmsException {
        if ("Online".equals(name)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_CREATE_PROJECT_ONLINE_PROJECT_NAME_1", "Online"));
        }
        CmsProject.checkProjectName(CmsOrganizationalUnit.getSimpleName(name));
        this.readOrganizationalUnit(dbc, CmsOrganizationalUnit.getParentFqn(name));
        CmsGroup group = this.readGroup(dbc, groupname);
        CmsGroup managergroup = this.readGroup(dbc, managergroupname);
        return this.m_projectDriver.createProject(dbc, new CmsUUID(), dbc.currentUser(), group, managergroup, name, description, 0, projecttype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPropertyDefinition createPropertyDefinition(CmsDbContext dbc, String name) throws CmsException {
        CmsPropertyDefinition propertyDefinition = null;
        name = name.trim();
        CmsPropertyDefinition.checkPropertyName(name);
        try {
            try {
                propertyDefinition = this.m_vfsDriver.readPropertyDefinition(dbc, name, dbc.currentProject().getUuid());
            }
            catch (CmsException e) {
                propertyDefinition = this.m_vfsDriver.createPropertyDefinition(dbc, dbc.currentProject().getUuid(), name, CmsPropertyDefinition.TYPE_NORMAL);
            }
            try {
                this.m_vfsDriver.readPropertyDefinition(dbc, name, CmsProject.ONLINE_PROJECT_ID);
            }
            catch (CmsException e) {
                this.m_vfsDriver.createPropertyDefinition(dbc, CmsProject.ONLINE_PROJECT_ID, name, CmsPropertyDefinition.TYPE_NORMAL);
            }
            try {
                this.m_historyDriver.readPropertyDefinition(dbc, name);
            }
            catch (CmsException e) {
                this.m_historyDriver.createPropertyDefinition(dbc, name, CmsPropertyDefinition.TYPE_NORMAL);
            }
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(28, Collections.singletonMap("propertyDefinition", propertyDefinition)));
        }
        return propertyDefinition;
    }

    public void createPublishJob(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsException {
        this.m_projectDriver.createPublishJob(dbc, publishJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized CmsResource createResource(CmsDbContext dbc, String resourcePath, CmsResource resource, byte[] content, List properties, boolean importCase) throws CmsException {
        CmsResource newResource = null;
        if (resource.isFolder()) {
            resourcePath = CmsFileUtil.addTrailingSeparator(resourcePath);
        }
        try {
            block43: {
                int contentLength;
                String parentFolderName = CmsResource.getParentFolder(resourcePath);
                CmsFolder parentFolder = this.readFolder(dbc, parentFolderName, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsLock parentLock = this.getLock(dbc, parentFolder);
                if (!(parentLock.isUnlocked() || parentLock.isOwnedBy(dbc.currentUser()) || CmsResource.getName(resourcePath).startsWith(TEMP_FILE_PREFIX) && this.m_securityManager.hasRole(dbc, dbc.currentUser(), CmsRole.ROOT_ADMIN))) {
                    throw new CmsLockException(org.opencms.db.Messages.get().container("ERR_CREATE_RESOURCE_PARENT_LOCK_1", dbc.removeSiteRoot(resourcePath)));
                }
                if (resource.getTypeId() == CmsResourceTypeJsp.getStaticTypeId()) {
                    this.m_securityManager.checkRoleForResource(dbc, CmsRole.DEVELOPER, (CmsResource)parentFolder);
                }
                boolean useLostAndFound = importCase && !OpenCms.getImportExportManager().overwriteCollidingResources();
                CmsResource currentResourceByName = null;
                try {
                    currentResourceByName = this.readResource(dbc, resourcePath, CmsResourceFilter.ALL);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
                try {
                    CmsResource currentResourceById = this.readResource(dbc, resource.getStructureId(), CmsResourceFilter.ALL);
                    if (!currentResourceById.getRootPath().equals(resourcePath)) {
                        throw new CmsVfsResourceAlreadyExistsException(org.opencms.db.Messages.get().container("ERR_RESOURCE_WITH_ID_ALREADY_EXISTS_3", dbc.removeSiteRoot(resourcePath), dbc.removeSiteRoot(currentResourceById.getRootPath()), currentResourceById.getStructureId()));
                    }
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
                if (currentResourceByName == null) {
                    this.m_securityManager.checkPermissions(dbc, (CmsResource)parentFolder, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
                } else {
                    this.m_securityManager.checkPermissions(dbc, currentResourceByName, CmsPermissionSet.ACCESS_WRITE, !importCase, CmsResourceFilter.ALL);
                }
                if (currentResourceByName != null) {
                    boolean overwrite = true;
                    if (currentResourceByName.getState().isDeleted()) {
                        if (!currentResourceByName.isFolder()) {
                            overwrite = false;
                        }
                    } else {
                        if (!importCase) {
                            throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", dbc.removeSiteRoot(resource.getRootPath())));
                        }
                        if (!resource.isFolder() && useLostAndFound && !currentResourceByName.getResourceId().equals(resource.getResourceId())) {
                            this.moveToLostAndFound(dbc, currentResourceByName, false);
                        }
                    }
                    if (!overwrite) {
                        this.lockResource(dbc, currentResourceByName, CmsLockType.EXCLUSIVE);
                        currentResourceByName = null;
                    }
                }
                CmsResource overwrittenResource = currentResourceByName;
                String targetName = CmsResource.getName(resourcePath);
                if (resource.isFolder()) {
                    contentLength = -1;
                    if (CmsResource.isFolder(targetName)) {
                        targetName = targetName.substring(0, targetName.length() - 1);
                    }
                } else {
                    contentLength = content != null ? content.length : (overwrittenResource != null ? overwrittenResource.getLength() : resource.getLength());
                }
                CmsResource.checkResourceName(targetName);
                CmsUUID structureId = resource.getStructureId();
                CmsUUID resourceId = resource.getResourceId();
                if (overwrittenResource != null) {
                    structureId = overwrittenResource.getStructureId();
                }
                if (structureId.isNullUUID()) {
                    structureId = new CmsUUID();
                }
                if (overwrittenResource != null) {
                    resourceId = overwrittenResource.getResourceId();
                }
                if (resourceId.isNullUUID()) {
                    resourceId = new CmsUUID();
                }
                try {
                    CmsResource onlineResource = this.m_vfsDriver.readResource(dbc, CmsProject.ONLINE_PROJECT_ID, resourcePath, true);
                    try {
                        CmsResource offlineResource = this.m_vfsDriver.readResource(dbc, dbc.currentProject().getUuid(), onlineResource.getStructureId(), true);
                        if (!offlineResource.getRootPath().equals(onlineResource.getRootPath())) {
                            throw new CmsVfsOnlineResourceAlreadyExistsException(org.opencms.db.Messages.get().container("ERR_ONLINE_RESOURCE_EXISTS_2", dbc.removeSiteRoot(resourcePath), dbc.removeSiteRoot(offlineResource.getRootPath())));
                        }
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
                newResource = new CmsResource(structureId, resourceId, resourcePath, resource.getTypeId(), resource.isFolder(), resource.getFlags(), dbc.currentProject().getUuid(), resource.getState(), resource.getDateCreated(), resource.getUserCreated(), resource.getDateLastModified(), resource.getUserLastModified(), resource.getDateReleased(), resource.getDateExpired(), 1, contentLength, resource.getDateContent(), resource.getVersion());
                if (resource.isTouched()) {
                    newResource.setDateLastModified(resource.getDateLastModified());
                }
                if (resource.isFile()) {
                    if (this.labelResource(dbc, resource, resourcePath, 2)) {
                        int flags = resource.getFlags();
                        resource.setFlags(flags |= 2);
                    }
                    if (content == null) {
                        newResource.setState(CmsResource.STATE_KEEP);
                    }
                }
                this.m_vfsDriver.deleteRelations(dbc, dbc.currentProject().getUuid(), newResource, CmsRelationFilter.TARGETS);
                if (overwrittenResource == null) {
                    CmsLock lock = this.getLock(dbc, newResource);
                    if (lock.getEditionLock().isExclusive()) {
                        this.unlockResource(dbc, newResource, true, false);
                    }
                    newResource = this.m_vfsDriver.createResource(dbc, dbc.currentProject().getUuid(), newResource, content);
                } else {
                    int updateStates = overwrittenResource.getState().isNew() ? 0 : 3;
                    this.m_vfsDriver.writeResource(dbc, dbc.currentProject().getUuid(), newResource, updateStates);
                    if (content != null && resource.isFile()) {
                        this.m_vfsDriver.writeContent(dbc, newResource.getResourceId(), content);
                    }
                }
                this.writePropertyObjects(dbc, newResource, properties, false);
                try {
                    this.lockResource(dbc, newResource, CmsLockType.EXCLUSIVE);
                }
                catch (CmsLockException cle) {
                    if (!LOG.isDebugEnabled()) break block43;
                    LOG.debug((Object)org.opencms.db.Messages.get().getBundle().key("ERR_CREATE_RESOURCE_LOCK_1", new Object[]{dbc.removeSiteRoot(newResource.getRootPath())}));
                }
            }
            Object var21_30 = null;
            OpenCms.getMemoryMonitor().clearAccessControlListCache();
            OpenCms.getMemoryMonitor().flushProperties();
            OpenCms.getMemoryMonitor().flushPropertyLists();
            if (newResource == null) return newResource;
        }
        catch (Throwable throwable) {
            Object var21_31 = null;
            OpenCms.getMemoryMonitor().clearAccessControlListCache();
            OpenCms.getMemoryMonitor().flushProperties();
            OpenCms.getMemoryMonitor().flushPropertyLists();
            if (newResource == null) throw throwable;
            OpenCms.fireCmsEvent(new CmsEvent(23, Collections.singletonMap("resource", newResource)));
            throw throwable;
        }
        OpenCms.fireCmsEvent(new CmsEvent(23, Collections.singletonMap("resource", newResource)));
        return newResource;
    }

    public CmsResource createResource(CmsDbContext dbc, String resourcename, int type, byte[] content, List properties) throws CmsException, CmsIllegalArgumentException {
        int size;
        String targetName = resourcename;
        if (content == null) {
            content = new byte[]{};
        }
        if (CmsFolder.isFolderType(type)) {
            if (CmsResource.isFolder(targetName)) {
                targetName = targetName.substring(0, targetName.length() - 1);
            }
            size = -1;
        } else {
            size = content.length;
        }
        CmsResource newResource = new CmsResource(CmsUUID.getNullUUID(), CmsUUID.getNullUUID(), targetName, type, CmsFolder.isFolderType(type), 0, dbc.currentProject().getUuid(), CmsResource.STATE_NEW, 0L, dbc.currentUser().getId(), 0L, dbc.currentUser().getId(), 0L, Long.MAX_VALUE, 1, size, 0L, 0);
        return this.createResource(dbc, targetName, newResource, content, properties, false);
    }

    public CmsResource createSibling(CmsDbContext dbc, CmsResource source, String destination, List properties) throws CmsException {
        if (source.isFolder()) {
            throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_VFS_FOLDERS_DONT_SUPPORT_SIBLINGS_0"));
        }
        String destinationFoldername = CmsResource.getParentFolder(destination);
        CmsFolder destinationFolder = this.readFolder(dbc, destinationFoldername, CmsResourceFilter.IGNORE_EXPIRATION);
        int flags = source.getFlags();
        if (this.labelResource(dbc, source, destination, 1)) {
            flags |= 2;
        }
        CmsResource newResource = new CmsResource(new CmsUUID(), source.getResourceId(), destination, source.getTypeId(), source.isFolder(), flags, dbc.currentProject().getUuid(), CmsResource.STATE_KEEP, source.getDateCreated(), source.getUserCreated(), source.getDateLastModified(), source.getUserLastModified(), source.getDateReleased(), source.getDateExpired(), source.getSiblingCount() + 1, source.getLength(), source.getDateContent(), source.getVersion());
        newResource.setDateLastModified(newResource.getDateLastModified());
        newResource = this.createResource(dbc, destination, newResource, null, properties, false);
        OpenCms.getMemoryMonitor().clearAccessControlListCache();
        ArrayList<CmsResource> modifiedResources = new ArrayList<CmsResource>();
        modifiedResources.add(source);
        modifiedResources.add(newResource);
        modifiedResources.add(destinationFolder);
        OpenCms.fireCmsEvent(new CmsEvent(27, Collections.singletonMap("resources", modifiedResources)));
        return newResource;
    }

    public CmsProject createTempfileProject(CmsDbContext dbc) throws CmsException {
        CmsGroup projectUserGroup = this.readGroup(dbc, dbc.currentProject().getGroupId());
        CmsGroup projectManagerGroup = this.readGroup(dbc, dbc.currentProject().getManagerGroupId());
        CmsProject tempProject = this.m_projectDriver.createProject(dbc, new CmsUUID(), dbc.currentUser(), projectUserGroup, projectManagerGroup, "tempFileProject", org.opencms.db.Messages.get().getBundle(dbc.getRequestContext().getLocale()).key("GUI_WORKPLACE_TEMPFILE_PROJECT_DESC_0"), 4, CmsProject.PROJECT_TYPE_NORMAL);
        this.m_projectDriver.createProjectResource(dbc, tempProject.getUuid(), "/");
        OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", tempProject)));
        return tempProject;
    }

    public CmsUser createUser(CmsDbContext dbc, String name, String password, String description, Map additionalInfos) throws CmsException, CmsIllegalArgumentException {
        name = name.trim();
        String userName = CmsOrganizationalUnit.getSimpleName(name);
        OpenCms.getValidationHandler().checkUserName(userName);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userName)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_BAD_USER_1", userName));
        }
        CmsOrganizationalUnit ou = this.readOrganizationalUnit(dbc, CmsOrganizationalUnit.getParentFqn(name));
        this.validatePassword(password);
        HashMap<String, String> info = new HashMap<String, String>();
        if (additionalInfos != null) {
            info.putAll(additionalInfos);
        }
        if (description != null) {
            info.put("USER_DESCRIPTION", description);
        }
        int flags = 0;
        if (ou.hasFlagWebuser()) {
            flags += 32768;
        }
        return this.m_userDriver.createUser(dbc, new CmsUUID(), name, OpenCms.getPasswordHandler().digest(password), " ", " ", " ", 0L, 0 + flags, 0L, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllProperties(CmsDbContext dbc, String resourcename) throws CmsException {
        CmsResource resource = null;
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        try {
            resource = this.readResource(dbc, resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
            this.m_securityManager.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
            if (resource.getSiblingCount() > 1) {
                this.m_vfsDriver.deletePropertyObjects(dbc, dbc.currentProject().getUuid(), resource, 2);
                resources.addAll(this.readSiblings(dbc, resource, CmsResourceFilter.ALL));
            } else {
                this.m_vfsDriver.deletePropertyObjects(dbc, dbc.currentProject().getUuid(), resource, 1);
                resources.add(resource);
            }
            Object var6_5 = null;
            OpenCms.getMemoryMonitor().flushProperties();
            OpenCms.getMemoryMonitor().flushPropertyLists();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            OpenCms.getMemoryMonitor().flushProperties();
            OpenCms.getMemoryMonitor().flushPropertyLists();
            OpenCms.fireCmsEvent(new CmsEvent(27, Collections.singletonMap("resources", resources)));
            throw throwable;
        }
        OpenCms.fireCmsEvent(new CmsEvent(27, Collections.singletonMap("resources", resources)));
    }

    public void deleteAllStaticExportPublishedResources(CmsDbContext dbc, int linkType) throws CmsException {
        this.m_projectDriver.deleteAllStaticExportPublishedResources(dbc, linkType);
    }

    public void deleteGroup(CmsDbContext dbc, CmsGroup group, CmsUUID replacementId) throws CmsDataAccessException, CmsException {
        CmsGroup replacementGroup = null;
        if (replacementId != null) {
            replacementGroup = this.readGroup(dbc, replacementId);
        }
        List children = this.getChildren(dbc, group, false);
        List users = this.getUsersOfGroup(dbc, group.getName(), true, false, group.isRole());
        CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
        if (replacementGroup == null) {
            Iterator itUsers = users.iterator();
            while (itUsers.hasNext()) {
                CmsUser user = (CmsUser)itUsers.next();
                if (!this.userInGroup(dbc, user.getName(), group.getName(), group.isRole())) continue;
                this.removeUserFromGroup(dbc, user.getName(), group.getName(), group.isRole());
            }
            CmsUUID parentId = group.getParentId();
            if (parentId == null) {
                parentId = CmsUUID.getNullUUID();
            }
            Iterator itChildren = children.iterator();
            while (itChildren.hasNext()) {
                CmsGroup child = (CmsGroup)itChildren.next();
                child.setParentId(parentId);
                this.writeGroup(dbc, child);
            }
        } else {
            Iterator itChildren = children.iterator();
            while (itChildren.hasNext()) {
                CmsGroup child = (CmsGroup)itChildren.next();
                child.setParentId(replacementId);
                this.writeGroup(dbc, child);
            }
            Iterator itUsers = users.iterator();
            while (itUsers.hasNext()) {
                CmsUser user = (CmsUser)itUsers.next();
                this.addUserToGroup(dbc, user.getName(), replacementGroup.getName(), group.isRole());
                this.removeUserFromGroup(dbc, user.getName(), group.getName(), group.isRole());
            }
            this.transferPrincipalResources(dbc, dbc.currentProject(), group.getId(), replacementId, true);
            this.transferPrincipalResources(dbc, onlineProject, group.getId(), replacementId, true);
        }
        this.m_userDriver.removeAccessControlEntriesForPrincipal(dbc, dbc.currentProject(), onlineProject, group.getId());
        this.m_userDriver.deleteGroup(dbc, group.getName());
        this.m_historyDriver.writePrincipal(dbc, group);
        OpenCms.getMemoryMonitor().uncacheGroup(group);
        OpenCms.getMemoryMonitor().flushUserGroups();
        OpenCms.getMemoryMonitor().flushACLs();
    }

    public void deleteHistoricalVersions(CmsDbContext dbc, CmsFolder folder, int versionsToKeep, int versionsDeleted, long timeDeleted, I_CmsReport report) throws CmsException {
        I_CmsHistoryResource histResource;
        Iterator itResources;
        int m;
        int n;
        List resources;
        report.println(org.opencms.db.Messages.get().container("RPT_START_DELETE_VERSIONS_0"), 2);
        if (versionsToKeep >= 0) {
            report.println(org.opencms.db.Messages.get().container("RPT_START_DELETE_ACT_VERSIONS_1", new Integer(versionsToKeep)), 2);
            resources = this.m_historyDriver.getAllNotDeletedEntries(dbc, folder.getStructureId());
            if (resources.isEmpty()) {
                report.println(org.opencms.db.Messages.get().container("RPT_DELETE_NOTHING_0"), 4);
            }
            n = resources.size();
            m = 1;
            itResources = resources.iterator();
            while (itResources.hasNext()) {
                block12: {
                    histResource = (I_CmsHistoryResource)itResources.next();
                    report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
                    report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(histResource.getRootPath())));
                    report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    try {
                        int deleted = this.m_historyDriver.deleteEntries(dbc, histResource, versionsToKeep, -1L);
                        report.print(org.opencms.db.Messages.get().container("RPT_VERSION_DELETING_1", new Integer(deleted)), 3);
                        report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                        report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    }
                    catch (CmsDataAccessException e) {
                        report.println(org.opencms.report.Messages.get().container("RPT_ERROR_0"), 5);
                        if (!LOG.isDebugEnabled()) break block12;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                ++m;
            }
            report.println(org.opencms.db.Messages.get().container("RPT_END_DELETE_ACT_VERSIONS_0"), 2);
        }
        if (versionsDeleted >= 0 || timeDeleted >= 0L) {
            if (timeDeleted >= 0L) {
                report.println(org.opencms.db.Messages.get().container("RPT_START_DELETE_DEL_VERSIONS_2", new Integer(versionsDeleted), new Date(timeDeleted)), 2);
            } else {
                report.println(org.opencms.db.Messages.get().container("RPT_START_DELETE_DEL_VERSIONS_1", new Integer(versionsDeleted)), 2);
            }
            resources = this.m_historyDriver.getAllDeletedEntries(dbc, folder.getStructureId());
            if (resources.isEmpty()) {
                report.println(org.opencms.db.Messages.get().container("RPT_DELETE_NOTHING_0"), 4);
            }
            n = resources.size();
            m = 1;
            itResources = resources.iterator();
            while (itResources.hasNext()) {
                block13: {
                    histResource = (I_CmsHistoryResource)itResources.next();
                    report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
                    report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(histResource.getRootPath())));
                    report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    try {
                        int deleted = this.m_historyDriver.deleteEntries(dbc, histResource, versionsDeleted, timeDeleted);
                        report.print(org.opencms.db.Messages.get().container("RPT_VERSION_DELETING_1", new Integer(deleted)), 3);
                        report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                        report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    }
                    catch (CmsDataAccessException e) {
                        report.println(org.opencms.report.Messages.get().container("RPT_ERROR_0"), 5);
                        if (!LOG.isDebugEnabled()) break block13;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                ++m;
            }
            report.println(org.opencms.db.Messages.get().container("RPT_END_DELETE_DEL_VERSIONS_0"), 2);
        }
        report.println(org.opencms.db.Messages.get().container("RPT_END_DELETE_VERSIONS_0"), 2);
    }

    public void deleteOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit organizationalUnit) throws CmsException {
        CmsGroup group;
        if (dbc.getRequestContext().getOuFqn().equals(organizationalUnit.getName())) {
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_DELETE_IN_CONTEXT_1", organizationalUnit.getName()));
        }
        if (dbc.currentUser().getOuFqn().equals(organizationalUnit.getName())) {
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_DELETE_CURRENT_USER_1", organizationalUnit.getName()));
        }
        if (!this.getOrganizationalUnits(dbc, organizationalUnit, true).isEmpty()) {
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_DELETE_SUB_ORGUNITS_1", organizationalUnit.getName()));
        }
        List groups = this.getGroups(dbc, organizationalUnit, true, false);
        Iterator itGroups = groups.iterator();
        while (itGroups.hasNext()) {
            group = (CmsGroup)itGroups.next();
            if (OpenCms.getDefaultUsers().isDefaultGroup(group.getName())) continue;
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_DELETE_GROUPS_1", organizationalUnit.getName()));
        }
        if (!this.getUsers(dbc, organizationalUnit, true).isEmpty()) {
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_DELETE_USERS_1", organizationalUnit.getName()));
        }
        itGroups = groups.iterator();
        while (itGroups.hasNext()) {
            group = (CmsGroup)itGroups.next();
            this.deleteGroup(dbc, group, null);
        }
        Iterator itProjects = this.m_projectDriver.readProjects(dbc, organizationalUnit.getName()).iterator();
        while (itProjects.hasNext()) {
            CmsProject project = (CmsProject)itProjects.next();
            this.deleteProject(dbc, project);
        }
        Iterator itRoles = this.getGroups(dbc, organizationalUnit, true, true).iterator();
        while (itRoles.hasNext()) {
            CmsGroup role = (CmsGroup)itRoles.next();
            this.deleteGroup(dbc, role, null);
        }
        CmsResource resource = this.readResource(dbc, organizationalUnit.getId(), CmsResourceFilter.DEFAULT);
        CmsPublishList pl = new CmsPublishList(resource, false);
        pl.add(resource, false);
        this.m_userDriver.deleteOrganizationalUnit(dbc, organizationalUnit);
        this.m_projectDriver.writePublishHistory(dbc, pl.getPublishHistoryId(), new CmsPublishedResource(resource, -1, CmsResourceState.STATE_DELETED));
        OpenCms.getMemoryMonitor().clearPrincipalsCache();
        OpenCms.getMemoryMonitor().flushProperties();
        OpenCms.getMemoryMonitor().flushPropertyLists();
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("publishHistoryId", pl.getPublishHistoryId().toString());
        eventData.put("projectId", dbc.currentProject().getUuid());
        eventData.put("dbContext", dbc);
        CmsEvent afterPublishEvent = new CmsEvent(2, eventData);
        OpenCms.fireCmsEvent(afterPublishEvent);
        this.m_lockManager.removeDeletedResource(dbc, resource.getRootPath());
    }

    public void deleteProject(CmsDbContext dbc, CmsProject deleteProject) throws CmsException {
        CmsResource currentFolder;
        CmsLock lock;
        CmsResource currentFile;
        int i;
        CmsUUID projectId = deleteProject.getUuid();
        List modifiedFiles = this.readChangedResourcesInsideProject(dbc, projectId, RCPRM_FILES_ONLY_MODE);
        List modifiedFolders = this.readChangedResourcesInsideProject(dbc, projectId, RCPRM_FOLDERS_ONLY_MODE);
        for (i = 0; i < modifiedFiles.size(); ++i) {
            currentFile = (CmsResource)modifiedFiles.get(i);
            if (!currentFile.getState().isNew()) continue;
            lock = this.getLock(dbc, currentFile);
            if (lock.isNullLock()) {
                this.lockResource(dbc, currentFile, CmsLockType.EXCLUSIVE);
            } else if (!lock.isOwnedBy(dbc.currentUser()) || !lock.isInProject(dbc.currentProject())) {
                this.changeLock(dbc, currentFile, CmsLockType.EXCLUSIVE);
            }
            this.m_vfsDriver.deletePropertyObjects(dbc, projectId, currentFile, 1);
            this.m_vfsDriver.removeFile(dbc, dbc.currentProject().getUuid(), currentFile);
            this.m_userDriver.removeAccessControlEntries(dbc, dbc.currentProject(), currentFile.getResourceId());
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", currentFile)));
        }
        for (i = 0; i < modifiedFolders.size(); ++i) {
            currentFolder = (CmsResource)modifiedFolders.get(i);
            if (!currentFolder.getState().isNew()) continue;
            this.m_vfsDriver.deletePropertyObjects(dbc, projectId, currentFolder, 1);
            this.m_vfsDriver.removeFolder(dbc, dbc.currentProject(), currentFolder);
            this.m_userDriver.removeAccessControlEntries(dbc, dbc.currentProject(), currentFolder.getResourceId());
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", currentFolder)));
        }
        for (i = 0; i < modifiedFolders.size(); ++i) {
            currentFolder = (CmsResource)modifiedFolders.get(i);
            if (!currentFolder.getState().isChanged() && !currentFolder.getState().isDeleted()) continue;
            lock = this.getLock(dbc, currentFolder);
            if (lock.isNullLock()) {
                this.lockResource(dbc, currentFolder, CmsLockType.EXCLUSIVE);
            } else if (!lock.isOwnedBy(dbc.currentUser()) || !lock.isInProject(dbc.currentProject())) {
                this.changeLock(dbc, currentFolder, CmsLockType.EXCLUSIVE);
            }
            this.undoChanges(dbc, currentFolder, CmsResource.UNDO_CONTENT);
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", currentFolder)));
        }
        for (i = 0; i < modifiedFiles.size(); ++i) {
            currentFile = (CmsResource)modifiedFiles.get(i);
            if (!currentFile.getState().isChanged() && !currentFile.getState().isDeleted()) continue;
            lock = this.getLock(dbc, currentFile);
            if (lock.isNullLock()) {
                this.lockResource(dbc, currentFile, CmsLockType.EXCLUSIVE);
            } else if (!lock.isOwnedInProjectBy(dbc.currentUser(), dbc.currentProject()) && lock.isLockableBy(dbc.currentUser())) {
                this.changeLock(dbc, currentFile, CmsLockType.EXCLUSIVE);
            }
            this.undoChanges(dbc, currentFile, CmsResource.UNDO_CONTENT);
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", currentFile)));
        }
        this.m_lockManager.removeResourcesInProject(deleteProject.getUuid(), true);
        OpenCms.getMemoryMonitor().clearAccessControlListCache();
        OpenCms.getMemoryMonitor().clearResourceCache();
        if (projectId.equals(dbc.currentProject().getUuid())) {
            dbc.getRequestContext().setCurrentProject(this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID));
        }
        this.m_projectDriver.deleteProject(dbc, deleteProject);
        OpenCms.getMemoryMonitor().uncacheProject(deleteProject);
        OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", deleteProject)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePropertyDefinition(CmsDbContext dbc, String name) throws CmsException {
        CmsPropertyDefinition propertyDefinition = null;
        try {
            propertyDefinition = this.readPropertyDefinition(dbc, name);
            this.m_vfsDriver.deletePropertyDefinition(dbc, propertyDefinition);
            this.m_historyDriver.deletePropertyDefinition(dbc, propertyDefinition);
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(26, Collections.singletonMap("propertyDefinition", propertyDefinition)));
        }
    }

    public void deletePublishJob(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        this.m_projectDriver.deletePublishJob(dbc, publishHistoryId);
    }

    public void deletePublishList(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        this.m_projectDriver.deletePublishList(dbc, publishHistoryId);
    }

    public void deleteRelationsForResource(CmsDbContext dbc, CmsResource resource, CmsRelationFilter filter) throws CmsException {
        if (filter.includesDefinedInContent()) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_DELETE_RELATION_IN_CONTENT_2", dbc.removeSiteRoot(resource.getRootPath()), filter.getTypes()));
        }
        this.m_vfsDriver.deleteRelations(dbc, dbc.currentProject().getUuid(), resource, filter);
        this.setDateLastModified(dbc, resource, System.currentTimeMillis());
    }

    public void deleteResource(CmsDbContext dbc, CmsResource resource, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        CmsResource currentResource;
        int i;
        boolean allSiblingsRemoved;
        List<CmsResource> resources;
        CmsLock currentLock = this.getLock(dbc, resource);
        if (currentLock.getEditionLock().isDirectlyInherited()) {
            this.lockResource(dbc, resource, CmsLockType.EXCLUSIVE);
        }
        if (resource.isFolder()) {
            siblingMode = CmsResource.DELETE_PRESERVE_SIBLINGS;
        }
        if (siblingMode == CmsResource.DELETE_REMOVE_SIBLINGS) {
            resources = new ArrayList<CmsResource>(this.readSiblings(dbc, resource, CmsResourceFilter.ALL));
            allSiblingsRemoved = true;
            resources.remove(resource);
            resources.add(resource);
        } else {
            resources = Collections.singletonList(resource);
            allSiblingsRemoved = false;
        }
        int size = resources.size();
        if (size > 1) {
            CmsMultiException me = new CmsMultiException();
            for (i = 0; i < size; ++i) {
                currentResource = resources.get(i);
                currentLock = this.getLock(dbc, currentResource);
                if (currentLock.getEditionLock().isUnlocked() || currentLock.isOwnedBy(dbc.currentUser())) continue;
                CmsRequestContext context = dbc.getRequestContext();
                me.addException(new CmsLockException(org.opencms.lock.Messages.get().container("ERR_SIBLING_LOCKED_2", context.getSitePath(currentResource), context.getSitePath(resource))));
            }
            if (!me.getExceptions().isEmpty()) {
                throw me;
            }
        }
        boolean removeAce = true;
        if (resource.isFolder()) {
            Iterator childResources = this.m_vfsDriver.readChildResources(dbc, dbc.currentProject(), resource, true, true).iterator();
            CmsUUID projectId = CmsProject.ONLINE_PROJECT_ID;
            if (dbc.currentProject().isOnlineProject()) {
                projectId = CmsUUID.getOpenCmsUUID();
            }
            StringBuffer errorResNames = new StringBuffer(128);
            while (childResources.hasNext()) {
                boolean error;
                CmsResource errorRes = (CmsResource)childResources.next();
                if (errorRes.getState().isDeleted()) continue;
                boolean bl = error = !dbc.currentProject().isOnlineProject();
                if (!error) {
                    try {
                        String originalPath = this.m_vfsDriver.readResource(dbc, projectId, errorRes.getRootPath(), true).getRootPath();
                        error = originalPath.equals(errorRes.getRootPath()) || originalPath.startsWith(resource.getRootPath());
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        // empty catch block
                    }
                }
                if (!error) continue;
                if (errorResNames.length() != 0) {
                    errorResNames.append(", ");
                }
                errorResNames.append("[" + dbc.removeSiteRoot(errorRes.getRootPath()) + "]");
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(errorResNames.toString())) {
                throw new CmsVfsException(Messages.get().container("ERR_DELETE_NONEMTY_FOLDER_2", dbc.removeSiteRoot(resource.getRootPath()), errorResNames.toString()));
            }
        }
        for (i = 0; i < size; ++i) {
            currentResource = resources.get(i);
            if (!currentResource.equals(resource) && I_CmsPermissionHandler.PERM_ALLOWED != this.m_securityManager.hasPermissions(dbc, currentResource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL)) {
                allSiblingsRemoved = false;
                continue;
            }
            boolean existsOnline = this.m_vfsDriver.validateStructureIdExists(dbc, CmsProject.ONLINE_PROJECT_ID, currentResource.getStructureId());
            if (!existsOnline) {
                this.deleteAllProperties(dbc, currentResource.getRootPath());
                if (currentResource.isFolder()) {
                    this.m_vfsDriver.removeFolder(dbc, dbc.currentProject(), currentResource);
                } else {
                    if (currentResource.isLabeled() && !this.labelResource(dbc, currentResource, null, 2)) {
                        int flags = currentResource.getFlags();
                        currentResource.setFlags(flags &= 0xFFFFFFFD);
                    }
                    this.m_vfsDriver.removeFile(dbc, dbc.currentProject().getUuid(), currentResource);
                }
                this.m_lockManager.removeDeletedResource(dbc, currentResource.getRootPath());
                this.m_vfsDriver.deleteRelations(dbc, dbc.currentProject().getUuid(), currentResource, CmsRelationFilter.TARGETS);
                continue;
            }
            removeAce = false;
            currentResource.setState(CmsResource.STATE_DELETED);
            this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), currentResource, 5, false);
            this.m_vfsDriver.writeLastModifiedProjectId(dbc, dbc.currentProject(), dbc.currentProject().getUuid(), currentResource);
        }
        if ((resource.getSiblingCount() <= 1 || allSiblingsRemoved) && removeAce) {
            this.m_userDriver.removeAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId());
        }
        OpenCms.getMemoryMonitor().clearAccessControlListCache();
        OpenCms.getMemoryMonitor().flushProperties();
        OpenCms.getMemoryMonitor().flushPropertyLists();
        OpenCms.getMemoryMonitor().flushProjectResources();
        OpenCms.fireCmsEvent(new CmsEvent(25, Collections.singletonMap("resources", resources)));
    }

    public void deleteStaticExportPublishedResource(CmsDbContext dbc, String resourceName, int linkType, String linkParameter) throws CmsException {
        this.m_projectDriver.deleteStaticExportPublishedResource(dbc, resourceName, linkType, linkParameter);
    }

    public void deleteUser(CmsDbContext dbc, CmsProject project, String username, String replacementUsername) throws CmsException {
        CmsUser user = this.readUser(dbc, username);
        CmsUser replacementUser = null;
        if (replacementUsername != null) {
            replacementUser = this.readUser(dbc, replacementUsername);
        }
        CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
        boolean withACEs = true;
        if (replacementUser == null) {
            withACEs = false;
            replacementUser = this.readUser(dbc, OpenCms.getDefaultUsers().getUserDeletedResource());
        }
        boolean isVfsManager = this.m_securityManager.hasRole(dbc, replacementUser, CmsRole.VFS_MANAGER);
        boolean readRoles = false;
        for (int i = 0; i < 2; ++i) {
            Iterator itGroups = this.getGroupsOfUser(dbc, username, "", true, readRoles, true, dbc.getRequestContext().getRemoteAddress()).iterator();
            while (itGroups.hasNext()) {
                CmsGroup group = (CmsGroup)itGroups.next();
                if (!isVfsManager && !this.userInGroup(dbc, replacementUser.getName(), group.getName(), false)) {
                    this.addUserToGroup(dbc, replacementUser.getName(), group.getName(), false);
                }
                if (!this.userInGroup(dbc, username, group.getName(), readRoles)) continue;
                this.removeUserFromGroup(dbc, username, group.getName(), readRoles);
            }
            readRoles = !readRoles;
        }
        this.m_lockManager.removeLocks(user.getId());
        this.transferPrincipalResources(dbc, project, user.getId(), replacementUser.getId(), withACEs);
        this.transferPrincipalResources(dbc, onlineProject, user.getId(), replacementUser.getId(), withACEs);
        this.m_userDriver.removeAccessControlEntriesForPrincipal(dbc, project, onlineProject, user.getId());
        this.m_historyDriver.writePrincipal(dbc, user);
        this.m_userDriver.deleteUser(dbc, username);
        OpenCms.getMemoryMonitor().clearUserCache(user);
    }

    public void destroy() {
        try {
            if (this.m_projectDriver != null) {
                try {
                    this.m_projectDriver.destroy();
                }
                catch (Throwable t) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_CLOSE_PROJECT_DRIVER_0"), t);
                }
                this.m_projectDriver = null;
            }
            if (this.m_userDriver != null) {
                try {
                    this.m_userDriver.destroy();
                }
                catch (Throwable t) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_CLOSE_USER_DRIVER_0"), t);
                }
                this.m_userDriver = null;
            }
            if (this.m_vfsDriver != null) {
                try {
                    this.m_vfsDriver.destroy();
                }
                catch (Throwable t) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_CLOSE_VFS_DRIVER_0"), t);
                }
                this.m_vfsDriver = null;
            }
            if (this.m_historyDriver != null) {
                try {
                    this.m_historyDriver.destroy();
                }
                catch (Throwable t) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_CLOSE_HISTORY_DRIVER_0"), t);
                }
                this.m_historyDriver = null;
            }
            if (this.m_connectionPools != null) {
                for (int i = 0; i < this.m_connectionPools.size(); ++i) {
                    PoolingDriver driver = (PoolingDriver)this.m_connectionPools.get(i);
                    String[] pools = driver.getPoolNames();
                    for (int j = 0; j < pools.length; ++j) {
                        try {
                            driver.closePool(pools[j]);
                            if (!CmsLog.INIT.isDebugEnabled()) continue;
                            CmsLog.INIT.debug((Object)org.opencms.db.Messages.get().getBundle().key("INIT_CLOSE_CONN_POOL_1", pools[j]));
                            continue;
                        }
                        catch (Throwable t) {
                            LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_CLOSE_CONN_POOL_ERROR_1", pools[j]), t);
                        }
                    }
                }
                this.m_connectionPools = null;
            }
            OpenCms.getMemoryMonitor().clearCache();
            this.m_lockManager = null;
            this.m_htmlLinkValidator = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_DESTROY_1", this.getClass().getName()));
        }
    }

    public boolean existsResourceId(CmsDbContext dbc, CmsUUID resourceId) throws CmsException {
        return this.m_vfsDriver.validateResourceIdExists(dbc, dbc.currentProject().getUuid(), resourceId);
    }

    public void fillPublishList(CmsDbContext dbc, CmsPublishList publishList) throws CmsException {
        if (!publishList.isDirectPublish()) {
            List folderList = this.m_vfsDriver.readResourceTree(dbc, dbc.currentProject().getUuid(), READ_IGNORE_PARENT, -1, CmsResource.STATE_UNCHANGED, 0L, 0L, 0L, 0L, 0L, 0L, 74);
            publishList.addAll(this.filterResources(dbc, null, folderList), true);
            List fileList = this.m_vfsDriver.readResourceTree(dbc, dbc.currentProject().getUuid(), READ_IGNORE_PARENT, -1, CmsResource.STATE_UNCHANGED, 0L, 0L, 0L, 0L, 0L, 0L, 138);
            publishList.addAll(this.filterResources(dbc, publishList, fileList), true);
        } else {
            Iterator it = publishList.getDirectPublishResources().iterator();
            while (it.hasNext()) {
                CmsLock lock;
                CmsResource directPublishResource = (CmsResource)it.next();
                if (directPublishResource.isFolder()) {
                    lock = this.getLock(dbc, directPublishResource);
                    if (!directPublishResource.getState().isUnchanged() && lock.isLockableBy(dbc.currentUser())) {
                        try {
                            this.m_securityManager.checkPermissions(dbc, directPublishResource, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL);
                            publishList.add(directPublishResource, true);
                        }
                        catch (CmsException e) {
                            // empty catch block
                        }
                    }
                    if (!publishList.isPublishSubResources()) continue;
                    int flags = 8;
                    if (!directPublishResource.getState().isDeleted()) {
                        flags |= 2;
                    }
                    List folderList = this.m_vfsDriver.readResourceTree(dbc, dbc.currentProject().getUuid(), directPublishResource.getRootPath(), -1, CmsResource.STATE_UNCHANGED, 0L, 0L, 0L, 0L, 0L, 0L, flags | 0x40);
                    publishList.addAll(this.filterResources(dbc, publishList, folderList), true);
                    List fileList = this.m_vfsDriver.readResourceTree(dbc, dbc.currentProject().getUuid(), directPublishResource.getRootPath(), -1, CmsResource.STATE_UNCHANGED, 0L, 0L, 0L, 0L, 0L, 0L, flags | 0x80);
                    publishList.addAll(this.filterResources(dbc, publishList, fileList), true);
                    continue;
                }
                if (!directPublishResource.isFile() || directPublishResource.getState().isUnchanged() || !(lock = this.getLock(dbc, directPublishResource)).isLockableBy(dbc.currentUser())) continue;
                try {
                    this.m_securityManager.checkPermissions(dbc, directPublishResource, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL);
                    publishList.add(directPublishResource, true);
                }
                catch (CmsException e) {}
            }
        }
        if (publishList.isPublishSiblings()) {
            List publishFiles = publishList.getFileList();
            int size = publishFiles.size();
            HashSet siblingsClosure = new HashSet(publishFiles);
            for (int i = 0; i < size; ++i) {
                CmsResource currentFile = (CmsResource)publishFiles.get(i);
                if (currentFile.getSiblingCount() <= 1) continue;
                siblingsClosure.addAll(this.readSiblings(dbc, currentFile, CmsResourceFilter.ALL_MODIFIED));
            }
            publishList.addAll(this.filterSiblings(dbc, publishList, siblingsClosure), true);
        }
        publishList.initialize();
    }

    public List getAccessControlEntries(CmsDbContext dbc, CmsResource resource, boolean getInherited) throws CmsException {
        int d;
        List ace = this.m_userDriver.readAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId(), false);
        boolean overwriteAll = this.sortAceList(ace);
        String parentPath = CmsResource.getParentFolder(resource.getRootPath());
        int n = d = resource.isFolder() ? 1 : 0;
        while (!overwriteAll && getInherited && parentPath != null) {
            resource = this.m_vfsDriver.readFolder(dbc, dbc.currentProject().getUuid(), parentPath);
            List entries = this.m_userDriver.readAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId(), d > 0);
            overwriteAll = this.sortAceList(entries);
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                CmsAccessControlEntry e = (CmsAccessControlEntry)i.next();
                e.setFlags(8);
            }
            ace.addAll(entries);
            parentPath = CmsResource.getParentFolder(resource.getRootPath());
            ++d;
        }
        return ace;
    }

    public CmsAccessControlList getAccessControlList(CmsDbContext dbc, CmsResource resource) throws CmsException {
        return this.getAccessControlList(dbc, resource, false);
    }

    public CmsAccessControlList getAccessControlList(CmsDbContext dbc, CmsResource resource, boolean inheritedOnly) throws CmsException {
        return this.getAccessControlList(dbc, resource, inheritedOnly, resource.isFolder(), 0);
    }

    public int getActiveConnections(String dbPoolUrl) throws CmsDbException {
        try {
            Iterator i = this.m_connectionPools.iterator();
            if (i.hasNext()) {
                PoolingDriver d = (PoolingDriver)i.next();
                ObjectPool p = d.getConnectionPool(dbPoolUrl);
                return p.getNumActive();
            }
        }
        catch (Exception exc) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_ACCESSING_POOL_1", dbPoolUrl);
            throw new CmsDbException(message, (Throwable)exc);
        }
        CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_UNKNOWN_POOL_URL_1", dbPoolUrl);
        throw new CmsDbException(message);
    }

    public List getAllAccessibleProjects(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean includeSubOus) throws CmsException {
        HashSet projects = new HashSet();
        List ous = this.getOrgUnitsForRole(dbc, CmsRole.PROJECT_MANAGER.forOrgUnit(orgUnit.getName()), includeSubOus);
        HashSet<CmsUUID> userGroupIds = new HashSet<CmsUUID>();
        Iterator itGroups = this.getGroupsOfUser(dbc, dbc.currentUser().getName(), false).iterator();
        while (itGroups.hasNext()) {
            CmsGroup group = (CmsGroup)itGroups.next();
            userGroupIds.add(group.getId());
        }
        projects.addAll(this.m_projectDriver.readProjects(dbc, orgUnit.getName()));
        Iterator itProjects = projects.iterator();
        while (itProjects.hasNext()) {
            CmsProject project = (CmsProject)itProjects.next();
            boolean accessible = true;
            boolean bl = accessible = accessible && !project.isHidden();
            if (!includeSubOus) {
                accessible = accessible && project.getOuFqn().equals(orgUnit.getName());
            } else {
                boolean bl2 = accessible = accessible && project.getOuFqn().startsWith(orgUnit.getName());
            }
            if (!accessible) {
                itProjects.remove();
                continue;
            }
            accessible = false;
            accessible = accessible || project.isOnlineProject();
            accessible = accessible || project.getOwnerId().equals(dbc.currentUser().getId());
            Iterator itOus = ous.iterator();
            while (!accessible && itOus.hasNext()) {
                CmsOrganizationalUnit ou = (CmsOrganizationalUnit)itOus.next();
                accessible = accessible || project.getOuFqn().startsWith(ou.getName());
            }
            if (!accessible) {
                CmsUUID groupId = null;
                if (userGroupIds.contains(project.getGroupId())) {
                    groupId = project.getGroupId();
                } else if (userGroupIds.contains(project.getManagerGroupId())) {
                    groupId = project.getManagerGroupId();
                }
                if (groupId != null) {
                    String oufqn = this.readGroup(dbc, groupId).getOuFqn();
                    boolean bl3 = accessible = accessible || oufqn.startsWith(dbc.getRequestContext().getOuFqn());
                }
            }
            if (accessible) continue;
            itProjects.remove();
        }
        ArrayList<CmsProject> accessibleProjects = new ArrayList<CmsProject>(projects);
        Collections.sort(accessibleProjects);
        CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
        if (accessibleProjects.contains(onlineProject)) {
            accessibleProjects.remove(onlineProject);
            accessibleProjects.add(0, onlineProject);
        }
        return accessibleProjects;
    }

    public List getAllHistoricalProjects(CmsDbContext dbc) throws CmsException {
        HashSet manOus = new HashSet(this.getOrgUnitsForRole(dbc, CmsRole.PROJECT_MANAGER, true));
        List projects = this.m_historyDriver.readProjects(dbc);
        Iterator itProjects = projects.iterator();
        while (itProjects.hasNext()) {
            CmsHistoryProject project = (CmsHistoryProject)itProjects.next();
            if (project.isHidden()) {
                itProjects.remove();
                continue;
            }
            if (!project.getOuFqn().startsWith(dbc.currentUser().getOuFqn())) {
                itProjects.remove();
                continue;
            }
            CmsOrganizationalUnit ou = this.readOrganizationalUnit(dbc, project.getOuFqn());
            if (manOus.contains(ou) || project.getOwnerId().equals(dbc.currentUser().getId())) continue;
            boolean found = false;
            Iterator itGroups = this.getGroupsOfUser(dbc, dbc.currentUser().getName(), false).iterator();
            while (itGroups.hasNext()) {
                CmsGroup group = (CmsGroup)itGroups.next();
                if (!project.getManagerGroupId().equals(group.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            itProjects.remove();
        }
        return projects;
    }

    public List getAllManageableProjects(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean includeSubOus) throws CmsException {
        HashSet projects = new HashSet();
        List ous = this.getOrgUnitsForRole(dbc, CmsRole.PROJECT_MANAGER.forOrgUnit(orgUnit.getName()), includeSubOus);
        HashSet<CmsUUID> userGroupIds = new HashSet<CmsUUID>();
        Iterator itGroups = this.getGroupsOfUser(dbc, dbc.currentUser().getName(), false).iterator();
        while (itGroups.hasNext()) {
            CmsGroup group = (CmsGroup)itGroups.next();
            userGroupIds.add(group.getId());
        }
        projects.addAll(this.m_projectDriver.readProjects(dbc, orgUnit.getName()));
        Iterator itProjects = projects.iterator();
        while (itProjects.hasNext()) {
            CmsProject project = (CmsProject)itProjects.next();
            boolean manageable = true;
            manageable = manageable && !project.isOnlineProject();
            boolean bl = manageable = manageable && !project.isHidden();
            if (!includeSubOus) {
                manageable = manageable && project.getOuFqn().equals(orgUnit.getName());
            } else {
                boolean bl2 = manageable = manageable && project.getOuFqn().startsWith(orgUnit.getName());
            }
            if (!manageable) {
                itProjects.remove();
                continue;
            }
            manageable = false;
            manageable = manageable || project.getOwnerId().equals(dbc.currentUser().getId());
            Iterator itOus = ous.iterator();
            while (!manageable && itOus.hasNext()) {
                CmsOrganizationalUnit ou = (CmsOrganizationalUnit)itOus.next();
                manageable = manageable || project.getOuFqn().startsWith(ou.getName());
            }
            if (!manageable && userGroupIds.contains(project.getManagerGroupId())) {
                String oufqn = this.readGroup(dbc, project.getManagerGroupId()).getOuFqn();
                boolean bl3 = manageable = manageable || oufqn.startsWith(dbc.getRequestContext().getOuFqn());
            }
            if (manageable) continue;
            itProjects.remove();
        }
        ArrayList manageableProjects = new ArrayList(projects);
        Collections.sort(manageableProjects);
        CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
        if (manageableProjects.contains(onlineProject)) {
            manageableProjects.remove(onlineProject);
        }
        return manageableProjects;
    }

    public List getChildren(CmsDbContext dbc, CmsGroup group, boolean includeSubChildren) throws CmsException {
        if (!includeSubChildren) {
            return this.m_userDriver.readChildGroups(dbc, group.getName());
        }
        TreeSet<CmsGroup> allChildren = new TreeSet<CmsGroup>();
        Iterator it = this.m_userDriver.readChildGroups(dbc, group.getName()).iterator();
        while (it.hasNext()) {
            CmsGroup child = (CmsGroup)it.next();
            allChildren.add(child);
            allChildren.addAll(this.getChildren(dbc, child, true));
        }
        return new ArrayList(allChildren);
    }

    public List getGroups(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean includeSubOus, boolean readRoles) throws CmsException {
        return this.m_userDriver.getGroups(dbc, orgUnit, includeSubOus, readRoles);
    }

    public List getGroupsOfUser(CmsDbContext dbc, String username, boolean readRoles) throws CmsException {
        return this.getGroupsOfUser(dbc, username, "", true, readRoles, false, dbc.getRequestContext().getRemoteAddress());
    }

    public List getGroupsOfUser(CmsDbContext dbc, String username, String ouFqn, boolean includeChildOus, boolean readRoles, boolean directGroupsOnly, String remoteAddress) throws CmsException {
        CmsUser user = this.readUser(dbc, username);
        String prefix = ouFqn + "_" + includeChildOus + "_" + directGroupsOnly + "_" + readRoles + "_" + remoteAddress;
        String cacheKey = this.m_keyGenerator.getCacheKeyForUserGroups(prefix, dbc, user);
        List groups = OpenCms.getMemoryMonitor().getCachedUserGroups(cacheKey);
        if (groups == null) {
            int i;
            List directGroups = this.m_userDriver.readGroupsOfUser(dbc, user.getId(), readRoles ? "" : ouFqn, readRoles ? true : includeChildOus, remoteAddress, readRoles);
            HashSet<CmsGroup> allGroups = new HashSet<CmsGroup>();
            if (!readRoles) {
                allGroups.addAll(directGroups);
            }
            if (!directGroupsOnly && !readRoles) {
                for (i = 0; i < directGroups.size(); ++i) {
                    CmsGroup parent = this.getParent(dbc, ((CmsGroup)directGroups.get(i)).getName());
                    while (parent != null && !allGroups.contains(parent)) {
                        if (parent.getOuFqn().startsWith(ouFqn)) {
                            allGroups.add(parent);
                        }
                        parent = this.getParent(dbc, parent.getName());
                    }
                }
            }
            if (readRoles) {
                for (i = 0; i < directGroups.size(); ++i) {
                    CmsGroup group = (CmsGroup)directGroups.get(i);
                    CmsRole role = CmsRole.valueOf(group);
                    if (!includeChildOus && role.getOuFqn().equals(ouFqn)) {
                        allGroups.add(group);
                    }
                    if (includeChildOus && role.getOuFqn().startsWith(ouFqn)) {
                        allGroups.add(group);
                    }
                    if (directGroupsOnly) continue;
                    Iterator itChildRoles = role.getChildren(true).iterator();
                    while (itChildRoles.hasNext()) {
                        CmsRole childRole = (CmsRole)itChildRoles.next();
                        if (!childRole.isSystemRole()) continue;
                        allGroups.add(this.readGroup(dbc, childRole.getGroupName()));
                    }
                    if (!includeChildOus) continue;
                    Iterator itSubOus = this.getOrganizationalUnits(dbc, this.readOrganizationalUnit(dbc, group.getOuFqn()), true).iterator();
                    while (itSubOus.hasNext()) {
                        CmsOrganizationalUnit subOu;
                        block18: {
                            subOu = (CmsOrganizationalUnit)itSubOus.next();
                            try {
                                allGroups.add(this.readGroup(dbc, role.forOrgUnit(subOu.getName()).getGroupName()));
                            }
                            catch (CmsDbEntryNotFoundException e) {
                                if (!LOG.isDebugEnabled()) break block18;
                                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                        itChildRoles = role.getChildren(true).iterator();
                        while (itChildRoles.hasNext()) {
                            CmsRole childRole = (CmsRole)itChildRoles.next();
                            try {
                                allGroups.add(this.readGroup(dbc, childRole.forOrgUnit(subOu.getName()).getGroupName()));
                            }
                            catch (CmsDbEntryNotFoundException e) {
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            }
            groups = Collections.unmodifiableList(new ArrayList(allGroups));
            if (dbc.getProjectId().isNullUUID()) {
                OpenCms.getMemoryMonitor().cacheUserGroups(cacheKey, groups);
            }
        }
        return groups;
    }

    public I_CmsHistoryDriver getHistoryDriver() {
        return this.m_historyDriver;
    }

    public int getIdleConnections(String dbPoolUrl) throws CmsDbException {
        try {
            Iterator i = this.m_connectionPools.iterator();
            if (i.hasNext()) {
                PoolingDriver d = (PoolingDriver)i.next();
                ObjectPool p = d.getConnectionPool(dbPoolUrl);
                return p.getNumIdle();
            }
        }
        catch (Exception exc) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_ACCESSING_POOL_1", dbPoolUrl);
            throw new CmsDbException(message, (Throwable)exc);
        }
        CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_UNKNOWN_POOL_URL_1", dbPoolUrl);
        throw new CmsDbException(message);
    }

    public CmsLock getLock(CmsDbContext dbc, CmsResource resource) throws CmsException {
        return this.m_lockManager.getLock(dbc, resource);
    }

    public List getLockedResources(CmsDbContext dbc, CmsResource resource, CmsLockFilter filter) throws CmsException {
        ArrayList<String> lockedResources = new ArrayList<String>();
        Iterator it = this.m_lockManager.getLocks(dbc, resource.getRootPath(), filter).iterator();
        while (it.hasNext()) {
            CmsLock lock = (CmsLock)it.next();
            lockedResources.add(dbc.removeSiteRoot(lock.getResourceName()));
        }
        Collections.sort(lockedResources);
        return lockedResources;
    }

    public int getNextPublishTag(CmsDbContext dbc) {
        return this.m_historyDriver.readNextPublishTag(dbc);
    }

    public List getOrganizationalUnits(CmsDbContext dbc, CmsOrganizationalUnit parent, boolean includeChildren) throws CmsException {
        if (parent == null) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_PARENT_ORGUNIT_NULL_0"));
        }
        return this.m_userDriver.getOrganizationalUnits(dbc, parent, includeChildren);
    }

    public List getOrgUnitsForRole(CmsDbContext dbc, CmsRole role, boolean includeSubOus) throws CmsException {
        String ouFqn = role.getOuFqn();
        if (ouFqn == null) {
            ouFqn = "";
            role = role.forOrgUnit("");
        }
        CmsOrganizationalUnit ou = this.readOrganizationalUnit(dbc, ouFqn);
        ArrayList<CmsOrganizationalUnit> orgUnits = new ArrayList<CmsOrganizationalUnit>();
        if (this.m_securityManager.hasRole(dbc, dbc.currentUser(), role)) {
            orgUnits.add(ou);
        }
        if (includeSubOus) {
            Iterator it = this.getOrganizationalUnits(dbc, ou, true).iterator();
            while (it.hasNext()) {
                CmsOrganizationalUnit orgUnit = (CmsOrganizationalUnit)it.next();
                if (!this.m_securityManager.hasRole(dbc, dbc.currentUser(), role.forOrgUnit(orgUnit.getName()))) continue;
                orgUnits.add(orgUnit);
            }
        }
        return orgUnits;
    }

    public CmsGroup getParent(CmsDbContext dbc, String groupname) throws CmsException {
        CmsGroup group = this.readGroup(dbc, groupname);
        if (group.getParentId().isNullUUID()) {
            return null;
        }
        CmsGroup parent = OpenCms.getMemoryMonitor().getCachedGroup(group.getParentId().toString());
        if (parent == null) {
            parent = this.m_userDriver.readGroup(dbc, group.getParentId());
            OpenCms.getMemoryMonitor().cacheGroup(parent);
        }
        return parent;
    }

    public CmsPermissionSetCustom getPermissions(CmsDbContext dbc, CmsResource resource, CmsUser user) throws CmsException {
        CmsAccessControlList acList = this.getAccessControlList(dbc, resource, false);
        return acList.getPermissions(user, this.getGroupsOfUser(dbc, user.getName(), false), this.getRolesForUser(dbc, user));
    }

    public I_CmsProjectDriver getProjectDriver() {
        return this.m_projectDriver;
    }

    public CmsUUID getProjectId(CmsDbContext dbc, int id) throws CmsException {
        Iterator itProjects = this.getAllAccessibleProjects(dbc, this.readOrganizationalUnit(dbc, ""), true).iterator();
        while (itProjects.hasNext()) {
            CmsProject project = (CmsProject)itProjects.next();
            if (project.getUuid().hashCode() != id) continue;
            return project.getUuid();
        }
        return null;
    }

    public ExtendedProperties getPropertyConfiguration() {
        return this.m_propertyConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPublishList getRelatedResourcesToPublish(CmsDbContext dbc, CmsPublishList publishList, CmsRelationFilter filter) throws CmsException {
        HashMap<String, CmsResource> relations = new HashMap<String, CmsResource>();
        CmsProgressThread thread = null;
        if (Thread.currentThread() instanceof CmsProgressThread) {
            thread = (CmsProgressThread)Thread.currentThread();
        }
        List publishResources = publishList.getAllResources();
        Iterator itCheckList = publishResources.iterator();
        int count = 0;
        while (itCheckList.hasNext()) {
            ++count;
            if (thread != null) {
                if (thread.isInterrupted()) {
                    throw new CmsIllegalStateException(org.opencms.workplace.commons.Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                }
                thread.setProgress(count * 20 / publishResources.size());
                thread.setDescription(org.opencms.workplace.commons.Messages.get().getBundle().key("GUI_PROGRESS_PUBLISH_STEP1_2", new Integer(count), new Integer(publishResources.size())));
            }
            CmsResource checkResource = (CmsResource)itCheckList.next();
            Iterator itRelations = this.getRelationsForResource(dbc, checkResource, filter).iterator();
            while (itRelations.hasNext()) {
                CmsRelation relation = (CmsRelation)itRelations.next();
                try {
                    CmsResource target;
                    try {
                        target = this.readResource(dbc, relation.getTargetId(), CmsResourceFilter.ALL);
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        String storedSiteRoot = dbc.getRequestContext().getSiteRoot();
                        try {
                            dbc.getRequestContext().setSiteRoot("");
                            target = this.readResource(dbc, relation.getTargetPath(), CmsResourceFilter.ALL);
                        }
                        finally {
                            dbc.getRequestContext().setSiteRoot(storedSiteRoot);
                        }
                    }
                    CmsLock lock = this.getLock(dbc, target);
                    if (publishResources.contains(target) || relations.containsKey(target.getRootPath()) || target.getState().isUnchanged() || !lock.isLockableBy(dbc.currentUser())) continue;
                    relations.put(target.getRootPath(), target);
                    CmsFolder parent = this.m_vfsDriver.readParentFolder(dbc, dbc.currentProject().getUuid(), target.getStructureId());
                    while (parent != null && parent.getState().isNew()) {
                        if (!publishResources.contains(parent) && !relations.containsKey(parent.getRootPath())) {
                            relations.put(parent.getRootPath(), parent);
                        }
                        parent = this.m_vfsDriver.readParentFolder(dbc, dbc.currentProject().getUuid(), parent.getStructureId());
                    }
                }
                catch (CmsVfsResourceNotFoundException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        CmsPublishList ret = new CmsPublishList(publishList.getDirectPublishResources(), false, false);
        ret.addAll(relations.values(), false);
        ret.initialize();
        return ret;
    }

    public List getRelationsForResource(CmsDbContext dbc, CmsResource resource, CmsRelationFilter filter) throws CmsException {
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        return this.m_vfsDriver.readRelations(dbc, projectId, resource, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getResourceOrgUnits(CmsDbContext dbc, CmsResource resource) throws CmsException {
        try {
            dbc.getRequestContext().setAttribute("RETRIEVE_RESOURCE_OUS", Boolean.TRUE);
            List list = this.m_vfsDriver.readRelations(dbc, dbc.currentProject().getUuid(), resource, CmsRelationFilter.TARGETS.filterIncludeChildren());
            return list;
        }
        finally {
            dbc.getRequestContext().removeAttribute("RETRIEVE_RESOURCE_OUS");
        }
    }

    public List getResourcesForOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit) throws CmsException {
        return this.m_userDriver.getResourcesForOrganizationalUnit(dbc, orgUnit);
    }

    public Set getResourcesForPrincipal(CmsDbContext dbc, CmsProject project, CmsUUID principalId, CmsPermissionSet permissions, boolean includeAttr) throws CmsException {
        HashSet resources = new HashSet(this.m_vfsDriver.readResourcesForPrincipalACE(dbc, project, principalId));
        if (permissions != null) {
            Iterator itRes = resources.iterator();
            while (itRes.hasNext()) {
                CmsAccessControlEntry ace = this.readAccessControlEntry(dbc, (CmsResource)itRes.next(), principalId);
                if ((ace.getPermissions().getPermissions() & permissions.getPermissions()) == permissions.getPermissions()) continue;
                itRes.remove();
            }
        }
        if (includeAttr) {
            resources.addAll(this.m_vfsDriver.readResourcesForPrincipalAttr(dbc, project, principalId));
        }
        return resources;
    }

    public List getRolesForResource(CmsDbContext dbc, CmsUser user, CmsResource resource) throws CmsException {
        if (user.isGuestUser()) {
            return Collections.EMPTY_LIST;
        }
        String key = user.getId().toString() + resource.getRootPath();
        List<CmsRole> result = OpenCms.getMemoryMonitor().getCachedRoleList(key);
        if (result != null) {
            return result;
        }
        result = new ArrayList();
        Iterator itOus = this.getResourceOrgUnits(dbc, resource).iterator();
        while (itOus.hasNext()) {
            CmsOrganizationalUnit ou = (CmsOrganizationalUnit)itOus.next();
            ArrayList roles = new ArrayList(this.getGroupsOfUser(dbc, user.getName(), ou.getName(), false, true, false, dbc.getRequestContext().getRemoteAddress()));
            Iterator it = roles.iterator();
            while (it.hasNext()) {
                CmsGroup group = (CmsGroup)it.next();
                CmsRole givenRole = CmsRole.valueOf(group).forOrgUnit(null);
                if (givenRole.isOrganizationalUnitIndependent() || result.contains(givenRole)) continue;
                result.add(givenRole);
            }
        }
        result = Collections.unmodifiableList(result);
        OpenCms.getMemoryMonitor().cacheRoleList(key, result);
        return result;
    }

    public List getRolesForUser(CmsDbContext dbc, CmsUser user) throws CmsException {
        if (user.isGuestUser()) {
            return Collections.EMPTY_LIST;
        }
        String key = user.getId().toString();
        List<CmsRole> result = OpenCms.getMemoryMonitor().getCachedRoleList(key);
        if (result != null) {
            return result;
        }
        result = new ArrayList();
        ArrayList roles = new ArrayList(this.getGroupsOfUser(dbc, user.getName(), "", true, true, false, dbc.getRequestContext().getRemoteAddress()));
        Iterator it = roles.iterator();
        while (it.hasNext()) {
            CmsGroup group = (CmsGroup)it.next();
            CmsRole givenRole = CmsRole.valueOf(group);
            if (result.contains(givenRole = givenRole.forOrgUnit(null))) continue;
            result.add(givenRole);
        }
        result = Collections.unmodifiableList(result);
        OpenCms.getMemoryMonitor().cacheRoleList(key, result);
        return result;
    }

    public CmsSecurityManager getSecurityManager() {
        return this.m_securityManager;
    }

    public CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    public I_CmsUserDriver getUserDriver() {
        return this.m_userDriver;
    }

    public List getUsers(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean recursive) throws CmsException {
        return this.m_userDriver.getUsers(dbc, orgUnit, recursive);
    }

    public List getUsersOfGroup(CmsDbContext dbc, String groupname, boolean includeOtherOuUsers, boolean directUsersOnly, boolean readRoles) throws CmsException {
        return this.internalUsersOfGroup(dbc, CmsOrganizationalUnit.getParentFqn(groupname), groupname, includeOtherOuUsers, directUsersOnly, readRoles);
    }

    public I_CmsVfsDriver getVfsDriver() {
        return this.m_vfsDriver;
    }

    public void importAccessControlEntries(CmsDbContext dbc, CmsResource resource, List acEntries) throws CmsException {
        this.m_userDriver.removeAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId());
        Iterator i = acEntries.iterator();
        while (i.hasNext()) {
            this.m_userDriver.writeAccessControlEntry(dbc, dbc.currentProject(), (CmsAccessControlEntry)i.next());
        }
        OpenCms.getMemoryMonitor().clearAccessControlListCache();
    }

    public CmsUser importUser(CmsDbContext dbc, String id, String name, String password, String firstname, String lastname, String email, int flags, long dateCreated, Map additionalInfos) throws CmsException {
        name = name.trim();
        String userName = CmsOrganizationalUnit.getSimpleName(name);
        OpenCms.getValidationHandler().checkUserName(userName);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userName)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_BAD_USER_1", userName));
        }
        CmsOrganizationalUnit ou = this.readOrganizationalUnit(dbc, CmsOrganizationalUnit.getParentFqn(name));
        this.validatePassword(password);
        if (ou.hasFlagWebuser() && (flags & 0x8000) == 0) {
            flags += 32768;
        }
        CmsUser newUser = this.m_userDriver.createUser(dbc, new CmsUUID(id), name, password, firstname, lastname, email, 0L, flags, dateCreated, additionalInfos);
        return newUser;
    }

    public void init(CmsConfigurationManager configurationManager) throws CmsException, Exception {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_PHASE4_0"));
        }
        CmsSystemConfiguration systemConfiguation = (CmsSystemConfiguration)configurationManager.getConfiguration(CmsSystemConfiguration.class);
        CmsCacheSettings settings = systemConfiguation.getCacheSettings();
        this.m_keyGenerator = (I_CmsCacheKey)Class.forName(settings.getCacheKeyGenerator()).newInstance();
        this.m_htmlLinkValidator = new CmsRelationSystemValidator(this);
        this.getUserDriver().fillDefaults(new CmsDbContext());
        this.getProjectDriver().fillDefaults(new CmsDbContext());
        this.m_publishEngine.setDriverManager(this);
        CmsDbContext dbc = new CmsDbContext(new CmsRequestContext(this.readUser(new CmsDbContext(), OpenCms.getDefaultUsers().getUserAdmin()), this.readProject(new CmsDbContext(), CmsProject.ONLINE_PROJECT_ID), null, "", null, null, null, 0L, null, null, ""));
        this.getUserDriver().createRootOrganizationalUnit(dbc);
    }

    public boolean isInsideCurrentProject(CmsDbContext dbc, String resourcename) {
        List projectResources = null;
        try {
            projectResources = this.readProjectResources(dbc, dbc.currentProject());
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_CHECK_RESOURCE_INSIDE_CURRENT_PROJECT_2", resourcename, dbc.currentProject().getName()), (Throwable)e);
            }
            return false;
        }
        return CmsProject.isInsideProject(projectResources, resourcename);
    }

    public boolean isTempfileProject(CmsProject project) {
        return project.getName().equals("tempFileProject");
    }

    public boolean labelResource(CmsDbContext dbc, CmsResource resource, String newResource, int action) throws CmsDataAccessException {
        List labeledSites = OpenCms.getWorkplaceManager().getLabelSiteFolders();
        if (labeledSites.size() == 0) {
            return false;
        }
        if (action == 1) {
            if (!resource.isLabeled()) {
                boolean linkInside = false;
                boolean sourceInside = false;
                for (int i = 0; i < labeledSites.size(); ++i) {
                    String curSite = (String)labeledSites.get(i);
                    if (newResource.startsWith(curSite)) {
                        linkInside = true;
                    }
                    if (resource.getRootPath().startsWith(curSite)) {
                        sourceInside = true;
                    }
                    if (linkInside && sourceInside) break;
                }
                return linkInside != sourceInside;
            }
            return false;
        }
        boolean isInside = false;
        boolean isOutside = false;
        List siblings = this.m_vfsDriver.readSiblings(dbc, dbc.currentProject().getUuid(), resource, false);
        this.updateContextDates(dbc, siblings);
        Iterator i = siblings.iterator();
        while (!(!i.hasNext() || isInside && isOutside)) {
            CmsResource currentResource = (CmsResource)i.next();
            if (currentResource.equals(resource)) continue;
            String curPath = currentResource.getRootPath();
            boolean curInside = false;
            for (int k = 0; k < labeledSites.size(); ++k) {
                if (!curPath.startsWith((String)labeledSites.get(k))) continue;
                isInside = true;
                curInside = true;
                break;
            }
            if (curInside) continue;
            isOutside = true;
        }
        if (newResource != null) {
            boolean curInside = false;
            for (int k = 0; k < labeledSites.size(); ++k) {
                if (!newResource.startsWith((String)labeledSites.get(k))) continue;
                isInside = true;
                curInside = true;
                break;
            }
            if (!curInside) {
                isOutside = true;
            }
        }
        return isInside && isOutside;
    }

    public CmsUser lockedBy(CmsDbContext dbc, CmsResource resource) throws CmsException {
        return this.readUser(dbc, this.m_lockManager.getLock(dbc, resource).getEditionLock().getUserId());
    }

    public void lockResource(CmsDbContext dbc, CmsResource resource, CmsLockType type) throws CmsException {
        OpenCms.getMemoryMonitor().clearResourceCache();
        CmsProject project = dbc.currentProject();
        this.m_lockManager.addResource(dbc, resource, dbc.currentUser(), project, type);
        if (!resource.getState().isUnchanged() && !resource.getState().isKeep()) {
            this.m_vfsDriver.writeLastModifiedProjectId(dbc, project, project.getUuid(), resource);
        }
        OpenCms.getMemoryMonitor().flushPermissions();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(0));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public CmsUser loginUser(CmsDbContext dbc, String userName, String password, String remoteAddress) throws CmsAuthentificationException, CmsDataAccessException, CmsPasswordEncryptionException {
        CmsUser newUser;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(password)) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_USER_1", userName));
        }
        try {
            newUser = this.m_userDriver.readUser(dbc, userName, password, remoteAddress);
        }
        catch (CmsDbEntryNotFoundException e) {
            String parentOu;
            boolean userExists = true;
            try {
                this.readUser(dbc, userName);
            }
            catch (CmsDataAccessException e2) {
                userExists = false;
            }
            if (userExists) {
                if (dbc.currentUser().isGuestUser()) {
                    OpenCms.getLoginManager().addInvalidLogin(userName, remoteAddress);
                }
                OpenCms.getLoginManager().checkInvalidLogins(userName, remoteAddress);
                throw new CmsAuthentificationException(org.opencms.security.Messages.get().container("ERR_LOGIN_FAILED_2", userName, remoteAddress), (Throwable)e);
            }
            String userOu = CmsOrganizationalUnit.getParentFqn(userName);
            if (userOu != null && (parentOu = CmsOrganizationalUnit.getParentFqn(userOu)) != null) {
                String uName = CmsOrganizationalUnit.getSimpleName(userName);
                return this.loginUser(dbc, parentOu + uName, password, remoteAddress);
            }
            throw new CmsAuthentificationException(org.opencms.security.Messages.get().container("ERR_LOGIN_FAILED_NO_USER_2", userName, remoteAddress), (Throwable)e);
        }
        if (!newUser.isEnabled()) {
            throw new CmsAuthentificationException(org.opencms.security.Messages.get().container("ERR_LOGIN_FAILED_DISABLED_2", userName, remoteAddress));
        }
        if (dbc.currentUser().isGuestUser()) {
            OpenCms.getLoginManager().checkInvalidLogins(userName, remoteAddress);
            OpenCms.getLoginManager().removeInvalidLogins(userName, remoteAddress);
        }
        if (!this.m_securityManager.hasRole(dbc, newUser, CmsRole.ADMINISTRATOR.forOrgUnit(dbc.getRequestContext().getOuFqn()))) {
            OpenCms.getLoginManager().checkLoginAllowed();
        }
        newUser.setLastlogin(System.currentTimeMillis());
        this.m_userDriver.writeUser(dbc, newUser);
        OpenCms.getMemoryMonitor().cacheUser(newUser);
        OpenCms.getMemoryMonitor().flushACLs();
        OpenCms.getMemoryMonitor().flushGroups();
        OpenCms.getMemoryMonitor().flushOrgUnits();
        OpenCms.getMemoryMonitor().flushUserGroups();
        OpenCms.getMemoryMonitor().flushPermissions();
        OpenCms.getMemoryMonitor().flushResourceLists();
        return newUser;
    }

    public I_CmsPrincipal lookupPrincipal(CmsDbContext dbc, CmsUUID principalId) {
        try {
            CmsGroup group = this.m_userDriver.readGroup(dbc, principalId);
            if (group != null) {
                return group;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            CmsUser user = this.readUser(dbc, principalId);
            if (user != null) {
                return user;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public I_CmsPrincipal lookupPrincipal(CmsDbContext dbc, String principalName) {
        try {
            CmsGroup group = this.m_userDriver.readGroup(dbc, principalName);
            if (group != null) {
                return group;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            CmsUser user = this.readUser(dbc, principalName);
            if (user != null) {
                return user;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void moveResource(CmsDbContext dbc, CmsResource source, String destination, boolean internal) throws CmsException {
        ArrayList<CmsResource> resources;
        CmsResource destRes;
        CmsFolder destinationFolder;
        block7: {
            destinationFolder = this.readFolder(dbc, CmsResource.getParentFolder(destination), CmsResourceFilter.IGNORE_EXPIRATION);
            this.m_securityManager.checkPermissions(dbc, (CmsResource)destinationFolder, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
            if (source.isFolder()) {
                OpenCms.getMemoryMonitor().flushRoles();
                OpenCms.getMemoryMonitor().flushRoleLists();
            }
            this.m_vfsDriver.moveResource(dbc, dbc.getRequestContext().currentProject().getUuid(), source, destination);
            if (!internal) {
                CmsResourceState newState = CmsResource.STATE_CHANGED;
                if (source.getState().isNew()) {
                    newState = CmsResource.STATE_NEW;
                } else if (source.getState().isDeleted()) {
                    newState = CmsResource.STATE_DELETED;
                }
                source.setState(newState);
                this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), source, 2, false);
            }
            destRes = this.readResource(dbc, destination, CmsResourceFilter.ALL);
            this.m_lockManager.moveResource(source.getRootPath(), destRes.getRootPath());
            OpenCms.getMemoryMonitor().clearAccessControlListCache();
            OpenCms.getMemoryMonitor().flushProperties();
            OpenCms.getMemoryMonitor().flushPropertyLists();
            OpenCms.getMemoryMonitor().flushProjectResources();
            resources = new ArrayList<CmsResource>(4);
            resources.add(source);
            try {
                resources.add(this.readFolder(dbc, CmsResource.getParentFolder(source.getRootPath()), CmsResourceFilter.ALL));
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)e);
            }
        }
        resources.add(destRes);
        resources.add(destinationFolder);
        OpenCms.fireCmsEvent(new CmsEvent(22, Collections.singletonMap("resources", resources)));
    }

    public String moveToLostAndFound(CmsDbContext dbc, CmsResource resource, boolean returnNameOnly) throws CmsException, CmsIllegalArgumentException {
        String resourcename = dbc.removeSiteRoot(resource.getRootPath());
        String siteRoot = dbc.getRequestContext().getSiteRoot();
        dbc.getRequestContext().setSiteRoot("");
        String destination = LOST_AND_FOUND_FOLDER + resourcename;
        try {
            String folderPath = CmsResource.getParentFolder(destination);
            folderPath = folderPath.substring(1, folderPath.length() - 1);
            Iterator folders = CmsStringUtil.splitAsList(folderPath, '/').iterator();
            folderPath = "/";
            while (folders.hasNext()) {
                folderPath = folderPath + folders.next().toString() + "/";
                try {
                    this.readFolder(dbc, folderPath, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (Exception e1) {
                    if (returnNameOnly) break;
                    this.createResource(dbc, folderPath, 0, null, Collections.EMPTY_LIST);
                }
            }
            String des = destination;
            int postfix = 1;
            boolean found = true;
            while (found) {
                try {
                    found = true;
                    this.readResource(dbc, des, CmsResourceFilter.ALL);
                    String path = destination.substring(0, destination.lastIndexOf(47) + 1);
                    String filename = destination.substring(destination.lastIndexOf(47) + 1, destination.length());
                    des = path;
                    des = filename.lastIndexOf(46) > 0 ? des + filename.substring(0, filename.lastIndexOf(46)) : des + filename;
                    des = des + "_" + postfix;
                    if (filename.lastIndexOf(46) > 0) {
                        des = des + filename.substring(filename.lastIndexOf(46), filename.length());
                    }
                    ++postfix;
                }
                catch (CmsException e3) {
                    found = false;
                }
            }
            destination = des;
            if (!returnNameOnly) {
                this.copyResource(dbc, resource, destination, CmsResource.COPY_AS_SIBLING);
                this.deleteResource(dbc, resource, CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
        }
        catch (CmsException e2) {
            throw e2;
        }
        finally {
            dbc.getRequestContext().setSiteRoot(siteRoot);
        }
        return destination;
    }

    public Object newDriverInstance(CmsConfigurationManager configurationManager, String driverName, List successiveDrivers) throws CmsInitException {
        Class<?> driverClass = null;
        I_CmsDriver driver = null;
        CmsDbContext dbc = new CmsDbContext();
        try {
            driverClass = Class.forName(driverName);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_START_1", driverName));
            }
            driver = (I_CmsDriver)driverClass.newInstance();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_INITIALIZING_1", driverName));
            }
            driver.init(dbc, configurationManager, successiveDrivers, this);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_INIT_FINISHED_0"));
            }
        }
        catch (Throwable t) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_ERROR_INITIALIZING_DRIVER_1", driverName);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)message.key(), t);
            }
            throw new CmsInitException(message, t);
        }
        return driver;
    }

    public Object newDriverInstance(ExtendedProperties configuration, String driverName, String driverPoolUrl) throws CmsException {
        Class[] initParamClasses = new Class[]{ExtendedProperties.class, String.class, CmsDriverManager.class};
        Object[] initParams = new Object[]{configuration, driverPoolUrl, this};
        Class<?> driverClass = null;
        Object driver = null;
        try {
            driverClass = Class.forName(driverName);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_START_1", driverName));
            }
            driver = driverClass.newInstance();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_INITIALIZING_1", driverName));
            }
            driver.getClass().getMethod("init", initParamClasses).invoke(driver, initParams);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_INIT_FINISHED_1", driverPoolUrl));
            }
        }
        catch (Exception exc) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_INIT_DRIVER_MANAGER_1");
            if (LOG.isFatalEnabled()) {
                LOG.fatal((Object)message.key(), (Throwable)exc);
            }
            throw new CmsDbException(message, (Throwable)exc);
        }
        return driver;
    }

    public void newPoolInstance(Map configuration, String poolName) throws CmsInitException {
        PoolingDriver driver;
        try {
            driver = CmsDbPool.createDriverManagerConnectionPool(configuration, poolName);
        }
        catch (Exception e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_INIT_CONN_POOL_1", poolName);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)message.key(), (Throwable)e);
            }
            throw new CmsInitException(message, (Throwable)e);
        }
        this.m_connectionPools.add(driver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishJob(CmsObject cms, CmsDbContext dbc, CmsPublishList publishList, I_CmsReport report) throws CmsException {
        block12: {
            try {
                boolean temporaryProject;
                ArrayList allResources = new ArrayList(publishList.getFolderList());
                allResources.addAll(publishList.getDeletedFolderList());
                allResources.addAll(publishList.getFileList());
                Iterator itResources = allResources.iterator();
                while (itResources.hasNext()) {
                    CmsResource resource = (CmsResource)itResources.next();
                    try {
                        resource = this.readResource(dbc, resource.getStructureId(), CmsResourceFilter.ALL);
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        continue;
                    }
                    if (resource.getState().isUnchanged()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)org.opencms.db.Messages.get().getBundle().key("RPT_PUBLISH_REMOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
                        }
                        publishList.remove(resource);
                        this.unlockResource(dbc, resource, true, true);
                        continue;
                    }
                    CmsLock lock = this.m_lockManager.getLock(dbc, resource, false);
                    if (lock.getSystemLock().isPublish()) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)org.opencms.db.Messages.get().getBundle().key("RPT_PUBLISH_REMOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
                    }
                    publishList.remove(resource);
                }
                CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
                OpenCms.getMemoryMonitor().clearCache();
                int publishTag = this.getNextPublishTag(dbc);
                this.getProjectDriver().publishProject(dbc, report, onlineProject, publishList, publishTag);
                Iterator i = OpenCms.getModuleManager().getModuleNames().iterator();
                while (i.hasNext()) {
                    CmsModule module = OpenCms.getModuleManager().getModule(i.next().toString());
                    if (module == null || module.getActionInstance() == null) continue;
                    module.getActionInstance().publishProject(cms, publishList, publishTag, report);
                }
                boolean bl = temporaryProject = cms.getRequestContext().currentProject().getType() == CmsProject.PROJECT_TYPE_TEMPORARY;
                if (!temporaryProject || publishList.isDirectPublish()) break block12;
                try {
                    this.getProjectDriver().deleteProject(dbc, dbc.currentProject());
                }
                catch (CmsException e) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_DELETE_TEMP_PROJECT_FAILED_1", cms.getRequestContext().currentProject().getName()));
                }
                cms.getRequestContext().setCurrentProject(onlineProject);
            }
            finally {
                OpenCms.getMemoryMonitor().clearCache();
            }
        }
    }

    public synchronized void publishProject(CmsObject cms, CmsDbContext dbc, CmsPublishList publishList, I_CmsReport report) throws CmsException {
        this.checkParentFolders(dbc, publishList);
        try {
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("report", report);
            eventData.put("publishList", publishList);
            eventData.put("projectId", dbc.currentProject().getUuid());
            eventData.put("dbContext", dbc);
            CmsEvent beforePublishEvent = new CmsEvent(3, eventData);
            OpenCms.fireCmsEvent(beforePublishEvent);
        }
        catch (Throwable t) {
            report.addError(t);
            report.println(t);
        }
        Iterator itResources = new ArrayList(publishList.getAllResources()).iterator();
        while (itResources.hasNext()) {
            CmsResource resource = (CmsResource)itResources.next();
            CmsLock lock = this.m_lockManager.getLock(dbc, resource, false);
            if (lock.getSystemLock().isUnlocked() && lock.isLockableBy(dbc.currentUser())) {
                if (this.getLock(dbc, resource).getEditionLock().isNullLock()) {
                    this.lockResource(dbc, resource, CmsLockType.PUBLISH);
                } else {
                    this.changeLock(dbc, resource, CmsLockType.PUBLISH);
                }
            } else {
                if (lock.getSystemLock().isPublish()) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)org.opencms.db.Messages.get().getBundle().key("RPT_PUBLISH_REMOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
                    }
                    publishList.remove(resource);
                    continue;
                }
                this.changeLock(dbc, resource, CmsLockType.PUBLISH);
            }
            if ((lock = this.m_lockManager.getLock(dbc, resource, false)).getSystemLock().isPublish()) continue;
            if (report != null) {
                report.println(org.opencms.db.Messages.get().container("RPT_PUBLISH_REMOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())), 1);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)org.opencms.db.Messages.get().getBundle().key("RPT_PUBLISH_REMOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
            }
            publishList.remove(resource);
        }
        CmsException enqueueException = null;
        try {
            this.m_publishEngine.enqueuePublishJob(cms, publishList, report);
        }
        catch (CmsException exc) {
            enqueueException = exc;
        }
        if (enqueueException != null) {
            itResources = publishList.getAllResources().iterator();
            while (itResources.hasNext()) {
                CmsResource resource = (CmsResource)itResources.next();
                CmsLock lock = this.m_lockManager.getLock(dbc, resource, false);
                if (!lock.getSystemLock().isPublish() || !lock.getSystemLock().isOwnedInProjectBy(cms.getRequestContext().currentUser(), cms.getRequestContext().currentProject())) continue;
                this.unlockResource(dbc, resource, true, true);
            }
            throw enqueueException;
        }
    }

    public CmsAccessControlEntry readAccessControlEntry(CmsDbContext dbc, CmsResource resource, CmsUUID principal) throws CmsException {
        return this.m_userDriver.readAccessControlEntry(dbc, dbc.currentProject(), resource.getResourceId(), principal);
    }

    public List readAllAvailableVersions(CmsDbContext dbc, CmsResource resource) throws CmsException {
        List versions = this.m_historyDriver.readAllAvailableVersions(dbc, resource.getStructureId());
        if (versions.size() > OpenCms.getSystemInfo().getHistoryVersions() && OpenCms.getSystemInfo().getHistoryVersions() > -1) {
            return versions.subList(0, OpenCms.getSystemInfo().getHistoryVersions());
        }
        return versions;
    }

    public List readAllPropertyDefinitions(CmsDbContext dbc) throws CmsException {
        List returnValue = this.m_vfsDriver.readPropertyDefinitions(dbc, dbc.currentProject().getUuid());
        Collections.sort(returnValue);
        return returnValue;
    }

    public List readChildResources(CmsDbContext dbc, CmsResource resource, CmsResourceFilter filter, boolean getFolders, boolean getFiles, boolean checkPermissions) throws CmsException {
        String cacheKey = null;
        List resourceList = null;
        if (OpenCms.getMemoryMonitor().isCacheResourceList()) {
            String time = "";
            if (checkPermissions && dbc.getRequestContext() != null && OpenCms.getSiteManager().getSiteForSiteRoot(dbc.getRequestContext().getSiteRoot()) != null) {
                time = time + OpenCms.getSiteManager().getSiteForSiteRoot(dbc.getRequestContext().getSiteRoot()).getSiteMatcher().getTimeOffset();
            }
            String[] stringArray = new String[5];
            stringArray[0] = dbc.currentUser().getName();
            stringArray[1] = getFolders ? (getFiles ? "_all_" : "_folders_") : "_files_";
            stringArray[2] = checkPermissions ? "+" + time : "-";
            stringArray[3] = filter.getCacheId();
            stringArray[4] = resource.getRootPath();
            cacheKey = this.getCacheKey(stringArray, dbc);
            resourceList = OpenCms.getMemoryMonitor().getCachedResourceList(cacheKey);
        }
        if (resourceList == null || !dbc.getProjectId().isNullUUID()) {
            resourceList = this.m_vfsDriver.readChildResources(dbc, dbc.currentProject(), resource, getFolders, getFiles);
            if (checkPermissions) {
                resourceList = this.filterPermissions(dbc, resourceList, filter);
            }
            if (dbc.getProjectId().isNullUUID()) {
                OpenCms.getMemoryMonitor().cacheResourceList(cacheKey, resourceList);
            }
        }
        return this.updateContextDates(dbc, resourceList, filter);
    }

    public CmsResource readDefaultFile(CmsDbContext dbc, CmsResource resource) {
        if (resource.isFolder()) {
            block9: {
                try {
                    String defaultFileName = this.readPropertyObject(dbc, resource, "default-file", false).getValue();
                    if (defaultFileName != null) {
                        String folderName = CmsResource.getFolderPath(resource.getRootPath());
                        resource = this.readResource(dbc, folderName + defaultFileName, CmsResourceFilter.DEFAULT);
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (resource.isFolder()) {
                String folderName = CmsResource.getFolderPath(resource.getRootPath());
                Iterator it = OpenCms.getDefaultFiles().iterator();
                while (it.hasNext()) {
                    String tmpResourceName = folderName + it.next().toString();
                    try {
                        resource = this.readResource(dbc, tmpResourceName, CmsResourceFilter.DEFAULT);
                        break;
                    }
                    catch (CmsException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (resource.isFolder()) {
            resource = null;
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readDeletedResources(CmsDbContext dbc, CmsResource resource, boolean readTree, boolean isVfsManager) throws CmsException {
        HashSet<I_CmsHistoryResource> newResult;
        block18: {
            List deletedResources;
            HashSet result = new HashSet();
            dbc.getRequestContext().setAttribute("ATTR_RESOURCE_NAME", resource.getRootPath());
            try {
                deletedResources = this.m_historyDriver.readDeletedResources(dbc, resource.getStructureId(), isVfsManager ? null : dbc.currentUser().getId());
            }
            finally {
                dbc.getRequestContext().removeAttribute("ATTR_RESOURCE_NAME");
            }
            result.addAll(deletedResources);
            newResult = new HashSet<I_CmsHistoryResource>(result.size());
            Iterator it = result.iterator();
            while (it.hasNext()) {
                I_CmsHistoryResource histRes = (I_CmsHistoryResource)it.next();
                try {
                    if (this.getVfsDriver().validateStructureIdExists(dbc, dbc.currentProject().getUuid(), histRes.getStructureId())) {
                        newResult.add(histRes);
                        continue;
                    }
                    String resourcePath = histRes.getRootPath();
                    String resName = CmsResource.getName(resourcePath);
                    String path = CmsResource.getParentFolder(resourcePath);
                    CmsUUID parentId = histRes.getParentId();
                    try {
                        path = this.readResource(dbc, parentId, CmsResourceFilter.IGNORE_EXPIRATION).getRootPath();
                    }
                    catch (CmsDataAccessException e) {
                        try {
                            parentId = this.readResource(dbc, path, CmsResourceFilter.IGNORE_EXPIRATION).getStructureId();
                        }
                        catch (CmsDataAccessException e1) {
                            // empty catch block
                        }
                    }
                    resourcePath = path + resName;
                    boolean isFolder = resourcePath.endsWith("/");
                    if (isFolder) {
                        newResult.add(new CmsHistoryFolder(histRes.getPublishTag(), histRes.getStructureId(), histRes.getResourceId(), resourcePath, histRes.getTypeId(), histRes.getFlags(), histRes.getProjectLastModified(), histRes.getState(), histRes.getDateCreated(), histRes.getUserCreated(), histRes.getDateLastModified(), histRes.getUserLastModified(), histRes.getDateReleased(), histRes.getDateExpired(), histRes.getVersion(), parentId, histRes.getResourceVersion(), histRes.getStructureVersion()));
                        continue;
                    }
                    newResult.add(new CmsHistoryFile(histRes.getPublishTag(), histRes.getStructureId(), histRes.getResourceId(), resourcePath, histRes.getTypeId(), histRes.getFlags(), histRes.getProjectLastModified(), histRes.getState(), histRes.getDateCreated(), histRes.getUserCreated(), histRes.getDateLastModified(), histRes.getUserLastModified(), histRes.getDateReleased(), histRes.getDateExpired(), histRes.getLength(), histRes.getDateContent(), histRes.getVersion(), parentId, null, histRes.getResourceVersion(), histRes.getStructureVersion()));
                }
                catch (CmsDataAccessException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (readTree) {
                Iterator itDeleted = deletedResources.iterator();
                while (itDeleted.hasNext()) {
                    I_CmsHistoryResource delResource = (I_CmsHistoryResource)itDeleted.next();
                    if (!delResource.isFolder()) continue;
                    newResult.addAll(this.readDeletedResources(dbc, (CmsFolder)((Object)delResource), readTree, isVfsManager));
                }
                try {
                    this.readResource(dbc, resource.getStructureId(), CmsResourceFilter.ALL);
                    Iterator itResources = this.readResources(dbc, resource, CmsResourceFilter.ALL.addRequireFolder(), readTree).iterator();
                    while (itResources.hasNext()) {
                        CmsResource subResource = (CmsResource)itResources.next();
                        if (!subResource.isFolder()) continue;
                        newResult.addAll(this.readDeletedResources(dbc, subResource, readTree, isVfsManager));
                    }
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block18;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        ArrayList finalRes = new ArrayList(newResult);
        Collections.sort(finalRes, CmsResource.COMPARE_ROOT_PATH);
        return finalRes;
    }

    public CmsFile readFile(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (resource.isFolder()) {
            throw new CmsVfsResourceNotFoundException(org.opencms.db.Messages.get().container("ERR_ACCESS_FOLDER_AS_FILE_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
        CmsUUID projectId = dbc.currentProject().getUuid();
        CmsFile file = null;
        if (resource instanceof I_CmsHistoryResource) {
            file = new CmsHistoryFile((I_CmsHistoryResource)((Object)resource));
            file.setContents(this.m_historyDriver.readContent(dbc, resource.getResourceId(), ((I_CmsHistoryResource)((Object)resource)).getPublishTag()));
        } else {
            file = new CmsFile(resource);
            file.setContents(this.m_vfsDriver.readContent(dbc, projectId, resource.getResourceId()));
        }
        return file;
    }

    public CmsFolder readFolder(CmsDbContext dbc, String resourcename, CmsResourceFilter filter) throws CmsDataAccessException {
        CmsResource resource = this.readResource(dbc, resourcename, filter);
        return this.convertResourceToFolder(resource);
    }

    public CmsGroup readGroup(CmsDbContext dbc, CmsProject project) {
        try {
            return this.readGroup(dbc, project.getGroupId());
        }
        catch (CmsException exc) {
            return new CmsGroup(CmsUUID.getNullUUID(), CmsUUID.getNullUUID(), project.getGroupId() + "", "deleted group", 0);
        }
    }

    public CmsGroup readGroup(CmsDbContext dbc, CmsUUID groupId) throws CmsException {
        CmsGroup group = null;
        group = OpenCms.getMemoryMonitor().getCachedGroup(groupId.toString());
        if (group == null) {
            group = this.m_userDriver.readGroup(dbc, groupId);
            OpenCms.getMemoryMonitor().cacheGroup(group);
        }
        return group;
    }

    public CmsGroup readGroup(CmsDbContext dbc, String groupname) throws CmsDataAccessException {
        CmsGroup group = null;
        group = OpenCms.getMemoryMonitor().getCachedGroup(groupname);
        if (group == null) {
            group = this.m_userDriver.readGroup(dbc, groupname);
            OpenCms.getMemoryMonitor().cacheGroup(group);
        }
        return group;
    }

    public CmsHistoryPrincipal readHistoricalPrincipal(CmsDbContext dbc, CmsUUID principalId) throws CmsException {
        return this.m_historyDriver.readPrincipal(dbc, principalId);
    }

    public CmsHistoryProject readHistoryProject(CmsDbContext dbc, CmsUUID projectId) throws CmsException {
        return this.m_historyDriver.readProject(dbc, projectId);
    }

    public CmsHistoryProject readHistoryProject(CmsDbContext dbc, int publishTag) throws CmsException {
        return this.m_historyDriver.readProject(dbc, publishTag);
    }

    public List readHistoryPropertyObjects(CmsDbContext dbc, I_CmsHistoryResource historyResource) throws CmsException {
        return this.m_historyDriver.readProperties(dbc, historyResource);
    }

    public void readLocks(CmsDbContext dbc) throws CmsException {
        this.m_lockManager.readLocks(dbc);
    }

    public CmsGroup readManagerGroup(CmsDbContext dbc, CmsProject project) {
        try {
            return this.readGroup(dbc, project.getManagerGroupId());
        }
        catch (CmsException exc) {
            return new CmsGroup(CmsUUID.getNullUUID(), CmsUUID.getNullUUID(), project.getManagerGroupId() + "", "deleted group", 0);
        }
    }

    public CmsOrganizationalUnit readOrganizationalUnit(CmsDbContext dbc, String ouFqn) throws CmsException {
        CmsOrganizationalUnit organizationalUnit = null;
        organizationalUnit = OpenCms.getMemoryMonitor().getCachedOrgUnit(ouFqn);
        if (organizationalUnit == null) {
            organizationalUnit = this.m_userDriver.readOrganizationalUnit(dbc, ouFqn);
            OpenCms.getMemoryMonitor().cacheOrgUnit(organizationalUnit);
        }
        return organizationalUnit;
    }

    public CmsUser readOwner(CmsDbContext dbc, CmsProject project) throws CmsException {
        return this.readUser(dbc, project.getOwnerId());
    }

    public List readPath(CmsDbContext dbc, String path, CmsResourceFilter filter) throws CmsException {
        List tokens = CmsStringUtil.splitAsList(path, '/');
        int count = tokens.size() + 1;
        ArrayList<CmsResource> pathList = new ArrayList<CmsResource>(count);
        boolean lastResourceIsFile = false;
        int folderCount = count;
        if (!path.endsWith("/")) {
            --folderCount;
            lastResourceIsFile = true;
        }
        String currentResourceName = "/";
        StringBuffer currentPath = new StringBuffer(64);
        currentPath.append('/');
        String cp = currentPath.toString();
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        String cacheKey = this.getCacheKey(null, false, projectId, cp);
        CmsResource currentResource = OpenCms.getMemoryMonitor().getCachedResource(cacheKey);
        if (currentResource == null || !dbc.getProjectId().isNullUUID()) {
            currentResource = this.m_vfsDriver.readFolder(dbc, projectId, cp);
            if (dbc.getProjectId().isNullUUID()) {
                OpenCms.getMemoryMonitor().cacheResource(cacheKey, currentResource);
            }
        }
        pathList.add(0, currentResource);
        if (count == 1) {
            return pathList;
        }
        Iterator it = tokens.iterator();
        currentResourceName = (String)it.next();
        int i = 0;
        for (i = 1; i < folderCount; ++i) {
            currentPath.append(currentResourceName);
            currentPath.append('/');
            cp = currentPath.toString();
            cacheKey = this.getCacheKey(null, false, projectId, cp);
            currentResource = OpenCms.getMemoryMonitor().getCachedResource(cacheKey);
            if (currentResource == null || !dbc.getProjectId().isNullUUID()) {
                currentResource = this.m_vfsDriver.readFolder(dbc, projectId, cp);
                if (dbc.getProjectId().isNullUUID()) {
                    OpenCms.getMemoryMonitor().cacheResource(cacheKey, currentResource);
                }
            }
            pathList.add(i, currentResource);
            if (i >= folderCount - 1) continue;
            currentResourceName = (String)it.next();
        }
        if (lastResourceIsFile) {
            if (it.hasNext()) {
                currentResourceName = (String)it.next();
            }
            currentPath.append(currentResourceName);
            cp = currentPath.toString();
            cacheKey = this.getCacheKey(null, false, projectId, cp);
            currentResource = OpenCms.getMemoryMonitor().getCachedResource(cacheKey);
            if (currentResource == null || !dbc.getProjectId().isNullUUID()) {
                currentResource = this.m_vfsDriver.readResource(dbc, projectId, cp, filter.includeDeleted());
                if (dbc.getProjectId().isNullUUID()) {
                    OpenCms.getMemoryMonitor().cacheResource(cacheKey, currentResource);
                }
            }
            pathList.add(i, currentResource);
        }
        return pathList;
    }

    public CmsProject readProject(CmsDbContext dbc, CmsUUID id) throws CmsDataAccessException {
        CmsProject project = null;
        project = OpenCms.getMemoryMonitor().getCachedProject(id.toString());
        if (project == null) {
            project = this.m_projectDriver.readProject(dbc, id);
            OpenCms.getMemoryMonitor().cacheProject(project);
        }
        return project;
    }

    public CmsProject readProject(CmsDbContext dbc, String name) throws CmsException {
        CmsProject project = null;
        project = OpenCms.getMemoryMonitor().getCachedProject(name);
        if (project == null) {
            project = this.m_projectDriver.readProject(dbc, name);
            OpenCms.getMemoryMonitor().cacheProject(project);
        }
        return project;
    }

    public List readProjectResources(CmsDbContext dbc, CmsProject project) throws CmsException {
        return this.m_projectDriver.readProjectResources(dbc, project);
    }

    public List readProjectView(CmsDbContext dbc, CmsUUID projectId, CmsResourceState state) throws CmsException {
        List resources = state.isNew() || state.isChanged() || state.isDeleted() ? this.m_vfsDriver.readResources(dbc, projectId, state, 1) : this.m_vfsDriver.readResources(dbc, projectId, CmsResource.STATE_UNCHANGED, 2);
        List result = this.filterPermissions(dbc, resources, CmsResourceFilter.ALL);
        Collections.sort(result);
        return this.updateContextDates(dbc, result);
    }

    public CmsPropertyDefinition readPropertyDefinition(CmsDbContext dbc, String name) throws CmsException {
        return this.m_vfsDriver.readPropertyDefinition(dbc, name, dbc.currentProject().getUuid());
    }

    public CmsProperty readPropertyObject(CmsDbContext dbc, CmsResource resource, String key, boolean search) throws CmsException {
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        String cacheKey = this.getCacheKey(key, search, projectId, resource.getRootPath());
        CmsProperty value = OpenCms.getMemoryMonitor().getCachedProperty(cacheKey);
        if (value == null || !dbc.getProjectId().isNullUUID()) {
            String cacheKey2 = this.getCacheKey(CACHE_ALL_PROPERTIES, search, projectId, resource.getRootPath());
            List allProperties = OpenCms.getMemoryMonitor().getCachedPropertyList(cacheKey2);
            if (allProperties != null && dbc.getProjectId().isNullUUID()) {
                for (int i = 0; i < allProperties.size(); ++i) {
                    CmsProperty property = (CmsProperty)allProperties.get(i);
                    if (!property.getName().equals(key)) continue;
                    value = property;
                    break;
                }
            } else if (search) {
                String cacheKey3 = this.getCacheKey(key, search, projectId, resource.getRootPath());
                value = OpenCms.getMemoryMonitor().getCachedProperty(cacheKey3);
                if (value == null || value.isNullProperty() || !dbc.getProjectId().isNullUUID()) {
                    boolean cont;
                    do {
                        try {
                            value = this.readPropertyObject(dbc, resource, key, false);
                            cont = value.isNullProperty() && resource.getRootPath().length() > 1;
                        }
                        catch (CmsSecurityException se) {
                            cont = false;
                        }
                        if (!cont) continue;
                        resource = this.readResource(dbc, CmsResource.getParentFolder(resource.getRootPath()), CmsResourceFilter.ALL);
                    } while (cont);
                }
            } else {
                value = this.m_vfsDriver.readPropertyObject(dbc, key, dbc.currentProject(), resource);
            }
            if (value == null) {
                value = CmsProperty.getNullProperty();
            }
            value.setFrozen(true);
            if ((search || OpenCms.getMemoryMonitor().isCacheProperty()) && dbc.getProjectId().isNullUUID()) {
                OpenCms.getMemoryMonitor().cacheProperty(cacheKey, value);
            }
        }
        return value.cloneAsProperty();
    }

    public List readPropertyObjects(CmsDbContext dbc, CmsResource resource, boolean search) throws CmsException {
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        String cacheKey = this.getCacheKey(CACHE_ALL_PROPERTIES, search, projectId, resource.getRootPath());
        List properties = OpenCms.getMemoryMonitor().getCachedPropertyList(cacheKey);
        if (properties == null || !dbc.getProjectId().isNullUUID()) {
            if (search) {
                boolean cont;
                properties = new ArrayList();
                List parentProperties = null;
                do {
                    try {
                        parentProperties = this.readPropertyObjects(dbc, resource, false);
                        parentProperties.removeAll(properties);
                        parentProperties.addAll(properties);
                        properties.clear();
                        properties.addAll(parentProperties);
                        cont = resource.getRootPath().length() > 1;
                    }
                    catch (CmsSecurityException se) {
                        cont = false;
                    }
                    if (!cont) continue;
                    resource = this.readResource(dbc, CmsResource.getParentFolder(resource.getRootPath()), CmsResourceFilter.ALL);
                } while (cont);
            } else {
                properties = this.m_vfsDriver.readPropertyObjects(dbc, dbc.currentProject(), resource);
            }
            CmsProperty.setFrozen(properties);
            if ((search || OpenCms.getMemoryMonitor().isCachePropertyList()) && dbc.getProjectId().isNullUUID()) {
                OpenCms.getMemoryMonitor().cachePropertyList(cacheKey, properties);
            }
        }
        return new ArrayList(properties);
    }

    public List readPublishedResources(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        String cacheKey = publishHistoryId.toString();
        List resourceList = OpenCms.getMemoryMonitor().getCachedPublishedResources(cacheKey);
        if (resourceList == null || !dbc.getProjectId().isNullUUID()) {
            resourceList = this.m_projectDriver.readPublishedResources(dbc, publishHistoryId);
            if (dbc.getProjectId().isNullUUID()) {
                OpenCms.getMemoryMonitor().cachePublishedResources(cacheKey, resourceList);
            }
        }
        return resourceList;
    }

    public CmsPublishJobInfoBean readPublishJob(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        return this.m_projectDriver.readPublishJob(dbc, publishHistoryId);
    }

    public List readPublishJobs(CmsDbContext dbc, long startTime, long endTime) throws CmsException {
        return this.m_projectDriver.readPublishJobs(dbc, startTime, endTime);
    }

    public CmsPublishList readPublishList(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        return this.m_projectDriver.readPublishList(dbc, publishHistoryId);
    }

    public byte[] readPublishReportContents(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        return this.m_projectDriver.readPublishReportContents(dbc, publishHistoryId);
    }

    public I_CmsHistoryResource readResource(CmsDbContext dbc, CmsResource resource, int version) throws CmsException {
        Iterator itVersions = this.m_historyDriver.readAllAvailableVersions(dbc, resource.getStructureId()).iterator();
        while (itVersions.hasNext()) {
            I_CmsHistoryResource histRes = (I_CmsHistoryResource)itVersions.next();
            if (histRes.getVersion() != version) continue;
            return histRes;
        }
        throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_HISTORY_FILE_NOT_FOUND_1", resource.getStructureId()));
    }

    public CmsResource readResource(CmsDbContext dbc, CmsUUID structureID, CmsResourceFilter filter) throws CmsDataAccessException {
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        CmsResource resource = this.m_vfsDriver.readResource(dbc, projectId, structureID, filter.includeDeleted());
        this.updateContextDates(dbc, resource);
        return resource;
    }

    public CmsResource readResource(CmsDbContext dbc, String resourcePath, CmsResourceFilter filter) throws CmsDataAccessException {
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        CmsResource resource = this.m_vfsDriver.readResource(dbc, projectId, resourcePath, filter.includeDeleted());
        this.updateContextDates(dbc, resource);
        return resource;
    }

    public I_CmsHistoryResource readResourceForPublishTag(CmsDbContext dbc, CmsResource resource, int publishTag) throws CmsException {
        return this.m_historyDriver.readFile(dbc, resource.getStructureId(), publishTag);
    }

    public List readResources(CmsDbContext dbc, CmsResource parent, CmsResourceFilter filter, boolean readTree) throws CmsException, CmsDataAccessException {
        String cacheKey = this.getCacheKey(new String[]{dbc.currentUser().getName(), filter.getCacheId(), readTree ? "+" : "-", parent.getRootPath()}, dbc);
        List resourceList = OpenCms.getMemoryMonitor().getCachedResourceList(cacheKey);
        if (resourceList == null || !dbc.getProjectId().isNullUUID()) {
            resourceList = this.m_vfsDriver.readResourceTree(dbc, dbc.currentProject().getUuid(), readTree ? parent.getRootPath() : parent.getStructureId().toString(), filter.getType(), filter.getState(), filter.getModifiedAfter(), filter.getModifiedBefore(), filter.getReleaseAfter(), filter.getReleaseBefore(), filter.getExpireAfter(), filter.getExpireBefore(), (readTree ? 0 : 1) | (filter.excludeType() ? 4 : 0) | (filter.excludeState() ? 8 : 0) | (filter.getOnlyFolders() != null ? (filter.getOnlyFolders().booleanValue() ? 64 : 128) : 0));
            if (!parent.getRootPath().startsWith("/system/orgunits/")) {
                resourceList = this.filterPermissions(dbc, resourceList, filter);
            }
            if (dbc.getProjectId().isNullUUID()) {
                OpenCms.getMemoryMonitor().cacheResourceList(cacheKey, resourceList);
            }
        }
        return this.updateContextDates(dbc, resourceList, filter);
    }

    public List readResourcesWithProperty(CmsDbContext dbc, CmsResource folder, String propertyDefinition, String value, CmsResourceFilter filter) throws CmsException {
        String cacheKey = value == null ? this.getCacheKey(new String[]{dbc.currentUser().getName(), folder.getRootPath(), propertyDefinition, filter.getCacheId()}, dbc) : this.getCacheKey(new String[]{dbc.currentUser().getName(), folder.getRootPath(), propertyDefinition, value, filter.getCacheId()}, dbc);
        List resourceList = OpenCms.getMemoryMonitor().getCachedResourceList(cacheKey);
        if (resourceList == null || !dbc.getProjectId().isNullUUID()) {
            CmsPropertyDefinition propDef = this.readPropertyDefinition(dbc, propertyDefinition);
            resourceList = this.m_vfsDriver.readResourcesWithProperty(dbc, dbc.currentProject().getUuid(), propDef.getId(), folder.getRootPath(), value);
            resourceList = this.filterPermissions(dbc, resourceList, filter);
            if (dbc.getProjectId().isNullUUID()) {
                OpenCms.getMemoryMonitor().cacheResourceList(cacheKey, resourceList);
            }
        }
        return this.updateContextDates(dbc, resourceList, filter);
    }

    public Set readResponsiblePrincipals(CmsDbContext dbc, CmsResource resource) throws CmsException {
        HashSet<I_CmsPrincipal> result = new HashSet<I_CmsPrincipal>();
        Iterator aces = this.getAccessControlEntries(dbc, resource, true).iterator();
        while (aces.hasNext()) {
            I_CmsPrincipal p;
            CmsAccessControlEntry ace = (CmsAccessControlEntry)aces.next();
            if (!ace.isResponsible() || (p = this.lookupPrincipal(dbc, ace.getPrincipal())) == null) continue;
            result.add(p);
        }
        return result;
    }

    public Set readResponsibleUsers(CmsDbContext dbc, CmsResource resource) throws CmsException {
        HashSet<I_CmsPrincipal> result = new HashSet<I_CmsPrincipal>();
        Iterator principals = this.readResponsiblePrincipals(dbc, resource).iterator();
        while (principals.hasNext()) {
            I_CmsPrincipal principal = (I_CmsPrincipal)principals.next();
            if (principal instanceof CmsGroup) {
                try {
                    result.addAll(this.getUsersOfGroup(dbc, principal.getName(), true, false, false));
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)e);
                }
                continue;
            }
            result.add(principal);
        }
        return result;
    }

    public List readSiblings(CmsDbContext dbc, CmsResource resource, CmsResourceFilter filter) throws CmsException {
        List siblings = this.m_vfsDriver.readSiblings(dbc, dbc.currentProject().getUuid(), resource, filter.includeDeleted());
        return this.updateContextDates(dbc, siblings, filter);
    }

    public String readStaticExportPublishedResourceParameters(CmsDbContext dbc, String rfsName) throws CmsException {
        return this.m_projectDriver.readStaticExportPublishedResourceParameters(dbc, rfsName);
    }

    public List readStaticExportResources(CmsDbContext dbc, int parameterResources, long timestamp) throws CmsException {
        return this.m_projectDriver.readStaticExportResources(dbc, parameterResources, timestamp);
    }

    public CmsUser readUser(CmsDbContext dbc, CmsUUID id) throws CmsException {
        CmsUser user = OpenCms.getMemoryMonitor().getCachedUser(id.toString());
        if (user == null) {
            user = this.m_userDriver.readUser(dbc, id);
            OpenCms.getMemoryMonitor().cacheUser(user);
        }
        return user;
    }

    public CmsUser readUser(CmsDbContext dbc, String username) throws CmsDataAccessException {
        CmsUser user = OpenCms.getMemoryMonitor().getCachedUser(username);
        if (user == null) {
            user = this.m_userDriver.readUser(dbc, username);
            OpenCms.getMemoryMonitor().cacheUser(user);
        }
        return user;
    }

    public CmsUser readUser(CmsDbContext dbc, String username, String password) throws CmsException {
        CmsUser user = this.m_userDriver.readUser(dbc, username, password, null);
        OpenCms.getMemoryMonitor().cacheUser(user);
        return user;
    }

    public void removeAccessControlEntry(CmsDbContext dbc, CmsResource resource, CmsUUID principal) throws CmsException {
        this.m_userDriver.removeAccessControlEntry(dbc, dbc.currentProject(), resource.getResourceId(), principal);
        this.setDateLastModified(dbc, resource, resource.getDateLastModified());
        OpenCms.getMemoryMonitor().clearAccessControlListCache();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(1));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void removeResourceFromOrgUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, CmsResource resource) throws CmsException {
        OpenCms.getMemoryMonitor().flushRoles();
        OpenCms.getMemoryMonitor().flushRoleLists();
        this.m_userDriver.removeResourceFromOrganizationalUnit(dbc, orgUnit, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeResourceFromProject(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (!this.isInsideCurrentProject(dbc, resource.getRootPath())) return;
        if (resource.isFolder()) {
            List projectResources = this.m_projectDriver.readProjectResources(dbc, dbc.currentProject());
            for (int i = 0; i < projectResources.size(); ++i) {
                String resname = (String)projectResources.get(i);
                if (!resname.startsWith(resource.getRootPath())) continue;
                this.m_projectDriver.deleteProjectResource(dbc, dbc.currentProject().getUuid(), resname);
            }
        }
        try {
            try {
                this.m_projectDriver.deleteProjectResource(dbc, dbc.currentProject().getUuid(), resource.getRootPath());
            }
            catch (CmsException cmsException) {
                Object var7_8 = null;
                OpenCms.getMemoryMonitor().flushProjectResources();
                OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
                return;
            }
            Object var7_7 = null;
            OpenCms.getMemoryMonitor().flushProjectResources();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            OpenCms.getMemoryMonitor().flushProjectResources();
            OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
            throw throwable;
        }
        OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
    }

    public void removeUserFromGroup(CmsDbContext dbc, String username, String groupname, boolean readRoles) throws CmsException, CmsIllegalArgumentException, CmsDbEntryNotFoundException, CmsSecurityException {
        CmsGroup group = this.readGroup(dbc, groupname);
        if (group == null) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", groupname));
        }
        if (group.isVirtual() && !readRoles) {
            this.removeUserFromGroup(dbc, username, CmsRole.valueOf(group).getGroupName(), true);
            return;
        }
        if (group.isVirtual()) {
            readRoles = false;
        }
        if (readRoles && !group.isRole() || !readRoles && group.isRole()) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", groupname));
        }
        if (!this.userInGroup(dbc, username, groupname, readRoles)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_USER_NOT_IN_GROUP_2", username, groupname));
        }
        CmsUser user = this.readUser(dbc, username);
        if (user == null) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_USER_NOT_IN_GROUP_2", username, groupname));
        }
        if (readRoles) {
            CmsRole role = CmsRole.valueOf(group);
            if (role.equals(CmsRole.WORKPLACE_USER.forOrgUnit(role.getOuFqn())) && this.getGroupsOfUser(dbc, username, role.getOuFqn(), false, true, true, dbc.getRequestContext().getRemoteAddress()).size() > 1) {
                return;
            }
            Iterator it = this.getVirtualGroupsForRole(dbc, role).iterator();
            while (it.hasNext()) {
                CmsGroup virtualGroup = (CmsGroup)it.next();
                if (!this.userInGroup(dbc, username, virtualGroup.getName(), false)) continue;
                this.removeUserFromGroup(dbc, username, virtualGroup.getName(), true);
            }
        }
        this.m_userDriver.deleteUserInGroup(dbc, user.getId(), group.getId());
        if (readRoles) {
            OpenCms.getMemoryMonitor().flushRoles();
            OpenCms.getMemoryMonitor().flushRoleLists();
        }
        OpenCms.getMemoryMonitor().flushUserGroups();
    }

    public void replaceResource(CmsDbContext dbc, CmsResource resource, int type, byte[] content, List properties) throws CmsException {
        this.m_vfsDriver.replaceResource(dbc, resource, content, type);
        if (properties != null && properties != Collections.EMPTY_LIST) {
            this.m_vfsDriver.writePropertyObjects(dbc, dbc.currentProject(), resource, properties);
            OpenCms.getMemoryMonitor().flushProperties();
            OpenCms.getMemoryMonitor().flushPropertyLists();
        }
        if (resource.getState().isUnchanged()) {
            resource.setState(CmsResource.STATE_CHANGED);
        }
        resource.setUserLastModified(dbc.currentUser().getId());
        this.setDateLastModified(dbc, resource, System.currentTimeMillis());
        this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), resource, 4, false);
        this.deleteRelationsWithSiblings(dbc, resource);
        OpenCms.getMemoryMonitor().clearResourceCache();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(24));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void resetPassword(CmsDbContext dbc, String username, String oldPassword, String newPassword) throws CmsException, CmsSecurityException {
        if (oldPassword != null && newPassword != null) {
            CmsUser user = null;
            this.validatePassword(newPassword);
            try {
                user = this.m_userDriver.readUser(dbc, username, oldPassword, null);
            }
            catch (CmsDbEntryNotFoundException e) {
                throw new CmsDataAccessException(org.opencms.db.Messages.get().container("ERR_RESET_PASSWORD_1", username), (Throwable)e);
            }
            if (user == null || user.isManaged()) {
                throw new CmsDataAccessException(org.opencms.db.Messages.get().container("ERR_RESET_PASSWORD_1", username));
            }
            this.m_userDriver.writePassword(dbc, username, oldPassword, newPassword);
        } else {
            if (CmsStringUtil.isEmpty(oldPassword)) {
                throw new CmsDataAccessException(org.opencms.db.Messages.get().container("ERR_PWD_OLD_MISSING_0"));
            }
            if (CmsStringUtil.isEmpty(newPassword)) {
                throw new CmsDataAccessException(org.opencms.db.Messages.get().container("ERR_PWD_NEW_MISSING_0"));
            }
        }
    }

    public void restoreDeletedResource(CmsDbContext dbc, CmsUUID structureId) throws CmsException {
        CmsResource parent;
        int version = this.m_historyDriver.readLastVersion(dbc, structureId);
        I_CmsHistoryResource histRes = this.m_historyDriver.readResource(dbc, structureId, version);
        try {
            parent = this.m_vfsDriver.readResource(dbc, dbc.currentProject().getUuid(), histRes.getParentId(), true);
        }
        catch (CmsVfsResourceNotFoundException e) {
            try {
                parent = this.m_vfsDriver.readResource(dbc, dbc.currentProject().getUuid(), CmsResource.getParentFolder(histRes.getRootPath()), true);
            }
            catch (CmsVfsResourceNotFoundException e1) {
                this.restoreDeletedResource(dbc, histRes.getParentId());
                parent = this.readResource(dbc, histRes.getParentId(), CmsResourceFilter.IGNORE_EXPIRATION);
            }
        }
        this.m_securityManager.checkPermissions(dbc, parent, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
        String path = CmsResource.getParentFolder(histRes.getRootPath());
        String resName = CmsResource.getName(histRes.getRootPath());
        String ext = "";
        if (resName.charAt(resName.length() - 1) == '/') {
            resName = resName.substring(0, resName.length() - 1);
        } else {
            ext = CmsFileUtil.getExtension(resName);
        }
        String nameWOExt = resName.substring(0, resName.length() - ext.length());
        int i = 1;
        while (true) {
            try {
                this.readResource(dbc, path + resName, CmsResourceFilter.ALL);
                resName = nameWOExt + "_" + i + ext;
            }
            catch (CmsVfsResourceNotFoundException e) {
                break;
            }
            ++i;
        }
        CmsUUID id = structureId;
        if (this.m_vfsDriver.validateStructureIdExists(dbc, dbc.currentProject().getUuid(), structureId)) {
            id = new CmsUUID();
        }
        byte[] contents = null;
        boolean isFolder = true;
        if (histRes instanceof CmsFile) {
            contents = ((CmsFile)((Object)histRes)).getContents();
            if (contents == null || contents.length == 0) {
                contents = this.m_historyDriver.readContent(dbc, histRes.getResourceId(), histRes.getPublishTag());
            }
            isFolder = false;
        }
        List properties = this.m_historyDriver.readProperties(dbc, histRes);
        CmsResource newResource = new CmsResource(id, histRes.getResourceId(), path + resName, histRes.getTypeId(), isFolder, histRes.getFlags(), dbc.currentProject().getUuid(), CmsResource.STATE_NEW, histRes.getDateCreated(), histRes.getUserCreated(), histRes.getDateLastModified(), dbc.currentUser().getId(), histRes.getDateReleased(), histRes.getDateExpired(), histRes.getSiblingCount(), histRes.getLength(), histRes.getDateContent(), histRes.getVersion());
        newResource.setDateLastModified(newResource.getDateLastModified());
        CmsResource resource = this.createResource(dbc, path + resName, newResource, contents, properties, true);
        newResource.setState(CmsResource.STATE_CHANGED);
        this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), newResource, 1, false);
        newResource.setState(CmsResource.STATE_NEW);
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(24));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void restoreResource(CmsDbContext dbc, CmsResource resource, int version) throws CmsException {
        I_CmsHistoryResource historyResource = this.readResource(dbc, resource, version);
        CmsResourceState state = CmsResource.STATE_CHANGED;
        if (resource.getState().isNew()) {
            state = CmsResource.STATE_NEW;
        }
        int newVersion = resource.getVersion();
        if (resource.getState().isUnchanged()) {
            ++newVersion;
        }
        CmsResource newResource = null;
        if (historyResource instanceof CmsFile) {
            int flags = historyResource.getFlags();
            if (resource.isLabeled()) {
                flags |= 2;
            }
            CmsFile newFile = new CmsFile(resource.getStructureId(), resource.getResourceId(), resource.getRootPath(), historyResource.getTypeId(), flags, dbc.currentProject().getUuid(), state, resource.getDateCreated(), historyResource.getUserCreated(), resource.getDateLastModified(), dbc.currentUser().getId(), historyResource.getDateReleased(), historyResource.getDateExpired(), resource.getSiblingCount(), historyResource.getLength(), historyResource.getDateContent(), newVersion, this.readFile(dbc, (CmsHistoryFile)historyResource).getContents());
            newResource = this.writeFile(dbc, newFile);
        } else {
            newResource = new CmsFolder(resource.getStructureId(), resource.getResourceId(), resource.getRootPath(), historyResource.getTypeId(), historyResource.getFlags(), dbc.currentProject().getUuid(), state, resource.getDateCreated(), historyResource.getUserCreated(), resource.getDateLastModified(), dbc.currentUser().getId(), historyResource.getDateReleased(), historyResource.getDateExpired(), newVersion);
            this.writeResource(dbc, newResource);
        }
        if (newResource != null) {
            List historyProperties = this.m_historyDriver.readProperties(dbc, historyResource);
            this.deleteAllProperties(dbc, newResource.getRootPath());
            this.writePropertyObjects(dbc, newResource, historyProperties, false);
            OpenCms.getMemoryMonitor().clearResourceCache();
        }
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(24));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void setDateExpired(CmsDbContext dbc, CmsResource resource, long dateExpired) throws CmsDataAccessException {
        resource.setDateExpired(dateExpired);
        if (resource.getState().isUnchanged()) {
            resource.setState(CmsResource.STATE_CHANGED);
        }
        this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), resource, 5, false);
        this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), resource, 6, false);
        OpenCms.getMemoryMonitor().clearResourceCache();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(2));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void setDateLastModified(CmsDbContext dbc, CmsResource resource, long dateLastModified) throws CmsDataAccessException {
        resource.setDateLastModified(dateLastModified);
        if (resource.getState().isUnchanged()) {
            resource.setState(CmsResource.STATE_CHANGED);
        } else if (resource.getState().isNew() && resource.getSiblingCount() > 1) {
            resource.setState(CmsResource.STATE_CHANGED);
        }
        resource.setUserLastModified(dbc.currentUser().getId());
        this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), resource, 4, false);
        OpenCms.getMemoryMonitor().clearResourceCache();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(4));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void setDateReleased(CmsDbContext dbc, CmsResource resource, long dateReleased) throws CmsDataAccessException {
        resource.setDateReleased(dateReleased);
        if (resource.getState().isUnchanged()) {
            resource.setState(CmsResource.STATE_CHANGED);
        }
        this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), resource, 5, false);
        this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), resource, 6, false);
        OpenCms.getMemoryMonitor().clearResourceCache();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(2));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void setParentGroup(CmsDbContext dbc, String groupName, String parentGroupName) throws CmsException, CmsDataAccessException {
        CmsGroup group = this.readGroup(dbc, groupName);
        CmsUUID parentGroupId = CmsUUID.getNullUUID();
        if (parentGroupName != null) {
            parentGroupId = this.readGroup(dbc, parentGroupName).getId();
        }
        group.setParentId(parentGroupId);
        this.writeGroup(dbc, group);
    }

    public void setPassword(CmsDbContext dbc, String username, String newPassword) throws CmsException, CmsIllegalArgumentException {
        this.validatePassword(newPassword);
        this.m_userDriver.readUser(dbc, username);
        this.m_userDriver.writePassword(dbc, username, null, newPassword);
    }

    public void setUsersOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, CmsUser user) throws CmsException {
        if (!this.getGroupsOfUser(dbc, user.getName(), false).isEmpty()) {
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_MOVE_USER_2", orgUnit.getName(), user.getName()));
        }
        this.m_userDriver.setUsersOrganizationalUnit(dbc, orgUnit, user);
        OpenCms.getMemoryMonitor().clearUserCache(user);
    }

    public void undelete(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (!resource.getState().isDeleted()) {
            throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_UNDELETE_FOR_RESOURCE_DELETED_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
        resource.setState(CmsResourceState.STATE_CHANGED);
        this.updateState(dbc, resource, false);
        OpenCms.getMemoryMonitor().clearResourceCache();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(8));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void undoChanges(CmsDbContext dbc, CmsResource resource, CmsResource.CmsResourceUndoMode mode) throws CmsException {
        boolean moved;
        if (resource.getState().isNew()) {
            throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_UNDO_CHANGES_FOR_RESOURCE_NEW_0"));
        }
        CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
        CmsResource onlineResource = this.m_vfsDriver.readResource(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getStructureId(), true);
        CmsResource onlineResourceByPath = null;
        try {
            onlineResourceByPath = this.m_vfsDriver.readResource(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getRootPath(), true);
            if (!mode.isUndoMove() && !onlineResourceByPath.getRootPath().equals(onlineResource.getRootPath())) {
                mode = mode.includeMove();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = moved = !onlineResource.getRootPath().equals(resource.getRootPath());
        if (moved && mode.isUndoMove()) {
            this.moveResource(dbc, resource, onlineResource.getRootPath(), true);
            if (onlineResourceByPath != null && !onlineResourceByPath.getRootPath().equals(onlineResource.getRootPath())) {
                this.undoContentChanges(dbc, onlineProject, null, onlineResourceByPath, CmsResource.STATE_UNCHANGED, true);
            }
        }
        CmsResourceState newState = CmsResource.STATE_UNCHANGED;
        if (moved && !mode.isUndoMove()) {
            newState = CmsResource.STATE_CHANGED;
        }
        this.undoContentChanges(dbc, onlineProject, resource, onlineResource, newState, moved && mode.isUndoMove());
    }

    public void unlockProject(CmsProject project) {
        this.m_lockManager.removeResourcesInProject(project.getUuid(), false);
        OpenCms.getMemoryMonitor().clearResourceCache();
        OpenCms.getMemoryMonitor().flushProjects();
        OpenCms.getMemoryMonitor().flushPermissions();
    }

    public void unlockResource(CmsDbContext dbc, CmsResource resource, boolean force, boolean removeSystemLock) throws CmsException {
        OpenCms.getMemoryMonitor().clearResourceCache();
        this.m_lockManager.removeResource(dbc, resource, force, removeSystemLock);
        OpenCms.getMemoryMonitor().flushPermissions();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(0));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void updateExportPoints(CmsDbContext dbc) {
        block10: {
            try {
                HashSet exportPoints = new HashSet();
                exportPoints.addAll(OpenCms.getExportPoints());
                exportPoints.addAll(OpenCms.getModuleManager().getExportPoints());
                if (exportPoints.size() == 0) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)org.opencms.db.Messages.get().getBundle().key("LOG_NO_EXPORT_POINTS_CONFIGURED_0"));
                    }
                    return;
                }
                CmsExportPointDriver exportPointDriver = new CmsExportPointDriver(exportPoints);
                Iterator i = exportPointDriver.getExportPointPaths().iterator();
                while (i.hasNext()) {
                    String currentExportPoint = (String)i.next();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)org.opencms.db.Messages.get().getBundle().key("LOG_WRITE_EXPORT_POINT_1", currentExportPoint));
                    }
                    try {
                        CmsResourceFilter filter = CmsResourceFilter.DEFAULT;
                        List resources = this.m_vfsDriver.readResourceTree(dbc, CmsProject.ONLINE_PROJECT_ID, currentExportPoint, filter.getType(), filter.getState(), filter.getModifiedAfter(), filter.getModifiedBefore(), filter.getReleaseAfter(), filter.getReleaseBefore(), filter.getExpireAfter(), filter.getExpireBefore(), 0 | (filter.excludeType() ? 4 : 0) | (filter.excludeState() ? 8 : 0));
                        Iterator j = resources.iterator();
                        while (j.hasNext()) {
                            CmsResource currentResource = (CmsResource)j.next();
                            if (currentResource.isFolder()) {
                                exportPointDriver.createFolder(currentResource.getRootPath(), currentExportPoint);
                                continue;
                            }
                            exportPointDriver.createFolder(currentExportPoint, currentExportPoint);
                            byte[] onlineContent = this.getVfsDriver().readContent(dbc, CmsProject.ONLINE_PROJECT_ID, currentResource.getResourceId());
                            exportPointDriver.writeFile(currentResource.getRootPath(), currentExportPoint, onlineContent);
                        }
                    }
                    catch (CmsException e) {
                        if (!(e instanceof CmsVfsResourceNotFoundException) || !LOG.isErrorEnabled()) continue;
                        LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_UPDATE_EXORT_POINTS_ERROR_0"), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block10;
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_UPDATE_EXORT_POINTS_ERROR_0"), (Throwable)e);
            }
        }
    }

    public void updateRelationsForResource(CmsDbContext dbc, CmsResource resource, List links) throws CmsException {
        this.deleteRelationsWithSiblings(dbc, resource);
        if (links == null || links.isEmpty()) {
            return;
        }
        HashSet<CmsRelation> writtenRelations = new HashSet<CmsRelation>();
        Iterator itLinks = links.iterator();
        while (itLinks.hasNext()) {
            CmsRelation originalRelation;
            CmsLink link = (CmsLink)itLinks.next();
            if (!link.isInternal() || CmsStringUtil.isEmptyOrWhitespaceOnly(link.getTarget())) continue;
            try {
                CmsResource target = this.readResource(dbc, link.getTarget(), CmsResourceFilter.ALL);
                originalRelation = new CmsRelation(resource, target, link.getType());
            }
            catch (Exception e) {
                originalRelation = new CmsRelation(resource.getStructureId(), resource.getRootPath(), CmsUUID.getNullUUID(), link.getTarget(), link.getType());
            }
            if (writtenRelations.contains(originalRelation)) continue;
            writtenRelations.add(originalRelation);
            Iterator itSiblings = this.readSiblings(dbc, resource, CmsResourceFilter.ALL).iterator();
            while (itSiblings.hasNext()) {
                CmsResource sibling = (CmsResource)itSiblings.next();
                CmsRelation relation = new CmsRelation(sibling.getStructureId(), sibling.getRootPath(), originalRelation.getTargetId(), originalRelation.getTargetPath(), link.getType());
                this.m_vfsDriver.createRelation(dbc, dbc.currentProject().getUuid(), relation);
            }
        }
    }

    public boolean userInGroup(CmsDbContext dbc, String username, String groupname, boolean readRoles) throws CmsException {
        List groups = this.getGroupsOfUser(dbc, username, readRoles);
        for (int i = 0; i < groups.size(); ++i) {
            CmsGroup group = (CmsGroup)groups.get(i);
            if (!groupname.equals(group.getName()) && !groupname.substring(1).equals(group.getName())) continue;
            return true;
        }
        return false;
    }

    public void validatePassword(String password) throws CmsSecurityException {
        OpenCms.getPasswordHandler().validatePassword(password);
    }

    public Map validateRelations(CmsDbContext dbc, CmsPublishList publishList, I_CmsReport report) throws Exception {
        return this.m_htmlLinkValidator.validateResources(dbc, publishList, report);
    }

    public void writeAccessControlEntry(CmsDbContext dbc, CmsResource resource, CmsAccessControlEntry ace) throws CmsException {
        this.m_userDriver.writeAccessControlEntry(dbc, dbc.currentProject(), ace);
        this.setDateLastModified(dbc, resource, resource.getDateLastModified());
        OpenCms.getMemoryMonitor().clearAccessControlListCache();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(1));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void writeExportPoints(CmsDbContext dbc, I_CmsReport report, CmsUUID publishHistoryId) {
        List publishedResources;
        boolean printReportHeaders;
        block20: {
            printReportHeaders = false;
            publishedResources = null;
            try {
                publishedResources = this.m_projectDriver.readPublishedResources(dbc, publishHistoryId);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block20;
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_READ_PUBLISHED_RESOURCES_FOR_ID_1", publishHistoryId), (Throwable)e);
            }
        }
        if (publishedResources == null || publishedResources.isEmpty()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)org.opencms.db.Messages.get().getBundle().key("LOG_EMPTY_PUBLISH_HISTORY_1", publishHistoryId));
            }
            return;
        }
        HashSet exportPoints = new HashSet();
        exportPoints.addAll(OpenCms.getExportPoints());
        exportPoints.addAll(OpenCms.getModuleManager().getExportPoints());
        if (exportPoints.size() == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)org.opencms.db.Messages.get().getBundle().key("LOG_NO_EXPORT_POINTS_CONFIGURED_0"));
            }
            return;
        }
        CmsExportPointDriver exportPointDriver = new CmsExportPointDriver(exportPoints);
        if (report == null) {
            report = dbc.getRequestContext() != null ? new CmsLogReport(dbc.getRequestContext().getLocale(), this.getClass()) : new CmsLogReport(CmsLocaleManager.getDefaultLocale(), this.getClass());
        }
        Iterator i = publishedResources.iterator();
        while (i.hasNext()) {
            CmsPublishedResource currentPublishedResource = (CmsPublishedResource)i.next();
            String currentExportPoint = exportPointDriver.getExportPoint(currentPublishedResource.getRootPath());
            if (currentExportPoint == null) continue;
            if (!printReportHeaders) {
                report.println(org.opencms.db.Messages.get().container("RPT_EXPORT_POINTS_WRITE_BEGIN_0"), 2);
                printReportHeaders = true;
            }
            if (currentPublishedResource.getState().isDeleted()) {
                report.print(org.opencms.db.Messages.get().container("RPT_EXPORT_POINTS_DELETE_0"), 3);
            } else {
                report.print(org.opencms.db.Messages.get().container("RPT_EXPORT_POINTS_WRITE_0"), 3);
            }
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", currentPublishedResource.getRootPath()));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            if (currentPublishedResource.isFolder()) {
                if (currentPublishedResource.getState().isDeleted()) {
                    exportPointDriver.deleteResource(currentPublishedResource.getRootPath(), currentExportPoint);
                } else {
                    exportPointDriver.createFolder(currentPublishedResource.getRootPath(), currentExportPoint);
                }
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                continue;
            }
            try {
                if (currentPublishedResource.getState().isDeleted()) {
                    exportPointDriver.deleteResource(currentPublishedResource.getRootPath(), currentExportPoint);
                } else {
                    byte[] onlineContent = this.getVfsDriver().readContent(dbc, CmsProject.ONLINE_PROJECT_ID, currentPublishedResource.getResourceId());
                    exportPointDriver.writeFile(currentPublishedResource.getRootPath(), currentExportPoint, onlineContent);
                }
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
            catch (CmsException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_WRITE_EXPORT_POINT_ERROR_1", currentPublishedResource.getRootPath()), (Throwable)e);
                }
                report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
            }
        }
        if (printReportHeaders) {
            report.println(org.opencms.db.Messages.get().container("RPT_EXPORT_POINTS_WRITE_END_0"), 2);
        }
    }

    public CmsFile writeFile(CmsDbContext dbc, CmsFile resource) throws CmsException {
        resource.setUserLastModified(dbc.currentUser().getId());
        resource.setContents(resource.getContents());
        this.m_vfsDriver.writeResource(dbc, dbc.currentProject().getUuid(), resource, 1);
        byte[] contents = resource.getContents();
        this.m_vfsDriver.writeContent(dbc, resource.getResourceId(), contents);
        resource = new CmsFile(this.readResource(dbc, resource.getStructureId(), CmsResourceFilter.ALL));
        resource.setContents(contents);
        this.deleteRelationsWithSiblings(dbc, resource);
        OpenCms.getMemoryMonitor().clearResourceCache();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(16));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
        return resource;
    }

    public void writeGroup(CmsDbContext dbc, CmsGroup group) throws CmsException {
        OpenCms.getMemoryMonitor().uncacheGroup(group);
        this.m_userDriver.writeGroup(dbc, group);
        OpenCms.getMemoryMonitor().cacheGroup(group);
    }

    public void writeHistoryProject(CmsDbContext dbc, int publishTag, long publishDate) throws CmsDataAccessException {
        this.m_historyDriver.writeProject(dbc, publishTag, publishDate);
    }

    public void writeLocks(CmsDbContext dbc) throws CmsException {
        this.m_lockManager.writeLocks(dbc);
    }

    public void writeOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit organizationalUnit) throws CmsException {
        OpenCms.getMemoryMonitor().uncacheOrgUnit(organizationalUnit);
        this.m_userDriver.writeOrganizationalUnit(dbc, organizationalUnit);
        CmsResource ouRes = this.readResource(dbc, organizationalUnit.getId(), CmsResourceFilter.DEFAULT);
        CmsPublishList pl = new CmsPublishList(ouRes, false);
        pl.add(ouRes, false);
        this.getProjectDriver().writePublishHistory(dbc, pl.getPublishHistoryId(), new CmsPublishedResource(ouRes, -1, CmsResourceState.STATE_NEW));
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("publishHistoryId", pl.getPublishHistoryId().toString());
        eventData.put("projectId", dbc.currentProject().getUuid());
        eventData.put("dbContext", dbc);
        CmsEvent afterPublishEvent = new CmsEvent(2, eventData);
        OpenCms.fireCmsEvent(afterPublishEvent);
        OpenCms.getMemoryMonitor().cacheOrgUnit(organizationalUnit);
    }

    public void writeProject(CmsDbContext dbc, CmsProject project) throws CmsException {
        OpenCms.getMemoryMonitor().uncacheProject(project);
        this.m_projectDriver.writeProject(dbc, project);
        OpenCms.getMemoryMonitor().cacheProject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePropertyObject(CmsDbContext dbc, CmsResource resource, CmsProperty property) throws CmsException {
        block5: {
            HashMap<String, Comparable> data2;
            block4: {
                try {
                    if (property == CmsProperty.getNullProperty()) {
                        Object var6_4 = null;
                        OpenCms.getMemoryMonitor().clearResourceCache();
                        OpenCms.getMemoryMonitor().flushProperties();
                        OpenCms.getMemoryMonitor().flushPropertyLists();
                        data2 = new HashMap<String, Comparable>();
                        data2.put("resource", resource);
                        break block4;
                    }
                    int updateState = this.getUpdateState(dbc, resource, Collections.singletonList(property));
                    this.m_vfsDriver.writePropertyObject(dbc, dbc.currentProject(), resource, property);
                    if (updateState > 0) {
                        this.updateState(dbc, resource, updateState == 2);
                    }
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OpenCms.getMemoryMonitor().clearResourceCache();
                    OpenCms.getMemoryMonitor().flushProperties();
                    OpenCms.getMemoryMonitor().flushPropertyLists();
                    HashMap<String, Comparable> data2 = new HashMap<String, Comparable>();
                    data2.put("resource", resource);
                    data2.put("property", property);
                    OpenCms.fireCmsEvent(new CmsEvent(14, data2));
                    throw throwable;
                }
            }
            data2.put("property", property);
            OpenCms.fireCmsEvent(new CmsEvent(14, data2));
            return;
        }
        Object var6_5 = null;
        OpenCms.getMemoryMonitor().clearResourceCache();
        OpenCms.getMemoryMonitor().flushProperties();
        OpenCms.getMemoryMonitor().flushPropertyLists();
        HashMap<String, Comparable> data2 = new HashMap<String, Comparable>();
        data2.put("resource", resource);
        data2.put("property", property);
        OpenCms.fireCmsEvent(new CmsEvent(14, data2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePropertyObjects(CmsDbContext dbc, CmsResource resource, List properties, boolean updateState) throws CmsException {
        if (properties == null || properties.size() == 0) {
            return;
        }
        try {
            int n = properties.size();
            for (int i = 0; i < n; ++i) {
                HashSet<String> keyValidationSet = new HashSet<String>();
                CmsProperty property = (CmsProperty)properties.get(i);
                if (keyValidationSet.contains(property.getName())) {
                    throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_VFS_INVALID_PROPERTY_LIST_1", property.getName()));
                }
                keyValidationSet.add(property.getName());
            }
            int updateStateValue = 0;
            if (updateState) {
                updateStateValue = this.getUpdateState(dbc, resource, properties);
            }
            for (int i = 0; i < properties.size(); ++i) {
                CmsProperty property = (CmsProperty)properties.get(i);
                this.m_vfsDriver.writePropertyObject(dbc, dbc.currentProject(), resource, property);
            }
            if (updateStateValue > 0) {
                this.updateState(dbc, resource, updateStateValue == 2);
            }
            Object var10_9 = null;
            OpenCms.getMemoryMonitor().clearResourceCache();
            OpenCms.getMemoryMonitor().flushProperties();
            OpenCms.getMemoryMonitor().flushPropertyLists();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            OpenCms.getMemoryMonitor().clearResourceCache();
            OpenCms.getMemoryMonitor().flushProperties();
            OpenCms.getMemoryMonitor().flushPropertyLists();
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", resource)));
            throw throwable;
        }
        OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", resource)));
    }

    public void writePublishJob(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsException {
        this.m_projectDriver.writePublishJob(dbc, publishJob);
    }

    public void writePublishReport(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsException {
        CmsPublishReport report = (CmsPublishReport)publishJob.removePublishReport();
        if (report != null) {
            this.m_projectDriver.writePublishReport(dbc, publishJob.getPublishHistoryId(), report.getContents());
        }
    }

    public void writeResource(CmsDbContext dbc, CmsResource resource) throws CmsException {
        resource.setUserLastModified(dbc.currentUser().getId());
        this.m_vfsDriver.writeResource(dbc, dbc.currentProject().getUuid(), resource, 1);
        if (resource.getState().isUnchanged()) {
            resource.setState(CmsResource.STATE_CHANGED);
        }
        if (!(OpenCms.getResourceManager().getResourceType(resource.getTypeId()) instanceof I_CmsLinkParseable)) {
            this.deleteRelationsWithSiblings(dbc, resource);
        }
        OpenCms.getMemoryMonitor().clearResourceCache();
        HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
        data.put("resource", resource);
        data.put("change", new Integer(8));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void writeStaticExportPublishedResource(CmsDbContext dbc, String resourceName, int linkType, String linkParameter, long timestamp) throws CmsException {
        this.m_projectDriver.writeStaticExportPublishedResource(dbc, resourceName, linkType, linkParameter, timestamp);
    }

    public void writeUser(CmsDbContext dbc, CmsUser user) throws CmsException {
        OpenCms.getMemoryMonitor().clearUserCache(user);
        this.m_userDriver.writeUser(dbc, user);
    }

    protected CmsFolder convertResourceToFolder(CmsResource resource) throws CmsVfsResourceNotFoundException {
        if (resource.isFolder()) {
            return new CmsFolder(resource);
        }
        throw new CmsVfsResourceNotFoundException(org.opencms.db.Messages.get().container("ERR_ACCESS_FILE_AS_FOLDER_1", resource.getRootPath()));
    }

    protected void deleteRelationsWithSiblings(CmsDbContext dbc, CmsResource resource) throws CmsException {
        List siblings;
        if (resource.getSiblingCount() > 1) {
            siblings = this.readSiblings(dbc, resource, CmsResourceFilter.ALL);
        } else {
            siblings = new ArrayList<CmsResource>();
            siblings.add(resource);
        }
        Iterator it = siblings.iterator();
        while (it.hasNext()) {
            CmsResource sibling = (CmsResource)it.next();
            this.m_vfsDriver.deleteRelations(dbc, dbc.currentProject().getUuid(), sibling, CmsRelationFilter.TARGETS.filterDefinedInContent());
        }
    }

    protected CmsLockManager getLockManager() {
        return this.m_lockManager;
    }

    private boolean checkDeletedParentFolder(CmsDbContext dbc, List deletedFolders, CmsResource res) {
        CmsResource parent;
        String parentPath = CmsResource.getParentFolder(res.getRootPath());
        if (parentPath == null) {
            return false;
        }
        try {
            parent = this.readResource(dbc, parentPath, CmsResourceFilter.ALL);
        }
        catch (Exception e) {
            return false;
        }
        if (!parent.getState().isDeleted()) {
            return false;
        }
        for (int j = 0; j < deletedFolders.size(); ++j) {
            if (!((CmsResource)deletedFolders.get(j)).getStructureId().equals(parent.getStructureId())) continue;
            return true;
        }
        return false;
    }

    private void checkParentFolders(CmsDbContext dbc, CmsPublishList publishList) throws CmsVfsException {
        boolean directPublish = publishList.isDirectPublish();
        if (directPublish) {
            Iterator it = publishList.getDirectPublishResources().iterator();
            List<String> parentFolderNames = new ArrayList();
            while (it.hasNext()) {
                CmsResource res = (CmsResource)it.next();
                String parentFolderName = CmsResource.getParentFolder(res.getRootPath());
                if (parentFolderName == null) continue;
                parentFolderNames.add(parentFolderName);
            }
            parentFolderNames = CmsFileUtil.removeRedundancies(parentFolderNames);
            String parentFolderName = null;
            try {
                Iterator parentIt = parentFolderNames.iterator();
                while (parentIt.hasNext()) {
                    parentFolderName = (String)parentIt.next();
                    this.getVfsDriver().readFolder(dbc, CmsProject.ONLINE_PROJECT_ID, parentFolderName);
                }
            }
            catch (CmsException e) {
                throw new CmsVfsException(org.opencms.db.Messages.get().container("RPT_PARENT_FOLDER_NOT_PUBLISHED_1", parentFolderName));
            }
        }
    }

    private boolean checkParentResource(CmsDbContext dbc, List folderList, CmsResource res) {
        CmsResource parent;
        String parentPath = CmsResource.getParentFolder(res.getRootPath());
        if (parentPath == null) {
            return true;
        }
        try {
            parent = this.readResource(dbc, parentPath, CmsResourceFilter.ALL);
        }
        catch (Exception e) {
            return false;
        }
        if (!parent.getState().isNew()) {
            return true;
        }
        for (int j = 0; j < folderList.size(); ++j) {
            if (!((CmsResource)folderList.get(j)).getStructureId().equals(parent.getStructureId())) continue;
            return true;
        }
        return false;
    }

    private List filterPermissions(CmsDbContext dbc, List resourceList, CmsResourceFilter filter) throws CmsException {
        if (filter.requireTimerange()) {
            filter = filter.addExcludeTimerange();
        }
        ArrayList<CmsResource> result = new ArrayList<CmsResource>(resourceList.size());
        for (int i = 0; i < resourceList.size(); ++i) {
            CmsResource currentResource = (CmsResource)resourceList.get(i);
            if (!this.m_securityManager.hasPermissions(dbc, currentResource, CmsPermissionSet.ACCESS_READ, true, filter).isAllowed()) continue;
            result.add(currentResource);
        }
        return result;
    }

    private List filterResources(CmsDbContext dbc, CmsPublishList publishList, List resourceList) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        ArrayList<CmsResource> newFolderList = new ArrayList<CmsResource>(publishList == null ? resourceList : publishList.getFolderList());
        for (int i = 0; i < resourceList.size(); ++i) {
            CmsResource res = (CmsResource)resourceList.get(i);
            try {
                CmsLock lock = this.getLock(dbc, res);
                if (lock.isPublish() || !lock.isLockableBy(dbc.currentUser()) && (!lock.isShared() || publishList == null || !res.getState().isDeleted() || !this.checkDeletedParentFolder(dbc, publishList.getDeletedFolderList(), res)) || !"/".equals(res.getRootPath()) && !this.checkParentResource(dbc, newFolderList, res)) continue;
                try {
                    this.m_securityManager.checkPermissions(dbc, res, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL);
                }
                catch (CmsException e) {
                    continue;
                }
                if (res.isFolder()) {
                    newFolderList.add(res);
                }
                result.add(res);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private List filterSiblings(CmsDbContext dbc, CmsPublishList publishList, Collection resourceList) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        Iterator i = resourceList.iterator();
        while (i.hasNext()) {
            CmsResource res = (CmsResource)i.next();
            try {
                CmsLock lock = this.getLock(dbc, res);
                if (lock.isPublish() || !lock.isLockableBy(dbc.currentUser()) && (!lock.isShared() || publishList == null || !res.getState().isDeleted() || !this.checkDeletedParentFolder(dbc, publishList.getDeletedFolderList(), res)) || !"/".equals(res.getRootPath()) && !this.checkParentResource(dbc, publishList.getFolderList(), res)) continue;
                try {
                    this.m_securityManager.checkPermissions(dbc, res, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL);
                }
                catch (CmsException e) {
                    continue;
                }
                result.add(res);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private CmsAccessControlList getAccessControlList(CmsDbContext dbc, CmsResource resource, boolean inheritedOnly, boolean forFolder, int depth) throws CmsException {
        String cacheKey = this.getCacheKey(new String[]{inheritedOnly ? "+" : "-", forFolder ? "+" : "-", Integer.toString(depth), resource.getStructureId().toString()}, dbc);
        CmsAccessControlList acl = OpenCms.getMemoryMonitor().getCachedACL(cacheKey);
        if (acl != null && dbc.getProjectId().isNullUUID()) {
            return acl;
        }
        List aces = this.m_userDriver.readAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId(), depth > 1 || depth > 0 && forFolder);
        boolean overwriteAll = this.sortAceList(aces);
        if (!overwriteAll) {
            CmsFolder parentResource;
            block10: {
                parentResource = null;
                try {
                    parentResource = this.m_vfsDriver.readParentFolder(dbc, dbc.currentProject().getUuid(), resource.getStructureId());
                }
                catch (CmsVfsResourceNotFoundException e) {
                    String parentPath = CmsResource.getParentFolder(resource.getRootPath());
                    if (parentPath == null) break block10;
                    parentResource = this.m_vfsDriver.readFolder(dbc, dbc.currentProject().getUuid(), parentPath);
                }
            }
            if (parentResource != null) {
                acl = (CmsAccessControlList)this.getAccessControlList(dbc, parentResource, inheritedOnly, forFolder, depth + 1).clone();
            }
        }
        if (acl == null) {
            acl = new CmsAccessControlList();
        }
        if (depth != 0 || !inheritedOnly) {
            Iterator itAces = aces.iterator();
            while (itAces.hasNext()) {
                CmsAccessControlEntry acEntry = (CmsAccessControlEntry)itAces.next();
                if (depth > 0) {
                    acEntry.setFlags(8);
                }
                acl.add(acEntry);
                if ((acEntry.getFlags() & 4) <= 0) continue;
                acl.setAllowedPermissions(acEntry);
            }
        }
        if (dbc.getProjectId().isNullUUID()) {
            OpenCms.getMemoryMonitor().cacheACL(cacheKey, acl);
        }
        return acl;
    }

    private String getCacheKey(String prefix, boolean flag, CmsUUID projectId, String resource) {
        StringBuffer b = new StringBuffer(64);
        if (prefix != null) {
            b.append(prefix);
            b.append(flag ? (char)'+' : '-');
        }
        b.append(CmsProject.isOnlineProject(projectId) ? (char)'+' : '-');
        return b.append(resource).toString();
    }

    private String getCacheKey(String[] keys, CmsDbContext dbc) {
        if (!dbc.getProjectId().isNullUUID()) {
            return "";
        }
        StringBuffer b = new StringBuffer(64);
        int len = keys.length;
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                b.append(keys[i]);
                b.append('_');
            }
        }
        if (dbc.currentProject().isOnlineProject()) {
            b.append("+");
        } else {
            b.append("-");
        }
        return b.toString();
    }

    private CmsUUID getProjectIdForContext(CmsDbContext dbc) {
        CmsUUID projectId = dbc.getProjectId();
        if (projectId.isNullUUID()) {
            projectId = dbc.currentProject().getUuid();
        }
        return projectId;
    }

    private int getUpdateState(CmsDbContext dbc, CmsResource resource, List properties) throws CmsDataAccessException {
        int updateState = 0;
        Iterator it = properties.iterator();
        while (it.hasNext() && updateState < 2) {
            CmsProperty property = (CmsProperty)it.next();
            CmsProperty existingProperty = this.m_vfsDriver.readPropertyObject(dbc, property.getName(), dbc.currentProject(), resource);
            if (property.getResourceValue() != null) {
                if (property.isDeleteResourceValue()) {
                    if (existingProperty.getResourceValue() != null) {
                        updateState = 2;
                    }
                } else if (existingProperty.getResourceValue() == null) {
                    updateState = 2;
                } else if (!property.getResourceValue().equals(existingProperty.getResourceValue())) {
                    updateState = 2;
                }
            }
            if (updateState != 0 || property.getStructureValue() == null) continue;
            if (property.isDeleteStructureValue()) {
                if (existingProperty.getStructureValue() == null) continue;
                updateState = 1;
                continue;
            }
            if (existingProperty.getStructureValue() == null) {
                updateState = 1;
                continue;
            }
            if (property.getStructureValue().equals(existingProperty.getStructureValue())) continue;
            updateState = 1;
        }
        return updateState;
    }

    private List getVirtualGroupsForRole(CmsDbContext dbc, CmsRole role) throws CmsException {
        HashSet<Integer> roleFlags = new HashSet<Integer>();
        Integer flags = new Integer(role.getVirtualGroupFlags());
        roleFlags.add(flags);
        Iterator itChildRoles = role.getChildren(true).iterator();
        while (itChildRoles.hasNext()) {
            CmsRole child = (CmsRole)itChildRoles.next();
            flags = new Integer(child.getVirtualGroupFlags());
            roleFlags.add(flags);
        }
        ArrayList<CmsGroup> groups = new ArrayList<CmsGroup>();
        Iterator it = this.getGroups(dbc, this.readOrganizationalUnit(dbc, role.getOuFqn()), false, false).iterator();
        while (it.hasNext()) {
            CmsRole r;
            CmsGroup group = (CmsGroup)it.next();
            if (!group.isVirtual() || !roleFlags.contains(new Integer((r = CmsRole.valueOf(group)).getVirtualGroupFlags()))) continue;
            groups.add(group);
        }
        return groups;
    }

    private List internalUsersOfGroup(CmsDbContext dbc, String ouFqn, String groupname, boolean includeOtherOuUsers, boolean directUsersOnly, boolean readRoles) throws CmsException {
        CmsGroup group = this.readGroup(dbc, groupname);
        if (group != null && (!readRoles && !group.isRole() || readRoles && group.isRole())) {
            String prefix = "_" + includeOtherOuUsers + "_" + directUsersOnly + "_" + ouFqn;
            String cacheKey = this.m_keyGenerator.getCacheKeyForGroupUsers(prefix, dbc, group);
            List allUsers = OpenCms.getMemoryMonitor().getCachedUserGroups(cacheKey);
            if (allUsers == null) {
                HashSet users = new HashSet(this.m_userDriver.readUsersOfGroup(dbc, groupname, includeOtherOuUsers));
                if (readRoles && !directUsersOnly) {
                    String parentOu;
                    block10: {
                        CmsRole role = CmsRole.valueOf(group);
                        if (role.getParentRole() != null) {
                            try {
                                String parentGroup = role.getParentRole().getGroupName();
                                this.readGroup(dbc, parentGroup);
                                users.addAll(this.internalUsersOfGroup(dbc, ouFqn, parentGroup, includeOtherOuUsers, directUsersOnly, readRoles));
                            }
                            catch (CmsDbEntryNotFoundException e) {
                                if (!LOG.isDebugEnabled()) break block10;
                                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    }
                    if ((parentOu = CmsOrganizationalUnit.getParentFqn(group.getOuFqn())) != null) {
                        users.addAll(this.internalUsersOfGroup(dbc, ouFqn, parentOu + group.getSimpleName(), includeOtherOuUsers, directUsersOnly, readRoles));
                    }
                    if (!includeOtherOuUsers) {
                        Iterator itUsers = users.iterator();
                        while (itUsers.hasNext()) {
                            CmsUser user = (CmsUser)itUsers.next();
                            if (user.getOuFqn().equals(ouFqn)) continue;
                            itUsers.remove();
                        }
                    }
                }
                allUsers = Collections.unmodifiableList(new ArrayList(users));
                if (dbc.getProjectId().isNullUUID()) {
                    OpenCms.getMemoryMonitor().cacheUserGroups(cacheKey, allUsers);
                }
            }
            return allUsers;
        }
        throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", groupname));
    }

    private List readChangedResourcesInsideProject(CmsDbContext dbc, CmsUUID projectId, CmsReadChangedProjectResourceMode mode) throws CmsException {
        String cacheKey = projectId + "_" + mode.toString();
        ArrayList<CmsResource> result = OpenCms.getMemoryMonitor().getCachedProjectResources(cacheKey);
        if (result != null) {
            return result;
        }
        List projectResources = this.readProjectResources(dbc, this.readProject(dbc, projectId));
        result = new ArrayList<CmsResource>();
        String currentProjectResource = null;
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        CmsResource currentResource = null;
        CmsLock currentLock = null;
        for (int i = 0; i < projectResources.size(); ++i) {
            currentProjectResource = (String)projectResources.get(i);
            try {
                currentResource = this.readResource(dbc, currentProjectResource, CmsResourceFilter.ALL);
                if (currentResource.isFolder()) {
                    resources.addAll(this.readResources(dbc, currentResource, CmsResourceFilter.ALL, true));
                    continue;
                }
                resources.add(currentResource);
                continue;
            }
            catch (CmsException e) {
                if (e instanceof CmsVfsResourceNotFoundException) continue;
                throw e;
            }
        }
        for (int j = 0; j < resources.size(); ++j) {
            currentResource = (CmsResource)resources.get(j);
            currentLock = this.getLock(dbc, currentResource).getEditionLock();
            if (currentResource.getState().isUnchanged() || (!currentLock.isNullLock() || !currentResource.getProjectLastModified().equals(projectId)) && (!currentLock.isOwnedBy(dbc.currentUser()) || !currentLock.getProjectId().equals(projectId)) || mode != RCPRM_FILES_AND_FOLDERS_MODE && (!currentResource.isFolder() || mode != RCPRM_FOLDERS_ONLY_MODE) && (!currentResource.isFile() || mode != RCPRM_FILES_ONLY_MODE)) continue;
            result.add(currentResource);
        }
        resources.clear();
        resources = null;
        OpenCms.getMemoryMonitor().cacheProjectResources(cacheKey, result);
        return result;
    }

    private boolean sortAceList(List aces) {
        Collections.sort(aces, CmsAccessControlEntry.COMPARATOR_ACE);
        for (int i = 0; i < Math.min(aces.size(), 2); ++i) {
            CmsAccessControlEntry acEntry = (CmsAccessControlEntry)aces.get(i);
            if (!acEntry.getPrincipal().equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID)) continue;
            return true;
        }
        return false;
    }

    private void transferPrincipalResources(CmsDbContext dbc, CmsProject project, CmsUUID principalId, CmsUUID replacementId, boolean withACEs) throws CmsException {
        Set resources = this.getResourcesForPrincipal(dbc, project, principalId, null, true);
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            CmsResource resource = (CmsResource)it.next();
            boolean attrModified = false;
            CmsUUID createdUser = null;
            if (resource.getUserCreated().equals(principalId)) {
                createdUser = replacementId;
                attrModified = true;
            }
            CmsUUID lastModUser = null;
            if (resource.getUserLastModified().equals(principalId)) {
                lastModUser = replacementId;
                attrModified = true;
            }
            if (attrModified) {
                this.m_vfsDriver.transferResource(dbc, project, resource, createdUser, lastModUser);
                OpenCms.getMemoryMonitor().clearResourceCache();
            }
            boolean aceModified = false;
            if (withACEs) {
                Iterator itAces = this.m_userDriver.readAccessControlEntries(dbc, project, resource.getResourceId(), false).iterator();
                while (itAces.hasNext()) {
                    CmsAccessControlEntry ace = (CmsAccessControlEntry)itAces.next();
                    if (!ace.getPrincipal().equals(principalId)) continue;
                    CmsAccessControlEntry newAce = new CmsAccessControlEntry(ace.getResource(), replacementId, ace.getAllowedPermissions(), ace.getDeniedPermissions(), ace.getFlags());
                    this.m_userDriver.writeAccessControlEntry(dbc, project, newAce);
                    aceModified = true;
                }
                if (aceModified) {
                    OpenCms.getMemoryMonitor().clearAccessControlListCache();
                }
            }
            if (!attrModified && !aceModified) continue;
            HashMap<String, Comparable> data = new HashMap<String, Comparable>(2);
            data.put("resource", resource);
            data.put("change", new Integer((attrModified ? 8 : 0) | (aceModified ? 1 : 0)));
            OpenCms.fireCmsEvent(new CmsEvent(11, data));
        }
    }

    private void undoContentChanges(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource, CmsResource onlineResource, CmsResourceState newState, boolean moveUndone) throws CmsException {
        String path;
        String string = path = moveUndone || offlineResource == null ? onlineResource.getRootPath() : offlineResource.getRootPath();
        if (onlineResource.isFolder()) {
            CmsFolder restoredFolder = new CmsFolder(onlineResource.getStructureId(), onlineResource.getResourceId(), path, onlineResource.getTypeId(), onlineResource.getFlags(), dbc.currentProject().getUuid(), newState, onlineResource.getDateCreated(), onlineResource.getUserCreated(), onlineResource.getDateLastModified(), onlineResource.getUserLastModified(), onlineResource.getDateReleased(), onlineResource.getDateExpired(), onlineResource.getVersion());
            restoredFolder.setDateLastModified(onlineResource.getDateLastModified());
            this.m_vfsDriver.writeResource(dbc, dbc.currentProject().getUuid(), restoredFolder, 0);
            this.m_vfsDriver.deletePropertyObjects(dbc, dbc.currentProject().getUuid(), restoredFolder, 1);
            List propertyInfos = this.m_vfsDriver.readPropertyObjects(dbc, onlineProject, onlineResource);
            this.m_vfsDriver.writePropertyObjects(dbc, dbc.currentProject(), restoredFolder, propertyInfos);
            this.m_userDriver.removeAccessControlEntries(dbc, dbc.currentProject(), onlineResource.getResourceId());
            ListIterator aceList = this.m_userDriver.readAccessControlEntries(dbc, onlineProject, onlineResource.getResourceId(), false).listIterator();
            while (aceList.hasNext()) {
                CmsAccessControlEntry ace = (CmsAccessControlEntry)aceList.next();
                this.m_userDriver.createAccessControlEntry(dbc, dbc.currentProject(), onlineResource.getResourceId(), ace.getPrincipal(), ace.getPermissions().getAllowedPermissions(), ace.getPermissions().getDeniedPermissions(), ace.getFlags());
            }
        } else {
            byte[] onlineContent = this.m_vfsDriver.readContent(dbc, CmsProject.ONLINE_PROJECT_ID, onlineResource.getResourceId());
            CmsFile restoredFile = new CmsFile(onlineResource.getStructureId(), onlineResource.getResourceId(), path, onlineResource.getTypeId(), onlineResource.getFlags(), dbc.currentProject().getUuid(), newState, onlineResource.getDateCreated(), onlineResource.getUserCreated(), onlineResource.getDateLastModified(), onlineResource.getUserLastModified(), onlineResource.getDateReleased(), onlineResource.getDateExpired(), 0, onlineResource.getLength(), onlineResource.getDateContent(), onlineResource.getVersion(), onlineContent);
            restoredFile.setDateLastModified(onlineResource.getDateLastModified());
            List properties = this.m_vfsDriver.readPropertyObjects(dbc, onlineProject, onlineResource);
            if (offlineResource != null) {
                this.m_vfsDriver.deletePropertyObjects(dbc, dbc.currentProject().getUuid(), onlineResource, 1);
                this.deleteResource(dbc, offlineResource, CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
            CmsResource res = this.createResource(dbc, restoredFile.getRootPath(), restoredFile, restoredFile.getContents(), properties, false);
            if (offlineResource != null) {
                this.m_userDriver.removeAccessControlEntries(dbc, dbc.currentProject(), onlineResource.getResourceId());
            }
            ListIterator aceList = this.m_userDriver.readAccessControlEntries(dbc, onlineProject, onlineResource.getResourceId(), false).listIterator();
            while (aceList.hasNext()) {
                CmsAccessControlEntry ace = (CmsAccessControlEntry)aceList.next();
                this.m_userDriver.createAccessControlEntry(dbc, dbc.currentProject(), res.getResourceId(), ace.getPrincipal(), ace.getPermissions().getAllowedPermissions(), ace.getPermissions().getDeniedPermissions(), ace.getFlags());
            }
            res.setState(newState);
            this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), res, 3, false);
        }
        this.m_vfsDriver.deleteRelations(dbc, dbc.currentProject().getUuid(), offlineResource, CmsRelationFilter.TARGETS);
        List relations = this.m_vfsDriver.readRelations(dbc, CmsProject.ONLINE_PROJECT_ID, onlineResource, CmsRelationFilter.TARGETS);
        Iterator itRelations = relations.iterator();
        while (itRelations.hasNext()) {
            CmsRelation relation = (CmsRelation)itRelations.next();
            this.m_vfsDriver.createRelation(dbc, dbc.currentProject().getUuid(), relation);
        }
        OpenCms.getMemoryMonitor().clearResourceCache();
        OpenCms.getMemoryMonitor().flushProperties();
        OpenCms.getMemoryMonitor().flushPropertyLists();
        if (offlineResource != null) {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", offlineResource)));
        } else {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", onlineResource)));
        }
    }

    private void updateContextDates(CmsDbContext dbc, CmsResource resource) {
        CmsFlexRequestContextInfo info = dbc.getFlexRequestContextInfo();
        if (info != null) {
            info.updateFromResource(resource);
        }
    }

    private List updateContextDates(CmsDbContext dbc, List resourceList) {
        CmsFlexRequestContextInfo info = dbc.getFlexRequestContextInfo();
        if (info != null) {
            for (int i = 0; i < resourceList.size(); ++i) {
                CmsResource resource = (CmsResource)resourceList.get(i);
                info.updateFromResource(resource);
            }
        }
        return resourceList;
    }

    private List updateContextDates(CmsDbContext dbc, List resourceList, CmsResourceFilter filter) {
        if (CmsResourceFilter.ALL == filter) {
            if (resourceList instanceof ArrayList) {
                return (List)((ArrayList)this.updateContextDates(dbc, resourceList)).clone();
            }
            return new ArrayList(this.updateContextDates(dbc, resourceList));
        }
        CmsFlexRequestContextInfo info = dbc.getFlexRequestContextInfo();
        ArrayList<CmsResource> result = new ArrayList<CmsResource>(resourceList.size());
        for (int i = 0; i < resourceList.size(); ++i) {
            CmsResource resource = (CmsResource)resourceList.get(i);
            if (filter.isValid(dbc.getRequestContext(), resource)) {
                result.add(resource);
            }
            if (info == null) continue;
            info.updateFromResource(resource);
        }
        return result;
    }

    private void updateState(CmsDbContext dbc, CmsResource resource, boolean resourceState) throws CmsDataAccessException {
        resource.setUserLastModified(dbc.currentUser().getId());
        if (resourceState) {
            this.m_vfsDriver.writeResource(dbc, dbc.currentProject().getUuid(), resource, 1);
        } else {
            this.m_vfsDriver.writeResource(dbc, dbc.currentProject().getUuid(), resource, 2);
        }
    }

    private static class CmsReadChangedProjectResourceMode {
        protected CmsReadChangedProjectResourceMode() {
        }
    }
}

