/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import org.opencms.main.OpenCms;

public class CmsExportPoint {
    private String m_configuredDestination;
    private String m_destinationPath;
    private String m_uri;

    public CmsExportPoint() {
        this.m_uri = "";
        this.m_configuredDestination = "";
        this.m_destinationPath = "";
    }

    public CmsExportPoint(String uri, String destination) {
        this.m_uri = uri;
        this.m_configuredDestination = destination;
        this.m_destinationPath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebApplication(destination);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsExportPoint) {
            return ((CmsExportPoint)obj).m_uri.equals(this.m_uri);
        }
        return false;
    }

    public String getConfiguredDestination() {
        return this.m_configuredDestination;
    }

    public String getDestinationPath() {
        return this.m_destinationPath;
    }

    public String getUri() {
        return this.m_uri;
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }

    public void setConfiguredDestination(String value) {
        this.m_configuredDestination = value;
        this.m_destinationPath = OpenCms.getSystemInfo().getAbsoluteRfsPathRelativeToWebApplication(this.m_configuredDestination);
    }

    public void setDestinationPath(String value) {
        if (value == null) {
            // empty if block
        }
    }

    public void setUri(String value) {
        this.m_uri = value;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ", uri: " + this.m_uri + ", destination: " + this.m_destinationPath + "]";
    }
}

