/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsExportPoint;
import org.opencms.db.Messages;
import org.opencms.main.CmsLog;

public class CmsExportPointDriver {
    private static final Log LOG = CmsLog.getLog(CmsExportPointDriver.class);
    private HashMap m_exportpointLookupMap;
    private Set m_exportpoints;

    public CmsExportPointDriver(Set exportpoints) {
        this.m_exportpoints = exportpoints;
        this.m_exportpointLookupMap = new HashMap();
        Iterator i = this.m_exportpoints.iterator();
        while (i.hasNext()) {
            CmsExportPoint point = (CmsExportPoint)i.next();
            if (point.getDestinationPath() == null) continue;
            this.m_exportpointLookupMap.put(point.getUri(), point.getDestinationPath());
        }
    }

    public void createFolder(String resourceName, String exportpoint) {
        this.writeResource(resourceName, exportpoint, null);
    }

    public void deleteResource(String resourceName, String exportpoint) {
        File file = this.getExportPointFile(resourceName, exportpoint);
        if (file.exists() && file.canWrite()) {
            file.delete();
            File parent = file.getParentFile();
            if (parent.canWrite()) {
                parent.delete();
            }
        }
    }

    public String getExportPoint(String rootPath) {
        Iterator i = this.getExportPointPaths().iterator();
        while (i.hasNext()) {
            String point = (String)i.next();
            if (!rootPath.startsWith(point)) continue;
            return point;
        }
        return null;
    }

    public Set getExportPointPaths() {
        return this.m_exportpointLookupMap.keySet();
    }

    public void writeFile(String resourceName, String exportpoint, byte[] content) {
        this.writeResource(resourceName, exportpoint, content);
    }

    private File getExportPointFile(String rootPath, String exportpoint) {
        StringBuffer exportpath = new StringBuffer(128);
        exportpath.append((String)this.m_exportpointLookupMap.get(exportpoint));
        exportpath.append(rootPath.substring(exportpoint.length()));
        return new File(exportpath.toString());
    }

    private void writeResource(String resourceName, String exportpoint, byte[] content) {
        File file = this.getExportPointFile(resourceName, exportpoint);
        try {
            boolean success;
            File folder = content == null ? file : file.getParentFile();
            if (!folder.exists() && !(success = folder.mkdirs())) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_CREATE_FOLDER_FAILED_1", folder.getAbsolutePath()));
            }
            if (content != null) {
                FileOutputStream s = new FileOutputStream(file);
                ((OutputStream)s).write(content);
                ((OutputStream)s).close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_WRITE_EXPORT_POINT_FAILED_1", file.getAbsolutePath()), (Throwable)e);
        }
    }
}

