/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.generic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbIoException;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsDriverManager;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.db.I_CmsDriver;
import org.opencms.db.I_CmsProjectDriver;
import org.opencms.db.generic.CmsSqlManager;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryFile;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsProjectDriver
implements I_CmsDriver,
I_CmsProjectDriver {
    private static final Log LOG = CmsLog.getLog(CmsProjectDriver.class);
    protected CmsDriverManager m_driverManager;
    protected CmsSqlManager m_sqlManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsProject createProject(CmsDbContext dbc, CmsUUID id, CmsUser owner, CmsGroup group, CmsGroup managergroup, String projectFqn, String description, int flags, CmsProject.CmsProjectType type) throws CmsDataAccessException {
        CmsProject project = null;
        if (description == null || description.length() < 1) {
            description = " ";
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_CREATE_10");
            stmt.setString(1, id.toString());
            stmt.setString(2, owner.getId().toString());
            stmt.setString(3, group.getId().toString());
            stmt.setString(4, managergroup.getId().toString());
            stmt.setString(5, CmsOrganizationalUnit.getSimpleName(projectFqn));
            stmt.setString(6, description);
            stmt.setInt(7, flags);
            stmt.setInt(9, type.getMode());
            stmt.setString(10, "/" + CmsOrganizationalUnit.getParentFqn(projectFqn));
            CmsProjectDriver cmsProjectDriver = this;
            synchronized (cmsProjectDriver) {
                long createTime = System.currentTimeMillis();
                stmt.setLong(8, createTime);
                stmt.executeUpdate();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                project = new CmsProject(id, projectFqn, description, owner.getId(), group.getId(), managergroup.getId(), flags, createTime, type);
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        return project;
    }

    public void createProjectResource(CmsDbContext dbc, CmsUUID projectId, String resourcePath) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        boolean projectResourceExists = false;
        try {
            this.readProjectResource(dbc, projectId, resourcePath);
            projectResourceExists = true;
        }
        catch (CmsVfsResourceNotFoundException e) {
            projectResourceExists = false;
        }
        if (projectResourceExists) {
            throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", dbc.removeSiteRoot(resourcePath)));
        }
        try {
            conn = this.getSqlManager().getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTRESOURCES_CREATE_2");
            stmt.setString(1, projectId.toString());
            stmt.setString(2, resourcePath);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createPublishJob(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            CmsPublishJobInfoBean currentJob = this.readPublishJob(dbc, publishJob.getPublishHistoryId());
            LOG.error((Object)("wanted to write: " + publishJob));
            LOG.error((Object)("already on db: " + currentJob));
            return;
        }
        catch (CmsDbEntryNotFoundException e) {
            try {
                conn = this.m_sqlManager.getConnection(dbc);
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PUBLISHJOB_CREATE");
                stmt.setString(1, publishJob.getPublishHistoryId().toString());
                stmt.setString(2, publishJob.getProjectId().toString());
                stmt.setString(3, publishJob.getProjectName());
                stmt.setString(4, publishJob.getUserId().toString());
                stmt.setString(5, publishJob.getLocale().toString());
                stmt.setInt(6, publishJob.getFlags());
                stmt.setInt(7, publishJob.getSize());
                stmt.setLong(8, publishJob.getEnqueueTime());
                stmt.setLong(9, publishJob.getStartTime());
                stmt.setLong(10, publishJob.getFinishTime());
                byte[] publishList = this.internalSerializePublishList(publishJob.getPublishList());
                if (publishList.length < 2000) {
                    stmt.setBytes(11, publishList);
                } else {
                    stmt.setBinaryStream(11, (InputStream)new ByteArrayInputStream(publishList), publishList.length);
                }
                stmt.executeUpdate();
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                return;
            }
            catch (SQLException e2) {
                try {
                    throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e2);
                    catch (IOException e3) {
                        throw new CmsDbIoException(Messages.get().container("ERR_SERIALIZING_PUBLISHLIST_1", publishJob.getPublishHistoryId().toString()), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                    throw throwable;
                }
            }
        }
    }

    public void deleteAllStaticExportPublishedResources(CmsDbContext dbc, int linkType) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STATICEXPORT_DELETE_ALL_PUBLISHED_LINKS");
            stmt.setInt(1, linkType);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void deleteProject(CmsDbContext dbc, CmsProject project) throws CmsDataAccessException {
        this.deleteProjectResources(dbc, project);
        this.unmarkProjectResources(dbc, project);
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_DELETE_1");
            stmt.setString(1, project.getUuid().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void deleteProjectResource(CmsDbContext dbc, CmsUUID projectId, String resourceName) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTRESOURCES_DELETE_2");
            stmt.setString(1, projectId.toString());
            stmt.setString(2, resourceName);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void deleteProjectResources(CmsDbContext dbc, CmsProject project) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTRESOURCES_DELETEALL_1");
            stmt.setString(1, project.getUuid().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void deletePublishHistory(CmsDbContext dbc, CmsUUID projectId, int maxpublishTag) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, projectId, "C_DELETE_PUBLISH_HISTORY");
            stmt.setInt(1, maxpublishTag);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void deletePublishHistoryEntry(CmsDbContext dbc, CmsUUID publishHistoryId, CmsPublishedResource publishedResource) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_DELETE_PUBLISH_HISTORY_ENTRY");
            stmt.setString(1, publishHistoryId.toString());
            stmt.setInt(2, publishedResource.getPublishTag());
            stmt.setString(3, publishedResource.getStructureId().toString());
            stmt.setString(4, publishedResource.getRootPath());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void deletePublishJob(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PUBLISHJOB_DELETE");
            stmt.setString(1, publishHistoryId.toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void deletePublishList(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PUBLISHJOB_DELETE_PUBLISHLIST");
            stmt.setString(1, publishHistoryId.toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void deleteStaticExportPublishedResource(CmsDbContext dbc, String resourceName, int linkType, String linkParameter) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STATICEXPORT_DELETE_PUBLISHED_LINKS");
            stmt.setString(1, resourceName);
            stmt.setInt(2, linkType);
            stmt.setString(3, linkParameter);
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void destroy() throws Throwable {
        this.m_sqlManager = null;
        this.m_driverManager = null;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SHUTDOWN_DRIVER_1", this.getClass().getName()));
        }
    }

    public void fillDefaults(CmsDbContext dbc) throws CmsDataAccessException {
        try {
            if (this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID) != null) {
                return;
            }
        }
        catch (CmsDataAccessException exc) {
            // empty catch block
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_FILL_DEFAULTS_0"));
        }
        String adminUser = OpenCms.getDefaultUsers().getUserAdmin();
        CmsUser admin = this.m_driverManager.readUser(dbc, adminUser);
        String administratorsGroup = OpenCms.getDefaultUsers().getGroupAdministrators();
        CmsGroup administrators = this.m_driverManager.readGroup(dbc, administratorsGroup);
        String usersGroup = OpenCms.getDefaultUsers().getGroupUsers();
        CmsGroup users = this.m_driverManager.readGroup(dbc, usersGroup);
        String projectmanagersGroup = OpenCms.getDefaultUsers().getGroupProjectmanagers();
        CmsGroup projectmanager = this.m_driverManager.readGroup(dbc, projectmanagersGroup);
        CmsProject onlineProject = this.createProject(dbc, CmsProject.ONLINE_PROJECT_ID, admin, users, projectmanager, "Online", "The Online project", 0, CmsProject.PROJECT_TYPE_NORMAL);
        CmsFolder rootFolder = new CmsFolder(new CmsUUID(), new CmsUUID(), "/", 0, 0, onlineProject.getUuid(), CmsResource.STATE_CHANGED, 0L, admin.getId(), 0L, admin.getId(), 0L, Long.MAX_VALUE, 0);
        this.m_driverManager.getVfsDriver().createResource(dbc, onlineProject.getUuid(), rootFolder, null);
        this.m_driverManager.getProjectDriver().createProjectResource(dbc, onlineProject.getUuid(), rootFolder.getRootPath());
        CmsFolder systemFolder = new CmsFolder(new CmsUUID(), new CmsUUID(), "/system", 0, 0, onlineProject.getUuid(), CmsResource.STATE_CHANGED, 0L, admin.getId(), 0L, admin.getId(), 0L, Long.MAX_VALUE, 0);
        this.m_driverManager.getVfsDriver().createResource(dbc, onlineProject.getUuid(), systemFolder, null);
        CmsProject setupProject = this.m_driverManager.getProjectDriver().createProject(dbc, CmsUUID.getConstantUUID("_setupProject"), admin, administrators, administrators, "_setupProject", "The Project for the initial import", 0, CmsProject.PROJECT_TYPE_TEMPORARY);
        rootFolder.setState(CmsResource.STATE_CHANGED);
        CmsResource offlineRootFolder = this.m_driverManager.getVfsDriver().createResource(dbc, setupProject.getUuid(), rootFolder, null);
        offlineRootFolder.setState(CmsResource.STATE_UNCHANGED);
        this.m_driverManager.getVfsDriver().writeResource(dbc, setupProject.getUuid(), offlineRootFolder, 0);
        this.m_driverManager.getProjectDriver().createProjectResource(dbc, setupProject.getUuid(), offlineRootFolder.getRootPath());
        systemFolder.setState(CmsResource.STATE_CHANGED);
        CmsResource offlineSystemFolder = this.m_driverManager.getVfsDriver().createResource(dbc, setupProject.getUuid(), systemFolder, null);
        offlineSystemFolder.setState(CmsResource.STATE_UNCHANGED);
        this.m_driverManager.getVfsDriver().writeResource(dbc, setupProject.getUuid(), offlineSystemFolder, 0);
    }

    public CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    public void init(CmsDbContext dbc, CmsConfigurationManager configurationManager, List successiveDrivers, CmsDriverManager driverManager) {
        Map configuration = configurationManager.getConfiguration();
        String poolUrl = configuration.get("db.project.pool").toString();
        String classname = configuration.get("db.project.sqlmanager").toString();
        this.m_sqlManager = this.initSqlManager(classname);
        this.m_sqlManager.init(1, poolUrl);
        this.m_driverManager = driverManager;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ASSIGNED_POOL_1", poolUrl));
        }
        if (successiveDrivers != null && !successiveDrivers.isEmpty() && LOG.isWarnEnabled()) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_SUCCESSIVE_DRIVERS_UNSUPPORTED_1", this.getClass().getName()));
        }
    }

    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishDeletedFolder(CmsDbContext dbc, I_CmsReport report, int m, int n, CmsProject onlineProject, CmsFolder currentFolder, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        try {
            report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
            report.print(Messages.get().container("RPT_DELETE_FOLDER_0"), 3);
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(currentFolder.getRootPath())));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            CmsResourceState folderState = this.fixMovedResource(dbc, onlineProject, currentFolder, publishHistoryId, publishTag);
            CmsFolder onlineFolder = this.m_driverManager.readFolder(dbc, currentFolder.getRootPath(), CmsResourceFilter.ALL);
            this.internalWriteHistory(dbc, currentFolder, folderState, null, publishHistoryId, publishTag);
            try {
                this.m_driverManager.getVfsDriver().deletePropertyObjects(dbc, onlineProject.getUuid(), onlineFolder, 1);
                this.m_driverManager.getVfsDriver().deletePropertyObjects(dbc, dbc.currentProject().getUuid(), currentFolder, 1);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_DELETING_PROPERTIES_1", currentFolder.getRootPath()), (Throwable)e);
                }
                throw e;
            }
            try {
                this.m_driverManager.getVfsDriver().removeFolder(dbc, dbc.currentProject(), currentFolder);
                this.m_driverManager.getVfsDriver().removeFolder(dbc, onlineProject, currentFolder);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_RESOURCE_1", currentFolder.getRootPath()), (Throwable)e);
                }
                throw e;
            }
            try {
                this.m_driverManager.getUserDriver().removeAccessControlEntries(dbc, onlineProject, onlineFolder.getResourceId());
                this.m_driverManager.getUserDriver().removeAccessControlEntries(dbc, dbc.currentProject(), currentFolder.getResourceId());
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_ACL_1", currentFolder.getRootPath()), (Throwable)e);
                }
                throw e;
            }
            try {
                this.m_driverManager.getVfsDriver().deleteRelations(dbc, onlineProject.getUuid(), onlineFolder, CmsRelationFilter.TARGETS);
                this.m_driverManager.getVfsDriver().deleteRelations(dbc, dbc.currentProject().getUuid(), currentFolder, CmsRelationFilter.TARGETS);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_RELATIONS_1", currentFolder.getRootPath()), (Throwable)e);
                }
                throw e;
            }
            report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DEL_FOLDER_3", currentFolder.getRootPath(), String.valueOf(m), String.valueOf(n)));
            }
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", currentFolder)));
        }
    }

    public void publishFile(CmsDbContext dbc, I_CmsReport report, int m, int n, CmsProject onlineProject, CmsResource offlineResource, Set publishedContentIds, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        try {
            report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
            if (offlineResource.getState().isDeleted()) {
                report.print(Messages.get().container("RPT_DELETE_FILE_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(offlineResource.getRootPath())));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.publishDeletedFile(dbc, onlineProject, offlineResource, publishHistoryId, publishTag);
                dbc.pop();
                this.m_driverManager.getHistoryDriver().deleteEntries(dbc, new CmsHistoryFile(offlineResource), OpenCms.getSystemInfo().getHistoryVersionsAfterDeletion(), -1L);
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_DEL_FILE_3", String.valueOf(m), String.valueOf(n), offlineResource.getRootPath()));
                }
            } else if (offlineResource.getState().isChanged()) {
                report.print(Messages.get().container("RPT_PUBLISH_FILE_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(offlineResource.getRootPath())));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.publishChangedFile(dbc, onlineProject, offlineResource, publishedContentIds, publishHistoryId, publishTag);
                dbc.pop();
                this.m_driverManager.getHistoryDriver().deleteEntries(dbc, new CmsHistoryFile(offlineResource), OpenCms.getSystemInfo().getHistoryVersions(), -1L);
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FILE_3", offlineResource.getRootPath(), String.valueOf(m), String.valueOf(n)));
                }
            } else if (offlineResource.getState().isNew()) {
                report.print(Messages.get().container("RPT_PUBLISH_FILE_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(offlineResource.getRootPath())));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                this.publishNewFile(dbc, onlineProject, offlineResource, publishedContentIds, publishHistoryId, publishTag);
                dbc.pop();
                this.m_driverManager.getHistoryDriver().deleteEntries(dbc, new CmsHistoryFile(offlineResource), OpenCms.getSystemInfo().getHistoryVersions(), -1L);
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FILE_3", offlineResource.getRootPath(), String.valueOf(m), String.valueOf(n)));
                }
            } else {
                report.print(Messages.get().container("RPT_PUBLISH_FILE_0"), 3);
                report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(offlineResource.getRootPath())));
                report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FILE_3", String.valueOf(m), String.valueOf(n), offlineResource));
                }
            }
        }
        catch (CmsException e) {
            throw new CmsDataAccessException(e.getMessageContainer(), (Throwable)e);
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", offlineResource)));
        }
    }

    public CmsFile publishFileContent(CmsDbContext dbc, CmsProject offlineProject, CmsProject onlineProject, CmsResource offlineResource, Set publishedResourceIds, boolean needToUpdateContent, int publishTag) throws CmsDataAccessException {
        CmsFile newFile = null;
        try {
            CmsUUID projectId = dbc.getProjectId();
            dbc.setProjectId(CmsUUID.getNullUUID());
            byte[] offlineContent = this.m_driverManager.getVfsDriver().readContent(dbc, offlineProject.getUuid(), offlineResource.getResourceId());
            CmsFile offlineFile = new CmsFile(offlineResource);
            offlineFile.setContents(offlineContent);
            dbc.setProjectId(projectId);
            newFile = (CmsFile)offlineFile.clone();
            newFile.setState(CmsResource.STATE_UNCHANGED);
            boolean createSibling = true;
            if (!offlineFile.getState().isNew()) {
                createSibling = false;
            } else if (!this.m_driverManager.getVfsDriver().validateResourceIdExists(dbc, onlineProject.getUuid(), offlineFile.getResourceId())) {
                createSibling = false;
            }
            boolean alreadyPublished = publishedResourceIds.contains(offlineResource.getResourceId());
            needToUpdateContent &= !alreadyPublished;
            if (createSibling) {
                if (!alreadyPublished) {
                    this.m_driverManager.getVfsDriver().createResource(dbc, onlineProject.getUuid(), newFile, null);
                } else {
                    this.m_driverManager.getVfsDriver().createSibling(dbc, onlineProject, offlineResource);
                }
                newFile = new CmsFile(offlineResource);
                newFile.setContents(offlineContent);
            } else {
                this.m_driverManager.getVfsDriver().publishResource(dbc, onlineProject, newFile, offlineFile);
            }
            this.m_driverManager.getVfsDriver().publishVersions(dbc, offlineResource, !alreadyPublished);
            this.m_driverManager.getVfsDriver().createOnlineContent(dbc, offlineFile.getResourceId(), offlineFile.getContents(), publishTag, true, needToUpdateContent);
            publishedResourceIds.add(offlineResource.getResourceId());
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FILE_CONTENT_1", offlineResource.toString()), (Throwable)e);
            }
            throw e;
        }
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishFolder(CmsDbContext dbc, I_CmsReport report, int m, int n, CmsProject onlineProject, CmsFolder offlineFolder, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        try {
            report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
            report.print(Messages.get().container("RPT_PUBLISH_FOLDER_0"), 3);
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(offlineFolder.getRootPath())));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            CmsResourceState resourceState = this.fixMovedResource(dbc, onlineProject, offlineFolder, publishHistoryId, publishTag);
            CmsResource onlineFolder = null;
            if (offlineFolder.getState().isNew()) {
                try {
                    CmsFolder newFolder = (CmsFolder)offlineFolder.clone();
                    newFolder.setState(CmsResource.STATE_UNCHANGED);
                    onlineFolder = this.m_driverManager.getVfsDriver().createResource(dbc, onlineProject.getUuid(), newFolder, null);
                    this.m_driverManager.getVfsDriver().publishResource(dbc, onlineProject, onlineFolder, offlineFolder);
                    this.m_driverManager.getVfsDriver().publishVersions(dbc, offlineFolder, true);
                }
                catch (CmsVfsResourceAlreadyExistsException e) {
                    if (!offlineFolder.getRootPath().equals("/") && !offlineFolder.getRootPath().equals("/system/") && LOG.isWarnEnabled()) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_WARN_FOLDER_WRONG_STATE_CN_1", offlineFolder.getRootPath()));
                    }
                    try {
                        onlineFolder = this.m_driverManager.getVfsDriver().readFolder(dbc, onlineProject.getUuid(), offlineFolder.getRootPath());
                        this.m_driverManager.getVfsDriver().publishResource(dbc, onlineProject, onlineFolder, offlineFolder);
                        this.m_driverManager.getVfsDriver().publishVersions(dbc, offlineFolder, true);
                    }
                    catch (CmsDataAccessException e1) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("LOG_READING_RESOURCE_1", offlineFolder.getRootPath()), (Throwable)e);
                        }
                        throw e1;
                    }
                }
                catch (CmsDataAccessException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineFolder.getRootPath()), (Throwable)e);
                    }
                    throw e;
                }
            } else if (offlineFolder.getState().isChanged()) {
                try {
                    onlineFolder = this.m_driverManager.getVfsDriver().readFolder(dbc, onlineProject.getUuid(), offlineFolder.getStructureId());
                }
                catch (CmsVfsResourceNotFoundException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_WARN_FOLDER_WRONG_STATE_NC_1", offlineFolder.getRootPath()));
                    }
                    try {
                        onlineFolder = this.m_driverManager.getVfsDriver().createResource(dbc, onlineProject.getUuid(), offlineFolder, null);
                        this.internalResetResourceState(dbc, onlineFolder);
                    }
                    catch (CmsDataAccessException e1) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineFolder.getRootPath()), (Throwable)e);
                        }
                        throw e1;
                    }
                }
                try {
                    this.m_driverManager.getVfsDriver().publishResource(dbc, onlineProject, onlineFolder, offlineFolder);
                    this.m_driverManager.getVfsDriver().publishVersions(dbc, offlineFolder, true);
                }
                catch (CmsDataAccessException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineFolder.getRootPath()), (Throwable)e);
                    }
                    throw e;
                }
            }
            if (onlineFolder != null) {
                try {
                    this.m_driverManager.getUserDriver().publishAccessControlEntries(dbc, dbc.currentProject(), onlineProject, offlineFolder.getResourceId(), onlineFolder.getResourceId());
                }
                catch (CmsDataAccessException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_ACL_1", offlineFolder.getRootPath()), (Throwable)e);
                    }
                    throw e;
                }
            }
            List offlineProperties = null;
            try {
                this.m_driverManager.getVfsDriver().deletePropertyObjects(dbc, onlineProject.getUuid(), onlineFolder, 1);
                offlineProperties = this.m_driverManager.getVfsDriver().readPropertyObjects(dbc, dbc.currentProject(), offlineFolder);
                CmsProperty.setAutoCreatePropertyDefinitions(offlineProperties, true);
                this.m_driverManager.getVfsDriver().writePropertyObjects(dbc, onlineProject, onlineFolder, offlineProperties);
            }
            catch (CmsDataAccessException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_PROPERTIES_1", offlineFolder.getRootPath()), (Throwable)e);
                }
                throw e;
            }
            this.internalWriteHistory(dbc, offlineFolder, resourceState, offlineProperties, publishHistoryId, publishTag);
            this.m_driverManager.getVfsDriver().updateRelations(dbc, onlineProject, offlineFolder);
            report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FOLDER_3", String.valueOf(m), String.valueOf(n), offlineFolder.getRootPath()));
            }
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", offlineFolder)));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publishProject(CmsDbContext dbc, I_CmsReport report, CmsProject onlineProject, CmsPublishList publishList, int publishTag) throws CmsException {
        int publishedFileCount;
        int deletedFolderCount;
        int publishedFolderCount;
        block33: {
            block32: {
                publishedFolderCount = 0;
                deletedFolderCount = 0;
                publishedFileCount = 0;
                HashSet publishedContentIds = new HashSet();
                try {
                    try {
                        List deletedFolders;
                        if (OpenCms.getSystemInfo().isHistoryEnabled()) {
                            try {
                                this.m_driverManager.getHistoryDriver().writeProject(dbc, publishTag, System.currentTimeMillis());
                                dbc.pop();
                            }
                            catch (Throwable t) {
                                dbc.report(report, Messages.get().container("ERR_WRITING_HISTORY_OF_PROJECT_1", dbc.currentProject().getName()), t);
                            }
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)Messages.get().getBundle().key("LOG_START_PUBLISHING_PROJECT_2", dbc.currentProject().getName(), dbc.currentUser().getName()));
                        }
                        publishedFolderCount = 0;
                        int foldersSize = publishList.getFolderList().size();
                        if (foldersSize > 0) {
                            report.println(Messages.get().container("RPT_PUBLISH_FOLDERS_BEGIN_0"), 2);
                        }
                        Iterator itFolders = publishList.getFolderList().iterator();
                        while (itFolders.hasNext()) {
                            CmsResource currentFolder = (CmsResource)itFolders.next();
                            try {
                                if (currentFolder.getState().isNew() || currentFolder.getState().isChanged()) {
                                    this.m_driverManager.getProjectDriver().publishFolder(dbc, report, ++publishedFolderCount, foldersSize, onlineProject, new CmsFolder(currentFolder), publishList.getPublishHistoryId(), publishTag);
                                    dbc.pop();
                                    this.m_driverManager.getHistoryDriver().deleteEntries(dbc, new CmsHistoryFile(currentFolder), OpenCms.getSystemInfo().getHistoryVersions(), -1L);
                                    this.internalResetResourceState(dbc, currentFolder);
                                    this.m_driverManager.unlockResource(dbc, currentFolder, true, true);
                                } else {
                                    report.print(Messages.get().container("RPT_PUBLISH_FOLDER_0"), 3);
                                    report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(currentFolder.getRootPath())));
                                    report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                                    report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                                    if (LOG.isErrorEnabled()) {
                                        LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_FILE_3", String.valueOf(++publishedFolderCount), String.valueOf(foldersSize), currentFolder));
                                    }
                                }
                                dbc.pop();
                            }
                            catch (Throwable t) {
                                dbc.report(report, Messages.get().container("ERR_ERROR_PUBLISHING_FOLDER_1", currentFolder.getRootPath()), t);
                            }
                        }
                        if (foldersSize > 0) {
                            report.println(Messages.get().container("RPT_PUBLISH_FOLDERS_END_0"), 2);
                        }
                        publishedFileCount = 0;
                        int filesSize = publishList.getFileList().size();
                        if (filesSize > 0) {
                            report.println(Messages.get().container("RPT_PUBLISH_FILES_BEGIN_0"), 2);
                        }
                        Iterator itFiles = publishList.getFileList().iterator();
                        while (itFiles.hasNext()) {
                            CmsResource currentResource = (CmsResource)itFiles.next();
                            try {
                                this.m_driverManager.getProjectDriver().publishFile(dbc, report, ++publishedFileCount, filesSize, onlineProject, currentResource, publishedContentIds, publishList.getPublishHistoryId(), publishTag);
                                if (!currentResource.getState().isDeleted()) {
                                    this.internalResetResourceState(dbc, currentResource);
                                }
                                this.m_driverManager.unlockResource(dbc, currentResource, true, true);
                                dbc.pop();
                            }
                            catch (Throwable t) {
                                dbc.report(report, Messages.get().container("ERR_ERROR_PUBLISHING_FILE_1", currentResource.getRootPath()), t);
                            }
                        }
                        if (filesSize > 0) {
                            report.println(Messages.get().container("RPT_PUBLISH_FILES_END_0"), 2);
                        }
                        if ((deletedFolders = publishList.getDeletedFolderList()).isEmpty()) {
                            Object var20_22 = null;
                            break block32;
                        }
                        deletedFolderCount = 0;
                        int deletedFoldersSize = deletedFolders.size();
                        if (deletedFoldersSize > 0) {
                            report.println(Messages.get().container("RPT_DELETE_FOLDERS_BEGIN_0"), 2);
                        }
                        Iterator itDeletedFolders = deletedFolders.iterator();
                        while (itDeletedFolders.hasNext()) {
                            CmsResource currentFolder = (CmsResource)itDeletedFolders.next();
                            try {
                                this.m_driverManager.getProjectDriver().publishDeletedFolder(dbc, report, ++deletedFolderCount, deletedFoldersSize, onlineProject, new CmsFolder(currentFolder), publishList.getPublishHistoryId(), publishTag);
                                dbc.pop();
                                this.m_driverManager.getHistoryDriver().deleteEntries(dbc, new CmsHistoryFile(currentFolder), OpenCms.getSystemInfo().getHistoryVersionsAfterDeletion(), -1L);
                                this.m_driverManager.unlockResource(dbc, currentFolder, true, true);
                                dbc.pop();
                            }
                            catch (Throwable t) {
                                dbc.report(report, Messages.get().container("ERR_ERROR_PUBLISHING_DELETED_FOLDER_1", currentFolder.getRootPath()), t);
                            }
                        }
                        if (deletedFoldersSize > 0) {
                            report.println(Messages.get().container("RPT_DELETE_FOLDERS_END_0"), 2);
                        }
                        break block33;
                    }
                    catch (OutOfMemoryError o) {
                        OpenCms.fireCmsEvent(new CmsEvent(5, Collections.EMPTY_MAP));
                        CmsMessageContainer message = Messages.get().container("ERR_OUT_OF_MEMORY_0");
                        if (!LOG.isErrorEnabled()) throw new CmsDataAccessException(message, (Throwable)o);
                        LOG.error((Object)message.key(), (Throwable)o);
                        throw new CmsDataAccessException(message, (Throwable)o);
                    }
                }
                catch (Throwable throwable) {
                    Object var20_24 = null;
                    this.m_driverManager.getVfsDriver().publishVersions(dbc, null, false);
                    Object[] msgArgs = new Object[]{String.valueOf(publishedFileCount), String.valueOf(publishedFolderCount), String.valueOf(deletedFolderCount), report.formatRuntime()};
                    CmsMessageContainer message = Messages.get().container("RPT_PUBLISH_STAT_4", msgArgs);
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)message.key());
                    }
                    report.println(message);
                    throw throwable;
                }
            }
            this.m_driverManager.getVfsDriver().publishVersions(dbc, null, false);
            Object[] msgArgs = new Object[]{String.valueOf(publishedFileCount), String.valueOf(publishedFolderCount), String.valueOf(deletedFolderCount), report.formatRuntime()};
            CmsMessageContainer message = Messages.get().container("RPT_PUBLISH_STAT_4", msgArgs);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)message.key());
            }
            report.println(message);
            return;
        }
        Object var20_23 = null;
        this.m_driverManager.getVfsDriver().publishVersions(dbc, null, false);
        Object[] msgArgs = new Object[]{String.valueOf(publishedFileCount), String.valueOf(publishedFolderCount), String.valueOf(deletedFolderCount), report.formatRuntime()};
        CmsMessageContainer message = Messages.get().container("RPT_PUBLISH_STAT_4", msgArgs);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)message.key());
        }
        report.println(message);
    }

    public List readLocks(CmsDbContext dbc) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ArrayList<CmsLock> locks = new ArrayList<CmsLock>(256);
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCE_LOCKS_READALL");
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                CmsProject project;
                String resourcePath = rs.getString(this.m_sqlManager.readQuery("C_RESOURCE_LOCKS_RESOURCE_PATH"));
                CmsUUID userId = new CmsUUID(rs.getString(this.m_sqlManager.readQuery("C_RESOURCE_LOCKS_USER_ID")));
                CmsUUID projectId = new CmsUUID(rs.getString(this.m_sqlManager.readQuery("C_RESOURCE_LOCKS_PROJECT_ID")));
                int lockType = rs.getInt(this.m_sqlManager.readQuery("C_RESOURCE_LOCKS_LOCK_TYPE"));
                try {
                    project = this.readProject(dbc, projectId);
                }
                catch (CmsDataAccessException dae) {
                    project = null;
                }
                if (project == null) continue;
                CmsLock lock = new CmsLock(resourcePath, userId, project, CmsLockType.valueOf(lockType));
                locks.add(lock);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DBG_READ_LOCKS_1", new Integer(locks.size())));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
        return locks;
    }

    public CmsProject readProject(CmsDbContext dbc, CmsUUID id) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        CmsProject project = null;
        ResultSet res = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_READ_1");
            stmt.setString(1, id.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                project = this.internalCreateProject(res);
                while (res.next()) {
                }
            } else {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_PROJECT_WITH_ID_1", String.valueOf(id)));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return project;
    }

    public CmsProject readProject(CmsDbContext dbc, String projectFqn) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        CmsProject project = null;
        ResultSet res = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_READ_BYNAME_2");
            stmt.setString(1, CmsOrganizationalUnit.getSimpleName(projectFqn));
            stmt.setString(2, "/" + CmsOrganizationalUnit.getParentFqn(projectFqn));
            res = stmt.executeQuery();
            if (res.next()) {
                project = this.internalCreateProject(res);
                while (res.next()) {
                }
            } else {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_NO_PROJECT_WITH_NAME_1", projectFqn));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return project;
    }

    public String readProjectResource(CmsDbContext dbc, CmsUUID projectId, String resourcePath) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        String resName = null;
        try {
            conn = this.getSqlManager().getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTRESOURCES_READ_2");
            stmt.setString(1, projectId.toString());
            stmt.setString(2, resourcePath);
            res = stmt.executeQuery();
            if (res.next()) {
                resName = res.getString("RESOURCE_PATH");
                while (res.next()) {
                }
            } else {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_NO_PROJECTRESOURCE_1", resourcePath));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return resName;
    }

    public List readProjectResources(CmsDbContext dbc, CmsProject project) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        Connection conn = null;
        ResultSet res = null;
        ArrayList<String> result = new ArrayList<String>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTRESOURCES_READ_BY_ID_1");
            stmt.setString(1, project.getUuid().toString());
            res = stmt.executeQuery();
            while (res.next()) {
                result.add(res.getString("RESOURCE_PATH"));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return result;
    }

    public List readProjects(CmsDbContext dbc, String ouFqn) throws CmsDataAccessException {
        ArrayList<CmsProject> projects = new ArrayList<CmsProject>();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_READ_BYOU_1");
            stmt.setString(1, "/" + ouFqn + "%");
            res = stmt.executeQuery();
            while (res.next()) {
                projects.add(this.internalCreateProject(res));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return projects;
    }

    public List readProjectsForGroup(CmsDbContext dbc, CmsGroup group) throws CmsDataAccessException {
        ArrayList<CmsProject> projects = new ArrayList<CmsProject>();
        ResultSet res = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_READ_BYGROUP_2");
            stmt.setString(1, group.getId().toString());
            stmt.setString(2, group.getId().toString());
            res = stmt.executeQuery();
            while (res.next()) {
                projects.add(this.internalCreateProject(res));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return projects;
    }

    public List readProjectsForManagerGroup(CmsDbContext dbc, CmsGroup group) throws CmsDataAccessException {
        ArrayList<CmsProject> projects = new ArrayList<CmsProject>();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_READ_BYMANAGER_1");
            stmt.setString(1, group.getId().toString());
            res = stmt.executeQuery();
            while (res.next()) {
                projects.add(this.internalCreateProject(res));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return projects;
    }

    public List readProjectsForUser(CmsDbContext dbc, CmsUser user) throws CmsDataAccessException {
        ArrayList<CmsProject> projects = new ArrayList<CmsProject>();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_READ_BYUSER_1");
            stmt.setString(1, user.getId().toString());
            res = stmt.executeQuery();
            while (res.next()) {
                projects.add(this.internalCreateProject(res));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return projects;
    }

    public List readPublishedResources(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        ArrayList<CmsPublishedResource> publishedResources = new ArrayList<CmsPublishedResource>();
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_SELECT_PUBLISHED_RESOURCES");
            stmt.setString(1, publishHistoryId.toString());
            res = stmt.executeQuery();
            while (res.next()) {
                CmsUUID structureId = new CmsUUID(res.getString("STRUCTURE_ID"));
                CmsUUID resourceId = new CmsUUID(res.getString("RESOURCE_ID"));
                String rootPath = res.getString("RESOURCE_PATH");
                int resourceState = res.getInt("RESOURCE_STATE");
                int resourceType = res.getInt("RESOURCE_TYPE");
                int siblingCount = res.getInt("SIBLING_COUNT");
                int publishTag = res.getInt("PUBLISH_TAG");
                CmsResourceState state = resourceState == CmsPublishedResource.STATE_MOVED_SOURCE.getState() ? CmsPublishedResource.STATE_MOVED_SOURCE : (resourceState == CmsPublishedResource.STATE_MOVED_DESTINATION.getState() ? CmsPublishedResource.STATE_MOVED_DESTINATION : CmsResourceState.valueOf(resourceState));
                publishedResources.add(new CmsPublishedResource(structureId, resourceId, publishTag, rootPath, resourceType, structureId.isNullUUID() ? false : CmsFolder.isFolderType(resourceType), state, siblingCount));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return publishedResources;
    }

    public CmsPublishJobInfoBean readPublishJob(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        CmsPublishJobInfoBean result = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PUBLISHJOB_READ_JOB");
            stmt.setString(1, publishHistoryId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                result = this.createPublishJobInfoBean(res);
                while (res.next()) {
                }
            } else {
                throw new CmsDbEntryNotFoundException(Messages.get().container("ERR_READ_PUBLISH_JOB_1", publishHistoryId.toString()));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return result;
    }

    public List readPublishJobs(CmsDbContext dbc, long startTime, long endTime) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        ArrayList<CmsPublishJobInfoBean> result = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PUBLISHJOB_READ_JOBS_IN_TIMERANGE");
            stmt.setLong(1, startTime);
            stmt.setLong(2, endTime);
            res = stmt.executeQuery();
            result = new ArrayList<CmsPublishJobInfoBean>();
            while (res.next()) {
                result.add(this.createPublishJobInfoBean(res));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CmsPublishList readPublishList(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        CmsPublishList publishList = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PUBLISHJOB_READ_PUBLISHLIST");
            stmt.setString(1, publishHistoryId.toString());
            res = stmt.executeQuery();
            if (!res.next()) throw new CmsDataAccessException(Messages.get().container("ERR_READ_PUBLISH_JOB_1", publishHistoryId.toString()));
            byte[] bytes = this.m_sqlManager.getBytes(res, "PUBLISH_LIST");
            publishList = this.internalDeserializePublishList(bytes);
            while (res.next()) {
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
            return publishList;
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
                catch (Exception e2) {
                    throw new CmsDataAccessException(Messages.get().container("ERR_PUBLISHLIST_DESERIALIZATION_FAILED_1", publishHistoryId), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
    }

    public byte[] readPublishReportContents(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsDataAccessException {
        PreparedStatement stmt = null;
        ResultSet res = null;
        Connection conn = null;
        byte[] bytes = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PUBLISHJOB_READ_REPORT");
            stmt.setString(1, publishHistoryId.toString());
            res = stmt.executeQuery();
            if (res.next()) {
                bytes = this.m_sqlManager.getBytes(res, "PUBLISH_REPORT");
                while (res.next()) {
                }
            } else {
                throw new CmsDataAccessException(Messages.get().container("ERR_READ_PUBLISH_JOB_1", publishHistoryId.toString()));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return bytes;
    }

    public String readStaticExportPublishedResourceParameters(CmsDbContext dbc, String rfsName) throws CmsDataAccessException {
        String returnValue = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STATICEXPORT_READ_PUBLISHED_LINK_PARAMETERS");
            stmt.setString(1, rfsName);
            res = stmt.executeQuery();
            if (res.next()) {
                returnValue = res.getString(1);
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return returnValue;
    }

    public List readStaticExportResources(CmsDbContext dbc, int parameterResources, long timestamp) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        ArrayList<String> returnValue = new ArrayList<String>();
        if (parameterResources == 1) {
            timestamp = 0L;
        }
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STATICEXPORT_READ_ALL_PUBLISHED_LINKS");
            stmt.setInt(1, parameterResources);
            stmt.setLong(2, timestamp);
            res = stmt.executeQuery();
            while (res.next()) {
                returnValue.add(res.getString(1));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return returnValue;
    }

    public void unmarkProjectResources(CmsDbContext dbc, CmsProject project) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_UNMARK");
            stmt.setString(1, project.getUuid().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void writeLocks(CmsDbContext dbc, List locks) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCE_LOCKS_DELETEALL");
            int deleted = stmt.executeUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DBG_CLEAR_LOCKS_1", new Integer(deleted)));
            }
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCE_LOCK_WRITE");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SQL :" + this.m_sqlManager.readQuery("C_RESOURCE_LOCK_WRITE")));
            }
            Iterator i = locks.iterator();
            int count = 0;
            while (i.hasNext()) {
                CmsLock editLock;
                CmsLock lock = (CmsLock)i.next();
                CmsLock sysLock = lock.getSystemLock();
                if (sysLock.isPersistent()) {
                    stmt.setString(1, sysLock.getResourceName());
                    stmt.setString(2, sysLock.getUserId().toString());
                    stmt.setString(3, sysLock.getProjectId().toString());
                    stmt.setInt(4, sysLock.getType().hashCode());
                    stmt.executeUpdate();
                    ++count;
                }
                if (!(editLock = lock.getEditionLock()).isPersistent()) continue;
                stmt.setString(1, editLock.getResourceName());
                stmt.setString(2, editLock.getUserId().toString());
                stmt.setString(3, editLock.getProjectId().toString());
                stmt.setInt(4, editLock.getType().hashCode());
                stmt.executeUpdate();
                ++count;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_DBG_WRITE_LOCKS_1", new Integer(count)));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void writeProject(CmsDbContext dbc, CmsProject project) throws CmsDataAccessException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(project.getDescription())) {
            project.setDescription(" ");
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_WRITE_6");
            stmt.setString(1, project.getDescription());
            stmt.setString(2, project.getGroupId().toString());
            stmt.setString(3, project.getManagerGroupId().toString());
            stmt.setInt(4, project.getFlags());
            stmt.setInt(5, project.getType().getMode());
            stmt.setString(6, project.getUuid().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void writePublishHistory(CmsDbContext dbc, CmsUUID publishId, CmsPublishedResource resource) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_RESOURCES_WRITE_PUBLISH_HISTORY");
            stmt.setInt(1, resource.getPublishTag());
            stmt.setString(2, resource.getStructureId().toString());
            stmt.setString(3, resource.getResourceId().toString());
            stmt.setString(4, resource.getRootPath());
            stmt.setInt(5, resource.getMovedState().getState());
            stmt.setInt(6, resource.getType());
            stmt.setString(7, publishId.toString());
            stmt.setInt(8, resource.getSiblingCount());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void writePublishJob(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PUBLISHJOB_WRITE");
            stmt.setString(1, publishJob.getProjectId().toString());
            stmt.setString(2, publishJob.getProjectName());
            stmt.setString(3, publishJob.getUserId().toString());
            stmt.setString(4, publishJob.getLocale().toString());
            stmt.setInt(5, publishJob.getFlags());
            stmt.setInt(6, publishJob.getSize());
            stmt.setLong(7, publishJob.getEnqueueTime());
            stmt.setLong(8, publishJob.getStartTime());
            stmt.setLong(9, publishJob.getFinishTime());
            stmt.setString(10, publishJob.getPublishHistoryId().toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void writePublishReport(CmsDbContext dbc, CmsUUID publishId, byte[] content) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PUBLISHJOB_WRITE_REPORT");
            if (content.length < 2000) {
                stmt.setBytes(1, content);
            } else {
                stmt.setBinaryStream(1, (InputStream)new ByteArrayInputStream(content), content.length);
            }
            stmt.setString(2, publishId.toString());
            stmt.executeUpdate();
            this.m_sqlManager.closeAll(dbc, conn, stmt, null);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
                throw throwable;
            }
        }
    }

    public void writeStaticExportPublishedResource(CmsDbContext dbc, String resourceName, int linkType, String linkParameter, long timestamp) throws CmsDataAccessException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        int returnValue = 0;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STATICEXPORT_READ_PUBLISHED_RESOURCES");
            stmt.setString(1, resourceName);
            res = stmt.executeQuery();
            if (res.next()) {
                returnValue = res.getInt(1);
                while (res.next()) {
                }
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        if (returnValue == 0) {
            try {
                conn = this.m_sqlManager.getConnection(dbc);
                stmt = this.m_sqlManager.getPreparedStatement(conn, "C_STATICEXPORT_WRITE_PUBLISHED_LINKS");
                stmt.setString(1, new CmsUUID().toString());
                stmt.setString(2, resourceName);
                stmt.setInt(3, linkType);
                stmt.setString(4, linkParameter);
                stmt.setLong(5, timestamp);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", stmt), (Throwable)e);
            }
            finally {
                this.m_sqlManager.closeAll(dbc, conn, stmt, null);
            }
        }
    }

    protected CmsPublishJobInfoBean createPublishJobInfoBean(ResultSet res) throws SQLException {
        return new CmsPublishJobInfoBean(new CmsUUID(res.getString("HISTORY_ID")), new CmsUUID(res.getString("PROJECT_ID")), res.getString("PROJECT_NAME"), new CmsUUID(res.getString("USER_ID")), res.getString("PUBLISH_LOCALE"), res.getInt("PUBLISH_FLAGS"), res.getInt("RESOURCE_COUNT"), res.getLong("ENQUEUE_TIME"), res.getLong("START_TIME"), res.getLong("FINISH_TIME"));
    }

    protected CmsResourceState fixMovedResource(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        CmsResource onlineResource;
        try {
            onlineResource = this.m_driverManager.getVfsDriver().readResource(dbc, onlineProject.getUuid(), offlineResource.getStructureId(), true);
            if (onlineResource.getRootPath().equals(offlineResource.getRootPath())) {
                return offlineResource.getState();
            }
        }
        catch (CmsVfsResourceNotFoundException e) {
            return offlineResource.getState();
        }
        this.m_driverManager.getVfsDriver().moveResource(dbc, onlineProject.getUuid(), onlineResource, offlineResource.getRootPath());
        try {
            this.m_driverManager.getProjectDriver().writePublishHistory(dbc, publishHistoryId, new CmsPublishedResource(onlineResource, publishTag, CmsPublishedResource.STATE_MOVED_SOURCE));
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_WRITING_PUBLISHING_HISTORY_1", onlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        return offlineResource.getState().isDeleted() ? CmsResource.STATE_DELETED : CmsPublishedResource.STATE_MOVED_DESTINATION;
    }

    protected CmsProject internalCreateProject(ResultSet res) throws SQLException {
        String ou = CmsOrganizationalUnit.removeLeadingSeparator(res.getString(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_OU_0")));
        return new CmsProject(new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_ID_0"))), ou + res.getString(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_NAME_0")), res.getString(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_DESCRIPTION_0")), new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROJECTS_USER_ID_0"))), new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROJECTS_GROUP_ID_0"))), new CmsUUID(res.getString(this.m_sqlManager.readQuery("C_PROJECTS_MANAGERGROUP_ID_0"))), res.getInt(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_FLAGS_0")), res.getLong(this.m_sqlManager.readQuery("C_PROJECTS_DATE_CREATED_0")), CmsProject.CmsProjectType.valueOf(res.getInt(this.m_sqlManager.readQuery("C_PROJECTS_PROJECT_TYPE_0"))));
    }

    protected CmsPublishList internalDeserializePublishList(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        ObjectInputStream oin = new ObjectInputStream(bin);
        return (CmsPublishList)oin.readObject();
    }

    protected void internalResetResourceState(CmsDbContext dbc, CmsResource resource) throws CmsDataAccessException {
        try {
            resource.setState(CmsResource.STATE_UNCHANGED);
            this.m_driverManager.getVfsDriver().writeResourceState(dbc, dbc.currentProject(), resource, 3, true);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_RESETTING_RESOURCE_STATE_1", resource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
    }

    protected byte[] internalSerializePublishList(CmsPublishList publishList) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(publishList);
        oout.close();
        return bout.toByteArray();
    }

    protected void internalWriteHistory(CmsDbContext dbc, CmsResource resource, CmsResourceState state, List properties, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        try {
            if (OpenCms.getSystemInfo().isHistoryEnabled()) {
                if (properties == null) {
                    properties = this.m_driverManager.getVfsDriver().readPropertyObjects(dbc, dbc.currentProject(), resource);
                }
                this.m_driverManager.getHistoryDriver().writeResource(dbc, resource, properties, publishTag);
            }
            this.m_driverManager.getProjectDriver().writePublishHistory(dbc, publishHistoryId, new CmsPublishedResource(resource, publishTag, state));
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_WRITING_PUBLISHING_HISTORY_1", resource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
    }

    protected void publishChangedFile(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource, Set publishedResourceIds, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        List offlineProperties;
        CmsFile newFile;
        CmsResource onlineResource;
        CmsResourceState resourceState = this.fixMovedResource(dbc, onlineProject, offlineResource, publishHistoryId, publishTag);
        try {
            List offlineProperties2;
            onlineResource = this.m_driverManager.getVfsDriver().readResource(dbc, onlineProject.getUuid(), offlineResource.getStructureId(), false);
            int flags = offlineResource.getFlags();
            offlineResource.setFlags(flags &= 0xFFFFFFFD);
            this.m_driverManager.getVfsDriver().deletePropertyObjects(dbc, onlineProject.getUuid(), onlineResource, 1);
            if (!onlineResource.getResourceId().equals(offlineResource.getResourceId()) && (offlineProperties2 = this.m_driverManager.getVfsDriver().readPropertyObjects(dbc, dbc.currentProject(), onlineResource)).size() > 0) {
                for (int i = 0; i < offlineProperties2.size(); ++i) {
                    CmsProperty property = (CmsProperty)offlineProperties2.get(i);
                    property.setStructureValue(null);
                    property.setResourceValue("");
                }
                this.m_driverManager.getVfsDriver().writePropertyObjects(dbc, dbc.currentProject(), onlineResource, offlineProperties2);
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_DELETING_PROPERTIES_1", offlineResource.toString()), (Throwable)e);
            }
            throw e;
        }
        try {
            boolean needToUpdateContent = onlineResource.getDateContent() < offlineResource.getDateContent();
            newFile = this.m_driverManager.getProjectDriver().publishFileContent(dbc, dbc.currentProject(), onlineProject, offlineResource, publishedResourceIds, needToUpdateContent, publishTag);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            offlineProperties = this.m_driverManager.getVfsDriver().readPropertyObjects(dbc, dbc.currentProject(), offlineResource);
            CmsProperty.setAutoCreatePropertyDefinitions(offlineProperties, true);
            this.m_driverManager.getVfsDriver().writePropertyObjects(dbc, onlineProject, newFile, offlineProperties);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_PROPERTIES_1", newFile.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            this.m_driverManager.getUserDriver().publishAccessControlEntries(dbc, dbc.currentProject(), onlineProject, newFile.getResourceId(), onlineResource.getResourceId());
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_ACL_1", newFile.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        CmsFile offlineFile = new CmsFile(offlineResource);
        offlineFile.setContents(newFile.getContents());
        this.internalWriteHistory(dbc, offlineFile, resourceState, offlineProperties, publishHistoryId, publishTag);
        this.m_driverManager.getVfsDriver().updateRelations(dbc, onlineProject, offlineResource);
    }

    protected void publishDeletedFile(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        CmsResource onlineResource;
        CmsResourceState resourceState = this.fixMovedResource(dbc, onlineProject, offlineResource, publishHistoryId, publishTag);
        try {
            onlineResource = this.m_driverManager.getVfsDriver().readResource(dbc, onlineProject.getUuid(), offlineResource.getStructureId(), true);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_READING_RESOURCE_1", offlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        if (offlineResource.isLabeled() && !this.m_driverManager.labelResource(dbc, offlineResource, null, 2)) {
            int flags = offlineResource.getFlags();
            offlineResource.setFlags(flags &= 0xFFFFFFFD);
        }
        CmsFile offlineFile = new CmsFile(offlineResource);
        offlineFile.setContents(this.m_driverManager.getVfsDriver().readContent(dbc, dbc.currentProject().getUuid(), offlineFile.getResourceId()));
        this.internalWriteHistory(dbc, offlineFile, resourceState, null, publishHistoryId, publishTag);
        int propertyDeleteOption = -1;
        try {
            propertyDeleteOption = offlineResource.getSiblingCount() > 1 ? 2 : 1;
            this.m_driverManager.getVfsDriver().deletePropertyObjects(dbc, onlineProject.getUuid(), onlineResource, propertyDeleteOption);
            this.m_driverManager.getVfsDriver().deletePropertyObjects(dbc, dbc.currentProject().getUuid(), offlineResource, propertyDeleteOption);
            if (!onlineResource.getResourceId().equals(offlineResource.getResourceId())) {
                this.m_driverManager.getVfsDriver().deletePropertyObjects(dbc, dbc.currentProject().getUuid(), onlineResource, 1);
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_DELETING_PROPERTIES_1", offlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            this.m_driverManager.getVfsDriver().removeFile(dbc, dbc.currentProject().getUuid(), offlineResource);
            this.m_driverManager.getVfsDriver().removeFile(dbc, onlineProject.getUuid(), onlineResource);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_RESOURCE_1", offlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            if (onlineResource.getSiblingCount() == 1) {
                this.m_driverManager.getUserDriver().removeAccessControlEntries(dbc, onlineProject, onlineResource.getResourceId());
            }
            if (offlineResource.getSiblingCount() == 1) {
                this.m_driverManager.getUserDriver().removeAccessControlEntries(dbc, dbc.currentProject(), offlineResource.getResourceId());
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_ACL_1", offlineResource.toString()), (Throwable)e);
            }
            throw e;
        }
        try {
            this.m_driverManager.getVfsDriver().deleteRelations(dbc, onlineProject.getUuid(), offlineResource, CmsRelationFilter.TARGETS);
            this.m_driverManager.getVfsDriver().deleteRelations(dbc, dbc.currentProject().getUuid(), offlineResource, CmsRelationFilter.TARGETS);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_REMOVING_RELATIONS_1", offlineResource.toString()), (Throwable)e);
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void publishNewFile(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource, Set publishedContentIds, CmsUUID publishHistoryId, int publishTag) throws CmsDataAccessException {
        void var8_12;
        List offlineProperties;
        CmsFile newFile;
        CmsResourceState resourceState = this.fixMovedResource(dbc, onlineProject, offlineResource, publishHistoryId, publishTag);
        try {
            int flags = offlineResource.getFlags();
            offlineResource.setFlags(flags &= 0xFFFFFFFD);
            newFile = this.m_driverManager.getProjectDriver().publishFileContent(dbc, dbc.currentProject(), onlineProject, offlineResource, publishedContentIds, true, publishTag);
        }
        catch (CmsVfsResourceAlreadyExistsException e) {
            try {
                this.m_driverManager.getVfsDriver().removeFile(dbc, onlineProject.getUuid(), offlineResource);
                publishedContentIds.remove(offlineResource.getResourceId());
                newFile = this.m_driverManager.getProjectDriver().publishFileContent(dbc, dbc.currentProject(), onlineProject, offlineResource, publishedContentIds, true, publishTag);
            }
            catch (CmsDataAccessException e1) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineResource.getRootPath()), (Throwable)e);
                }
                throw e1;
            }
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_RESOURCE_1", offlineResource.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            offlineProperties = this.m_driverManager.getVfsDriver().readPropertyObjects(dbc, dbc.currentProject(), offlineResource);
            CmsProperty.setAutoCreatePropertyDefinitions(offlineProperties, true);
            this.m_driverManager.getVfsDriver().writePropertyObjects(dbc, onlineProject, (CmsResource)var8_12, offlineProperties);
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_PROPERTIES_1", var8_12.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        try {
            this.m_driverManager.getUserDriver().publishAccessControlEntries(dbc, dbc.currentProject(), onlineProject, offlineResource.getResourceId(), var8_12.getResourceId());
        }
        catch (CmsDataAccessException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PUBLISHING_ACL_1", var8_12.getRootPath()), (Throwable)e);
            }
            throw e;
        }
        CmsFile offlineFile = new CmsFile(offlineResource);
        offlineFile.setContents(var8_12.getContents());
        this.internalWriteHistory(dbc, offlineFile, resourceState, offlineProperties, publishHistoryId, publishTag);
        this.m_driverManager.getVfsDriver().updateRelations(dbc, onlineProject, offlineResource);
    }
}

