/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.mysql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.generic.CmsSqlManager;
import org.opencms.db.generic.Messages;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.history.CmsHistoryProject;

public class CmsHistoryDriver
extends org.opencms.db.generic.CmsHistoryDriver {
    public CmsSqlManager initSqlManager(String classname) {
        return CmsSqlManager.getInstance(classname);
    }

    public List readProjects(CmsDbContext dbc) throws CmsDataAccessException {
        ArrayList<CmsHistoryProject> projects = new ArrayList<CmsHistoryProject>();
        ResultSet res = null;
        PreparedStatement stmt = null;
        Connection conn = null;
        try {
            conn = this.m_sqlManager.getConnection(dbc);
            stmt = this.m_sqlManager.getPreparedStatement(conn, "C_PROJECTS_HISTORY_READ_ALL");
            stmt.setInt(1, 300);
            res = stmt.executeQuery();
            while (res.next()) {
                List resources = this.m_driverManager.getHistoryDriver().readProjectResources(dbc, res.getInt("PUBLISH_TAG"));
                projects.add(this.internalCreateProject(res, resources));
            }
            this.m_sqlManager.closeAll(dbc, conn, stmt, res);
        }
        catch (SQLException e) {
            try {
                throw new CmsDbSqlException(Messages.get().container("ERR_GENERIC_SQL_1", CmsDbSqlException.getErrorQuery(stmt)), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.m_sqlManager.closeAll(dbc, conn, stmt, res);
                throw throwable;
            }
        }
        return projects;
    }
}

