/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file;

import org.opencms.file.Messages;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.util.A_CmsModeIntEnumeration;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsPropertyDefinition
implements Cloneable,
Comparable {
    public static final String NAME_CONSTRAINTS = "-._~$";
    public static final String PROPERTY_ACTIV = "activemethod";
    public static final String PROPERTY_AVAILABLE_LOCALES = "locale-available";
    public static final String PROPERTY_BODY_CLASS = "templateclass";
    public static final String PROPERTY_CACHE = "cache";
    public static final String PROPERTY_CONTENT_CONVERSION = "content-conversion";
    public static final String PROPERTY_CONTENT_ENCODING = "content-encoding";
    public static final String PROPERTY_DEFAULT_FILE = "default-file";
    public static final String PROPERTY_DESCRIPTION = "Description";
    public static final String PROPERTY_ENABLE_NOTIFICATION = "enable-notification";
    public static final String PROPERTY_EXPORT = "export";
    public static final String PROPERTY_EXPORTNAME = "exportname";
    public static final String PROPERTY_EXPORTSUFFIX = "exportsuffix";
    public static final String PROPERTY_FOLDERS_AVAILABLE = "folders.available";
    public static final String PROPERTY_IMAGE_SIZE = "image.size";
    public static final String PROPERTY_KEYWORDS = "Keywords";
    public static final String PROPERTY_LOCALE = "locale";
    public static final String PROPERTY_LOGIN_FORM = "login-form";
    public static final String PROPERTY_NAVIMAGE = "NavImage";
    public static final String PROPERTY_NAVINFO = "NavInfo";
    public static final String PROPERTY_NAVPOS = "NavPos";
    public static final String PROPERTY_NAVTEXT = "NavText";
    public static final String PROPERTY_NOTIFICATION_INTERVAL = "notification-interval";
    public static final String PROPERTY_RELATIVEROOT = "relativeroot";
    public static final String PROPERTY_RESTYPES_AVAILABLE = "restypes.available";
    public static final String PROPERTY_SEARCH_CATEGORY = "category";
    public static final String PROPERTY_SEARCH_EXCLUDE = "search.exclude";
    public static final String PROPERTY_SEARCH_PRIORITY = "search.priority";
    public static final String PROPERTY_SECURE = "secure";
    public static final String PROPERTY_STYLESHEET = "stylesheet";
    public static final String PROPERTY_TEMPLATE = "template";
    public static final String PROPERTY_TEMPLATE_ELEMENTS = "template-elements";
    public static final String PROPERTY_TITLE = "Title";
    public static final String PROPERTY_VISIBLE = "visiblemethod";
    public static final int PROPERYDEFINITION_RESOURCE = 1;
    public static final CmsPropertyType TYPE_LINK = CmsPropertyType.LINK;
    public static final CmsPropertyType TYPE_NORMAL = CmsPropertyType.NORMAL;
    private static final CmsPropertyDefinition NULL_PROPERTY_DEFINITION = new CmsPropertyDefinition(CmsUUID.getNullUUID(), "", TYPE_NORMAL);
    private CmsUUID m_id;
    private String m_name;
    private CmsPropertyType m_type;

    public CmsPropertyDefinition(CmsUUID id, String name) {
        this(id, name, TYPE_NORMAL);
    }

    public CmsPropertyDefinition(CmsUUID id, String name, CmsPropertyType propertyType) {
        this.m_id = id;
        this.m_name = name;
        this.m_type = propertyType;
    }

    public static void checkPropertyName(String name) throws CmsIllegalArgumentException {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_PROPERTYNAME_EMPTY_0", name));
        }
        CmsStringUtil.checkName(name, NAME_CONSTRAINTS, "ERR_BAD_PROPERTYNAME_4", Messages.get());
    }

    public static CmsPropertyDefinition getNullPropertyDefinition() {
        return NULL_PROPERTY_DEFINITION;
    }

    public Object clone() {
        return new CmsPropertyDefinition(this.m_id, this.m_name, this.m_type);
    }

    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj instanceof CmsPropertyDefinition) {
            return this.m_name.compareTo(((CmsPropertyDefinition)obj).m_name);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsPropertyDefinition) {
            return ((CmsPropertyDefinition)obj).m_id.equals(this.m_id);
        }
        return false;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public CmsPropertyType getType() {
        return this.m_type;
    }

    public int hashCode() {
        if (this.m_name != null) {
            return this.m_name.hashCode();
        }
        return 0;
    }

    public void setType(CmsPropertyType type) {
        this.m_type = type;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[Propertydefinition]");
        result.append(" name:");
        result.append(this.m_name);
        result.append(" id:");
        result.append(this.m_id);
        result.append(" type:");
        result.append(this.m_type);
        return result.toString();
    }

    public static final class CmsPropertyType
    extends A_CmsModeIntEnumeration {
        protected static final CmsPropertyType LINK = new CmsPropertyType(1);
        protected static final CmsPropertyType NORMAL = new CmsPropertyType(0);
        private static final long serialVersionUID = 74746076708908673L;

        private CmsPropertyType(int type) {
            super(type);
        }

        public static CmsPropertyType valueOf(int type) {
            switch (type) {
                case 1: {
                    return LINK;
                }
            }
            return NORMAL;
        }
    }
}

