/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.CmsCollectorData;
import org.opencms.file.collectors.Messages;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.util.CmsStringUtil;

public class CmsCategoryResourceCollector
extends A_CmsResourceCollector {
    public static final Comparator COMPARE_DATE_RELEASED_DESC = new Comparator(){

        public int compare(Object o1, Object o2) {
            long date2;
            if (o1 == o2 || !(o1 instanceof CmsResource) || !(o2 instanceof CmsResource)) {
                return 0;
            }
            CmsResource r1 = (CmsResource)o1;
            CmsResource r2 = (CmsResource)o2;
            long date1 = r1.getDateReleased();
            if (date1 == 0L) {
                date1 = r1.getDateLastModified();
            }
            if ((date2 = r2.getDateReleased()) == 0L) {
                date2 = r2.getDateLastModified();
            }
            return date1 > date2 ? 1 : (date1 < date2 ? -1 : 0);
        }
    };
    protected static final Log LOG = CmsLog.getLog(CmsCategoryResourceCollector.class);
    private static final String[] COLLECTORS = new String[]{"allKeyValuePairFiltered"};
    private static final List COLLECTORS_LIST = Collections.unmodifiableList(Arrays.asList(COLLECTORS));

    public List getCollectorNames() {
        return COLLECTORS_LIST;
    }

    public String getCreateLink(CmsObject cms, String collectorName, String param) throws CmsException, CmsDataAccessException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: {
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    public String getCreateParam(CmsObject cms, String collectorName, String param) throws CmsDataAccessException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: {
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    public List getResults(CmsObject cms, String collectorName, String param) throws CmsDataAccessException, CmsException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: {
                return this.allKeyValuePairFiltered(cms, param);
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    protected List allKeyValuePairFiltered(CmsObject cms, String param) throws CmsException {
        CmsCategoryCollectorData data = new CmsCategoryCollectorData(param);
        if (data.getCategoryTypes() != null && data.getCategoryTypes().size() > 0) {
            ArrayList<CmsResource> result = new ArrayList<CmsResource>();
            HashMap sortCategories = new HashMap();
            String foldername = null;
            boolean includeSubTree = false;
            if (data.getFileName() != null) {
                foldername = CmsResource.getFolderPath(data.getFileName());
                includeSubTree = data.isSubTree();
            } else {
                foldername = "/";
                includeSubTree = true;
            }
            CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addExcludeFlags(1024);
            if (data.getType() != -1) {
                filter = filter.addRequireType(data.getType());
            }
            List resources = cms.readResources(foldername, filter, includeSubTree);
            List categoryTypes = data.getCategoryTypes();
            Iterator itResources = resources.iterator();
            CmsCategoryService service = CmsCategoryService.getInstance();
            while (itResources.hasNext()) {
                CmsResource resource = (CmsResource)itResources.next();
                Iterator itCategories = service.readResourceCategories(cms, cms.getSitePath(resource)).iterator();
                while (itCategories.hasNext()) {
                    CmsCategory category = (CmsCategory)itCategories.next();
                    if (!categoryTypes.contains(category.getPath())) continue;
                    if (data.getSortBy() != null && data.getSortBy().equals("category")) {
                        if (sortCategories.containsKey(category.getPath())) {
                            ((List)sortCategories.get(category.getPath())).add(resource);
                            continue;
                        }
                        ArrayList<CmsResource> sortResources = new ArrayList<CmsResource>();
                        sortResources.add(resource);
                        sortCategories.put(category.getPath(), sortResources);
                        continue;
                    }
                    if (result.contains(resource)) continue;
                    result.add(resource);
                }
            }
            if (data.getSortBy() != null && data.getSortBy().equals("date")) {
                if (!data.isSortAsc()) {
                    Collections.sort(result, COMPARE_DATE_RELEASED_DESC);
                } else {
                    Collections.sort(result, CmsResource.COMPARE_DATE_RELEASED);
                }
            } else if (data.getSortBy() != null && data.getSortBy().equals("category")) {
                Iterator itCategoryTypes = categoryTypes.iterator();
                while (itCategoryTypes.hasNext()) {
                    result.addAll((List)sortCategories.get(itCategoryTypes.next()));
                }
            }
            return this.shrinkToFit(result, data.getCount());
        }
        return null;
    }

    private static final class CmsCategoryCollectorData
    extends CmsCollectorData {
        public static final String PARAM_KEY_CATEGORY_TYPES = "categoryTypes";
        public static final String PARAM_KEY_COUNT = "count";
        public static final String PARAM_KEY_RESOURCE = "resource";
        public static final String PARAM_KEY_RESOURCE_TYPE = "resourceType";
        public static final String PARAM_KEY_SORT_ASC = "sortAsc";
        public static final String PARAM_KEY_SORT_BY = "sortBy";
        public static final String PARAM_KEY_SUB_TREE = "subTree";
        private List m_categoryTypes;
        private boolean m_sortAsc;
        private String m_sortBy;
        private boolean m_subTree;

        public CmsCategoryCollectorData(String data) throws CmsLoaderException {
            this.parseExtendedData(data);
        }

        public List getCategoryTypes() {
            return this.m_categoryTypes;
        }

        public String getSortBy() {
            return this.m_sortBy;
        }

        public boolean isSortAsc() {
            return this.m_sortAsc;
        }

        public boolean isSubTree() {
            return this.m_subTree;
        }

        private void parseExtendedData(String data) throws CmsLoaderException {
            String[] keyValueTokens = CmsStringUtil.splitAsArray(data, '|');
            this.setType(-1);
            for (int i = keyValueTokens.length - 1; i >= 0; --i) {
                String relation = keyValueTokens[i];
                String[] keyValuePair = CmsStringUtil.splitAsArray(relation, '=');
                String key = keyValuePair[0];
                String value = keyValuePair[1];
                if (PARAM_KEY_CATEGORY_TYPES.equals(key)) {
                    this.m_categoryTypes = CmsStringUtil.splitAsList(value, ',');
                    continue;
                }
                if (PARAM_KEY_RESOURCE.equals(key)) {
                    this.setFileName(value);
                    continue;
                }
                if (PARAM_KEY_RESOURCE_TYPE.equals(key)) {
                    I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(value);
                    if (type == null) continue;
                    this.setType(type.getTypeId());
                    continue;
                }
                if (PARAM_KEY_SORT_ASC.equals(key)) {
                    this.m_sortAsc = Boolean.valueOf(value);
                    continue;
                }
                if (PARAM_KEY_SORT_BY.equals(key)) {
                    this.m_sortBy = value;
                    continue;
                }
                if (PARAM_KEY_SUB_TREE.equals(key)) {
                    this.m_subTree = Boolean.valueOf(value);
                    continue;
                }
                if (PARAM_KEY_COUNT.equals(key)) {
                    int count = 0;
                    try {
                        count = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    this.setCount(count);
                    continue;
                }
                LOG.error((Object)"Unknow key found in collector parameters.");
            }
        }
    }
}

