/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.util.CmsStringUtil;

public class CmsDateResourceComparator
implements Comparator {
    private static final String[] DATE_ATTRIBUTES = new String[]{"dateCreated", "dateLastModified", "dateContent", "dateReleased", "dateExpired"};
    public static final List DATE_ATTRIBUTES_LIST = Arrays.asList(DATE_ATTRIBUTES);
    private boolean m_asc;
    private CmsObject m_cms;
    private long m_date;
    private List m_dateIdentifiers;
    private Map m_keys;

    public CmsDateResourceComparator(CmsObject cms, List dateIdentifiers, boolean asc) {
        this.m_cms = cms;
        this.m_asc = asc;
        this.m_dateIdentifiers = dateIdentifiers;
        if (this.m_dateIdentifiers == null) {
            this.m_dateIdentifiers = Collections.EMPTY_LIST;
        }
        this.m_keys = new HashMap();
    }

    private CmsDateResourceComparator() {
    }

    public static long calculateDate(CmsObject cms, CmsResource resource, List dateIdentifiers, long defaultValue) {
        long result = 0L;
        List properties = null;
        int size = dateIdentifiers.size();
        for (int i = 0; i < size; ++i) {
            String date = (String)dateIdentifiers.get(i);
            int pos = DATE_ATTRIBUTES_LIST.indexOf(date);
            switch (pos) {
                case 0: {
                    result = resource.getDateCreated();
                    break;
                }
                case 1: {
                    result = resource.getDateLastModified();
                    break;
                }
                case 2: {
                    if (!resource.isFile()) break;
                    result = resource.getDateContent();
                    break;
                }
                case 3: {
                    long dr = resource.getDateReleased();
                    if (dr == 0L) break;
                    result = dr;
                    break;
                }
                case 4: {
                    long de = resource.getDateExpired();
                    if (de == Long.MAX_VALUE) break;
                    result = de;
                    break;
                }
                default: {
                    String propValue;
                    if (properties == null) {
                        try {
                            properties = cms.readPropertyObjects(resource, false);
                        }
                        catch (CmsException e) {
                            properties = Collections.EMPTY_LIST;
                        }
                    }
                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(propValue = CmsProperty.get(date, properties).getValue())) break;
                    try {
                        result = Long.parseLong(propValue.trim());
                        break;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            if (result != 0L) break;
        }
        if (result == 0L) {
            result = defaultValue;
        }
        return result;
    }

    private static CmsDateResourceComparator create(CmsObject cms, CmsResource resource, List dateIdentifiers) {
        CmsDateResourceComparator result = new CmsDateResourceComparator();
        result.m_date = CmsDateResourceComparator.calculateDate(cms, resource, dateIdentifiers, resource.getDateCreated());
        return result;
    }

    public int compare(Object arg0, Object arg1) {
        if (arg0 == arg1 || !(arg0 instanceof CmsResource) || !(arg1 instanceof CmsResource)) {
            return 0;
        }
        CmsResource res0 = (CmsResource)arg0;
        CmsResource res1 = (CmsResource)arg1;
        CmsDateResourceComparator key0 = (CmsDateResourceComparator)this.m_keys.get(res0.getStructureId());
        CmsDateResourceComparator key1 = (CmsDateResourceComparator)this.m_keys.get(res1.getStructureId());
        if (key0 == null) {
            key0 = CmsDateResourceComparator.create(this.m_cms, res0, this.m_dateIdentifiers);
            this.m_keys.put(res0.getStructureId(), key0);
        }
        if (key1 == null) {
            key1 = CmsDateResourceComparator.create(this.m_cms, res1, this.m_dateIdentifiers);
            this.m_keys.put(res1.getStructureId(), key1);
        }
        if (this.m_asc) {
            if (key0.m_date > key1.m_date) {
                return 1;
            }
            if (key0.m_date < key1.m_date) {
                return -1;
            }
        } else {
            if (key0.m_date > key1.m_date) {
                return -1;
            }
            if (key0.m_date < key1.m_date) {
                return 1;
            }
        }
        return 0;
    }

    public long getDate() {
        return this.m_date;
    }
}

