/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;

public class CmsPriorityDateResourceComparator
implements Serializable,
Comparator {
    public static final String PROPERTY_DATE = "collector.date";
    private static final long serialVersionUID = 5316136357328564518L;
    private boolean m_asc;
    private transient CmsObject m_cms;
    private long m_date;
    private Map m_keys;
    private int m_priority;

    public CmsPriorityDateResourceComparator(CmsObject cms, boolean asc) {
        this.m_cms = cms;
        this.m_asc = asc;
        this.m_keys = new HashMap();
    }

    private static CmsPriorityDateResourceComparator create(CmsResource resource, CmsObject cms) {
        CmsPriorityDateResourceComparator result = new CmsPriorityDateResourceComparator(null, false);
        result.init(resource, cms);
        return result;
    }

    public int compare(Object arg0, Object arg1) {
        if (arg0 == arg1 || !(arg0 instanceof CmsResource) || !(arg1 instanceof CmsResource)) {
            return 0;
        }
        CmsResource res0 = (CmsResource)arg0;
        CmsResource res1 = (CmsResource)arg1;
        CmsPriorityDateResourceComparator key0 = (CmsPriorityDateResourceComparator)this.m_keys.get(res0.getStructureId());
        CmsPriorityDateResourceComparator key1 = (CmsPriorityDateResourceComparator)this.m_keys.get(res1.getStructureId());
        if (key0 == null) {
            key0 = CmsPriorityDateResourceComparator.create(res0, this.m_cms);
            this.m_keys.put(res0.getStructureId(), key0);
        }
        if (key1 == null) {
            key1 = CmsPriorityDateResourceComparator.create(res1, this.m_cms);
            this.m_keys.put(res1.getStructureId(), key1);
        }
        if (key0.getPriority() > key1.getPriority()) {
            return -1;
        }
        if (key0.getPriority() < key1.getPriority()) {
            return 1;
        }
        if (this.m_asc) {
            if (key0.getDate() > key1.getDate()) {
                return 1;
            }
            if (key0.getDate() < key1.getDate()) {
                return -1;
            }
        } else {
            if (key0.getDate() > key1.getDate()) {
                return -1;
            }
            if (key0.getDate() < key1.getDate()) {
                return 1;
            }
        }
        return 0;
    }

    public long getDate() {
        return this.m_date;
    }

    public int getPriority() {
        return this.m_priority;
    }

    private void init(CmsResource resource, CmsObject cms) {
        List properties;
        try {
            properties = cms.readPropertyObjects(resource, false);
        }
        catch (CmsException e) {
            this.m_priority = 0;
            this.m_date = 0L;
            return;
        }
        try {
            this.m_priority = Integer.parseInt(CmsProperty.get("collector.priority", properties).getValue());
        }
        catch (NumberFormatException e) {
            this.m_priority = 3;
        }
        try {
            this.m_date = Long.parseLong(CmsProperty.get(PROPERTY_DATE, properties).getValue());
        }
        catch (NumberFormatException e) {
            this.m_date = 0L;
        }
    }
}

