/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.history;

import java.io.Serializable;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.main.CmsException;
import org.opencms.security.CmsPrincipal;
import org.opencms.util.CmsUUID;

public class CmsHistoryFolder
extends CmsFolder
implements I_CmsHistoryResource,
Cloneable,
Serializable,
Comparable {
    private static final long serialVersionUID = -374285965677032786L;
    private CmsUUID m_parentId;
    private int m_publishTag;
    private int m_resourceVersion;
    private int m_structureVersion;

    public CmsHistoryFolder(I_CmsHistoryResource resource) {
        this(resource.getPublishTag(), resource.getStructureId(), resource.getResourceId(), resource.getRootPath(), resource.getTypeId(), resource.getFlags(), resource.getProjectLastModified(), resource.getState(), resource.getDateCreated(), resource.getUserCreated(), resource.getDateLastModified(), resource.getUserLastModified(), resource.getDateReleased(), resource.getDateExpired(), resource.getVersion(), resource.getParentId(), resource.getResourceVersion(), resource.getStructureVersion());
    }

    public CmsHistoryFolder(int publishTag, CmsUUID structureId, CmsUUID resourceId, String path, int type, int flags, CmsUUID projectId, CmsResourceState state, long dateCreated, CmsUUID userCreated, long dateLastModified, CmsUUID userLastModified, long dateReleased, long dateExpired, int version, CmsUUID parentId, int resourceVersion, int structureVersion) {
        super(structureId, resourceId, path, type, flags, projectId, state, dateCreated, userCreated, dateLastModified, userLastModified, dateReleased, dateExpired, version);
        this.m_publishTag = publishTag;
        this.m_parentId = parentId;
        this.m_resourceVersion = resourceVersion;
        this.m_structureVersion = structureVersion;
    }

    public Object clone() {
        return new CmsHistoryFolder(this.getPublishTag(), this.getStructureId(), this.getResourceId(), this.getRootPath(), this.getTypeId(), this.getFlags(), this.getProjectLastModified(), this.getState(), this.getDateCreated(), this.getUserCreated(), this.getDateLastModified(), this.getUserLastModified(), this.getDateReleased(), this.getDateExpired(), this.getVersion(), this.getParentId(), this.getResourceVersion(), this.getStructureVersion());
    }

    public CmsUUID getBackupId() {
        return new CmsUUID();
    }

    public String getCreatedByName() {
        return this.getUserCreated().toString();
    }

    public String getLastModifiedByName() {
        return this.getUserLastModified().toString();
    }

    public CmsUUID getParentId() {
        return this.m_parentId;
    }

    public int getPublishTag() {
        return this.m_publishTag;
    }

    public int getPublishTagId() {
        return this.getPublishTag();
    }

    public int getResourceVersion() {
        return this.m_resourceVersion;
    }

    public int getStructureVersion() {
        return this.m_structureVersion;
    }

    public String getUserCreatedName(CmsObject cms) {
        try {
            return CmsPrincipal.readPrincipalIncludingHistory(cms, this.getUserCreated()).getName();
        }
        catch (CmsException e) {
            return this.getUserCreated().toString();
        }
    }

    public String getUserLastModifiedName(CmsObject cms) {
        try {
            return CmsPrincipal.readPrincipalIncludingHistory(cms, this.getUserLastModified()).getName();
        }
        catch (CmsException e) {
            return this.getUserLastModified().toString();
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append(super.toString());
        result.append(", resource version: ");
        result.append(this.m_resourceVersion);
        result.append(", structure version ");
        result.append(this.m_structureVersion);
        result.append(", parent id: ");
        result.append(this.m_parentId);
        result.append(", publish tag: ");
        result.append(this.m_publishTag);
        result.append("]");
        return result.toString();
    }
}

