/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.history;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.Messages;
import org.opencms.file.history.CmsHistoryFile;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;

public class CmsHistoryResourceHandler
implements I_CmsResourceInit {
    public static final String ATTRIBUTE_NAME = "org.opencms.file.history.CmsHistoryResourceHandler";
    public static final String HISTORY_HANDLER = "/system/shared/showversion";
    private static final Log LOG = CmsLog.getLog(CmsHistoryResourceHandler.class);
    public static final String PARAM_VERSION = "version";
    public static final int PROJECT_OFFLINE_VERSION = Integer.MAX_VALUE;

    public static I_CmsHistoryResource getHistoryResource(ServletRequest req) {
        return (I_CmsHistoryResource)req.getAttribute(ATTRIBUTE_NAME);
    }

    public static boolean isHistoryRequest(ServletRequest req) {
        return null != req.getAttribute(ATTRIBUTE_NAME);
    }

    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException {
        String uri;
        if (req != null && (uri = cms.getRequestContext().getUri()).startsWith(HISTORY_HANDLER)) {
            String version = req.getParameter(PARAM_VERSION);
            if (resource == null && version != null && cms.existsResource(HISTORY_HANDLER)) {
                String storedSiteRoot = cms.getRequestContext().getSiteRoot();
                try {
                    try {
                        cms.getRequestContext().setSiteRoot("/");
                        uri = uri.substring(HISTORY_HANDLER.length(), uri.length());
                        int id = new Integer(version);
                        resource = id == Integer.MAX_VALUE ? new CmsHistoryFile(cms.readFile(uri)) : (CmsResource)((Object)cms.readResource(cms.readResource(uri).getStructureId(), id));
                        req.setAttribute(ATTRIBUTE_NAME, (Object)resource);
                    }
                    catch (CmsException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("ERR_HISTORYRESOURCE_2", uri, version));
                        }
                        throw new CmsResourceInitException(Messages.get().container("ERR_SHOWVERSION_2", uri, version), (Throwable)e);
                    }
                    Object var10_10 = null;
                    cms.getRequestContext().setSiteRoot(storedSiteRoot);
                    if (resource != null) {
                        cms.getRequestContext().setUri(cms.getSitePath(resource));
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    cms.getRequestContext().setSiteRoot(storedSiteRoot);
                    if (resource != null) {
                        cms.getRequestContext().setUri(cms.getSitePath(resource));
                    }
                    throw throwable;
                }
            }
        }
        return resource;
    }
}

