/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationCopyResource;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.Messages;
import org.opencms.file.types.CmsResourceTypeUnknownFile;
import org.opencms.file.types.CmsResourceTypeUnknownFolder;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;

public abstract class A_CmsResourceType
implements I_CmsResourceType {
    public static final String CONFIGURATION_INTERNAL = "resource.flag.internal";
    public static final String MACRO_RESOURCE_FOLDER_PATH = "resource.folder.path";
    public static final String MACRO_RESOURCE_NAME = "resource.name";
    public static final String MACRO_RESOURCE_PARENT_PATH = "resource.parent.path";
    public static final String MACRO_RESOURCE_ROOT_PATH = "resource.root.path";
    public static final String MACRO_RESOURCE_SITE_PATH = "resource.site.path";
    private static final Log LOG = CmsLog.getLog(A_CmsResourceType.class);
    protected boolean m_addititionalModuleResourceType;
    protected String m_className;
    protected List m_copyResources;
    protected List m_defaultProperties;
    protected boolean m_frozen;
    protected List m_mappings = new ArrayList();
    protected int m_typeId = -1;
    protected String m_typeName;
    private Boolean m_internal;

    public A_CmsResourceType() {
        this.m_defaultProperties = new ArrayList();
        this.m_copyResources = new ArrayList();
    }

    public void addConfigurationParameter(String paramName, String paramValue) {
        if (CONFIGURATION_INTERNAL.equalsIgnoreCase(paramName)) {
            this.m_internal = Boolean.valueOf(paramValue.trim());
        }
    }

    public void addCopyResource(String source, String target, String type) throws CmsConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_ADD_COPY_RESOURCE_4", new Object[]{this, source, target, type}));
        }
        if (this.m_frozen) {
            throw new CmsConfigurationException(org.opencms.file.types.Messages.get().container("ERR_CONFIG_FROZEN_3", this.getClass().getName(), this.getTypeName(), new Integer(this.getTypeId())));
        }
        CmsConfigurationCopyResource copyResource = new CmsConfigurationCopyResource(source, target, type);
        this.m_copyResources.add(copyResource);
    }

    public void addDefaultProperty(CmsProperty property) throws CmsConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_ADD_DFLT_PROP_2", this, property));
        }
        if (this.m_frozen) {
            throw new CmsConfigurationException(org.opencms.file.types.Messages.get().container("ERR_CONFIG_FROZEN_3", this.getClass().getName(), this.getTypeName(), new Integer(this.getTypeId())));
        }
        this.m_defaultProperties.add(property);
    }

    public void addMappingType(String mapping) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_ADD_MAPPING_TYPE_2", mapping, this));
        }
        if (this.m_mappings == null) {
            this.m_mappings = new ArrayList();
        }
        this.m_mappings.add(mapping);
    }

    public void changeLock(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource) throws CmsException {
        securityManager.changeLock(cms.getRequestContext(), resource);
    }

    public void chflags(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int flags) throws CmsException {
        securityManager.chflags(cms.getRequestContext(), resource, flags);
    }

    public void chtype(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int type) throws CmsException {
        securityManager.chtype(cms.getRequestContext(), resource, type);
        this.createRelations(cms, securityManager, resource.getRootPath());
    }

    public void copyResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException {
        securityManager.copyResource(cms.getRequestContext(), source, cms.getRequestContext().addSiteRoot(destination), siblingMode);
        this.createRelations(cms, securityManager, cms.getRequestContext().addSiteRoot(destination));
    }

    public void copyResourceToProject(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource) throws CmsException {
        securityManager.copyResourceToProject(cms.getRequestContext(), resource);
    }

    public CmsResource createResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, byte[] content, List properties) throws CmsException {
        CmsMacroResolver resolver = this.getMacroResolver(cms, resourcename);
        List newProperties = this.processDefaultProperties(properties, resolver);
        CmsResource result = securityManager.createResource(cms.getRequestContext(), cms.getRequestContext().addSiteRoot(resourcename), this.getTypeId(), content, newProperties);
        if (this.m_internal != null && this.m_internal.booleanValue()) {
            securityManager.chflags(cms.getRequestContext(), result, result.getFlags() ^ 0x200);
        }
        this.processCopyResources(cms, resourcename, resolver);
        this.createRelations(cms, securityManager, cms.getRequestContext().addSiteRoot(resourcename));
        return result;
    }

    public CmsResource createSibling(CmsObject cms, CmsSecurityManager securityManager, CmsResource source, String destination, List properties) throws CmsException {
        CmsResource sibling = securityManager.createSibling(cms.getRequestContext(), source, cms.getRequestContext().addSiteRoot(destination), properties);
        this.createRelations(cms, securityManager, sibling.getRootPath());
        return sibling;
    }

    public void deleteResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        securityManager.deleteResource(cms.getRequestContext(), resource, siblingMode);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof I_CmsResourceType) {
            I_CmsResourceType other = (I_CmsResourceType)obj;
            if (this.getTypeId() == other.getTypeId()) {
                return true;
            }
            if (this.getTypeName() != null && this.getTypeName().equals(other.getTypeName())) {
                return true;
            }
        }
        return false;
    }

    public String getCachePropertyDefault() {
        return null;
    }

    public String getClassName() {
        return this.m_className;
    }

    public Map getConfiguration() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_GET_CONFIGURATION_1", this));
        }
        TreeMap<String, Boolean> result = null;
        if (this.m_internal != null) {
            result = new TreeMap<String, Boolean>();
            result.put(CONFIGURATION_INTERNAL, this.m_internal);
        }
        return result;
    }

    public List getConfiguredCopyResources() {
        return this.m_copyResources;
    }

    public List getConfiguredDefaultProperties() {
        return this.m_defaultProperties;
    }

    public List getConfiguredMappings() {
        return this.m_mappings;
    }

    public abstract int getLoaderId();

    public int getTypeId() {
        return this.m_typeId;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public int hashCode() {
        return this.getTypeId();
    }

    public CmsResource importResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, CmsResource resource, byte[] content, List properties) throws CmsException {
        resource.setDateLastModified(resource.getDateLastModified());
        resource.setState(CmsResource.STATE_NEW);
        return securityManager.importResource(cms.getRequestContext(), cms.getRequestContext().addSiteRoot(resourcename), resource, content, properties, true);
    }

    public final void initConfiguration() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_INIT_CONFIGURATION_1", this));
        }
    }

    public void initConfiguration(String name, String id) throws CmsConfigurationException {
        this.initConfiguration(name, id, this.getClass().getName());
    }

    public void initConfiguration(String name, String id, String className) throws CmsConfigurationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_INIT_CONFIGURATION_3", this, name, id));
        }
        if (this.m_frozen) {
            throw new CmsConfigurationException(org.opencms.configuration.Messages.get().container("ERR_CONFIG_FROZEN_3", className, this.getTypeName(), new Integer(this.getTypeId())));
        }
        this.m_frozen = true;
        if (name != null) {
            this.m_typeName = name;
        }
        if (id != null) {
            this.m_typeId = Integer.valueOf(id);
        }
        if (className != null) {
            this.m_className = className;
        }
        if (this.getTypeName() == null || this.getClassName() == null || this.getTypeId() < 0 && !this.m_typeName.equals(CmsResourceTypeUnknownFile.getStaticTypeName()) && !this.m_typeName.equals(CmsResourceTypeUnknownFolder.getStaticTypeName())) {
            throw new CmsConfigurationException(org.opencms.file.types.Messages.get().container("ERR_INVALID_RESTYPE_CONFIG_3", className, this.m_typeName, new Integer(this.m_typeId)));
        }
        this.m_defaultProperties = Collections.unmodifiableList(this.m_defaultProperties);
        this.m_copyResources = Collections.unmodifiableList(this.m_copyResources);
        this.m_mappings = Collections.unmodifiableList(this.m_mappings);
    }

    public void initialize(CmsObject cms) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_INITIALIZE_1", this));
        }
    }

    public boolean isAdditionalModuleResourceType() {
        return this.m_addititionalModuleResourceType;
    }

    public boolean isDirectEditable() {
        return false;
    }

    public boolean isFolder() {
        return false;
    }

    public boolean isIdentical(I_CmsResourceType type) {
        if (type == null) {
            return false;
        }
        return this.getTypeId() == type.getTypeId() && this.getTypeName().equals(type.getTypeName());
    }

    public void lockResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsLockType type) throws CmsException {
        securityManager.lockResource(cms.getRequestContext(), resource, type);
    }

    public void moveResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, String destination) throws CmsException, CmsIllegalArgumentException {
        String dest = cms.getRequestContext().addSiteRoot(destination);
        if (resource.getRootPath().equals(dest)) {
            throw new CmsVfsException(Messages.get().container("ERR_MOVE_SAME_NAME_1", destination));
        }
        try {
            securityManager.readResource(cms.getRequestContext(), dest, CmsResourceFilter.ALL);
            throw new CmsVfsException(Messages.get().container("ERR_OVERWRITE_RESOURCE_2", cms.getRequestContext().removeSiteRoot(resource.getRootPath()), destination));
        }
        catch (CmsVfsResourceNotFoundException e) {
            securityManager.moveResource(cms.getRequestContext(), resource, dest);
            return;
        }
    }

    public void removeResourceFromProject(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource) throws CmsException {
        securityManager.removeResourceFromProject(cms.getRequestContext(), resource);
    }

    public void replaceResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int type, byte[] content, List properties) throws CmsException {
        securityManager.replaceResource(cms.getRequestContext(), resource, type, content, properties);
        this.createRelations(cms, securityManager, resource.getRootPath());
    }

    public void restoreResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int version) throws CmsException {
        securityManager.restoreResource(cms.getRequestContext(), resource, version);
        this.createRelations(cms, securityManager, resource.getRootPath());
    }

    public void restoreResourceBackup(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int version) throws CmsException {
        this.restoreResource(cms, securityManager, resource, version);
    }

    public void setAdditionalModuleResourceType(boolean additionalType) {
        this.m_addititionalModuleResourceType = additionalType;
    }

    public void setDateExpired(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateExpired, boolean recursive) throws CmsException {
        securityManager.setDateExpired(cms.getRequestContext(), resource, dateExpired);
    }

    public void setDateLastModified(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateLastModified, boolean recursive) throws CmsException {
        securityManager.setDateLastModified(cms.getRequestContext(), resource, dateLastModified);
    }

    public void setDateReleased(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateReleased, boolean recursive) throws CmsException {
        securityManager.setDateReleased(cms.getRequestContext(), resource, dateReleased);
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[ResourceType] class=");
        output.append(this.getClass().getName());
        output.append(" name=");
        output.append(this.getTypeName());
        output.append(" id=");
        output.append(this.getTypeId());
        output.append(" loaderId=");
        output.append(this.getLoaderId());
        return output.toString();
    }

    public void undelete(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, boolean recursive) throws CmsException {
        securityManager.undelete(cms.getRequestContext(), resource);
    }

    public void undoChanges(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsResource.CmsResourceUndoMode mode) throws CmsException {
        securityManager.undoChanges(cms.getRequestContext(), resource, mode);
        this.updateRelationForUndo(cms, securityManager, resource);
    }

    public void unlockResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource) throws CmsException {
        securityManager.unlockResource(cms.getRequestContext(), resource);
    }

    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        if (resource.isFile()) {
            CmsFile file = securityManager.writeFile(cms.getRequestContext(), resource);
            I_CmsResourceType type = this.getResourceType(file);
            List links = null;
            if (type instanceof I_CmsLinkParseable) {
                links = ((I_CmsLinkParseable)((Object)type)).parseLinks(cms, file);
            }
            securityManager.updateRelationsForResource(cms.getRequestContext(), file, links);
            return file;
        }
        throw new CmsVfsException(org.opencms.file.types.Messages.get().container("ERR_WRITE_FILE_IS_FOLDER_1", cms.getSitePath(resource)));
    }

    public void writePropertyObject(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsProperty property) throws CmsException {
        securityManager.writePropertyObject(cms.getRequestContext(), resource, property);
    }

    public void writePropertyObjects(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, List properties) throws CmsException {
        securityManager.writePropertyObjects(cms.getRequestContext(), resource, properties);
    }

    protected CmsResource createRelations(CmsObject cms, CmsSecurityManager securityManager, String resourceName) throws CmsException {
        CmsResource resource = securityManager.readResource(cms.getRequestContext(), resourceName, CmsResourceFilter.ALL);
        I_CmsResourceType resourceType = this.getResourceType(resource);
        List links = null;
        if (resourceType instanceof I_CmsLinkParseable) {
            I_CmsLinkParseable linkParseable = (I_CmsLinkParseable)((Object)resourceType);
            links = linkParseable.parseLinks(cms, cms.readFile(resource));
        }
        securityManager.updateRelationsForResource(cms.getRequestContext(), resource, links);
        return resource;
    }

    protected CmsMacroResolver getMacroResolver(CmsObject cms, String resourcename) {
        CmsMacroResolver result = CmsMacroResolver.newInstance().setCmsObject(cms);
        if (this.isFolder() && !CmsResource.isFolder(resourcename)) {
            resourcename = resourcename.concat("/");
        }
        result.addMacro(MACRO_RESOURCE_ROOT_PATH, cms.getRequestContext().addSiteRoot(resourcename));
        result.addMacro(MACRO_RESOURCE_SITE_PATH, resourcename);
        result.addMacro(MACRO_RESOURCE_FOLDER_PATH, CmsResource.getFolderPath(resourcename));
        result.addMacro(MACRO_RESOURCE_PARENT_PATH, CmsResource.getParentFolder(resourcename));
        result.addMacro(MACRO_RESOURCE_NAME, CmsResource.getName(resourcename));
        return result;
    }

    protected I_CmsResourceType getResourceType(CmsResource resource) {
        return OpenCms.getResourceManager().getResourceType(resource);
    }

    protected void processCopyResources(CmsObject cms, String resourcename, CmsMacroResolver resolver) {
        Iterator i = this.m_copyResources.iterator();
        while (i.hasNext()) {
            CmsConfigurationCopyResource copyResource = (CmsConfigurationCopyResource)i.next();
            String target = copyResource.getTarget();
            if (copyResource.isTargetWasNull() || CmsMacroResolver.isMacro(target, MACRO_RESOURCE_FOLDER_PATH)) {
                target = target.concat(CmsResource.getName(copyResource.getSource()));
            }
            target = resolver.resolveMacros(target);
            target = CmsFileUtil.normalizePath(CmsLinkManager.getAbsoluteUri(target, resourcename), '/');
            try {
                cms.copyResource(copyResource.getSource(), target, copyResource.getType());
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_PROCESS_COPY_RESOURCES_3", resourcename, copyResource, target), (Throwable)e);
                    continue;
                }
                LOG.error((Object)org.opencms.file.types.Messages.get().getBundle().key("LOG_PROCESS_COPY_RESOURCES_3", resourcename, copyResource, target));
            }
        }
    }

    protected List processDefaultProperties(List properties, CmsMacroResolver resolver) {
        if (this.m_defaultProperties == null || this.m_defaultProperties.size() == 0) {
            return properties;
        }
        ArrayList<CmsProperty> result = new ArrayList<CmsProperty>();
        Iterator i = this.m_defaultProperties.iterator();
        while (i.hasNext()) {
            CmsProperty property = (CmsProperty)((CmsProperty)i.next()).clone();
            if (property.getResourceValue() != null) {
                property.setResourceValue(resolver.resolveMacros(property.getResourceValue()));
            }
            if (property.getStructureValue() != null) {
                property.setStructureValue(resolver.resolveMacros(property.getStructureValue()));
            }
            result.add(property);
        }
        if (properties != null) {
            result.addAll(properties);
        }
        return result;
    }

    protected void updateRelationForUndo(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource) throws CmsException {
        CmsResource undoneResource1 = null;
        try {
            undoneResource1 = this.createRelations(cms, securityManager, resource.getRootPath());
        }
        catch (CmsVfsResourceNotFoundException e) {
            // empty catch block
        }
        CmsResource undoneResource2 = securityManager.readResource(cms.getRequestContext(), resource.getStructureId(), CmsResourceFilter.ALL);
        if (!undoneResource2.equals(undoneResource1)) {
            List links;
            block9: {
                I_CmsResourceType resourceType = this.getResourceType(resource);
                links = null;
                if (resourceType instanceof I_CmsLinkParseable) {
                    I_CmsLinkParseable linkParseable = (I_CmsLinkParseable)((Object)resourceType);
                    if (undoneResource1 == null || !undoneResource2.getRootPath().equals(undoneResource1.getRootPath())) {
                        try {
                            links = linkParseable.parseLinks(cms, cms.readFile(undoneResource2));
                        }
                        catch (CmsException e) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn((Object)e);
                            }
                        }
                        catch (CmsRuntimeException e) {
                            if (!LOG.isWarnEnabled()) break block9;
                            LOG.warn((Object)e);
                        }
                    }
                }
            }
            securityManager.updateRelationsForResource(cms.getRequestContext(), undoneResource2, links);
        }
    }
}

